/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import org.freeplane.features.nodestyle.ShapeConfigurationModel;
import org.freeplane.view.swing.map.ShapedMainView;

class RectangleMainView
extends ShapedMainView {
    private static final long serialVersionUID = 1L;

    @Override
    protected void paintNodeShape(Graphics2D g) {
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    @Override
    protected void paintBackground(Graphics2D graphics, Color color) {
        graphics.setColor(color);
        graphics.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    public RectangleMainView(ShapeConfigurationModel shapeConfiguration) {
        super(shapeConfiguration);
    }

    @Override
    public Insets getInsets() {
        ShapeConfigurationModel shapeConfiguration = this.getShapeConfiguration();
        int horizontalMargin = shapeConfiguration.getHorizontalMargin().toBaseUnitsRounded();
        int verticalMargin = shapeConfiguration.getVerticalMargin().toBaseUnitsRounded();
        return new Insets(verticalMargin, horizontalMargin, verticalMargin, horizontalMargin);
    }

    @Override
    public Insets getInsets(Insets insets) {
        return this.getInsets();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        if (this.isPreferredSizeSet()) {
            return preferredSize;
        }
        preferredSize.width = this.limitWidth(preferredSize.width);
        if (this.getShapeConfiguration().isUniform()) {
            if (preferredSize.width < preferredSize.height) {
                preferredSize.width = preferredSize.height;
            } else {
                preferredSize.height = preferredSize.width;
            }
        }
        return preferredSize;
    }
}

