/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph.index;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.index.EdgeSetIntersector;
import com.vividsolutions.jts.geomgraph.index.SegmentIntersector;
import com.vividsolutions.jts.geomgraph.index.SweepLineEvent;
import com.vividsolutions.jts.geomgraph.index.SweepLineSegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SimpleSweepLineIntersector
extends EdgeSetIntersector {
    List events = new ArrayList();
    int nOverlaps;

    public void computeIntersections(List list, SegmentIntersector segmentIntersector, boolean bl) {
        if (bl) {
            this.add(list, null);
        } else {
            this.add(list);
        }
        this.computeIntersections(segmentIntersector);
    }

    public void computeIntersections(List list, List list2, SegmentIntersector segmentIntersector) {
        this.add(list, (Object)list);
        this.add(list2, (Object)list2);
        this.computeIntersections(segmentIntersector);
    }

    private void add(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            this.add(edge, (Object)edge);
        }
    }

    private void add(List list, Object object) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            this.add(edge, object);
        }
    }

    private void add(Edge edge, Object object) {
        Coordinate[] coordinateArray = edge.getCoordinates();
        for (int i = 0; i < coordinateArray.length - 1; ++i) {
            SweepLineSegment sweepLineSegment = new SweepLineSegment(edge, i);
            SweepLineEvent sweepLineEvent = new SweepLineEvent(object, sweepLineSegment.getMinX(), null, sweepLineSegment);
            this.events.add(sweepLineEvent);
            this.events.add(new SweepLineEvent(object, sweepLineSegment.getMaxX(), sweepLineEvent, sweepLineSegment));
        }
    }

    private void prepareEvents() {
        Collections.sort(this.events);
        for (int i = 0; i < this.events.size(); ++i) {
            SweepLineEvent sweepLineEvent = (SweepLineEvent)this.events.get(i);
            if (!sweepLineEvent.isDelete()) continue;
            sweepLineEvent.getInsertEvent().setDeleteEventIndex(i);
        }
    }

    private void computeIntersections(SegmentIntersector segmentIntersector) {
        this.nOverlaps = 0;
        this.prepareEvents();
        for (int i = 0; i < this.events.size(); ++i) {
            SweepLineEvent sweepLineEvent = (SweepLineEvent)this.events.get(i);
            if (!sweepLineEvent.isInsert()) continue;
            this.processOverlaps(i, sweepLineEvent.getDeleteEventIndex(), sweepLineEvent, segmentIntersector);
        }
    }

    private void processOverlaps(int n, int n2, SweepLineEvent sweepLineEvent, SegmentIntersector segmentIntersector) {
        SweepLineSegment sweepLineSegment = (SweepLineSegment)sweepLineEvent.getObject();
        for (int i = n; i < n2; ++i) {
            SweepLineEvent sweepLineEvent2 = (SweepLineEvent)this.events.get(i);
            if (!sweepLineEvent2.isInsert()) continue;
            SweepLineSegment sweepLineSegment2 = (SweepLineSegment)sweepLineEvent2.getObject();
            if (sweepLineEvent.edgeSet != null && sweepLineEvent.edgeSet == sweepLineEvent2.edgeSet) continue;
            sweepLineSegment.computeIntersections(sweepLineSegment2, segmentIntersector);
            ++this.nOverlaps;
        }
    }
}

