/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.precision;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.GeometryEditor;

public class SimpleGeometryPrecisionReducer {
    private PrecisionModel newPrecisionModel;
    private boolean removeCollapsed = true;
    private boolean changePrecisionModel = false;

    public SimpleGeometryPrecisionReducer(PrecisionModel precisionModel) {
        this.newPrecisionModel = precisionModel;
    }

    public void setRemoveCollapsedComponents(boolean bl) {
        this.removeCollapsed = bl;
    }

    public void setChangePrecisionModel(boolean bl) {
        this.changePrecisionModel = bl;
    }

    public Geometry reduce(Geometry geometry) {
        GeometryEditor geometryEditor;
        if (this.changePrecisionModel) {
            GeometryFactory geometryFactory = new GeometryFactory(this.newPrecisionModel, geometry.getSRID());
            geometryEditor = new GeometryEditor(geometryFactory);
        } else {
            geometryEditor = new GeometryEditor();
        }
        return geometryEditor.edit(geometry, new PrecisionReducerCoordinateOperation());
    }

    private class PrecisionReducerCoordinateOperation
    extends GeometryEditor.CoordinateOperation {
        private PrecisionReducerCoordinateOperation() {
        }

        public Coordinate[] edit(Coordinate[] coordinateArray, Geometry geometry) {
            Coordinate[] coordinateArray2;
            if (coordinateArray.length == 0) {
                return null;
            }
            Coordinate[] coordinateArray3 = new Coordinate[coordinateArray.length];
            for (int i = 0; i < coordinateArray.length; ++i) {
                coordinateArray2 = new Coordinate(coordinateArray[i]);
                SimpleGeometryPrecisionReducer.this.newPrecisionModel.makePrecise((Coordinate)coordinateArray2);
                coordinateArray3[i] = coordinateArray2;
            }
            CoordinateList coordinateList = new CoordinateList(coordinateArray3, false);
            coordinateArray2 = coordinateList.toCoordinateArray();
            int n = 0;
            if (geometry instanceof LineString) {
                n = 2;
            }
            if (geometry instanceof LinearRing) {
                n = 4;
            }
            Coordinate[] coordinateArray4 = coordinateArray3;
            if (SimpleGeometryPrecisionReducer.this.removeCollapsed) {
                coordinateArray4 = null;
            }
            if (coordinateArray2.length < n) {
                return coordinateArray4;
            }
            return coordinateArray2;
        }
    }
}

