/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.coordsys.impl;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.coordsys.Geographic;
import com.vividsolutions.jump.coordsys.Planar;
import com.vividsolutions.jump.coordsys.Projection;
import com.vividsolutions.jump.coordsys.Spheroid;
import com.vividsolutions.jump.coordsys.impl.TransverseMercator;

public class UniversalTransverseMercator
extends Projection {
    private static final double SCALE_FACTOR = 0.9996;
    private static final double FALSE_EASTING = 500000.0;
    private static final double FALSE_NORTHING = 0.0;
    private TransverseMercator transverseMercator = new TransverseMercator();
    private int zone = -1;

    public void setParameters(int n) {
        Assert.isTrue(n >= 7, "UTM zone " + n + " not supported");
        Assert.isTrue(n <= 11, "UTM zone " + n + " not supported");
        switch (n) {
            case 7: {
                this.transverseMercator.setParameters(-141.0);
                break;
            }
            case 8: {
                this.transverseMercator.setParameters(-135.0);
                break;
            }
            case 9: {
                this.transverseMercator.setParameters(-129.0);
                break;
            }
            case 10: {
                this.transverseMercator.setParameters(-123.0);
                break;
            }
            case 11: {
                this.transverseMercator.setParameters(-117.0);
                break;
            }
            case 12: {
                this.transverseMercator.setParameters(-111.0);
                break;
            }
            default: {
                Assert.shouldNeverReachHere();
            }
        }
        this.zone = n;
    }

    public void setSpheroid(Spheroid spheroid) {
        this.transverseMercator.setSpheroid(spheroid);
    }

    public Geographic asGeographic(Planar planar, Geographic geographic) {
        Assert.isTrue(this.zone != -1, "Call #setParameters first");
        planar.x = (planar.x - 500000.0) / 0.9996;
        planar.y = (planar.y - 0.0) / 0.9996;
        this.transverseMercator.asGeographic(planar, geographic);
        return geographic;
    }

    public Planar asPlanar(Geographic geographic, Planar planar) {
        Assert.isTrue(this.zone != -1, "Call #setParameters first");
        this.transverseMercator.asPlanar(geographic, planar);
        planar.x = 0.9996 * planar.x + 500000.0;
        planar.y = 0.9996 * planar.y + 0.0;
        return planar;
    }
}

