/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.util.MathUtil;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Iterator;

public class CoordUtil {
    public static Coordinate average(Coordinate coordinate, Coordinate coordinate2) {
        return new Coordinate(MathUtil.avg(coordinate.x, coordinate2.x), MathUtil.avg(coordinate.y, coordinate2.y));
    }

    public static Coordinate average(Collection collection) {
        Assert.isTrue(!collection.isEmpty());
        double d = 0.0;
        double d2 = 0.0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Coordinate coordinate = (Coordinate)iterator.next();
            d += coordinate.x;
            d2 += coordinate.y;
        }
        return new Coordinate(d / (double)collection.size(), d2 / (double)collection.size());
    }

    public static Coordinate closest(Collection collection, Coordinate coordinate) {
        Assert.isTrue(!collection.isEmpty());
        Coordinate coordinate2 = (Coordinate)collection.iterator().next();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Coordinate coordinate3 = (Coordinate)iterator.next();
            if (!(coordinate.distance(coordinate3) < coordinate.distance(coordinate2))) continue;
            coordinate2 = coordinate3;
        }
        return coordinate2;
    }

    public static Coordinate add(Coordinate coordinate, Coordinate coordinate2) {
        return new Coordinate(coordinate.x + coordinate2.x, coordinate.y + coordinate2.y);
    }

    public static Coordinate subtract(Coordinate coordinate, Coordinate coordinate2) {
        return new Coordinate(coordinate.x - coordinate2.x, coordinate.y - coordinate2.y);
    }

    public static Coordinate multiply(double d, Coordinate coordinate) {
        return new Coordinate(d * coordinate.x, d * coordinate.y);
    }

    public static Coordinate divide(Coordinate coordinate, double d) {
        return new Coordinate(coordinate.x / d, coordinate.y / d);
    }

    public static Coordinate toCoordinate(Point2D point2D) {
        return new Coordinate(point2D.getX(), point2D.getY());
    }

    public static Point2D toPoint2D(Coordinate coordinate) {
        return new Point2D.Double(coordinate.x, coordinate.y);
    }

    public static Point2D add(Point2D point2D, Point2D point2D2) {
        return new Point2D.Double(point2D.getX() + point2D2.getX(), point2D.getY() + point2D2.getY());
    }

    public static Point2D subtract(Point2D point2D, Point2D point2D2) {
        return new Point2D.Double(point2D.getX() - point2D2.getX(), point2D.getY() - point2D2.getY());
    }
}

