/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.util.OrderedMap;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.renderer.FeatureSelectionRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.LayerRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.LineStringSelectionRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.PartSelectionRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.Renderer;
import com.vividsolutions.jump.workbench.ui.renderer.SelectionBackgroundRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.ThreadQueue;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Timer;

public class RenderingManager {
    private LayerViewPanel panel;
    private Map contentIDToRendererMap = new OrderedMap();
    private OrderedMap contentIDToLowRendererFactoryMap = new OrderedMap();
    private OrderedMap contentIDToHighRendererFactoryMap = new OrderedMap();
    private ThreadQueue defaultRendererThreadQueue = new ThreadQueue(1);
    private Timer repaintTimer = new Timer(1000, new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            Iterator iterator = RenderingManager.this.contentIDToRendererMap.values().iterator();
            while (iterator.hasNext()) {
                Renderer renderer = (Renderer)iterator.next();
                if (!renderer.isRendering()) continue;
                RenderingManager.this.repaintPanel();
                return;
            }
            RenderingManager.this.repaintTimer.stop();
            RenderingManager.this.repaintPanel();
        }
    });
    private boolean paintingEnabled = true;

    public RenderingManager(final LayerViewPanel layerViewPanel) {
        this.panel = layerViewPanel;
        this.repaintTimer.setCoalesce(true);
        this.putAboveLayerables("SELECTION_BACKGROUND", new Renderer.Factory(){

            public Renderer create() {
                return new SelectionBackgroundRenderer(layerViewPanel);
            }
        });
        this.putAboveLayerables("SELECTED_FEATURES", new Renderer.Factory(){

            public Renderer create() {
                return new FeatureSelectionRenderer(layerViewPanel);
            }
        });
        this.putAboveLayerables("SELECTED_LINESTRINGS", new Renderer.Factory(){

            public Renderer create() {
                return new LineStringSelectionRenderer(layerViewPanel);
            }
        });
        this.putAboveLayerables("SELECTED_PARTS", new Renderer.Factory(){

            public Renderer create() {
                return new PartSelectionRenderer(layerViewPanel);
            }
        });
    }

    public void putBelowLayerables(Object object, Renderer.Factory factory) {
        this.contentIDToLowRendererFactoryMap.put(object, factory);
    }

    public void putAboveLayerables(Object object, Renderer.Factory factory) {
        this.contentIDToHighRendererFactoryMap.put(object, factory);
    }

    public void renderAll() {
        this.defaultRendererThreadQueue.clear();
        Iterator iterator = this.contentIDs().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.render(e);
        }
    }

    protected List contentIDs() {
        ArrayList<Layerable> arrayList = new ArrayList<Layerable>();
        arrayList.addAll(this.contentIDToLowRendererFactoryMap.keyList());
        Iterator iterator = this.panel.getLayerManager().reverseIterator(Layerable.class);
        while (iterator.hasNext()) {
            Layerable layerable = (Layerable)iterator.next();
            arrayList.add(layerable);
        }
        arrayList.addAll(this.contentIDToHighRendererFactoryMap.keyList());
        return arrayList;
    }

    public Renderer getRenderer(Object object) {
        return (Renderer)this.contentIDToRendererMap.get(object);
    }

    private void setRenderer(Object object, Renderer renderer) {
        this.contentIDToRendererMap.put(object, renderer);
    }

    public void render(Object object) {
        this.render(object, true);
    }

    public void render(Object object, boolean bl) {
        Runnable runnable;
        if (this.getRenderer(object) == null) {
            this.setRenderer(object, this.createRenderer(object));
        }
        if (this.getRenderer(object).isRendering()) {
            this.getRenderer(object).cancel();
            this.setRenderer(object, this.createRenderer(object));
        }
        if (bl) {
            this.getRenderer(object).clearImageCache();
        }
        if ((runnable = this.getRenderer(object).createRunnable()) != null) {
            this.defaultRendererThreadQueue.add(runnable);
        }
        if (!this.repaintTimer.isRunning()) {
            this.repaintPanel();
            this.repaintTimer.start();
        }
    }

    public void repaintPanel() {
        if (!this.paintingEnabled) {
            return;
        }
        this.panel.superRepaint();
    }

    protected Renderer createRenderer(Object object) {
        if (object instanceof Layer) {
            return new LayerRenderer((Layer)object, this.panel);
        }
        if (this.contentIDToLowRendererFactoryMap.containsKey(object)) {
            return ((Renderer.Factory)this.contentIDToLowRendererFactoryMap.get(object)).create();
        }
        if (this.contentIDToHighRendererFactoryMap.containsKey(object)) {
            return ((Renderer.Factory)this.contentIDToHighRendererFactoryMap.get(object)).create();
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    public void setPaintingEnabled(boolean bl) {
        this.paintingEnabled = bl;
    }

    public void copyTo(Graphics2D graphics2D) {
        Iterator iterator = this.contentIDs().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.getRenderer(e) == null) continue;
            this.getRenderer(e).copyTo(graphics2D);
        }
    }

    public ThreadQueue getDefaultRendererThreadQueue() {
        return this.defaultRendererThreadQueue;
    }

    public void dispose() {
        this.repaintTimer.stop();
        this.defaultRendererThreadQueue.dispose();
        this.contentIDToRendererMap.clear();
    }
}

