/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.geom.Angle;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.geom.InteriorPointFinder;
import com.vividsolutions.jump.util.CoordinateArrays;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;

public class LabelStyle
implements Style {
    public static final int FONT_BASE_SIZE = 12;
    public static final String ABOVE_LINE = "ABOVE_LINE";
    public static final String ON_LINE = "ON_LINE";
    public static final String BELOW_LINE = "BELOW_LINE";
    public static final String FID_COLUMN = "$FID";
    private GeometryFactory factory = new GeometryFactory();
    private Color originalColor;
    private AffineTransform originalTransform;
    private Layer layer;
    private Geometry viewportRectangle = null;
    private InteriorPointFinder interiorPointFinder = new InteriorPointFinder();
    private Quadtree labelsDrawn = null;
    private String attribute = "$FID";
    private String angleAttribute = "";
    private String heightAttribute = "";
    private boolean enabled = false;
    private Color color = Color.black;
    private Font font = new Font("Dialog", 0, 12);
    private boolean scaling = false;
    private double height = 12.0;
    private boolean hidingOverlappingLabels = true;
    public String verticalAlignment = "ABOVE_LINE";

    public void initialize(Layer layer) {
        this.labelsDrawn = new Quadtree();
        this.viewportRectangle = null;
        this.layer = layer;
    }

    public void paint(Feature feature, Graphics2D graphics2D, Viewport viewport) throws NoninvertibleTransformException {
        Object object;
        Object object2 = object = this.getAttribute().equals(FID_COLUMN) ? feature.getID() + "" : feature.getAttribute(this.getAttribute());
        if (object == null || object.toString().length() == 0) {
            return;
        }
        Geometry geometry = this.intersection(feature.getGeometry(), viewport);
        if (geometry == null) {
            return;
        }
        ModelSpaceLabelSpec modelSpaceLabelSpec = this.modelSpaceLabelSpec(geometry);
        Point2D point2D = viewport.toViewPoint(new Point2D.Double(modelSpaceLabelSpec.location.x, modelSpaceLabelSpec.location.y));
        this.paint(graphics2D, object.toString(), viewport.getScale(), point2D, LabelStyle.angle(feature, this.getAngleAttribute(), modelSpaceLabelSpec.angle), LabelStyle.height(feature, this.getHeightAttribute(), this.getHeight()), modelSpaceLabelSpec.linear);
    }

    public static double angle(Feature feature, String string, double d) {
        if (string.equals("")) {
            return d;
        }
        Object object = feature.getAttribute(string);
        if (object == null) {
            return d;
        }
        try {
            return Angle.toRadians(Double.parseDouble(object.toString().trim()));
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    private ModelSpaceLabelSpec modelSpaceLabelSpec(Geometry geometry) throws NoninvertibleTransformException {
        if (geometry.getDimension() == 1) {
            return this.modelSpaceLabelSpec1D(geometry);
        }
        return new ModelSpaceLabelSpec(this.interiorPointFinder.findPoint(geometry), 0.0, false);
    }

    private ModelSpaceLabelSpec modelSpaceLabelSpec1D(Geometry geometry) {
        LineSegment lineSegment = this.longestSegment(geometry);
        return new ModelSpaceLabelSpec(CoordUtil.average(lineSegment.p0, lineSegment.p1), this.angle(lineSegment), true);
    }

    private double angle(LineSegment lineSegment) {
        double d = Angle.angle(lineSegment.p0, lineSegment.p1);
        if (d < -1.5707963267948966) {
            d += Math.PI;
        }
        if (d > 1.5707963267948966) {
            d -= Math.PI;
        }
        return d;
    }

    private LineSegment longestSegment(Geometry geometry) {
        double d = -1.0;
        Coordinate coordinate = null;
        Coordinate coordinate2 = null;
        List list = CoordinateArrays.toCoordinateArrays(geometry, false);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Coordinate[] coordinateArray = (Coordinate[])iterator.next();
            for (int i = 1; i < coordinateArray.length; ++i) {
                if (!(coordinateArray[i - 1].distance(coordinateArray[i]) > d)) continue;
                d = coordinateArray[i - 1].distance(coordinateArray[i]);
                coordinate = coordinateArray[i - 1];
                coordinate2 = coordinateArray[i];
            }
        }
        return new LineSegment(coordinate, coordinate2);
    }

    public static double height(Feature feature, String string, double d) {
        if (string.equals("")) {
            return d;
        }
        Object object = feature.getAttribute(string);
        if (object == null) {
            return d;
        }
        try {
            return Double.parseDouble(object.toString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D graphics2D, String string, double d, Point2D point2D, double d2, double d3, boolean bl) {
        this.setup(graphics2D);
        try {
            double d4 = d3 / (double)this.getFont().getSize2D();
            if (this.isScaling()) {
                d4 *= d;
            }
            graphics2D.setColor(this.getColor());
            TextLayout textLayout = new TextLayout(string, this.getFont(), graphics2D.getFontRenderContext());
            AffineTransform affineTransform = graphics2D.getTransform();
            this.configureTransform(affineTransform, point2D, d4, textLayout, d2, bl);
            graphics2D.setTransform(affineTransform);
            if (this.isHidingOverlappingLabels()) {
                Envelope envelope;
                Area area = new Area(textLayout.getBounds()).createTransformedArea(affineTransform);
                if (this.collidesWithExistingLabel(area, envelope = this.envelope(area))) {
                    return;
                }
                this.labelsDrawn.insert(envelope, area);
            }
            textLayout.draw(graphics2D, 0.0f, 0.0f);
        }
        finally {
            this.cleanup(graphics2D);
        }
    }

    private Envelope envelope(Shape shape) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        return new Envelope(rectangle2D.getMinX(), rectangle2D.getMaxX(), rectangle2D.getMinY(), rectangle2D.getMaxY());
    }

    private boolean collidesWithExistingLabel(Area area, Envelope envelope) {
        List list = this.labelsDrawn.query(envelope);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Area area2 = (Area)iterator.next();
            Area area3 = new Area(area2);
            area3.intersect(area);
            if (area3.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void setup(Graphics2D graphics2D) {
        this.originalTransform = graphics2D.getTransform();
        this.originalColor = graphics2D.getColor();
    }

    private void cleanup(Graphics2D graphics2D) {
        graphics2D.setTransform(this.originalTransform);
        graphics2D.setColor(this.originalColor);
    }

    private Geometry intersection(Geometry geometry, Viewport viewport) throws NoninvertibleTransformException {
        return geometry.intersection(this.viewportRectangle(viewport));
    }

    private Geometry viewportRectangle(Viewport viewport) throws NoninvertibleTransformException {
        if (this.viewportRectangle == null) {
            Envelope envelope = viewport.toModelEnvelope(0.0, viewport.getPanel().getWidth(), 0.0, viewport.getPanel().getHeight());
            this.viewportRectangle = this.factory.createPolygon(this.factory.createLinearRing(new Coordinate[]{new Coordinate(envelope.getMinX(), envelope.getMinY()), new Coordinate(envelope.getMinX(), envelope.getMaxY()), new Coordinate(envelope.getMaxX(), envelope.getMaxY()), new Coordinate(envelope.getMaxX(), envelope.getMinY()), new Coordinate(envelope.getMinX(), envelope.getMinY())}), null);
        }
        return this.viewportRectangle;
    }

    private void configureTransform(AffineTransform affineTransform, Point2D point2D, double d, TextLayout textLayout, double d2, boolean bl) {
        double d3 = point2D.getX() - d * textLayout.getBounds().getWidth() / 2.0;
        double d4 = point2D.getY() + d * -textLayout.getBounds().getY() / 2.0;
        if (bl) {
            d4 -= this.verticalAlignmentOffset(d * textLayout.getBounds().getHeight());
        }
        affineTransform.rotate(-d2, point2D.getX(), point2D.getY());
        affineTransform.translate(d3, d4);
        affineTransform.scale(d, d);
    }

    private double verticalAlignmentOffset(double d) {
        if (this.getVerticalAlignment().equals(ON_LINE)) {
            return 0.0;
        }
        double d2 = 3.0;
        double d3 = d2 + (double)this.layer.getBasicStyle().getLineWidth() / 2.0 + d / 2.0;
        if (this.getVerticalAlignment().equals(ABOVE_LINE)) {
            return d3;
        }
        if (this.getVerticalAlignment().equals(BELOW_LINE)) {
            return -d3;
        }
        Assert.shouldNeverReachHere();
        return 0.0;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public String getAngleAttribute() {
        return this.angleAttribute;
    }

    public String getHeightAttribute() {
        return this.heightAttribute;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Color getColor() {
        return this.color;
    }

    public Font getFont() {
        return this.font;
    }

    public boolean isScaling() {
        return this.scaling;
    }

    public double getHeight() {
        return this.height;
    }

    public boolean isHidingOverlappingLabels() {
        return this.hidingOverlappingLabels;
    }

    public String getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(String string) {
        this.verticalAlignment = string;
    }

    public void setAttribute(String string) {
        this.attribute = string;
    }

    public void setAngleAttribute(String string) {
        this.angleAttribute = string;
    }

    public void setHeightAttribute(String string) {
        this.heightAttribute = string;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setScaling(boolean bl) {
        this.scaling = bl;
    }

    public void setHeight(double d) {
        this.height = d;
    }

    public void setHidingOverlappingLabels(boolean bl) {
        this.hidingOverlappingLabels = bl;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    private class ModelSpaceLabelSpec {
        public double angle;
        public Coordinate location;
        public boolean linear;

        public ModelSpaceLabelSpec(Coordinate coordinate, double d, boolean bl) {
            this.location = coordinate;
            this.angle = d;
            this.linear = bl;
        }
    }
}

