/*
 * Decompiled with CFR 0.152.
 */
package genj.geo;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.geo.GeoLocation;
import genj.geo.GeoModel;
import genj.geo.GeoModelListener;
import genj.geo.GeoView;
import genj.geo.QueryWidget;
import genj.util.swing.Action2;
import genj.util.swing.ButtonHelper;
import genj.view.ContextProvider;
import genj.view.ContextSelectionEvent;
import genj.view.ViewContext;
import genj.view.ViewManager;
import genj.window.WindowBroadcastEvent;
import genj.window.WindowManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import swingx.tree.AbstractTreeModel;

class GeoList
extends JPanel {
    private static final String TXT_LOCATION = GeoView.RESOURCES.getString("location");
    private static final String TXT_CHANGE = GeoView.RESOURCES.getString("location.change");
    private static final String TXT_LATLON = GeoView.RESOURCES.getString("location.latlon");
    private static final String TXT_UNKNOWN = GeoView.RESOURCES.getString("location.unknown");
    private GeoView view;
    private ViewManager viewManager;
    private GeoModel model;
    private Content tree;
    private boolean ignoreSelectionChanges = false;

    public GeoList(GeoModel model, GeoView view, ViewManager viewManager) {
        this.model = model;
        this.view = view;
        this.viewManager = viewManager;
        this.tree = new Content(model);
        Update update = new Update();
        this.tree.getSelectionModel().addTreeSelectionListener(update);
        this.tree.setCellRenderer(new Renderer());
        Box buttonPanel = new Box(0);
        ButtonHelper bh = new ButtonHelper().setContainer((JComponent)buttonPanel);
        bh.create((Action)((Object)new UnFold(true)));
        bh.create((Action)((Object)new UnFold(false)));
        bh.create((Action)((Object)update));
        this.setLayout(new BorderLayout());
        this.add("Center", new JScrollPane(this.tree));
        this.add("South", buttonPanel);
        this.setPreferredSize(new Dimension(160, 64));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedLocations(Collection locations) {
        if (this.ignoreSelectionChanges) {
            return;
        }
        TreePath[] paths = ((Model)((Object)this.tree.getModel())).getPathsToLocations(locations);
        if (paths.length == 0) {
            return;
        }
        Rectangle bounds = this.tree.getPathBounds(paths[0]);
        bounds.height = this.tree.getParent().getHeight();
        this.tree.scrollRectToVisible(bounds);
        try {
            this.ignoreSelectionChanges = true;
            this.tree.setSelectionPaths(paths);
        }
        finally {
            this.ignoreSelectionChanges = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedContext(ViewContext context) {
        if (this.ignoreSelectionChanges) {
            return;
        }
        Property[] properties = context.getProperties();
        ArrayList<TreePath> paths = new ArrayList<TreePath>(properties.length);
        for (int i = 0; i < properties.length; ++i) {
            TreePath path = ((Model)((Object)this.tree.getModel())).getPathToProperty(properties[i]);
            if (path == null) continue;
            paths.add(path.getParentPath());
            paths.add(path);
        }
        if (paths.isEmpty()) {
            return;
        }
        try {
            this.ignoreSelectionChanges = true;
            this.tree.getSelectionModel().setSelectionPaths(paths.toArray(new TreePath[paths.size()]));
        }
        finally {
            this.ignoreSelectionChanges = false;
        }
        TreePath first = (TreePath)paths.get(0);
        this.tree.makeVisible(first);
        Rectangle bounds = this.tree.getPathBounds(first);
        bounds.width = 1;
        this.tree.scrollRectToVisible(bounds);
    }

    private static class Model
    extends AbstractTreeModel
    implements GeoModelListener {
        private GeoModel geo;
        private List locations = new ArrayList();

        private Model(GeoModel geo) {
            this.geo = geo;
            this.locations.addAll(geo.getLocations());
            Collections.sort(this.locations);
            geo.addGeoModelListener(this);
        }

        private TreePath[] getPathsToLocations() {
            return this.getPathsToLocations(this.locations);
        }

        private TreePath[] getPathsToLocations(Collection locations) {
            TreePath[] result = new TreePath[locations.size()];
            Iterator it = locations.iterator();
            for (int i = 0; i < result.length; ++i) {
                result[i] = new TreePath(new Object[]{this, it.next()});
            }
            return result;
        }

        private TreePath getPathToProperty(Property prop) {
            while (!(prop.getParent() instanceof Entity)) {
                if ((prop = prop.getParent()) != null) continue;
                return null;
            }
            for (int i = 0; i < this.locations.size(); ++i) {
                GeoLocation loc = (GeoLocation)this.locations.get(i);
                if (!loc.properties.contains(prop)) continue;
                return new TreePath(new Object[]{this, loc, prop});
            }
            return null;
        }

        public void locationAdded(GeoLocation location) {
            ListIterator<GeoLocation> it = this.locations.listIterator();
            while (it.hasNext()) {
                if (((Comparable)it.next()).compareTo(location) <= 0) continue;
                it.previous();
                break;
            }
            int pos = it.nextIndex();
            it.add(location);
            this.fireTreeNodesInserted(this, new Object[]{this}, new int[]{pos}, new Object[]{location});
        }

        public void locationUpdated(GeoLocation location) {
            this.fireTreeStructureChanged(this, new Object[]{this, location}, null, null);
        }

        public void locationRemoved(GeoLocation location) {
            int i = this.locations.indexOf(location);
            this.locations.remove(i);
            this.fireTreeNodesRemoved(this, new Object[]{this}, new int[]{i}, new Object[]{location});
        }

        public void asyncResolveEnd(int status, String msg) {
        }

        public void asyncResolveStart() {
        }

        protected Object getParent(Object node) {
            throw new IllegalArgumentException();
        }

        public Object getRoot() {
            return this;
        }

        public int getChildCount(Object parent) {
            if (this.geo == null) {
                return 0;
            }
            return parent == this ? this.locations.size() : ((GeoLocation)parent).getNumProperties();
        }

        public boolean isLeaf(Object node) {
            return node instanceof Property;
        }

        public Object getChild(Object parent, int index) {
            return parent == this ? this.locations.get(index) : ((GeoLocation)parent).getProperty(index);
        }

        public int getIndexOfChild(Object parent, Object child) {
            if (parent == this) {
                return this.locations.indexOf(child);
            }
            return ((GeoLocation)parent).getPropertyIndex((Property)child);
        }
    }

    private class Content
    extends JTree
    implements TreeSelectionListener,
    ContextProvider {
        private Content(GeoModel geomodel) {
            super((TreeModel)((Object)new Model(geomodel)));
            this.getSelectionModel().setSelectionMode(4);
            this.setRootVisible(false);
            this.setShowsRootHandles(true);
            this.addTreeSelectionListener(this);
        }

        public ViewContext getContext() {
            ViewContext result = new ViewContext(GeoList.this.model.getGedcom());
            TreePath[] selections = this.getSelectionPaths();
            for (int i = 0; selections != null && i < selections.length; ++i) {
                Object selection = selections[i].getLastPathComponent();
                if (!(selection instanceof Property)) continue;
                result.addProperty((Property)selection);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void valueChanged(TreeSelectionEvent e) {
            if (GeoList.this.ignoreSelectionChanges) {
                return;
            }
            HashSet<Object> props = new HashSet<Object>();
            HashSet<Object> locs = new HashSet<Object>();
            TreePath[] paths = GeoList.this.tree.getSelectionModel().getSelectionPaths();
            if (paths != null) {
                for (int i = 0; i < paths.length; ++i) {
                    if (paths[i].getPathCount() == 3) {
                        props.add(paths[i].getPathComponent(2));
                    }
                    if (paths[i].getPathCount() <= 1) continue;
                    locs.add(paths[i].getPathComponent(1));
                }
            }
            GeoList.this.view.setSelection(locs);
            try {
                GeoList.this.ignoreSelectionChanges = true;
                if (!props.isEmpty()) {
                    ViewContext context = new ViewContext(GeoList.this.model.getGedcom());
                    context.addProperties(Property.toArray(props));
                    WindowManager.broadcast((WindowBroadcastEvent)new ContextSelectionEvent(context, (Component)this));
                }
            }
            finally {
                GeoList.this.ignoreSelectionChanges = false;
            }
        }
    }

    private class Renderer
    extends DefaultTreeCellRenderer {
        private Renderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            StringBuffer sb = new StringBuffer();
            if (value instanceof GeoLocation) {
                GeoLocation loc = (GeoLocation)value;
                sb.append(loc.getJurisdictionsAsString());
                sb.append(" (");
                if (loc.getMatches() == 0) {
                    sb.append(TXT_UNKNOWN);
                } else {
                    sb.append(loc.getCoordinateAsString());
                    if (loc.getMatches() > 1) {
                        sb.append("?");
                    }
                }
                sb.append(")");
                this.setText(sb.toString());
                this.setIcon(null);
                return this;
            }
            if (value instanceof Property) {
                Property prop = (Property)value;
                Property date = prop.getProperty("DATE", true);
                if (date != null) {
                    sb.append(date.toString());
                    sb.append(" ");
                }
                sb.append(Gedcom.getName((String)prop.getTag()));
                sb.append(" ");
                sb.append(prop.getEntity().toString());
                this.setText(sb.toString());
                this.setIcon((Icon)prop.getImage(false));
            }
            return this;
        }
    }

    private class Update
    extends Action2
    implements TreeSelectionListener {
        private Update() {
            this.setText(TXT_CHANGE);
            this.setEnabled(false);
        }

        public void valueChanged(TreeSelectionEvent e) {
            this.setEnabled(GeoList.this.tree.getSelectionCount() == 1 && GeoList.this.tree.getSelectionPath().getPathCount() == 2);
        }

        protected void execute() {
            GeoLocation loc;
            Action[] actions = new Action[]{new Action2(GeoView.RESOURCES, "query.remember"), Action2.cancel()};
            TreePath selection = GeoList.this.tree.getSelectionPath();
            if (selection == null) {
                return;
            }
            GeoLocation location = (GeoLocation)selection.getLastPathComponent();
            QueryWidget query = new QueryWidget(location, GeoList.this.view);
            int rc = WindowManager.getInstance((Component)GeoList.this).openDialog("query", TXT_CHANGE, 3, (JComponent)query, actions, (Component)GeoList.this);
            if (rc == 0 && (loc = query.getGeoLocation()) != null) {
                GeoList.this.model.setCoordinates(location, loc.getCoordinate());
            }
        }
    }

    private class UnFold
    extends Action2 {
        private boolean fold;

        private UnFold(boolean fold) {
            this.setText(fold ? "+" : "-");
            this.fold = fold;
        }

        protected void execute() {
            TreePath[] paths = ((Model)((Object)GeoList.this.tree.getModel())).getPathsToLocations();
            for (int i = 0; i < paths.length; ++i) {
                if (!this.fold) {
                    GeoList.this.tree.collapsePath(paths[i]);
                    continue;
                }
                GeoList.this.tree.expandPath(paths[i]);
            }
        }
    }
}

