/*
 * Decompiled with CFR 0.152.
 */
package com.nm.resedit;

import com.nm.resedit.ResourceArchive;
import com.nm.resedit.ResourceDir;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;

public class ResourceDirView
extends JTree {
    private ResourceArchive archive;

    public ResourceDirView() {
        super(new DefaultMutableTreeNode());
        this.setCellRenderer(new TRenderer());
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
    }

    public void setResourceArchive(ResourceArchive resourceArchive) {
        this.archive = resourceArchive;
        TreeNode treeNode = resourceArchive == null ? new DefaultMutableTreeNode() : resourceArchive.getRoot();
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(treeNode);
        this.setModel(defaultTreeModel);
        int n = 0;
        while (n < this.getRowCount()) {
            this.expandRow(n);
            ++n;
        }
    }

    public ResourceArchive getResourceArchive() {
        return this.archive;
    }

    private class TRenderer
    extends JLabel
    implements TreeCellRenderer {
        private JLabel label;
        private Color selection = new JList().getSelectionBackground();

        TRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            ResourceDir resourceDir;
            if (this.label == null) {
                this.label = new JLabel();
                this.label.setFont(jTree.getFont());
                this.label.setOpaque(true);
            }
            Color color = Color.black;
            if (object instanceof ResourceDir && !(resourceDir = (ResourceDir)object).isTranslated() && !bl) {
                color = Color.red;
            }
            this.label.setForeground(color);
            this.label.setBackground(bl ? this.selection : jTree.getBackground());
            this.label.setText(object.toString());
            return this.label;
        }
    }
}

