/*
 * Decompiled with CFR 0.152.
 */
package genj.app;

import genj.app.Workbench;
import genj.app.WorkbenchAdapter;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.Property;
import genj.util.swing.Action2;
import genj.util.swing.GraphicsHelper;
import genj.util.swing.ImageIcon;
import genj.util.swing.PopupWidget;
import genj.view.SelectionSink;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;

public class HistoryWidget
extends JToolBar {
    private static final Icon POPUP = GraphicsHelper.getIcon(Color.BLACK, 0.0, 0.0, 8.0, 0.0, 4.0, 4.0);
    private List<Entity> history = new ArrayList<Entity>();
    private int index = -1;
    private EventHandler events = new EventHandler();
    private Back back = new Back();
    private Forward forward = new Forward();
    private Popup pick = new Popup();

    public HistoryWidget(Workbench workbench) {
        workbench.addWorkbenchListener(this.events);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(this.back);
        this.add(this.forward);
        this.add(this.pick);
        this.setFloatable(false);
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public JButton add(Action action) {
        JButton jButton = super.add(action);
        jButton.setFocusable(false);
        return jButton;
    }

    private void fireSelection(Entity entity) {
        SelectionSink.Dispatcher.fireSelection(this, new Context(entity), true);
    }

    private void update() {
        this.forward.setEnabled(this.index < this.history.size() - 1);
        this.back.setEnabled(this.index > 0);
        this.pick.setEnabled(this.history.size() > 1);
    }

    private class EventHandler
    extends WorkbenchAdapter
    implements GedcomListener {
        private EventHandler() {
        }

        public void gedcomClosed(Workbench workbench, Gedcom gedcom) {
            HistoryWidget.this.history.clear();
            HistoryWidget.this.index = -1;
            HistoryWidget.this.update();
            gedcom.removeGedcomListener(this);
        }

        public void gedcomOpened(Workbench workbench, Gedcom gedcom) {
            gedcom.addGedcomListener(this);
        }

        public void selectionChanged(Workbench workbench, Context context, boolean bl) {
            Entity entity = context.getEntity();
            if (entity == null) {
                return;
            }
            if (!HistoryWidget.this.history.isEmpty() && HistoryWidget.this.history.get(HistoryWidget.this.index) == entity) {
                return;
            }
            while (HistoryWidget.this.history.size() > HistoryWidget.this.index + 1) {
                HistoryWidget.this.history.remove(HistoryWidget.this.history.size() - 1);
            }
            HistoryWidget.this.history.add(++HistoryWidget.this.index, entity);
            while (HistoryWidget.this.history.size() > 16) {
                HistoryWidget.this.index--;
                HistoryWidget.this.history.remove(0);
            }
            HistoryWidget.this.update();
        }

        public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
        }

        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
            Entity entity2;
            int n = HistoryWidget.this.history.indexOf(entity);
            if (n < 0) {
                return;
            }
            HistoryWidget.this.history.remove(n);
            if (HistoryWidget.this.index >= n) {
                HistoryWidget.this.index--;
            }
            if (--n < 0 && HistoryWidget.this.history.size() > 0) {
                ++n;
            }
            if (n >= 0) {
                HistoryWidget.this.fireSelection((Entity)HistoryWidget.this.history.get(n));
            }
            if (n < 0 && (entity2 = gedcom.getFirstEntity("INDI")) != null) {
                HistoryWidget.this.fireSelection(entity2);
            }
            HistoryWidget.this.update();
        }

        public void gedcomPropertyAdded(Gedcom gedcom, Property property, int n, Property property2) {
        }

        public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
        }

        public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int n, Property property2) {
        }
    }

    private class Forward
    extends Action2 {
        public Forward() {
            this.install(HistoryWidget.this, "alt RIGHT");
            this.setImage(new ImageIcon(this, "images/Forward.png"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (HistoryWidget.this.index == HistoryWidget.this.history.size() - 1) {
                return;
            }
            HistoryWidget.this.index++;
            HistoryWidget.this.update();
            HistoryWidget.this.fireSelection((Entity)HistoryWidget.this.history.get(HistoryWidget.this.index));
        }
    }

    private class Back
    extends Action2 {
        public Back() {
            this.setImage(new ImageIcon(this, "images/Back.png"));
            this.install(HistoryWidget.this, "alt LEFT");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (HistoryWidget.this.index < 1) {
                return;
            }
            HistoryWidget.this.index--;
            HistoryWidget.this.update();
            HistoryWidget.this.fireSelection((Entity)HistoryWidget.this.history.get(HistoryWidget.this.index));
        }
    }

    private class Jump
    extends Action2 {
        private int i;

        public Jump(int n) {
            this.i = n;
            Entity entity = (Entity)HistoryWidget.this.history.get(n);
            this.setImage(entity.getImage());
            this.setText(entity.toString());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HistoryWidget.this.index = this.i;
            HistoryWidget.this.update();
            HistoryWidget.this.fireSelection((Entity)HistoryWidget.this.history.get(this.i));
        }
    }

    private class Popup
    extends PopupWidget {
        Popup() {
            super(POPUP);
        }

        public void showPopup() {
            this.removeItems();
            for (int i = 0; i < HistoryWidget.this.history.size(); ++i) {
                JMenuItem jMenuItem = new JMenuItem(new Jump(i));
                if (HistoryWidget.this.index == i) {
                    jMenuItem.setFont(jMenuItem.getFont().deriveFont(1));
                }
                this.addItem(jMenuItem);
            }
            super.showPopup();
        }
    }
}

