/*
 * Decompiled with CFR 0.152.
 */
package genj.common;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyComparator;
import genj.gedcom.TagPath;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.WordBuffer;
import genj.util.swing.Action2;
import genj.util.swing.ImageIcon;
import genj.util.swing.PopupWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;

public class SelectEntityWidget
extends JPanel {
    private static final Resources RESOURCES = Resources.get(SelectEntityWidget.class);
    private static final Registry REGISTRY = Registry.get(SelectEntityWidget.class);
    public static final String NEW = RESOURCES.getString("select.new");
    private String type = "INDI";
    private Gedcom gedcom;
    private Entity[] list;
    private Object none;
    private PopupWidget sortWidget;
    private JComboBox listWidget;
    private TagPath sort;
    private List<TagPath> sorts;
    private static final String[] SORTS = new String[]{"INDI:NAME", "INDI", "INDI:BIRT:DATE", "INDI:DEAT:DATE", "FAM", "FAM:MARR:DATE", "FAM:HUSB:*:..:NAME", "FAM:WIFE:*:..:NAME", "OBJE", "OBJE:TITL", "OBJE:FILE:TITL", "NOTE", "NOTE:NOTE", "SOUR", "SOUR:TITL", "SOUR:AUTH", "SOUR:REPO", "SUBM", "SUBM:NAME", "REPO", "REPO:NAME", "REPO:REFN", "REPO:RIN"};

    public SelectEntityWidget(Gedcom gedcom, String string, String string2) {
        this.gedcom = gedcom;
        this.type = string;
        this.none = string2;
        Collection<? extends Entity> collection = gedcom.getEntities(string);
        this.list = new Entity[collection.size()];
        int n = 0;
        for (Entity object : collection) {
            if (!object.getTag().equals(string)) {
                throw new IllegalArgumentException("Type of all entities has to be " + string);
            }
            this.list[n++] = object;
        }
        this.sorts = new ArrayList<TagPath>(SORTS.length);
        for (int i = 0; i < SORTS.length; ++i) {
            String string3 = SORTS[i];
            if (!string3.startsWith(string)) continue;
            TagPath tagPath = new TagPath(string3);
            if (!gedcom.getGrammar().isValid(tagPath)) continue;
            this.sorts.add(tagPath);
            if (this.sort != null && !string3.equals(REGISTRY.get("select.sort." + string, ""))) continue;
            this.sort = tagPath;
        }
        this.sortWidget = new PopupWidget();
        for (TagPath tagPath : this.sorts) {
            this.sortWidget.addItem(new Sort(tagPath));
        }
        this.listWidget = new JComboBox();
        this.listWidget.setMaximumRowCount(16);
        this.listWidget.setEditable(false);
        this.listWidget.setRenderer(new Renderer());
        this.setLayout(new BorderLayout());
        this.add("Center", this.listWidget);
        this.add("West", this.sortWidget);
        this.sort(this.sort);
        if (string2 != null || this.list.length > 0) {
            this.listWidget.setSelectedIndex(0);
        }
    }

    public void sort(TagPath tagPath) {
        this.sort = tagPath;
        REGISTRY.put("select.sort." + this.type, tagPath.toString());
        PropertyComparator propertyComparator = new PropertyComparator(tagPath);
        Arrays.sort(this.list, propertyComparator);
        Entity entity = this.getSelection();
        this.listWidget.setModel(new Model());
        this.sortWidget.setIcon(this.getPathImage(tagPath));
        this.sortWidget.setToolTipText(RESOURCES.getString("select.sort", "..."));
        this.setSelection(entity);
    }

    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
    }

    public Dimension getPreferredSize() {
        return new Dimension(128, super.getPreferredSize().height);
    }

    public int getEntityCount() {
        return this.listWidget.getItemCount() - 1;
    }

    public Entity getSelection() {
        Object object = this.listWidget.getSelectedItem();
        if (!(object instanceof Entity)) {
            return null;
        }
        return (Entity)object;
    }

    public void setSelection(Entity entity) {
        if (entity == null) {
            this.listWidget.setSelectedItem(this.none != null ? this.none : null);
        } else if (entity.getTag().equals(this.type)) {
            this.listWidget.setSelectedItem(entity);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listWidget.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listWidget.removeActionListener(actionListener);
    }

    private MetaProperty getMeta(TagPath tagPath) {
        MetaProperty metaProperty = tagPath.length() > 1 && !tagPath.getLast().equals("TITL") ? this.gedcom.getGrammar().getMeta(new TagPath(tagPath, 2)) : this.gedcom.getGrammar().getMeta(tagPath);
        return metaProperty;
    }

    private ImageIcon getPathImage(TagPath tagPath) {
        return this.getMeta(tagPath).getImage();
    }

    private String getPathText(TagPath tagPath) {
        return RESOURCES.getString("select.sort", tagPath.length() == 1 ? "ID" : this.getMeta(tagPath).getName());
    }

    private class Sort
    extends Action2 {
        private TagPath tagPath;

        private Sort(TagPath tagPath) {
            this.tagPath = tagPath;
            this.setImage(SelectEntityWidget.this.getPathImage(tagPath));
            this.setText(SelectEntityWidget.this.getPathText(tagPath));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SelectEntityWidget.this.sort(this.tagPath);
        }
    }

    private class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object instanceof Entity ? this.getString((Entity)object) : (object != null ? object.toString() : "");
            return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
        }

        private String getString(Entity entity) {
            if (SelectEntityWidget.this.sort == null) {
                return entity.toString();
            }
            WordBuffer wordBuffer = new WordBuffer(", ");
            wordBuffer.append(this.getString(entity.getProperty(SelectEntityWidget.this.sort), "?"));
            for (TagPath tagPath : SelectEntityWidget.this.sorts) {
                if (tagPath.equals(SelectEntityWidget.this.sort) || !tagPath.getFirst().equals(SelectEntityWidget.this.sort.getFirst())) continue;
                wordBuffer.append(this.getString(entity.getProperty(tagPath), ""));
            }
            return wordBuffer.toString();
        }

        private String getString(Property property, String string) {
            if (property instanceof Entity) {
                return ((Entity)property).getId();
            }
            return property != null && property.isValid() ? property.getDisplayValue() : string;
        }
    }

    private class Model
    extends AbstractListModel
    implements ComboBoxModel {
        private Object selection;

        private Model() {
        }

        public Object getSelectedItem() {
            return this.selection;
        }

        public void setSelectedItem(Object object) {
            this.selection = object;
        }

        public Object getElementAt(int n) {
            if (SelectEntityWidget.this.none != null) {
                return n == 0 ? SelectEntityWidget.this.none : SelectEntityWidget.this.list[n - 1];
            }
            return SelectEntityWidget.this.list[n];
        }

        public int getSize() {
            return SelectEntityWidget.this.list.length + (SelectEntityWidget.this.none != null ? 1 : 0);
        }
    }
}

