/*
 * Decompiled with CFR 0.152.
 */
package genj.fo;

import genj.fo.Format;
import genj.fo.PDFFormat;
import genj.gedcom.Entity;
import genj.util.ImageSniffer;
import genj.util.Resources;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Document {
    public static final int FONT_XX_SMALL = 0;
    public static final int FONT_X_SMALL = 1;
    public static final int FONT_SMALL = 2;
    public static final int FONT_MEDIUM = 3;
    public static final int FONT_LARGE = 4;
    public static final int FONT_X_LARGE = 5;
    public static final int FONT_XX_LARGE = 6;
    private static final Resources RESOURCES = Resources.get(Document.class);
    protected static final Pattern REGEX_ATTR = Pattern.compile("([^,]+)=([^,\\(]*(\\(.*?\\))?)");
    private static final String NS_XSLFO = "http://www.w3.org/1999/XSL/Format";
    private static final String NS_GENJ = "http://genj.sourceforge.net/XSL/Format";
    private org.w3c.dom.Document doc;
    private Element cursor;
    private String title;
    private boolean needsTOC = false;
    private Map file2elements = new HashMap();
    private List toc = new ArrayList();
    private String formatSection = "font-weight=bold,space-before=0.5cm,space-after=0.2cm,keep-with-next.within-page=always";
    private String formatSectionLarger = "font-size=larger," + this.formatSection;
    private static final String[] fontSizes = new String[]{"xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large"};
    private int minSectionFontSize;
    private int maxSectionFontSize;
    private Map index2primary2secondary2elements = new TreeMap();
    private int idSequence = 0;
    private boolean containsCSV = false;

    public Document(String string) {
        this.title = string;
        this.setSectionSizes(3, 6);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            this.doc = documentBuilderFactory.newDocumentBuilder().newDocument();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        this.cursor = (Element)this.doc.appendChild(this.doc.createElementNS(NS_XSLFO, "root"));
        this.cursor.setAttribute("xmlns", NS_XSLFO);
        this.cursor.setAttribute("xmlns:genj", NS_GENJ);
        this.cursor.setAttributeNS(NS_GENJ, "genj:title", string);
        this.push("layout-master-set");
        this.push("simple-page-master", "master-name=master,margin-top=1cm,margin-bottom=1cm,margin-left=1cm,margin-right=1cm");
        this.push("region-body", "margin-bottom=1cm").pop();
        this.push("region-after", "extent=0.8cm").pop();
        this.pop().pop().push("page-sequence", "master-reference=master");
        this.push("static-content", "flow-name=xsl-region-after");
        this.push("block", "text-align=center");
        this.push("page-number").pop();
        this.pop();
        this.pop();
        this.push("flow", "flow-name=xsl-region-body");
        this.push("block");
    }

    public void setSectionSizes(int n, int n2) {
        if (n < 0 || n > n2 || n2 > fontSizes.length - 1) {
            throw new IllegalArgumentException("setSectionSizes(" + n + "," + n2 + ")");
        }
        this.minSectionFontSize = n;
        this.maxSectionFontSize = n2;
    }

    protected boolean containsCSV() {
        return this.containsCSV;
    }

    public String toString() {
        return this.getTitle();
    }

    protected void close() {
        if (this.cursor == null) {
            return;
        }
        this.indexes();
        if (this.needsTOC) {
            this.toc();
        }
        this.cursor = null;
    }

    public String getTitle() {
        return this.title;
    }

    DOMSource getDOMSource() {
        return new DOMSource(this.doc);
    }

    public Document addTOC() {
        this.needsTOC = true;
        return this;
    }

    public Document addTOCEntry(String string) {
        this.addTOC();
        String string2 = "toc" + this.toc.size();
        this.addAnchor(string2);
        this.toc.add(new TOCEntry(string2, string));
        return this;
    }

    private String getFontSize(int n) {
        int n2 = this.maxSectionFontSize + 1 - n;
        if (n2 < this.minSectionFontSize) {
            n2 = this.minSectionFontSize;
        }
        return fontSizes[n2];
    }

    public Document startSection(String string, String string2, int n) {
        if (string2 != null && string2.startsWith("_")) {
            throw new IllegalArgumentException("underscore is reserved for internal IDs");
        }
        this.pop("flow", "addSection() is not applicable outside document flow");
        this.cursor = (Element)this.cursor.getLastChild();
        if (string2 == null || string2.length() == 0) {
            string2 = "toc" + this.toc.size();
        }
        String string3 = this.getFontSize(n);
        this.pop().push("block", "font-size=" + string3 + "," + this.formatSection + ",id=" + string2);
        this.toc.add(new TOCEntry(string2, string));
        this.addText(string);
        this.nextParagraph();
        return this;
    }

    public Document startSection(String string, String string2) {
        return this.startSection(string, string2, 1);
    }

    public Document startSection(String string, Entity entity, int n) {
        return this.startSection(string, entity.getTag() + "_" + entity.getId(), n);
    }

    public Document startSection(String string, Entity entity) {
        return this.startSection(string, entity.getTag() + "_" + entity.getId());
    }

    public Document startSection(String string, int n) {
        return this.startSection(string, "", n);
    }

    public Document startSection(String string) {
        return this.startSection(string, "");
    }

    public Document addIndexTerm(String string, String string2) {
        return this.addIndexTerm(string, string2, "");
    }

    public Document addIndexTerm(String string, String string2, String string3) {
        String string4;
        ArrayList<Element> arrayList;
        TreeMap treeMap;
        if (string == null) {
            throw new IllegalArgumentException("addIndexTerm() requires name of index");
        }
        if ((string = string.trim()).length() == 0) {
            throw new IllegalArgumentException("addIndexTerm() name of index can't be empty");
        }
        if ((string2 = this.trimIndexTerm(string2)).length() == 0) {
            return this;
        }
        string3 = this.trimIndexTerm(string3);
        TreeMap treeMap2 = (TreeMap)this.index2primary2secondary2elements.get(string);
        if (treeMap2 == null) {
            treeMap2 = new TreeMap();
            this.index2primary2secondary2elements.put(string, treeMap2);
        }
        if ((treeMap = (TreeMap)treeMap2.get(string2)) == null) {
            treeMap = new TreeMap();
            treeMap2.put(string2, treeMap);
        }
        if ((arrayList = (ArrayList<Element>)treeMap.get(string3)) == null) {
            arrayList = new ArrayList<Element>();
            treeMap.put(string3, arrayList);
        }
        if ((string4 = this.cursor.getAttribute("id")).length() == 0) {
            string4 = "" + ++this.idSequence;
            this.cursor.setAttribute("id", string4);
        }
        if (!arrayList.contains(this.cursor)) {
            arrayList.add(this.cursor);
        }
        return this;
    }

    private String trimIndexTerm(String string) {
        int n;
        if (string == null) {
            return "";
        }
        int n2 = string.indexOf(40);
        if (n2 >= 0) {
            string = string.substring(0, n2);
        }
        if ((n = string.indexOf(40)) >= 0) {
            string = string.substring(0, n);
        }
        return string.trim();
    }

    public Document addText(String string) {
        return this.addText(string, "");
    }

    public Document addText(String string, String string2) {
        this.text(string, string2);
        return this;
    }

    public Document addImage(File file, String string) {
        if (file == null || !file.exists()) {
            return this;
        }
        Dimension2D dimension2D = new ImageSniffer(file).getDimensionInInches();
        if (dimension2D == null) {
            return this;
        }
        if (dimension2D.getWidth() > dimension2D.getHeight()) {
            if (dimension2D.getWidth() > 1.0) {
                string = "width=1in,content-width=scale-to-fit," + string;
            }
        } else if (dimension2D.getHeight() > 1.0) {
            string = "height=1in,content-height=scale-to-fit," + string;
        }
        this.push("external-graphic", "src=" + file.getAbsolutePath() + "," + string);
        ArrayList<Element> arrayList = (ArrayList<Element>)this.file2elements.get(file);
        if (arrayList == null) {
            arrayList = new ArrayList<Element>(3);
            this.file2elements.put(file, arrayList);
        }
        arrayList.add(this.cursor);
        this.pop();
        this.addText(" ");
        return this;
    }

    protected File[] getImages() {
        Set set = this.file2elements.keySet();
        return set.toArray(new File[set.size()]);
    }

    protected void setImage(File file, String string) {
        List list = (List)this.file2elements.get(file);
        for (int i = 0; i < list.size(); ++i) {
            Element element = (Element)list.get(i);
            element.setAttribute("src", string);
        }
    }

    public Document nextParagraph() {
        return this.nextParagraph("");
    }

    public Document nextParagraph(String string) {
        if (this.cursor.getFirstChild() != null) {
            this.pop().push("block", string);
        } else {
            this.attributes(this.cursor, string);
        }
        return this;
    }

    public Document startList() {
        return this.startList("");
    }

    public Document startList(String string) {
        this.pop();
        this.push("list-block", "provisional-distance-between-starts=0.6em, provisional-label-separation=0pt," + string);
        this.nextListItem();
        return this;
    }

    public Document nextListItem() {
        return this.nextListItem("");
    }

    public Document nextListItem(String string) {
        Element element = this.peek("list-block", "nextListItem() is not applicable outside list block");
        if (element.getChildNodes().getLength() == 1 && this.cursor.getFirstChild() == null && this.cursor.getPreviousSibling() == null && this.cursor.getParentNode().getLocalName().equals("list-item-body")) {
            element.removeChild(element.getFirstChild());
        }
        this.cursor = element;
        String string2 = this.attribute("genj:label", string);
        if (string2 != null) {
            String string3 = element.getAttribute("provisional-distance-between-starts");
            if (string3.endsWith("em")) {
                float f = (float)string2.length() * 0.6f;
                if (Float.parseFloat(string3.substring(0, string3.length() - 2)) < f) {
                    element.setAttribute("provisional-distance-between-starts", f + "em");
                }
            }
        } else {
            string2 = "\u2219";
        }
        this.push("list-item");
        this.push("list-item-label", "end-indent=label-end()");
        this.push("block");
        this.text(string2, "");
        this.pop();
        this.pop();
        this.push("list-item-body", "start-indent=body-start()");
        this.push("block");
        return this;
    }

    public Document endList() {
        this.pop("list-block", "endList() is not applicable outside list-block").pop();
        this.push("block", "");
        return this;
    }

    public Document startTable() {
        return this.startTable("width=100%,border=0.5pt solid black");
    }

    public Document startTable(String string) {
        string = "table-layout=fixed," + string;
        this.push("table", string);
        Element element = this.cursor;
        if ("true".equals(this.attribute("genj:csv", string))) {
            this.containsCSV = true;
            this.cursor.setAttributeNS(NS_GENJ, "genj:csv", "true");
            String string2 = this.attribute("genj:csvprefix", string);
            if (string2 != null) {
                this.cursor.setAttributeNS(NS_GENJ, "genj:csvprefix", string2);
            }
        }
        if (string.indexOf("genj:header=true") >= 0) {
            this.push("table-header");
            this.push("table-row", "color=#ffffff,background-color=#c0c0c0,font-weight=bold");
        } else {
            this.push("table-body");
            this.push("table-row");
        }
        this.push("table-cell", "border=" + element.getAttribute("border"));
        this.push("block");
        return this;
    }

    public Document addTableColumn(String string) {
        Node node;
        Element element = this.cursor;
        this.pop("table", "addTableColumn() is not applicable outside enclosing table");
        for (node = this.cursor.getFirstChild(); node != null && node.getNodeName().equals("table-column"); node = node.getNextSibling()) {
        }
        this.push("table-column", string, node);
        this.cursor = element;
        return this;
    }

    public Document nextTableCell() {
        return this.nextTableCell("");
    }

    public Document nextTableCell(String string) {
        Element element = this.peek("table-cell", "nextTableCell() is not applicable outside enclosing table");
        if (element.getPreviousSibling() == null && this.cursor == element.getFirstChild() && !this.cursor.hasChildNodes()) {
            this.attributes(element, string);
            this.push("inline", "").pop();
            return this;
        }
        Element element2 = this.peek("table-row", "nextTableCell() is not applicable outside enclosing table row");
        int n = element2.getElementsByTagName("table-cell").getLength();
        Element element3 = this.peek("table", "nextTableCell() is not applicable outside enclosing table");
        int n2 = element3.getElementsByTagName("table-column").getLength();
        if (n2 > 0 && n == n2) {
            return this.nextTableRow();
        }
        this.pop("table-row", "nextTableCell() is not applicable outside enclosing table row");
        this.push("table-cell", "border=" + element3.getAttribute("border") + "," + string);
        this.push("block");
        return this;
    }

    public Document nextTableRow() {
        return this.nextTableRow("");
    }

    public Document nextTableRow(String string) {
        Element element = this.peek("table-cell", "nextTableRow() is not applicable outside enclosing table");
        if (element.getPreviousSibling() == null && this.cursor == element.getFirstChild() && !this.cursor.hasChildNodes()) {
            this.attributes((Element)element.getParentNode(), string);
            return this;
        }
        this.pop("table", "nextTableRow() is not applicable outside enclosing table");
        Element element2 = this.cursor;
        if (element2.getLastChild().getNodeName().equals("table-body")) {
            this.cursor = (Element)element2.getLastChild();
        } else {
            this.push("table-body");
        }
        this.push("table-row", string);
        this.push("table-cell", "border=" + element2.getAttribute("border"));
        this.push("block");
        return this;
    }

    public Document endTable() {
        this.pop("table", "endTable() is not applicable outside enclosing table").pop();
        return this;
    }

    public Document nextPage() {
        this.pop();
        this.push("block", "page-break-before=always");
        return this;
    }

    public Document addAnchor(String string) {
        if (string.startsWith("_")) {
            throw new IllegalArgumentException("underscore is reserved for internal IDs");
        }
        if (this.cursor.getAttribute("id").length() == 0) {
            this.cursor.setAttribute("id", string);
        } else {
            this.push("block", "id=" + string).pop();
        }
        return this;
    }

    public Document addAnchor(Entity entity) {
        return this.addAnchor(entity.getTag() + "_" + entity.getId());
    }

    public Document addExternalLink(String string, String string2) {
        this.push("basic-link", "external-destination=" + string2);
        this.text(string, "");
        this.pop();
        return this;
    }

    public Document addLink(String string, String string2) {
        this.push("basic-link", "internal-destination=" + string2);
        this.text(string, "");
        this.pop();
        return this;
    }

    public Document addLink(String string, Entity entity) {
        this.addLink(string, entity.getTag() + "_" + entity.getId());
        return this;
    }

    public Document addLink(Entity entity) {
        return this.addLink(entity.toString(), entity);
    }

    private Document indexes() {
        for (String string : this.index2primary2secondary2elements.keySet()) {
            Map map = (Map)this.index2primary2secondary2elements.get(string);
            this.nextPage();
            this.startSection(string);
            this.push("block", "start-indent=1cm");
            for (String string2 : map.keySet()) {
                Map map2 = (Map)map.get(string2);
                this.push("block", "");
                this.text(string2 + " ", "");
                for (String string3 : map2.keySet()) {
                    List list = (List)map2.get(string3);
                    if (string3.length() > 0) {
                        this.push("block", "start-indent=2cm");
                        this.text(string3 + " ", "");
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        if (i > 0) {
                            this.text(", ", "");
                        }
                        Element element = (Element)list.get(i);
                        String string4 = element.getAttribute("id");
                        this.push("basic-link", "internal-destination=" + string4);
                        this.push("page-number-citation", "ref-id=" + string4);
                        this.cursor.setAttributeNS(NS_GENJ, "genj:citation", Integer.toString(i + 1));
                        this.pop();
                        this.pop();
                    }
                    if (string3.length() <= 0) continue;
                    this.pop();
                }
                this.pop();
            }
            this.pop();
        }
        return this;
    }

    private Document toc() {
        if (this.toc.isEmpty()) {
            return this;
        }
        Element element = this.cursor;
        this.pop("flow", "can't create TOC without enclosing flow");
        this.push("block", "", this.cursor.getFirstChild());
        this.push("block", this.formatSectionLarger);
        this.text(RESOURCES.getString("toc"), "");
        this.pop();
        Iterator iterator = this.toc.iterator();
        while (iterator.hasNext()) {
            this.push("block", "start-indent=1cm,end-indent=1cm,text-indent=0cm,text-align-last=justify,text-align=justify");
            TOCEntry tOCEntry = (TOCEntry)iterator.next();
            this.addLink(tOCEntry.text, tOCEntry.id);
            this.push("leader", "leader-pattern=dots").pop();
            this.push("page-number-citation", "ref-id=" + tOCEntry.id).pop();
            this.pop();
        }
        this.cursor = element;
        return this;
    }

    private Document push(String string) {
        return this.push(string, "");
    }

    private Document push(String string, String string2) {
        return this.push(string, string2, null);
    }

    private Document push(String string, String string2, Node node) {
        Element element = this.doc.createElementNS(NS_XSLFO, string);
        if (node != null) {
            this.cursor.insertBefore(element, node);
        } else {
            this.cursor.appendChild(element);
        }
        this.cursor = element;
        return this.attributes(element, string2);
    }

    private Document attributes(Element element, String string) {
        Matcher matcher = REGEX_ATTR.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(1).trim();
            if (string2.indexOf(58) >= 0) continue;
            String string3 = matcher.group(2).trim();
            element.setAttribute(string2, string3);
        }
        return this;
    }

    private String attribute(String string, String string2) {
        Matcher matcher = REGEX_ATTR.matcher(string2);
        while (matcher.find()) {
            if (!matcher.group(1).trim().equals(string)) continue;
            return matcher.group(2).trim();
        }
        return null;
    }

    private Document text(String string, String string2) {
        if (string.length() == 0) {
            return this;
        }
        Text text = this.doc.createTextNode(string);
        if (string2.length() > 0) {
            this.push("inline", string2);
            this.cursor.appendChild(text);
            this.pop();
        } else {
            this.cursor.appendChild(text);
        }
        return this;
    }

    private Document pop() {
        this.cursor = (Element)this.cursor.getParentNode();
        return this;
    }

    private Document pop(String string, String string2) {
        this.cursor = this.peek(string, string2);
        return this;
    }

    private Element peek(String string, String string2) {
        Node node = this.cursor;
        while (node instanceof Element) {
            if (node.getLocalName().equals(string)) {
                return node;
            }
            node = node.getParentNode();
        }
        throw new IllegalArgumentException(string2);
    }

    public static void main(String[] stringArray) {
        try {
            Document document = new Document("Testing FO");
            document.addText("A paragraph");
            document.nextParagraph("start-indent=10pt");
            document.addText("The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. ");
            document.nextParagraph("text-decoration=underline");
            document.addText("this paragraph is underlined");
            document.nextParagraph();
            document.addText("this line contains ");
            document.addText("underlined", "text-decoration=underline");
            document.addText(" text");
            document.startList();
            document.nextListItem("genj:label=a)");
            document.addText("A foo'd bullet");
            document.nextListItem("genj:label=b)");
            document.addText("A foo'd bullet");
            document.nextListItem();
            document.addText("A normal bullet");
            document.addTOC();
            document.startSection("Section 1");
            document.addText("here comes a ").addText("table", "font-weight=bold, color=rgb(255,0,0)").addText(" for you:");
            document.addImage(new File("C:/Documents and Settings/Nils/My Documents/Java/Workspace/GenJ/gedcom/meiern.jpg"), "vertical-align=middle");
            document.addImage(new File("C:/Documents and Settings/Nils/My Documents/My Pictures/usamap.gif"), "vertical-align=middle");
            document.startSection("Section 2");
            document.addText("Text and a page break");
            document.addTOCEntry("Foo");
            document.startSection("Section 3");
            document.addText("Text");
            Format format = stringArray.length > 0 ? Format.getFormat(stringArray[0]) : new PDFFormat();
            File file = null;
            String string = format.getFileExtension();
            if (string != null) {
                file = new File("c:/temp/foo." + string);
            }
            format.format(document, file);
            if (file != null) {
                Runtime.getRuntime().exec("c:/Program Files/Internet Explorer/iexplore.exe \"" + file.getAbsolutePath() + "\"");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private class TOCEntry {
        String id;
        String text;

        private TOCEntry(String string, String string2) {
            this.id = string;
            this.text = string2;
        }
    }
}

