/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import genj.gedcom.PropertySimpleValue;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.util.swing.ImageIcon;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaProperty
implements Comparable<MetaProperty> {
    public static final int WHERE_NOT_HIDDEN = 1;
    public static final int WHERE_DEFAULT = 2;
    public static final int WHERE_CARDINALITY_ALLOWS = 4;
    private static Map<String, ImageIcon> name2images = new HashMap<String, ImageIcon>();
    public static final ImageIcon IMG_CUSTOM = MetaProperty.loadImage("Attribute");
    public static final ImageIcon IMG_LINK = MetaProperty.loadImage("Association");
    public static final ImageIcon IMG_UNKNOWN = MetaProperty.loadImage("Question");
    public static final ImageIcon IMG_ERROR = MetaProperty.loadImage("Error");
    public static final ImageIcon IMG_PRIVATE = MetaProperty.loadImage("Private");
    private Grammar grammar;
    private String tag;
    private ImageIcon image;
    private String name;
    private String names;
    private Class<? extends Property>[] types;
    private String info;
    boolean isInstantiated = false;
    private boolean isGrammar;
    private Map<String, String> attrs;
    private Map<String, MetaProperty> tag2nested = new HashMap<String, MetaProperty>();
    List<MetaProperty> nested = new ArrayList<MetaProperty>();

    MetaProperty(Grammar grammar, String string, Map<String, String> map, boolean bl) {
        this.grammar = grammar;
        this.tag = string;
        this.attrs = map;
        this.isGrammar = bl;
        MetaProperty metaProperty = this.getSuper();
        if (metaProperty != null) {
            this.copyAttributesFrom(metaProperty);
        }
    }

    private void copyAttributesFrom(MetaProperty metaProperty) {
        for (MetaProperty metaProperty2 : new ArrayList<MetaProperty>(metaProperty.nested)) {
            if ("0".equals(metaProperty2.attrs.get("inherit"))) continue;
            this.addNested(metaProperty2);
        }
        if (this.getAttribute("type") == null) {
            this.attrs.put("type", metaProperty.getAttribute("type"));
        }
        if (this.getAttribute("img") == null) {
            this.attrs.put("img", metaProperty.getAttribute("img"));
        }
        if (this.getAttribute("cardinality") == null) {
            this.attrs.put("cardinality", metaProperty.getAttribute("cardinality"));
        }
        if (this.getAttribute("hide") == null) {
            this.attrs.put("hide", metaProperty.getAttribute("hide"));
        }
    }

    public MetaProperty getSuper() {
        String string = this.attrs.get("super");
        return string == null ? null : this.grammar.getMetaRecursively(new TagPath(string), false);
    }

    synchronized void addNested(MetaProperty metaProperty) {
        if (metaProperty == null) {
            throw new IllegalArgumentException("Nested meta can't be null");
        }
        this.tag2nested.put(metaProperty.tag, metaProperty);
        for (int i = 0; i < this.nested.size(); ++i) {
            MetaProperty metaProperty2 = this.nested.get(i);
            if (!metaProperty2.tag.equals(metaProperty.tag)) continue;
            metaProperty.copyAttributesFrom(metaProperty2);
            this.nested.set(i, metaProperty);
            return;
        }
        this.nested.add(metaProperty);
    }

    MetaProperty[] getAllNested(Property property, int n) {
        ArrayList<MetaProperty> arrayList = new ArrayList<MetaProperty>(this.nested.size());
        for (int i = 0; i < this.nested.size(); ++i) {
            MetaProperty metaProperty = this.nested.get(i);
            if ((n & 2) != 0 && !metaProperty.isDefault() || (n & 1) != 0 && metaProperty.getAttribute("hide") != null || "0".equals(metaProperty.getAttribute("xref")) && property instanceof PropertyXRef || "1".equals(metaProperty.getAttribute("xref")) && !(property instanceof PropertyXRef) || (n & 4) != 0 && metaProperty.isSingleton() && property.getProperty(metaProperty.getTag()) != null) continue;
            arrayList.add(metaProperty);
        }
        return arrayList.toArray(new MetaProperty[arrayList.size()]);
    }

    String getAttribute(String string) {
        return this.attrs.get(string);
    }

    void assertTag(String string) throws GedcomException {
        if (!this.tag.equals(string)) {
            throw new GedcomException("Tag should be " + string + " but is " + this.tag);
        }
    }

    public boolean isEntity() {
        return Entity.class.isAssignableFrom(this.getType());
    }

    public boolean isSingleton() {
        String string = this.getAttribute("cardinality");
        return string != null && string.endsWith(":1");
    }

    public boolean isVersion(String string) {
        String string2 = this.getAttribute("gedcom");
        return string2 == null || string2.equals(string);
    }

    public boolean isDefault() {
        String string = this.getAttribute("default");
        return string != null && "1".equals(string);
    }

    public boolean isRequired() {
        String string = this.getAttribute("cardinality");
        return string != null && string.startsWith("1:");
    }

    @Override
    public int compareTo(MetaProperty metaProperty) {
        return Collator.getInstance().compare(this.getName(), metaProperty.getName());
    }

    public boolean allows(String string) {
        MetaProperty metaProperty = this.tag2nested.get(string);
        return metaProperty == null ? false : metaProperty.isGrammar;
    }

    public boolean allows(String string, Class<? extends Property> clazz) {
        MetaProperty metaProperty = this.tag2nested.get(string);
        return metaProperty != null && clazz.isAssignableFrom(metaProperty.getType());
    }

    public Property create(String string) throws GedcomException {
        Property property = null;
        try {
            property = this.getType(string).getDeclaredConstructor(String.class).newInstance(this.getTag());
        }
        catch (Exception exception) {
            Gedcom.LOG.log(Level.WARNING, "Couldn't instantiate property " + this.getType() + " with value '" + string, exception);
            property = new PropertySimpleValue(this.getTag());
        }
        property.setValue(string);
        this.isInstantiated = true;
        return property;
    }

    public boolean isInstantiated() {
        return this.isInstantiated;
    }

    public ImageIcon getImage() {
        if (this.image == null) {
            String string = this.getAttribute("img");
            this.image = string == null ? (this.getTag().startsWith("_") ? IMG_CUSTOM : IMG_UNKNOWN) : MetaProperty.loadImage(string);
        }
        return this.image;
    }

    public ImageIcon getImage(String string) {
        String string2 = this.getAttribute("img." + string);
        if (string2 == null) {
            if ("err".equals(string)) {
                return IMG_ERROR;
            }
            return this.getImage();
        }
        return MetaProperty.loadImage(string2.toString());
    }

    public String getTag() {
        return this.tag;
    }

    public Class<? extends Property> getType() {
        return this.getTypes()[0];
    }

    public Class<? extends Property> getType(String string) {
        for (Class<? extends Property> clazz : this.getTypes()) {
            if (PropertyXRef.class.isAssignableFrom(clazz) && (!string.trim().startsWith("@") || !string.trim().endsWith("@"))) continue;
            return clazz;
        }
        return PropertySimpleValue.class;
    }

    public Class<? extends Property>[] getTypes() {
        if (this.types == null) {
            String string = this.getAttribute("type");
            if (string == null) {
                this.types = new Class[]{PropertySimpleValue.class};
            } else {
                try {
                    String[] stringArray = string.split("\\|");
                    this.types = new Class[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.types[i] = Class.forName("genj.gedcom." + stringArray[i]);
                    }
                }
                catch (Throwable throwable) {
                    Gedcom.LOG.log(Level.WARNING, "Property type(s) genj.gedcom." + string + " couldn't be instantiated", throwable);
                    this.types = new Class[]{PropertySimpleValue.class};
                }
            }
        }
        return this.types;
    }

    public String getName() {
        return this.getName(false);
    }

    public String getCardinality() {
        return this.attrs.get("cardinality");
    }

    public String getName(boolean bl) {
        String string;
        if (bl) {
            string = this.names;
            if (string == null) {
                string = Gedcom.getName(this.tag, true);
            }
            this.names = string;
        } else {
            string = this.name;
            if (string == null) {
                string = Gedcom.getName(this.tag, false);
            }
            this.name = string;
        }
        return string;
    }

    public String getInfo() {
        if (this.info == null) {
            this.info = Gedcom.getResources().getString(this.tag + ".info", false);
            if (this.info == null) {
                char c = this.tag.charAt(0);
                if (c != '_') {
                    c = '?';
                }
                this.info = Gedcom.getResources().getString(c + ".info");
            }
            this.info = this.getName() + ":\n" + this.info;
        }
        return this.info;
    }

    public MetaProperty getNestedRecursively(TagPath tagPath, boolean bl) {
        String string = tagPath.get(0);
        if (!this.tag.equals(string) && !".".equals(string)) {
            throw new IllegalArgumentException();
        }
        return this.getNestedRecursively(tagPath, 1, bl);
    }

    MetaProperty getNestedRecursively(TagPath tagPath, int n, boolean bl) {
        if (n == tagPath.length()) {
            return this;
        }
        return this.getNested(tagPath.get(n), bl).getNestedRecursively(tagPath, n + 1, bl);
    }

    public MetaProperty getNested(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("tag can't be empty");
        }
        MetaProperty metaProperty = this.tag2nested.get(string);
        if (metaProperty == null) {
            metaProperty = new MetaProperty(this.grammar, string, new HashMap<String, String>(), false);
            if (bl) {
                this.addNested(metaProperty);
            }
        }
        return metaProperty;
    }

    public int getNestedIndex(String string) {
        if (string.equals("CHAN")) {
            return Integer.MAX_VALUE;
        }
        for (int i = 0; i < this.nested.size(); ++i) {
            if (!this.nested.get(i).getTag().equals(string)) continue;
            return i;
        }
        return Integer.MAX_VALUE;
    }

    private static ImageIcon loadImage(String string) {
        ImageIcon imageIcon = name2images.get(string);
        if (imageIcon == null) {
            try {
                while (true) {
                    try {
                        imageIcon = new ImageIcon(MetaProperty.class, "images/" + string);
                        name2images.put(string, imageIcon);
                    }
                    catch (IllegalStateException illegalStateException) {
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                Gedcom.LOG.log(Level.WARNING, "Unexpected problem reading " + string, throwable);
                return IMG_ERROR;
            }
        }
        return imageIcon;
    }

    public String toString() {
        return this.getTag() + this.attrs;
    }
}

