/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.option.Option;
import genj.option.OptionProvider;
import genj.option.PropertyOption;
import genj.util.Resources;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Options
extends OptionProvider {
    private static final Resources RESOURCES = Resources.get(Options.class);
    private static final Options instance = new Options();
    public boolean isFillGapsInIDs = false;
    public boolean isUpperCaseNames = false;
    public boolean setWifeLastname = true;
    public boolean isAddGivenSurname = false;
    public boolean isAddAge = false;
    public boolean isUseInline = false;
    public int nameFormat = 1;
    public static final String[] nameFormats = new String[]{RESOURCES.getString("option.nameFormat.first"), RESOURCES.getString("option.nameFormat.last")};
    private int maxImageFileSizeKB = 128;
    private int valueLineBreak = 255;
    protected String txtMarriageSymbol = "+";
    protected int numberOfUndos = 10;
    protected Set<String> placeHierarchyCityKeys = new HashSet<String>(Arrays.asList("city", "commune", "ville", "stadt"));
    public int dateFormat = 1;
    public static final String[] dateFormats = new String[]{RESOURCES.getString("option.dateFormat.gedcom"), RESOURCES.getString("option.dateFormat.short"), RESOURCES.getString("option.dateFormat.long"), RESOURCES.getString("option.dateFormat.numeric")};

    public static Options getInstance() {
        return instance;
    }

    public void setMaxImageFileSizeKB(int n) {
        this.maxImageFileSizeKB = Math.max(4, n);
    }

    public int getMaxImageFileSizeKB() {
        return this.maxImageFileSizeKB;
    }

    public int getValueLineBreak() {
        return this.valueLineBreak;
    }

    public void setValueLineBreak(int n) {
        this.valueLineBreak = Math.max(40, n);
    }

    public String getTxtMarriageSymbol() {
        return this.txtMarriageSymbol;
    }

    public void setTxtMarriageSymbol(String string) {
        this.txtMarriageSymbol = string != null && string.trim().length() > 0 ? ' ' + string.trim() + ' ' : " + ";
    }

    public int getNumberOfUndos() {
        return this.numberOfUndos;
    }

    public void setNumberOfUndos(int n) {
        this.numberOfUndos = Math.max(10, n);
    }

    @Override
    public List<? extends Option> getOptions() {
        return PropertyOption.introspect(instance);
    }
}

