/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyFamilySpouse;
import genj.gedcom.PropertyHusband;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;

public class PropertyWife
extends PropertyXRef {
    static final TagPath PATH_INDIFAMS = new TagPath("INDI:FAMS");
    public static final String TAG = "WIFE";
    public static final String LABEL_MOTHER = Gedcom.resources.getString("WIFE.mother");

    public PropertyWife() {
        super(TAG);
    }

    protected PropertyWife(String string) {
        super(string);
        this.assertTag(TAG);
    }

    public String getDeleteVeto() {
        if (this.getTargetEntity() == null) {
            return null;
        }
        return resources.getString("prop.wife.veto");
    }

    public Indi getWife() {
        return (Indi)this.getTargetEntity();
    }

    public String getPropertyNameAsParent() {
        Indi indi = this.getWife();
        if (indi == null) {
            return LABEL_MOTHER;
        }
        switch (indi.getSex()) {
            case 1: {
                return PropertyHusband.LABEL_FATHER;
            }
        }
        return LABEL_MOTHER;
    }

    public void link() throws GedcomException {
        PropertyFamilySpouse propertyFamilySpouse;
        Fam fam = null;
        try {
            fam = (Fam)this.getEntity();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (fam == null) {
            throw new GedcomException(resources.getString("error.noenclosingfam"));
        }
        if (fam.getWife() != null) {
            throw new GedcomException(resources.getString("error.already.spouse", fam.getWife().toString(), fam.toString()));
        }
        Indi indi = (Indi)this.getCandidate();
        if (fam.getHusband() == indi) {
            throw new GedcomException(resources.getString("error.already.spouse", indi.toString(), fam.toString()));
        }
        if (indi.isDescendantOf(fam)) {
            throw new GedcomException(resources.getString("error.already.descendant", indi.toString(), fam.toString()));
        }
        Property[] propertyArray = indi.getProperties(PATH_INDIFAMS);
        for (int i = 0; i < propertyArray.length; ++i) {
            propertyFamilySpouse = (PropertyFamilySpouse)propertyArray[i];
            if (!propertyFamilySpouse.isCandidate(fam)) continue;
            this.link(propertyFamilySpouse);
            return;
        }
        propertyFamilySpouse = new PropertyFamilySpouse();
        indi.addProperty(propertyFamilySpouse);
        this.link(propertyFamilySpouse);
    }

    public String getTargetType() {
        return "INDI";
    }
}

