/*
 * Decompiled with CFR 0.152.
 */
package genj.report;

import genj.app.Workbench;
import genj.app.WorkbenchAdapter;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.report.Report;
import genj.report.ReportLoader;
import genj.report.ReportView;
import genj.report.ReportViewFactory;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.view.ActionProvider;
import genj.view.View;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportPlugin
extends WorkbenchAdapter
implements ActionProvider {
    private static final Resources RESOURCES = Resources.get(ReportPlugin.class);
    private static final int MAX_HISTORY = 5;
    private boolean showReportPickerOnOpen = true;
    private Workbench workbench;
    private Action2.Group workbenchActions = new Action2.Group(Resources.get(this).getString("report.reports"), null, true);

    public ReportPlugin(Workbench workbench) {
        this.workbench = workbench;
        workbench.addWorkbenchListener(this);
    }

    @Override
    public void createActions(Context context, ActionProvider.Purpose purpose, Action2.Group group) {
        if (context.getGedcom() == null) {
            return;
        }
        switch (purpose) {
            case TOOLBAR: {
                break;
            }
            case MENU: {
                this.workbenchActions.clear();
                HashMap<String, Action2.Group> hashMap = new HashMap<String, Action2.Group>();
                for (Report report : ReportLoader.getInstance().getReports()) {
                    try {
                        String string = report.accepts(context.getGedcom());
                        if (string == null) continue;
                        String string2 = report.getCategory();
                        Action2.Group group2 = (Action2.Group)hashMap.get(string2);
                        if (group2 == null) {
                            group2 = new Action2.Group(string2, report.getIcon(), true);
                            hashMap.put(string2, group2);
                            this.workbenchActions.add(group2);
                        }
                        group2.add(new ActionRun(report.accepts(context.getGedcom()), context.getGedcom(), report));
                    }
                    catch (Throwable throwable) {
                        ReportView.LOG.log(Level.WARNING, "Report " + report.getClass().getName() + " failed in accept()", throwable);
                    }
                }
                group.add(this.workbenchActions);
                break;
            }
            case CONTEXT: {
                Action2.Group group3;
                Iterable<Action2> iterable;
                List<? extends Property> list = context.getProperties();
                if (list.size() > 1) {
                    iterable = new ActionProvider.PropertiesActionGroup(list);
                    this.getActions(list, context.getGedcom(), (Action2.Group)iterable);
                    group.add((Action2)((Object)iterable));
                } else if (list.size() == 1) {
                    iterable = new ActionProvider.PropertyActionGroup(context.getProperty());
                    this.getActions(context.getProperty(), context.getGedcom(), (Action2.Group)iterable);
                    group.add((Action2)((Object)iterable));
                }
                iterable = context.getEntities();
                if (iterable.size() > 1) {
                    group3 = new ActionProvider.EntitiesActionGroup((List<? extends Entity>)iterable);
                    this.getActions(iterable, context.getGedcom(), group3);
                    group.add(group3);
                } else if (iterable.size() == 1) {
                    group3 = new ActionProvider.EntityActionGroup(context.getEntity());
                    this.getActions(context.getEntity(), context.getGedcom(), group3);
                    group.add(group3);
                }
                group3 = new ActionProvider.GedcomActionGroup(context.getGedcom());
                this.getActions(context.getGedcom(), context.getGedcom(), group3);
                group.add(group3);
            }
        }
    }

    public List<Action2> createActions(Property[] propertyArray) {
        return this.getActions(propertyArray, propertyArray[0].getGedcom());
    }

    public List<Action2> createActions(Entity entity) {
        return this.getActions(entity, entity.getGedcom());
    }

    public List<Action2> createActions(Gedcom gedcom) {
        return this.getActions(gedcom, gedcom);
    }

    public List<Action2> createActions(Property property) {
        return this.getActions(property, property.getGedcom());
    }

    private List<Action2> getActions(Object object, Gedcom gedcom) {
        Action2.Group group = new Action2.Group("Reports", ReportViewFactory.IMG);
        this.getActions(object, gedcom, group);
        ArrayList<Action2> arrayList = new ArrayList<Action2>();
        if (group.size() > 0) {
            arrayList.add(group);
        }
        return arrayList;
    }

    private void getActions(Object object, Gedcom gedcom, Action2.Group group) {
        HashMap<String, Action2.Group> hashMap = new HashMap<String, Action2.Group>();
        for (Report report : ReportLoader.getInstance().getReports()) {
            try {
                String string = report.accepts(object);
                if (string == null) continue;
                ActionRun actionRun = new ActionRun(string, object, report);
                String string2 = report.getCategory();
                if (string2 == null) {
                    group.add(actionRun);
                    continue;
                }
                Action2.Group group2 = (Action2.Group)hashMap.get(string2);
                if (group2 == null) {
                    group2 = new Action2.Group(RESOURCES.getString("title") + " (" + string2 + ")", report.getIcon());
                    hashMap.put(string2, group2);
                }
                group2.add(actionRun);
            }
            catch (Throwable throwable) {
                ReportView.LOG.log(Level.WARNING, "Report " + report.getClass().getName() + " failed in accept()", throwable);
            }
        }
        for (Action2.Group group3 : hashMap.values()) {
            group.add(group3);
        }
    }

    @Override
    public void viewClosed(Workbench workbench, View view) {
    }

    @Override
    public void viewOpened(Workbench workbench, View view) {
        if (view instanceof ReportView && this.showReportPickerOnOpen) {
            ((ReportView)view).startReport();
        }
    }

    void setEnabled(boolean bl) {
        if (this.workbenchActions != null) {
            this.workbenchActions.setEnabled(bl);
        }
    }

    private class ActionRun
    extends Action2 {
        private Object context;
        private Report report;

        private ActionRun(Report report) {
            this(report.getName(), null, report);
        }

        private ActionRun(String string, Object object, Report report) {
            this.context = object;
            this.report = report;
            this.setText(string);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html><body><table width=320><tr><td>");
            String string2 = report.getInfo();
            int n = string2.indexOf("</p>");
            if (n > 0) {
                string2 = string2.substring(0, n + 4);
            }
            stringBuffer.append(string2);
            stringBuffer.append("</td></tr></table>");
            this.setTip(stringBuffer.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            ReportPlugin.this.showReportPickerOnOpen = false;
            try {
                ReportView reportView = (ReportView)ReportPlugin.this.workbench.openView(ReportViewFactory.class);
                reportView.startReport(this.report, this.context);
            }
            finally {
                ReportPlugin.this.showReportPickerOnOpen = true;
            }
        }
    }
}

