/*
 * Decompiled with CFR 0.152.
 */
package genj.report;

import genj.common.ContextListWidget;
import genj.fo.Format;
import genj.fo.FormatOptionsWidget;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.report.Report;
import genj.report.ReportLoader;
import genj.report.ReportPluginFactory;
import genj.report.ReportSelector;
import genj.report.Runner;
import genj.util.EnvironmentChecker;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.WordBuffer;
import genj.util.swing.Action2;
import genj.util.swing.DialogHelper;
import genj.util.swing.EditorHyperlinkSupport;
import genj.util.swing.ImageIcon;
import genj.util.swing.NestedBlockLayout;
import genj.view.SelectionSink;
import genj.view.ToolBar;
import genj.view.View;
import genj.view.ViewContext;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import spin.Spin;

public class ReportView
extends View {
    static Logger LOG = Logger.getLogger("genj.report");
    private static final String WELCOME = "welcome";
    private static final String CONSOLE = "console";
    private static final String RESULT = "result";
    private String currentPage = "welcome";
    private static final String EOL = System.getProperty("line.separator");
    private static final ImageIcon imgStart = new ImageIcon(ReportView.class, "Start");
    private static final ImageIcon imgStop = new ImageIcon(ReportView.class, "Stop");
    private static final ImageIcon imgSave = new ImageIcon(ReportView.class, "Save");
    private static final ImageIcon imgConsole = new ImageIcon(ReportView.class, "ReportShell");
    private static final ImageIcon imgGui = new ImageIcon(ReportView.class, "ReportGui");
    private Gedcom gedcom;
    private Console output;
    private JScrollPane result;
    private ActionStart actionStart = new ActionStart();
    private ActionStop actionStop = new ActionStop();
    private ActionShow actionShow = new ActionShow();
    private static final Registry REGISTRY = Registry.get(ReportView.class);
    static final Resources RESOURCES = Resources.get(ReportView.class);

    public ReportView() {
        this.setLayout(new CardLayout());
        this.output = new Console();
        this.add((Component)new JScrollPane(this.output), CONSOLE);
        this.result = new JScrollPane();
        this.add((Component)this.result, RESULT);
        String string = RESOURCES.getString("report.welcome");
        int n = string.indexOf(42);
        String string2 = n < 0 ? "" : string.substring(0, n);
        String string3 = n < 0 ? "" : string.substring(n + 1);
        JButton jButton = new JButton(new ActionStart());
        jButton.setRequestFocusEnabled(false);
        jButton.setOpaque(false);
        JPanel jPanel = new JPanel(new NestedBlockLayout("<col><row><a wx=\"1\" ax=\"1\" wy=\"1\"/><b/><c wx=\"1\"/></row></col>"));
        jPanel.setBackground(this.output.getBackground());
        jPanel.setOpaque(true);
        jPanel.add(new JLabel(string2, 4));
        jPanel.add(jButton);
        jPanel.add(new JLabel(string3));
        this.add((Component)jPanel, WELCOME);
    }

    public void removeNotify() {
        super.removeNotify();
        ReportLoader.getInstance().saveOptions();
    }

    public void startReport(Report report, Object object) {
        if (!this.actionStart.isEnabled()) {
            return;
        }
        if (report.getStartMethod(object) == null) {
            for (int i = 0; i < Gedcom.ENTITIES.length; ++i) {
                String string = Gedcom.ENTITIES[i];
                Entity entity = this.gedcom.getFirstEntity(string);
                if (entity == null || report.accepts(entity) == null) continue;
                String string2 = report.accepts(entity.getClass());
                if (string2 == null) {
                    Gedcom.getName(string);
                }
                if ((object = report.getEntityFromUser(string2, this.gedcom, string)) != null) break;
                return;
            }
        }
        if (object == null || report.accepts(object) == null) {
            DialogHelper.openDialog(report.getName(), 0, RESOURCES.getString("report.noaccept"), (Action[])Action2.okOnly(), (Object)this);
            return;
        }
        REGISTRY.put("lastreport", report.getClass().getName());
        report.setOwner(this);
        this.clear();
        this.show(CONSOLE);
        this.actionStart.setEnabled(false);
        this.actionStop.setEnabled(true);
        ReportPluginFactory.getInstance().setEnabled(false);
        new Thread(new Runner(this.gedcom, object, report, (Runner.Callback)Spin.over((Object)new RunnerCallback()))).start();
    }

    private void clear() {
        this.output.clear();
        this.output.setContentType("text/plain");
        this.result.setViewportView(null);
        this.actionShow.setSelected(false);
        this.actionShow.setEnabled(false);
        this.show(this.gedcom != null ? WELCOME : CONSOLE);
    }

    public void startReport() {
        if (this.gedcom == null) {
            return;
        }
        ReportSelector reportSelector = new ReportSelector();
        try {
            reportSelector.select(ReportLoader.getInstance().getReportByName(REGISTRY.get("lastreport", (String)null)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        final DialogHelper.Dialog dialog = new DialogHelper.Dialog(RESOURCES.getString("report.reports"), 3, reportSelector, (Action[])Action2.okCancel(), (Object)this);
        reportSelector.setActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dialog.close(0);
            }
        });
        if (0 != dialog.show()) {
            return;
        }
        Report report = reportSelector.getReport();
        if (report == null) {
            return;
        }
        REGISTRY.put("lastreport", report.getClass().getName());
        this.startReport(report, this.gedcom);
    }

    public void stopReport() {
    }

    public void setContext(Context context, boolean bl) {
        if (this.gedcom != context.getGedcom()) {
            this.clear();
        }
        this.gedcom = context.getGedcom();
        this.actionStart.setEnabled(!this.actionStop.isEnabled() && this.gedcom != null);
    }

    void show(String string) {
        if (this.currentPage != string) {
            ((CardLayout)this.getLayout()).show(this, string);
            this.currentPage = string;
        }
    }

    void showResult(Object object) {
        Object object2;
        if (object == null) {
            if (this.output.getDocument().getLength() == 0) {
                this.show(WELCOME);
            }
            return;
        }
        if (object instanceof InterruptedException) {
            this.output.add("*** cancelled");
            return;
        }
        if (object instanceof Throwable) {
            CharArrayWriter charArrayWriter = new CharArrayWriter(256);
            ((Throwable)object).printStackTrace(new PrintWriter(charArrayWriter));
            this.output.add("*** exception caught\n" + charArrayWriter);
            LOG.log(Level.WARNING, "Exception caught ", (Throwable)object);
            return;
        }
        if (object instanceof File) {
            object2 = (File)object;
            if (((File)object2).getName().endsWith(".htm") || ((File)object2).getName().endsWith(".html")) {
                try {
                    object = ((File)object2).toURI().toURL();
                }
                catch (Throwable throwable) {}
            } else {
                try {
                    Desktop.getDesktop().open((File)object2);
                }
                catch (Throwable throwable) {
                    Logger.getLogger("genj.report").log(Level.INFO, "can't open " + object2, throwable);
                    this.output.add("*** can't open file " + object2);
                }
                return;
            }
        }
        if (object instanceof URL) {
            try {
                this.output.setPage((URL)object);
            }
            catch (IOException iOException) {
                this.output.add("*** can't open URL " + object + ": " + iOException.getMessage());
            }
            this.actionShow.setEnabled(false);
            this.actionShow.setSelected(false);
            this.show(CONSOLE);
            return;
        }
        if (object instanceof List) {
            try {
                object = new ContextListWidget((List)object);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (object instanceof JComponent) {
            object2 = (JComponent)object;
            ((JComponent)object2).setMinimumSize(new Dimension(0, 0));
            this.result.setViewportView((Component)object2);
            this.actionShow.setEnabled(true);
            this.actionShow.setSelected(true);
            if (object2 instanceof ContextListWidget) {
                ContextListWidget contextListWidget = (ContextListWidget)this.result.getViewport().getView();
                WordBuffer wordBuffer = new WordBuffer("\n");
                for (Context context : contextListWidget.getContexts()) {
                    if (context instanceof ViewContext) {
                        wordBuffer.append(context.getEntity() + ":" + ((ViewContext)context).getText());
                        continue;
                    }
                    wordBuffer.append(((Component)object2).toString());
                }
            }
            this.show(RESULT);
            return;
        }
        if (object instanceof genj.fo.Document) {
            object2 = (genj.fo.Document)object;
            String string = "Document " + ((genj.fo.Document)object2).getTitle();
            Registry registry = Registry.get(this.getClass());
            Action[] actionArray = Action2.okCancel();
            FormatOptionsWidget formatOptionsWidget = new FormatOptionsWidget((genj.fo.Document)object2, registry);
            formatOptionsWidget.connect(actionArray[0]);
            int n = DialogHelper.openDialog(string, 3, formatOptionsWidget, actionArray, (Object)this);
            Format format = formatOptionsWidget.getFormat();
            File file = formatOptionsWidget.getFile();
            if (n != 0 || format.getFileExtension() == null || file == null) {
                this.showResult(null);
                return;
            }
            formatOptionsWidget.remember(registry);
            try {
                file.getParentFile().mkdirs();
                format.format((genj.fo.Document)object2, file);
            }
            catch (Throwable throwable) {
                LOG.log(Level.WARNING, "formatting " + object2 + " failed", throwable);
                this.output.add("*** formatting " + object2 + " failed");
                return;
            }
            this.showResult(file);
            return;
        }
        this.output.add("*** report returned unknown result " + object);
    }

    public void populate(ToolBar toolBar) {
        toolBar.add(this.actionStart);
        toolBar.add(new JToggleButton(this.actionShow));
        toolBar.add(new ActionSave());
    }

    private class Console
    extends JEditorPane
    implements MouseListener,
    MouseMotionListener {
        private String id = null;

        private Console() {
            this.setContentType("text/plain");
            this.setFont(new Font("Monospaced", 0, 12));
            this.setEditable(false);
            this.addHyperlinkListener(new EditorHyperlinkSupport(this));
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.id = this.markIDat(mouseEvent.getPoint());
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Entity entity;
            if (this.id != null && ReportView.this.gedcom != null && (entity = ReportView.this.gedcom.getEntity(this.id)) != null) {
                SelectionSink.Dispatcher.fireSelection(mouseEvent, new Context(entity));
            }
        }

        private String markIDat(Point point) {
            try {
                int n = this.viewToModel(point);
                if (n < 0) {
                    return null;
                }
                Document document = this.getDocument();
                int n2 = 0;
                while (true) {
                    if (n2 == 10) {
                        return null;
                    }
                    if (n == 0 || !Character.isLetterOrDigit(document.getText(n - 1, 1).charAt(0))) break;
                    --n;
                    ++n2;
                }
                n2 = 0;
                while (true) {
                    if (n2 == 10) {
                        return null;
                    }
                    if (n + n2 == document.getLength() || !Character.isLetterOrDigit(document.getText(n + n2, 1).charAt(0))) break;
                    ++n2;
                }
                if (n2 < 2) {
                    return null;
                }
                String string = document.getText(n, n2);
                if (ReportView.this.gedcom == null || ReportView.this.gedcom.getEntity(string) == null) {
                    return null;
                }
                this.setCaretPosition(n);
                this.moveCaretPosition(n + n2);
                return string;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        void clear() {
            this.setContentType("text/plain");
            this.setText("");
        }

        void add(String string) {
            Document document = this.getDocument();
            try {
                document.insertString(document.getLength(), string, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    private class ActionSave
    extends Action2
    implements DocumentListener {
        protected ActionSave() {
            this.setImage(imgSave);
            this.setTip(RESOURCES, "report.save.tip");
            ReportView.this.output.getDocument().addDocumentListener(this);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OutputStreamWriter outputStreamWriter;
            int n;
            String string = REGISTRY.get("txtdir", EnvironmentChecker.getProperty("user.home", ".", "looking for txt output dir"));
            JFileChooser jFileChooser = new JFileChooser(string);
            jFileChooser.setDialogTitle(this.getTip());
            jFileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".txt");
                }

                public String getDescription() {
                    return "*.txt (Text)";
                }
            });
            if (0 != jFileChooser.showDialog(ReportView.this, "Save")) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            REGISTRY.put("txtdir", file.getParent());
            if (!file.getName().endsWith("*.txt")) {
                file = new File(file.getAbsolutePath() + ".txt");
            }
            if (file.exists() && (n = DialogHelper.openDialog(RESOURCES.getString("title"), 2, "File exists. Overwrite?", (Action[])Action2.yesNo(), (Object)ReportView.this)) != 0) {
                return;
            }
            try {
                outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF8"));
            }
            catch (IOException iOException) {
                DialogHelper.openDialog(RESOURCES.getString("title"), 0, "Error while saving to\n" + file.getAbsolutePath(), (Action[])Action2.okOnly(), (Object)ReportView.this);
                return;
            }
            try {
                String string2;
                String string3 = System.getProperty("line.separator");
                BufferedReader bufferedReader = new BufferedReader(new StringReader(ReportView.this.output.getText()));
                while ((string2 = bufferedReader.readLine()) != null) {
                    outputStreamWriter.write(string2);
                    outputStreamWriter.write(string3);
                }
                bufferedReader.close();
                outputStreamWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.setEnabled(documentEvent.getDocument().getLength() > 0);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }
    }

    private class ActionShow
    extends Action2 {
        protected ActionShow() {
            this.setImage(imgConsole);
            this.setTip(RESOURCES, "report.output");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setSelected(this.isSelected());
        }

        public boolean setSelected(boolean bl) {
            this.setImage(bl ? imgGui : imgConsole);
            if (bl) {
                ReportView.this.show(ReportView.RESULT);
            } else {
                ReportView.this.show(ReportView.CONSOLE);
            }
            return super.setSelected(bl);
        }
    }

    private class ActionStart
    extends Action2 {
        private Object context;
        private Report report;
        private PrintWriter out;

        protected ActionStart() {
            this.setImage(imgStart);
            this.setTip(RESOURCES, "report.start.tip");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ReportView.this.startReport();
        }
    }

    private class ActionStop
    extends Action2 {
        protected ActionStop() {
            this.setImage(imgStop);
            this.setTip(RESOURCES, "report.stop.tip");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ReportView.this.stopReport();
        }
    }

    private class RunnerCallback
    implements Runner.Callback {
        private RunnerCallback() {
        }

        public void handleOutput(Report report, String string) {
            if (ReportView.this.currentPage != ReportView.CONSOLE) {
                ReportView.this.show(ReportView.CONSOLE);
            }
            ReportView.this.output.add(string);
        }

        public void handleResult(Report report, Object object) {
            LOG.fine("Result of report " + report.getName() + " = " + object);
            ReportView.this.actionStart.setEnabled(ReportView.this.gedcom != null);
            ReportView.this.actionStop.setEnabled(false);
            ReportPluginFactory.getInstance().setEnabled(true);
            ReportView.this.showResult(object);
        }
    }
}

