/*
 * Decompiled with CFR 0.152.
 */
package genj.tree;

import genj.tree.Bookmark;
import genj.tree.TreeMetrics;
import genj.tree.TreeView;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.ColorsWidget;
import genj.util.swing.FontChooser;
import genj.util.swing.NestedBlockLayout;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TreeViewSettings
extends JTabbedPane {
    private static final Resources RESOURCES = Resources.get(TreeViewSettings.class);
    private JSpinner[] spinners = new JSpinner[5];
    private ColorsWidget colors;
    private JCheckBox checkBending;
    private JCheckBox checkAntialiasing;
    private JCheckBox checkMarrSymbols;
    private Action2 up = new Move(-1);
    private Action2 down = new Move(1);
    private Action2 delete = new Delete();
    private FontChooser font;
    private Commit commit;
    private Bookmarks bookmarks;
    private JList bList;

    public TreeViewSettings(TreeView treeView) {
        this.commit = new Commit(treeView);
        JPanel jPanel = new JPanel(new NestedBlockLayout("<col><check gx=\"1\"/><check gx=\"1\"/><check gx=\"1\"/><font gx=\"1\"/><row><label/><spinner/></row><row><label/><spinner/></row><row><label/><spinner/></row><row><label/><spinner/></row><row><label/><spinner/></row></col>"));
        this.checkBending = this.createCheck("bend", treeView.getModel().isBendArcs());
        this.checkAntialiasing = this.createCheck("antialiasing", treeView.isAntialising());
        this.checkMarrSymbols = this.createCheck("marrsymbols", treeView.getModel().isMarrSymbols());
        this.font = new FontChooser();
        this.font.setSelectedFont(treeView.getContentFont());
        this.font.addChangeListener(this.commit);
        jPanel.add(this.checkBending);
        jPanel.add(this.checkAntialiasing);
        jPanel.add(this.checkMarrSymbols);
        jPanel.add(this.font);
        TreeMetrics treeMetrics = treeView.getModel().getMetrics();
        this.spinners[0] = this.createSpinner("indiwidth", jPanel, 0.4, (double)treeMetrics.wIndis * 0.1, 16.0);
        this.spinners[1] = this.createSpinner("indiheight", jPanel, 0.4, (double)treeMetrics.hIndis * 0.1, 16.0);
        this.spinners[2] = this.createSpinner("famwidth", jPanel, 0.4, (double)treeMetrics.wFams * 0.1, 16.0);
        this.spinners[3] = this.createSpinner("famheight", jPanel, 0.4, (double)treeMetrics.hFams * 0.1, 16.0);
        this.spinners[4] = this.createSpinner("padding", jPanel, 0.4, (double)treeMetrics.pad * 0.1, 4.0);
        this.colors = new ColorsWidget();
        for (String string : treeView.getColors().keySet()) {
            this.colors.addColor(string, RESOURCES.getString("color." + string), treeView.getColors().get(string));
        }
        this.colors.addChangeListener(this.commit);
        this.bookmarks = new Bookmarks(treeView.getModel().getBookmarks());
        this.bookmarks.addListDataListener(this.commit);
        this.bList = new JList(this.bookmarks);
        this.bList.setSelectionMode(0);
        this.bList.getModel().addListDataListener(this.commit);
        this.bList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = TreeViewSettings.this.bList.getSelectedIndex();
                int n2 = TreeViewSettings.this.bookmarks.getSize();
                TreeViewSettings.this.up.setEnabled(n > 0);
                TreeViewSettings.this.down.setEnabled(n >= 0 && n < n2 - 1);
                TreeViewSettings.this.delete.setEnabled(n >= 0);
            }
        });
        JPanel jPanel2 = new JPanel(new NestedBlockLayout("<col><list wx=\"1\" wy=\"1\"/><row><up/><dn/><del/></row></col>"));
        jPanel2.add(new JScrollPane(this.bList));
        jPanel2.add(new JButton(this.up));
        jPanel2.add(new JButton(this.down));
        jPanel2.add(new JButton(this.delete));
        this.add(RESOURCES.getString("page.main"), jPanel);
        this.add(RESOURCES.getString("page.colors"), this.colors);
        this.add(RESOURCES.getString("page.bookmarks"), jPanel2);
    }

    private JCheckBox createCheck(String string, boolean bl) {
        JCheckBox jCheckBox = new JCheckBox(RESOURCES.getString(string), bl);
        jCheckBox.setToolTipText(RESOURCES.getString(string + ".tip"));
        jCheckBox.addActionListener(this.commit);
        return jCheckBox;
    }

    private JSpinner createSpinner(String string, Container container, double d, double d2, double d3) {
        d2 = Math.min(d3, Math.max(d2, d));
        JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(d2, d, d3, 0.1));
        JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor(jSpinner, "##0.0");
        jSpinner.setEditor(numberEditor);
        jSpinner.addChangeListener(numberEditor);
        jSpinner.setToolTipText(RESOURCES.getString("info." + string + ".tip"));
        jSpinner.addChangeListener(this.commit);
        container.add(new JLabel(RESOURCES.getString("info." + string)));
        container.add(jSpinner);
        return jSpinner;
    }

    private class Commit
    implements ChangeListener,
    ActionListener,
    ListDataListener {
        private TreeView view;

        private Commit(TreeView treeView) {
            this.view = treeView;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.actionPerformed(null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.view.getModel().setBendArcs(TreeViewSettings.this.checkBending.isSelected());
            this.view.setAntialiasing(TreeViewSettings.this.checkAntialiasing.isSelected());
            this.view.setContentFont(TreeViewSettings.this.font.getSelectedFont());
            this.view.getModel().setMarrSymbols(TreeViewSettings.this.checkMarrSymbols.isSelected());
            this.view.getModel().setMetrics(new TreeMetrics((int)((Double)TreeViewSettings.this.spinners[0].getModel().getValue() * 10.0), (int)((Double)TreeViewSettings.this.spinners[1].getModel().getValue() * 10.0), (int)((Double)TreeViewSettings.this.spinners[2].getModel().getValue() * 10.0), (int)((Double)TreeViewSettings.this.spinners[3].getModel().getValue() * 10.0), (int)((Double)TreeViewSettings.this.spinners[4].getModel().getValue() * 10.0)));
            this.view.setColors(TreeViewSettings.this.colors.getColors());
            this.view.getModel().setBookmarks(TreeViewSettings.this.bookmarks.get());
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.actionPerformed(null);
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.actionPerformed(null);
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.actionPerformed(null);
        }
    }

    private class Delete
    extends Action2 {
        private Delete() {
            this.setText(RESOURCES.getString("bookmark.del"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = TreeViewSettings.this.bList.getSelectedIndex();
            TreeViewSettings.this.bookmarks.delete(n);
        }
    }

    private class Move
    extends Action2 {
        private int by;

        private Move(int n) {
            this.setText(RESOURCES.getString("bookmark.move." + n));
            this.setEnabled(false);
            this.by = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = TreeViewSettings.this.bList.getSelectedIndex();
            TreeViewSettings.this.bookmarks.swap(n, n + this.by);
            TreeViewSettings.this.bList.setSelectedIndex(n + this.by);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Bookmarks
    extends AbstractListModel {
        private ArrayList<Bookmark> list;

        Bookmarks(List<Bookmark> list) {
            this.list = new ArrayList<Bookmark>(list);
        }

        @Override
        public Object getElementAt(int n) {
            return this.list.get(n);
        }

        @Override
        public int getSize() {
            return this.list.size();
        }

        public void swap(int n, int n2) {
            if (n == n2) {
                return;
            }
            Bookmark bookmark = this.list.get(n);
            this.list.set(n, this.list.get(n2));
            this.list.set(n2, bookmark);
            this.fireContentsChanged(this, Math.min(n, n2), Math.max(n, n2));
        }

        public void delete(int n) {
            this.list.remove(n);
            this.fireIntervalRemoved(this, n, n);
        }

        public List<Bookmark> get() {
            return Collections.unmodifiableList(this.list);
        }
    }
}

