/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

public class GridBagHelper {
    public static final int FILL_HORIZONTAL = 1;
    public static final int FILL_VERTICAL = 2;
    public static final int FILL_BOTH = 4;
    public static final int GROW_HORIZONTAL = 16;
    public static final int GROW_VERTICAL = 32;
    public static final int GROW_BOTH = 64;
    public static final int GROWFILL_HORIZONTAL = 17;
    public static final int GROWFILL_VERTICAL = 34;
    public static final int GROWFILL_BOTH = 68;
    private GridBagLayout layout;
    private GridBagConstraints constraints;
    private Container container;
    private Insets presetInsets = new Insets(0, 0, 0, 0);
    private int presetParameter = 0;

    public GridBagHelper(Container container) {
        this.container = container;
        this.layout = new GridBagLayout();
        container.setLayout(this.layout);
        this.constraints = new GridBagConstraints();
    }

    public GridBagHelper setInsets(Insets insets) {
        this.presetInsets = insets;
        return this;
    }

    public GridBagHelper setParameter(int n) {
        this.presetParameter = n;
        return this;
    }

    public Component add(Component component, int n, int n2) {
        return this.add(component, n, n2, 1, 1);
    }

    public Component add(Component component, int n, int n2, int n3, int n4) {
        return this.add(component, n, n2, n3, n4, this.presetParameter);
    }

    public Component add(Component component, int n, int n2, int n3, int n4, int n5) {
        return this.add(component, n, n2, n3, n4, n5, this.presetInsets);
    }

    public Component add(Component component, int n, int n2, int n3, int n4, int n5, Insets insets) {
        this.container.add(component);
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        this.constraints.weightx = this.isSet(n5, 64) || this.isSet(n5, 16) ? 1.0 : 0.0;
        this.constraints.weighty = this.isSet(n5, 64) || this.isSet(n5, 32) ? 1.0 : 0.0;
        this.constraints.fill = 0;
        this.constraints.insets = insets;
        if (this.isSet(n5, 4) || this.isSet(n5, 1) && this.isSet(n5, 2)) {
            this.constraints.fill = 1;
        } else if (this.isSet(n5, 1)) {
            this.constraints.fill = 2;
        } else if (this.isSet(n5, 2)) {
            this.constraints.fill = 3;
        }
        this.layout.setConstraints(component, this.constraints);
        return component;
    }

    public void addFiller(int n, int n2) {
        this.add(new Fill(new Dimension(0, 0)), n, n2, 1, 1, 64);
    }

    public void addFiller(int n, int n2, Dimension dimension) {
        this.add(new Fill(dimension), n, n2, 1, 1);
    }

    private boolean isSet(int n, int n2) {
        return (n & n2) != 0;
    }

    private class Fill
    extends Component {
        Dimension size;

        Fill(Dimension dimension) {
            this.size = dimension;
        }

        public Dimension getPreferredSize() {
            return this.size;
        }

        public Dimension getMinimumSize() {
            return this.size;
        }
    }
}

