/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.io.InputSource;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.GraphicsHelper;
import genj.util.swing.ImageIcon;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOParam;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.event.IIOReadUpdateListener;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.filechooser.FileSystemView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThumbnailWidget
extends JComponent {
    private static final Resources RES = Resources.get(ThumbnailWidget.class);
    private static final int MIN_THUMBNAIL = 32;
    public static final ImageIcon IMG_THUMBNAIL = new ImageIcon(ThumbnailWidget.class, "File.png");
    public static final ImageIcon IMG_ZOOM_FIT = new ImageIcon(ThumbnailWidget.class, "ZoomFit.png");
    public static final ImageIcon IMG_ZOOM_ALL = new ImageIcon(ThumbnailWidget.class, "ZoomAll.png");
    private static final Logger LOG = Logger.getLogger("genj.util.swing");
    private static final BlockingQueue<Runnable> executorQueue = new LinkedBlockingDeque<Runnable>();
    private static final Executor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, executorQueue);
    private int thumbSize = 64;
    private int thumbPadding = 10;
    private Insets thumbBorder = new Insets(4, 4, 20, 4);
    private List<Thumbnail> thumbs = new ArrayList<Thumbnail>();
    private Timer repaint = new Timer(100, new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            ThumbnailWidget.this.repaint();
        }
    });
    private Thumbnail selection = null;
    private Action2 zoomFit = new Fit();
    private Action2 zoomAll = new All();
    private Action2 zoomOne = new One();
    private Point topLeft = new Point(0, 0);

    public ThumbnailWidget() {
        this.setRequestFocusEnabled(true);
        EventHandler eventHandler = new EventHandler();
        this.addMouseWheelListener(eventHandler);
        this.addMouseListener(eventHandler);
        this.addMouseMotionListener(eventHandler);
        new DropTarget(this, eventHandler);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setBackground(Color.LIGHT_GRAY);
    }

    public Action2 getFitAction() {
        return this.zoomFit;
    }

    public Action2 getOneAction() {
        return this.zoomOne;
    }

    public Action2 getAllAction() {
        return this.zoomAll;
    }

    public void clear() {
        this.setSources(null);
    }

    public InputSource getSelection() {
        return this.selection != null ? this.selection.source : null;
    }

    public void setSource(InputSource inputSource) {
        if (inputSource == null) {
            this.clear();
        } else {
            this.setSources(Collections.singletonList(inputSource));
        }
    }

    public void setSources(List<InputSource> list) {
        if (this.selection != null) {
            this.unselect(this.selection.source);
        }
        int n = this.thumbs.size();
        this.thumbs.clear();
        if (list != null) {
            for (InputSource inputSource : list) {
                this.thumbs.add(new Thumbnail(inputSource));
            }
        }
        this.firePropertyChange("content", n, this.thumbs.size());
        this.showAll();
    }

    public void addSource(InputSource inputSource) {
        int n = this.thumbs.size();
        Thumbnail thumbnail = new Thumbnail(inputSource);
        this.thumbs.add(thumbnail);
        this.firePropertyChange("content", n, this.thumbs.size());
        Thumbnail thumbnail2 = this.selection;
        this.selection = thumbnail;
        this.firePropertyChange("selection", thumbnail2 != null ? thumbnail2.getSource() : null, this.selection.getSource());
        this.showAll();
    }

    public void removeSource(InputSource inputSource) {
        this.unselect(inputSource);
        int n = this.thumbs.size();
        for (Thumbnail thumbnail : new ArrayList<Thumbnail>(this.thumbs)) {
            if (thumbnail.source != inputSource) continue;
            this.thumbs.remove(thumbnail);
        }
        this.firePropertyChange("content", n, this.thumbs.size());
        this.showAll();
    }

    @Override
    public String getToolTipText() {
        return super.getToolTipText();
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        Thumbnail thumbnail = this.getThumb(mouseEvent.getPoint());
        return thumbnail != null ? this.getToolTipText(thumbnail.source) : null;
    }

    public String getToolTipText(InputSource inputSource) {
        return inputSource.getName();
    }

    private void unselect(InputSource inputSource) {
        if (this.selection == null || this.selection.source != inputSource) {
            return;
        }
        Thumbnail thumbnail = this.selection;
        this.selection = null;
        this.firePropertyChange("selection", thumbnail.getSource(), null);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        Dimension dimension = this.getDimension();
        this.topLeft.x = (n3 - dimension.width) / 2;
        this.topLeft.y = (n4 - dimension.height) / 2;
    }

    private void scrollTo(int n, int n2) {
        Dimension dimension = this.getDimension();
        this.topLeft.x = dimension.width < this.getWidth() ? (this.getWidth() - dimension.width) / 2 : Math.max(-(dimension.width - this.getWidth()), Math.min(0, n));
        this.topLeft.y = dimension.height < this.getHeight() ? (this.getHeight() - dimension.height) / 2 : Math.max(-(dimension.height - this.getHeight()), Math.min(0, n2));
        this.repaint();
    }

    protected void handleDrop(List<File> list) {
    }

    public void showOne() {
        if (this.selection == null || ((Thumbnail)this.selection).size.width == 0 || ((Thumbnail)this.selection).size.height == 0) {
            return;
        }
        Point point = new Point(this.getWidth() / 2, this.getHeight() / 2);
        Rectangle rectangle = this.getRectangle(this.selection);
        double d = 0.5;
        double d2 = 0.5;
        if (rectangle.contains(point)) {
            d = (double)(point.x - rectangle.x) / rectangle.getWidth();
            d2 = (double)(point.y - rectangle.y) / rectangle.getHeight();
        }
        this.thumbSize = Math.max(((Thumbnail)this.selection).size.width, ((Thumbnail)this.selection).size.height);
        this.topLeft.setLocation(0, 0);
        rectangle = this.getRectangle(this.selection);
        this.scrollTo(-((int)((double)rectangle.x + (double)rectangle.width * d - (double)(this.getWidth() / 2))), -((int)((double)rectangle.y + (double)rectangle.height * d2 - (double)(this.getHeight() / 2))));
    }

    public void showSelection() {
        if (this.selection == null) {
            return;
        }
        if (((Thumbnail)this.selection).size.width == 0 || ((Thumbnail)this.selection).size.height == 0) {
            return;
        }
        Dimension dimension = ThumbnailWidget.fit(this.selection.size, this.getSize());
        this.thumbSize = Math.max(dimension.width, dimension.height);
        this.topLeft.setLocation(0, 0);
        Rectangle rectangle = this.getRectangle(this.selection);
        this.scrollTo(-(rectangle.x + this.thumbBorder.left - (Math.max(this.thumbSize, this.getWidth()) - dimension.width) / 2), -(rectangle.y + this.thumbBorder.top + (Math.max(this.thumbSize, this.getHeight()) - dimension.height) / 2));
    }

    public void showAll() {
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ThumbnailWidget.this.showAllImpl();
                }
            });
            return;
        }
        this.showAllImpl();
    }

    private void showAllImpl() {
        this.thumbSize = this.thumbs.size() == 1 ? Math.min(this.getShowAllThumbSize(), this.getMinThumbSize()) : this.getShowAllThumbSize();
        this.scrollTo(0, 0);
    }

    private int getMinThumbSize() {
        int n = Integer.MAX_VALUE;
        for (Thumbnail thumbnail : this.thumbs) {
            if (((Thumbnail)thumbnail).size.width <= 0 || ((Thumbnail)thumbnail).size.height <= 0) continue;
            n = Math.min(n, Math.max(((Thumbnail)thumbnail).size.width, ((Thumbnail)thumbnail).size.height));
        }
        return n;
    }

    private int getShowAllThumbSize() {
        Dimension dimension = this.getRowsCols();
        if (dimension.width == 0 || dimension.height == 0) {
            return 32;
        }
        int n = Math.max(32, this.getWidth() / dimension.width - this.thumbBorder.left - this.thumbBorder.right - this.thumbPadding);
        int n2 = Math.max(32, this.getHeight() / dimension.height - this.thumbBorder.top - this.thumbBorder.bottom - this.thumbPadding);
        return Math.min(n, n2);
    }

    private void select(Thumbnail thumbnail) {
        Thumbnail thumbnail2 = this.selection;
        if (thumbnail2 == thumbnail) {
            return;
        }
        this.selection = thumbnail;
        this.repaint();
        this.firePropertyChange("selection", thumbnail2 != null ? thumbnail2.getSource() : null, this.selection != null ? this.selection.getSource() : null);
    }

    private Rectangle getRectangle(Thumbnail thumbnail) {
        Dimension dimension = this.getRowsCols();
        int n = 0;
        int n2 = 0;
        for (Thumbnail thumbnail2 : this.thumbs) {
            if (thumbnail == thumbnail2) {
                return new Rectangle(this.topLeft.x + n2 * (this.thumbBorder.left + this.thumbSize + this.thumbBorder.right + this.thumbPadding) + this.thumbPadding / 2, this.topLeft.y + n * (this.thumbBorder.top + this.thumbSize + this.thumbBorder.bottom + this.thumbPadding) + this.thumbPadding / 2, this.thumbBorder.left + this.thumbSize + this.thumbBorder.right, this.thumbBorder.top + this.thumbSize + this.thumbBorder.bottom);
            }
            ++n2;
            if ((n2 %= dimension.width) != 0) continue;
            ++n;
        }
        throw new IllegalArgumentException("unknown thumbnail");
    }

    private Thumbnail getThumb(Point point) {
        Dimension dimension = this.getRowsCols();
        int n = 0;
        int n2 = 0;
        for (Thumbnail thumbnail : this.thumbs) {
            Rectangle rectangle = new Rectangle(this.topLeft.x + n2 * (this.thumbBorder.left + this.thumbSize + this.thumbBorder.right + this.thumbPadding) + this.thumbPadding / 2, this.topLeft.y + n * (this.thumbBorder.top + this.thumbSize + this.thumbBorder.bottom + this.thumbPadding) + this.thumbPadding / 2, this.thumbBorder.left + this.thumbSize + this.thumbBorder.right, this.thumbBorder.top + this.thumbSize + this.thumbBorder.bottom);
            if (rectangle.contains(point)) {
                return thumbnail;
            }
            ++n2;
            if ((n2 %= dimension.width) != 0) continue;
            ++n;
        }
        return null;
    }

    private Dimension getDimension() {
        Dimension dimension = this.getRowsCols();
        return new Dimension(dimension.width * (this.thumbSize + this.thumbBorder.left + this.thumbBorder.right + this.thumbPadding), dimension.height * (this.thumbSize + this.thumbBorder.top + this.thumbBorder.bottom + this.thumbPadding));
    }

    private Dimension getRowsCols() {
        if (this.thumbs.isEmpty()) {
            return new Dimension();
        }
        int n = (int)Math.ceil(Math.sqrt(this.thumbs.size()));
        int n2 = (int)Math.ceil((float)this.thumbs.size() / (float)n);
        return new Dimension(n, n2);
    }

    private Image getFallback(InputSource inputSource) {
        File file;
        ImageIcon imageIcon = IMG_THUMBNAIL;
        if (inputSource instanceof InputSource.FileInput && (file = ((InputSource.FileInput)inputSource).getFile()).isFile()) {
            try {
                Icon icon = FileSystemView.getFileSystemView().getSystemIcon(file);
                if (icon != null) {
                    imageIcon = new ImageIcon(icon);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return imageIcon.getImage();
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        int n = (int)Math.ceil(Math.sqrt(this.thumbs.size()));
        int n2 = (int)Math.ceil((float)this.thumbs.size() / (float)n);
        int n3 = 0;
        int n4 = 0;
        for (Thumbnail thumbnail : this.thumbs) {
            Validation validation;
            Rectangle rectangle;
            Point point = new Point(this.topLeft.x + n4 * (this.thumbSize + this.thumbBorder.left + this.thumbBorder.right + this.thumbPadding) + this.thumbPadding / 2, this.topLeft.y + n3 * (this.thumbSize + this.thumbBorder.top + this.thumbBorder.bottom + this.thumbPadding) + this.thumbPadding / 2);
            graphics.setColor(Color.DARK_GRAY);
            graphics2D.fill(new Rectangle(point.x + this.thumbBorder.left + this.thumbSize + this.thumbBorder.right, point.y + 2, 2, this.thumbBorder.top + this.thumbSize + this.thumbBorder.bottom));
            graphics2D.fill(new Rectangle(point.x + 2, point.y + this.thumbBorder.top + this.thumbSize + this.thumbBorder.bottom, this.thumbBorder.left + this.thumbSize + this.thumbBorder.right, 2));
            graphics.setColor(Color.WHITE);
            graphics2D.fill(new Rectangle(point.x, point.y, this.thumbBorder.left + this.thumbSize + this.thumbBorder.right, this.thumbBorder.top + this.thumbSize + this.thumbBorder.bottom));
            graphics.setColor(Color.BLACK);
            GraphicsHelper.render(graphics2D, thumbnail.getName(), new Rectangle(point.x + this.thumbBorder.left, point.y + this.thumbBorder.top + this.thumbSize, this.thumbSize, this.thumbBorder.bottom), 0.5, 0.5);
            if (thumbnail == this.selection) {
                graphics.setColor(Color.BLUE);
                graphics2D.draw(new Rectangle(point.x, point.y, this.thumbBorder.left + this.thumbSize + this.thumbBorder.right, this.thumbBorder.top + this.thumbSize + this.thumbBorder.bottom));
            }
            if (!thumbnail.render(graphics2D, rectangle = new Rectangle(point.x + this.thumbBorder.left, point.y + this.thumbBorder.top, this.thumbSize, this.thumbSize)) && !executorQueue.contains(validation = new Validation(thumbnail))) {
                executor.execute(validation);
            }
            ++n4;
            if ((n4 %= n) != 0) continue;
            ++n3;
        }
    }

    private void center(Point point) {
    }

    private static Rectangle grow(Rectangle rectangle, int n) {
        return new Rectangle(rectangle.x - n / 2, rectangle.y - n / 2, rectangle.width + n, rectangle.height + n);
    }

    private static Rectangle center(Rectangle rectangle, Rectangle rectangle2) {
        return new Rectangle(rectangle2.x + (rectangle2.width - rectangle.width) / 2, rectangle2.y + (rectangle2.height - rectangle.height) / 2, rectangle.width, rectangle.height);
    }

    private static Dimension fit(Dimension dimension, Dimension dimension2) {
        float f = Math.min((float)dimension2.width / (float)dimension.width, (float)dimension2.height / (float)dimension.height);
        return new Dimension((int)((float)dimension.width * f), (int)((float)dimension.height * f));
    }

    private class All
    extends Action2
    implements PropertyChangeListener {
        public All() {
            this.setImage(IMG_ZOOM_ALL);
            this.setTip(RES, "thumbnail.all");
            this.setEnabled(false);
            ThumbnailWidget.this.addPropertyChangeListener("content", this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ThumbnailWidget.this.showAll();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.setEnabled(!ThumbnailWidget.this.thumbs.isEmpty());
        }
    }

    private class One
    extends Action2
    implements PropertyChangeListener {
        public One() {
            this.setText("1:1");
            this.setTip(RES, "thumbnail.one");
            this.setEnabled(false);
            ThumbnailWidget.this.addPropertyChangeListener("selection", this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ThumbnailWidget.this.showOne();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.setEnabled(ThumbnailWidget.this.selection != null);
        }
    }

    private class Fit
    extends Action2
    implements PropertyChangeListener {
        public Fit() {
            this.setImage(IMG_ZOOM_FIT);
            this.setTip(RES, "thumbnail.fit");
            this.setEnabled(false);
            ThumbnailWidget.this.addPropertyChangeListener("selection", this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ThumbnailWidget.this.showSelection();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.setEnabled(ThumbnailWidget.this.selection != null);
        }
    }

    private class Thumbnail
    implements IIOReadUpdateListener {
        private InputSource source;
        private SoftReference<Image> image = new SoftReference<Object>(null);
        private Dimension size = new Dimension();
        private Dimension imageSize = new Dimension();
        private Rectangle imageView = new Rectangle();
        private Rectangle renderDest = new Rectangle();
        private Rectangle renderSource = new Rectangle();

        public Thumbnail(InputSource inputSource) {
            this.source = inputSource;
        }

        String getName() {
            return this.source.getName();
        }

        InputSource getSource() {
            return this.source;
        }

        private synchronized boolean isValid() {
            if (this.image.get() == null) {
                return false;
            }
            return (this.imageSize.width >= this.size.width || this.imageSize.width >= this.renderDest.width) && (this.imageSize.height >= this.size.height || this.imageSize.height >= this.renderDest.height);
        }

        synchronized boolean render(Graphics2D graphics2D, Rectangle rectangle) {
            this.renderDest.setBounds(rectangle);
            if (!graphics2D.getClipBounds().intersects(this.renderDest)) {
                return true;
            }
            if (this.size.width <= 0 || this.size.height <= 0) {
                return false;
            }
            this.renderSource.setBounds(0, 0, this.size.width, this.size.width);
            Image image = this.image.get();
            if (image == null || this.imageSize.width == 0 || this.imageSize.height == 0) {
                return false;
            }
            rectangle = ThumbnailWidget.center(new Rectangle(ThumbnailWidget.fit(this.size, rectangle.getSize())), rectangle);
            Shape shape = graphics2D.getClip();
            graphics2D.clip(rectangle);
            this.draw(image, graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height, 0.0f, 0.0f, this.imageSize.width, this.imageSize.height);
            graphics2D.setClip(shape);
            return this.isValid();
        }

        void draw(Image image, Graphics2D graphics2D, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            graphics2D.drawImage(image, (int)f, (int)f2, (int)(f + f3), (int)(f2 + f4), (int)f5, (int)f6, (int)(f5 + f7), (int)(f6 + f8), null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void validate() {
            Object object;
            Object object2;
            if (this.isValid()) {
                return;
            }
            LOG.finer("Loading " + this.source.getName());
            InputStream inputStream = null;
            ImageInputStream imageInputStream = null;
            ImageReader imageReader = null;
            try {
                inputStream = this.source.open();
                imageInputStream = ImageIO.createImageInputStream(inputStream);
                Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
                if (!iterator.hasNext()) {
                    throw new IOException("no suiteable image reader for " + this.source.getName());
                }
                imageReader = iterator.next();
                imageReader.setInput(imageInputStream, false, false);
                imageReader.addIIOReadUpdateListener(this);
                object2 = imageReader.getDefaultReadParam();
                object = this;
                synchronized (object) {
                    block62: {
                        this.size.setSize(imageReader.getWidth(0), imageReader.getHeight(0));
                        if (this.renderSource.width != 0 && this.renderSource.height != 0) break block62;
                        return;
                    }
                    if (((ImageReadParam)object2).canSetSourceRenderSize()) {
                        ((ImageReadParam)object2).setSourceRenderSize(ThumbnailWidget.fit(this.size, this.renderSource.getSize()));
                    } else {
                        ((IIOParam)object2).setSourceSubsampling(Math.max(1, (int)Math.floor(this.size.width / this.renderDest.width)), Math.max(1, (int)Math.floor(this.size.height / this.renderDest.height)), 0, 0);
                    }
                }
                object = imageReader.read(0, (ImageReadParam)object2);
                Thumbnail thumbnail = this;
                synchronized (thumbnail) {
                    this.image = new SoftReference<Object>(object);
                    this.imageSize.setSize(((Image)object).getWidth(null), ((Image)object).getHeight(null));
                }
            }
            catch (Throwable throwable) {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "Loading " + this.source.getName() + " failed", throwable);
                } else {
                    LOG.log(Level.FINE, "Loading " + this.source.getName() + " failed");
                }
                object2 = this;
                synchronized (object2) {
                    object = ThumbnailWidget.this.getFallback(this.source);
                    this.image = new SoftReference<Object>(object);
                    this.size.setSize(((Image)object).getWidth(null), ((Image)object).getHeight(null));
                    this.imageSize.setSize(this.size);
                    this.imageView.setBounds(0, 0, this.size.width, this.size.height);
                }
            }
            finally {
                try {
                    imageReader.removeIIOReadUpdateListener(this);
                }
                catch (Throwable throwable) {}
                try {
                    imageReader.reset();
                }
                catch (Throwable throwable) {}
                try {
                    imageReader.dispose();
                }
                catch (Throwable throwable) {}
                try {
                    imageInputStream.close();
                }
                catch (Throwable throwable) {}
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {}
                ThumbnailWidget.this.repaint.stop();
                ThumbnailWidget.this.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void imageUpdate(ImageReader imageReader, BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
            if (this.image.get() == null) {
                Thumbnail thumbnail = this;
                synchronized (thumbnail) {
                    this.image = new SoftReference<BufferedImage>(bufferedImage);
                    this.imageSize.setSize(bufferedImage.getWidth(null), bufferedImage.getHeight(null));
                    ThumbnailWidget.this.repaint.start();
                }
            }
        }

        public void passComplete(ImageReader imageReader, BufferedImage bufferedImage) {
        }

        public void passStarted(ImageReader imageReader, BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        }

        public void thumbnailPassComplete(ImageReader imageReader, BufferedImage bufferedImage) {
        }

        public void thumbnailPassStarted(ImageReader imageReader, BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        }

        public void thumbnailUpdate(ImageReader imageReader, BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        }
    }

    class Validation
    implements Runnable {
        private Thumbnail thumb;

        Validation(Thumbnail thumbnail) {
            this.thumb = thumbnail;
        }

        public void run() {
            this.thumb.validate();
        }

        public boolean equals(Object object) {
            return object instanceof Validation ? ((Validation)object).thumb == this.thumb : false;
        }

        public int hashCode() {
            return this.thumb.hashCode();
        }
    }

    private class EventHandler
    extends MouseAdapter
    implements MouseWheelListener,
    DropTargetListener {
        private Point start = new Point();

        private EventHandler() {
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (mouseWheelEvent.isControlDown()) {
                Point point = mouseWheelEvent.getPoint();
                Dimension dimension = ThumbnailWidget.this.getDimension();
                double d = (double)(point.x - ((ThumbnailWidget)ThumbnailWidget.this).topLeft.x) / (double)dimension.width;
                double d2 = (double)(point.y - ((ThumbnailWidget)ThumbnailWidget.this).topLeft.y) / (double)dimension.height;
                ThumbnailWidget.this.thumbSize = Math.max(Math.min(ThumbnailWidget.this.getShowAllThumbSize(), ThumbnailWidget.this.getMinThumbSize()), ThumbnailWidget.this.thumbSize - mouseWheelEvent.getWheelRotation() * Math.max(32, ThumbnailWidget.this.thumbSize / 2));
                dimension = ThumbnailWidget.this.getDimension();
                ThumbnailWidget.this.scrollTo(-((int)(d * (double)dimension.width - (double)point.x)), -((int)(d2 * (double)dimension.height - (double)point.y)));
                return;
            }
            if (mouseWheelEvent.isShiftDown()) {
                ThumbnailWidget.this.scrollTo(((ThumbnailWidget)ThumbnailWidget.this).topLeft.x - ThumbnailWidget.this.getWidth() * mouseWheelEvent.getWheelRotation(), ((ThumbnailWidget)ThumbnailWidget.this).topLeft.y);
            } else {
                ThumbnailWidget.this.scrollTo(((ThumbnailWidget)ThumbnailWidget.this).topLeft.x, ((ThumbnailWidget)ThumbnailWidget.this).topLeft.y -= ThumbnailWidget.this.getHeight() * mouseWheelEvent.getWheelRotation());
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            ThumbnailWidget.this.setCursor(Cursor.getPredefinedCursor(12));
            ThumbnailWidget.this.scrollTo(((ThumbnailWidget)ThumbnailWidget.this).topLeft.x + (mouseEvent.getPoint().x - this.start.x), ((ThumbnailWidget)ThumbnailWidget.this).topLeft.y += mouseEvent.getPoint().y - this.start.y);
            this.start.setLocation(mouseEvent.getPoint());
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ThumbnailWidget.this.setCursor(null);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ThumbnailWidget.this.requestFocusInWindow();
            this.start.setLocation(mouseEvent.getPoint());
            Thumbnail thumbnail = ThumbnailWidget.this.getThumb(mouseEvent.getPoint());
            if (thumbnail != null) {
                if (ThumbnailWidget.this.selection == thumbnail && mouseEvent.isControlDown()) {
                    ThumbnailWidget.this.select(null);
                } else {
                    ThumbnailWidget.this.select(thumbnail);
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() != 2) {
                return;
            }
            Thumbnail thumbnail = ThumbnailWidget.this.getThumb(mouseEvent.getPoint());
            if (thumbnail != null && thumbnail == ThumbnailWidget.this.selection) {
                ThumbnailWidget.this.showSelection();
            }
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            try {
                dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                ThumbnailWidget.this.handleDrop((List)dropTargetDropEvent.getTransferable().getTransferData(DataFlavor.javaFileListFlavor));
                dropTargetDropEvent.dropComplete(true);
            }
            catch (Throwable throwable) {
                dropTargetDropEvent.dropComplete(false);
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }
    }
}

