/*
 * Decompiled with CFR 0.152.
 */
package swingx.dnd.tree;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import swingx.dnd.ObjectTransferable;
import swingx.dnd.tree.DnDTreeModel;

public class DefaultDnDTreeModel
extends DefaultTreeModel
implements DnDTreeModel {
    private static DefaultDnDTreeModel currentDrag;
    private static boolean dragYielded;

    public DefaultDnDTreeModel(TreeNode treeNode) {
        super(treeNode);
    }

    public Transferable createTransferable(Object[] objectArray) {
        currentDrag = this;
        dragYielded = false;
        return new ObjectTransferable((Object)objectArray);
    }

    protected Object[] getNodes(Transferable transferable) throws UnsupportedFlavorException, IOException {
        return (Object[])ObjectTransferable.getObject((Transferable)transferable);
    }

    public int getDragActions(Transferable transferable) {
        try {
            Object[] objectArray = this.getNodes(transferable);
            for (int i = 0; i < objectArray.length; ++i) {
                if (((MutableTreeNode)objectArray[i]).getParent() != null) continue;
                return 0;
            }
            return 2;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getDropActions(Transferable transferable, Object object, int n) {
        try {
            Object[] objectArray = (Object[])ObjectTransferable.getObject((Transferable)transferable);
            for (int i = 0; i < objectArray.length; ++i) {
                if (!DefaultDnDTreeModel.isNodeAncestor((MutableTreeNode)objectArray[i], (MutableTreeNode)object)) continue;
                return 0;
            }
            return 2;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void drag(Transferable transferable, int n) throws UnsupportedFlavorException, IOException {
        if (!dragYielded && n == 2) {
            Object[] objectArray = this.getNodes(transferable);
            for (int i = objectArray.length - 1; i >= 0; --i) {
                this.removeNodeFromParent((MutableTreeNode)objectArray[i]);
            }
        }
        currentDrag = null;
    }

    public void drop(Transferable transferable, Object object, int n, int n2) throws UnsupportedFlavorException, IOException {
        if (n2 != 2) {
            throw new IllegalArgumentException("action not supported: " + n2);
        }
        if (currentDrag != null) {
            n = this.yieldDrag(transferable, object, n, n2);
        }
        Object[] objectArray = this.getNodes(transferable);
        for (int i = 0; i < objectArray.length; ++i) {
            this.insertNodeInto((MutableTreeNode)objectArray[i], (MutableTreeNode)object, n + i);
        }
    }

    protected int yieldDrag(Transferable transferable, Object object, int n, int n2) throws UnsupportedFlavorException, IOException {
        Object[] objectArray = this.getNodes(transferable);
        for (int i = 0; i < objectArray.length; ++i) {
            TreeNode treeNode = (TreeNode)objectArray[i];
            if (treeNode.getParent() != object || treeNode.getParent().getIndex(treeNode) >= n) continue;
            --n;
        }
        currentDrag.drag(transferable, n2);
        dragYielded = true;
        return n;
    }

    public void releaseTransferable(Transferable transferable) {
        currentDrag = null;
        dragYielded = false;
    }

    private static boolean isNodeAncestor(TreeNode treeNode, TreeNode treeNode2) {
        do {
            if (treeNode != treeNode2) continue;
            return true;
        } while ((treeNode2 = treeNode2.getParent()) != null);
        return false;
    }
}

