/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.fop.area.Area;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineBlockParent;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.fo.flow.InlineLevel;
import org.apache.fop.fo.flow.Leader;
import org.apache.fop.fo.pagination.Title;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonMarginInline;
import org.apache.fop.fo.properties.SpaceProperty;
import org.apache.fop.fonts.Font;
import org.apache.fop.layoutmgr.BlockKnuthSequence;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceSpecifier;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.InlineLevelLayoutManager;
import org.apache.fop.layoutmgr.inline.InlineStackingLayoutManager;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;

public class InlineLayoutManager
extends InlineStackingLayoutManager {
    private InlineLevel fobj;
    private CommonMarginInline inlineProps = null;
    private CommonBorderPaddingBackground borderProps = null;
    private boolean areaCreated = false;
    private LayoutManager lastChildLM = null;
    private Position auxiliaryPosition;
    private Font font;
    protected Length alignmentAdjust;
    protected int alignmentBaseline = 12;
    protected Length baselineShift;
    protected int dominantBaseline;
    protected SpaceProperty lineHeight;
    private AlignmentContext alignmentContext = null;

    public InlineLayoutManager(InlineLevel node) {
        super(node);
        this.fobj = node;
    }

    private Inline getInlineFO() {
        return (Inline)this.fobj;
    }

    public void initialize() {
        int padding = 0;
        this.font = this.fobj.getCommonFont().getFontState(this.fobj.getFOEventHandler().getFontInfo(), this);
        this.lineHeight = this.fobj.getLineHeight();
        this.borderProps = this.fobj.getCommonBorderPaddingBackground();
        this.inlineProps = this.fobj.getCommonMarginInline();
        if (this.fobj instanceof Inline) {
            this.alignmentAdjust = ((Inline)this.fobj).getAlignmentAdjust();
            this.alignmentBaseline = ((Inline)this.fobj).getAlignmentBaseline();
            this.baselineShift = ((Inline)this.fobj).getBaselineShift();
            this.dominantBaseline = ((Inline)this.fobj).getDominantBaseline();
        } else if (this.fobj instanceof Leader) {
            this.alignmentAdjust = ((Leader)this.fobj).getAlignmentAdjust();
            this.alignmentBaseline = ((Leader)this.fobj).getAlignmentBaseline();
            this.baselineShift = ((Leader)this.fobj).getBaselineShift();
            this.dominantBaseline = ((Leader)this.fobj).getDominantBaseline();
        }
        if (this.borderProps != null) {
            padding = this.borderProps.getPadding(0, false, this);
            padding += this.borderProps.getBorderWidth(0, false);
            padding += this.borderProps.getPadding(1, false, this);
            padding += this.borderProps.getBorderWidth(1, false);
        }
        this.extraBPD = new MinOptMax(padding);
    }

    protected MinOptMax getExtraIPD(boolean isNotFirst, boolean isNotLast) {
        int borderAndPadding = 0;
        if (this.borderProps != null) {
            borderAndPadding = this.borderProps.getPadding(2, isNotFirst, this);
            borderAndPadding += this.borderProps.getBorderWidth(2, isNotFirst);
            borderAndPadding += this.borderProps.getPadding(3, isNotLast, this);
            borderAndPadding += this.borderProps.getBorderWidth(3, isNotLast);
        }
        return new MinOptMax(borderAndPadding);
    }

    protected boolean hasLeadingFence(boolean isNotFirst) {
        return this.borderProps != null && (this.borderProps.getPadding(2, isNotFirst, this) > 0 || this.borderProps.getBorderWidth(2, isNotFirst) > 0);
    }

    protected boolean hasTrailingFence(boolean isNotLast) {
        return this.borderProps != null && (this.borderProps.getPadding(3, isNotLast, this) > 0 || this.borderProps.getBorderWidth(3, isNotLast) > 0);
    }

    protected SpaceProperty getSpaceStart() {
        return this.inlineProps != null ? this.inlineProps.spaceStart : null;
    }

    protected SpaceProperty getSpaceEnd() {
        return this.inlineProps != null ? this.inlineProps.spaceEnd : null;
    }

    protected InlineArea createArea(boolean hasInlineParent) {
        InlineArea area;
        if (hasInlineParent) {
            area = new InlineParent();
            area.setOffset(0);
        } else {
            area = new InlineBlockParent();
        }
        if (this.fobj instanceof Inline) {
            TraitSetter.setProducerID(area, this.getInlineFO().getId());
        }
        return area;
    }

    protected void setTraits(boolean isNotFirst, boolean isNotLast) {
        if (this.borderProps != null) {
            TraitSetter.setBorderPaddingTraits(this.getCurrentArea(), this.borderProps, isNotFirst, isNotLast, this);
            TraitSetter.addBackground(this.getCurrentArea(), this.borderProps, this);
        }
    }

    public boolean mustKeepTogether() {
        return this.mustKeepTogether(this.getParent());
    }

    private boolean mustKeepTogether(LayoutManager lm) {
        if (lm instanceof BlockLevelLayoutManager) {
            return ((BlockLevelLayoutManager)lm).mustKeepTogether();
        }
        if (lm instanceof InlineLayoutManager) {
            return ((InlineLayoutManager)lm).mustKeepTogether();
        }
        return this.mustKeepTogether(lm.getParent());
    }

    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        LayoutManager curLM;
        LinkedList<BlockKnuthSequence> returnList = new LinkedList<BlockKnuthSequence>();
        KnuthSequence lastSequence = null;
        SpaceSpecifier leadingSpace = context.getLeadingSpace();
        this.alignmentContext = this.fobj instanceof Title ? new AlignmentContext(this.font, this.lineHeight.getOptimum(this).getLength().getValue(this), context.getWritingMode()) : new AlignmentContext(this.font, this.lineHeight.getOptimum(this).getLength().getValue(this), this.alignmentAdjust, this.alignmentBaseline, this.baselineShift, this.dominantBaseline, context.getAlignmentContext());
        this.childLC = new LayoutContext(context);
        this.childLC.setAlignmentContext(this.alignmentContext);
        if (context.startsNewArea()) {
            if (this.getSpaceStart() != null) {
                context.getLeadingSpace().addSpace(new SpaceVal(this.getSpaceStart(), this));
            }
            if (this.hasLeadingFence(!context.isFirstArea())) {
                leadingSpace = new SpaceSpecifier(false);
            }
            this.clearPrevIPD();
        }
        StringBuffer trace = new StringBuffer("InlineLM:");
        boolean borderAdded = false;
        if (this.borderProps != null) {
            this.childLC.setLineStartBorderAndPaddingWidth(context.getLineStartBorderAndPaddingWidth() + this.borderProps.getPaddingStart(true, this) + this.borderProps.getBorderStartWidth(true));
            this.childLC.setLineEndBorderAndPaddingWidth(context.getLineEndBorderAndPaddingWidth() + this.borderProps.getPaddingEnd(true, this) + this.borderProps.getBorderEndWidth(true));
        }
        while ((curLM = this.getChildLM()) != null) {
            if (!(curLM instanceof InlineLevelLayoutManager) && this.borderProps != null) {
                this.childLC.setRefIPD(this.childLC.getRefIPD() - this.borderProps.getPaddingStart(this.lastChildLM != null, this) - this.borderProps.getBorderStartWidth(this.lastChildLM != null) - this.borderProps.getPaddingEnd(this.hasNextChildLM(), this) - this.borderProps.getBorderEndWidth(this.hasNextChildLM()));
            }
            LinkedList returnedList = curLM.getNextKnuthElements(this.childLC, alignment);
            if (returnList.size() == 0 && this.childLC.isKeepWithPreviousPending()) {
                this.childLC.setFlags(1024, false);
            }
            if (returnedList == null || returnedList.size() == 0) continue;
            if (curLM instanceof InlineLevelLayoutManager) {
                context.setFlags(512, false);
                ListIterator seqIter = returnedList.listIterator();
                while (seqIter.hasNext()) {
                    KnuthSequence sequence = (KnuthSequence)seqIter.next();
                    sequence.wrapPositions(this);
                }
                if (lastSequence != null && lastSequence.appendSequenceOrClose((KnuthSequence)returnedList.get(0))) {
                    returnedList.remove(0);
                }
                if (!borderAdded && returnedList.size() != 0) {
                    this.addKnuthElementsForBorderPaddingStart((KnuthSequence)returnedList.get(0));
                    borderAdded = true;
                }
                returnList.addAll(returnedList);
            } else {
                BlockKnuthSequence sequence = new BlockKnuthSequence(returnedList);
                sequence.wrapPositions(this);
                boolean appended = false;
                if (lastSequence != null) {
                    if (lastSequence.canAppendSequence(sequence)) {
                        BreakElement bk = new BreakElement(new Position(this), 0, context);
                        boolean keepTogether = this.mustKeepTogether() || context.isKeepWithNextPending() || this.childLC.isKeepWithPreviousPending();
                        appended = lastSequence.appendSequenceOrClose(sequence, keepTogether, bk);
                    } else {
                        lastSequence.endSequence();
                    }
                }
                if (!appended) {
                    if (!borderAdded) {
                        this.addKnuthElementsForBorderPaddingStart(sequence);
                        borderAdded = true;
                    }
                    returnList.add(sequence);
                }
                context.setFlags(512, this.childLC.isKeepWithNextPending());
                this.childLC.setFlags(512, false);
                this.childLC.setFlags(1024, false);
            }
            lastSequence = (KnuthSequence)returnList.getLast();
            this.lastChildLM = curLM;
        }
        if (lastSequence != null) {
            this.addKnuthElementsForBorderPaddingEnd(lastSequence);
        }
        this.setFinished(true);
        log.trace((Object)trace);
        return returnList.size() == 0 ? null : returnList;
    }

    public void addAreas(PositionIterator parentIter, LayoutContext context) {
        boolean isLast;
        LayoutManager childLM;
        NonLeafPosition lastPos = null;
        this.addId();
        this.setChildContext(new LayoutContext(context));
        if (this.hasLeadingFence(this.areaCreated)) {
            this.getContext().setLeadingSpace(new SpaceSpecifier(false));
            this.getContext().setFlags(256, true);
        } else {
            this.getContext().setFlags(256, false);
        }
        if (this.getSpaceStart() != null) {
            context.getLeadingSpace().addSpace(new SpaceVal(this.getSpaceStart(), this));
        }
        LinkedList<Position> positionList = new LinkedList<Position>();
        NonLeafPosition pos = null;
        LayoutManager lastLM = null;
        while (parentIter.hasNext()) {
            pos = (NonLeafPosition)parentIter.next();
            if (pos == null || pos.getPosition() == null) continue;
            positionList.add(pos.getPosition());
            lastLM = pos.getPosition().getLM();
            lastPos = pos;
        }
        InlineArea parent = this.createArea(lastLM == null || lastLM instanceof InlineLevelLayoutManager);
        parent.setBPD(this.alignmentContext.getHeight());
        if (parent instanceof InlineParent) {
            parent.setOffset(this.alignmentContext.getOffset());
        } else if (parent instanceof InlineBlockParent && this.borderProps != null) {
            parent.setOffset(this.borderProps.getPaddingBefore(false, this) + this.borderProps.getBorderBeforeWidth(false));
        }
        this.setCurrentArea(parent);
        InlineStackingLayoutManager.StackingIter childPosIter = new InlineStackingLayoutManager.StackingIter(positionList.listIterator());
        LayoutManager prevLM = null;
        while ((childLM = childPosIter.getNextChildLM()) != null) {
            this.getContext().setFlags(128, context.isLastArea() && childLM == lastLM);
            childLM.addAreas(childPosIter, this.getContext());
            this.getContext().setLeadingSpace(this.getContext().getTrailingSpace());
            this.getContext().setFlags(256, true);
            prevLM = childLM;
        }
        boolean bl = isLast = this.getContext().isLastArea() && prevLM == this.lastChildLM;
        if (this.hasTrailingFence(isLast)) {
            this.addSpace(this.getCurrentArea(), this.getContext().getTrailingSpace().resolve(false), this.getContext().getSpaceAdjust());
            context.setTrailingSpace(new SpaceSpecifier(false));
        } else {
            context.setTrailingSpace(this.getContext().getTrailingSpace());
        }
        if (context.getTrailingSpace() != null && this.getSpaceEnd() != null) {
            context.getTrailingSpace().addSpace(new SpaceVal(this.getSpaceEnd(), this));
        }
        this.setTraits(this.areaCreated, lastPos == null || !this.isLast(lastPos));
        this.parentLM.addChildArea(this.getCurrentArea());
        context.setFlags(128, isLast);
        this.areaCreated = true;
    }

    public void addChildArea(Area childArea) {
        Area parent = this.getCurrentArea();
        if (this.getContext().resolveLeadingSpace()) {
            this.addSpace(parent, this.getContext().getLeadingSpace().resolve(false), this.getContext().getSpaceAdjust());
        }
        parent.addChildArea(childArea);
    }

    public LinkedList getChangedKnuthElements(List oldList, int alignment) {
        LinkedList returnedList = new LinkedList();
        this.addKnuthElementsForBorderPaddingStart(returnedList);
        returnedList.addAll(super.getChangedKnuthElements(oldList, alignment));
        this.addKnuthElementsForBorderPaddingEnd(returnedList);
        return returnedList;
    }

    protected void addKnuthElementsForBorderPaddingStart(List returnList) {
        int ipStart;
        CommonBorderPaddingBackground borderAndPadding = this.fobj.getCommonBorderPaddingBackground();
        if (borderAndPadding != null && (ipStart = borderAndPadding.getBorderStartWidth(false) + borderAndPadding.getPaddingStart(false, this)) > 0) {
            returnList.add(0, new KnuthBox(ipStart, this.getAuxiliaryPosition(), true));
        }
    }

    protected void addKnuthElementsForBorderPaddingEnd(List returnList) {
        int ipEnd;
        CommonBorderPaddingBackground borderAndPadding = this.fobj.getCommonBorderPaddingBackground();
        if (borderAndPadding != null && (ipEnd = borderAndPadding.getBorderEndWidth(false) + borderAndPadding.getPaddingEnd(false, this)) > 0) {
            returnList.add(new KnuthBox(ipEnd, this.getAuxiliaryPosition(), true));
        }
    }

    protected Position getAuxiliaryPosition() {
        this.auxiliaryPosition = new NonLeafPosition(this, null);
        return this.auxiliaryPosition;
    }

    protected void addId() {
        if (this.fobj instanceof Inline) {
            this.getPSLM().addIDToPage(this.getInlineFO().getId());
        }
    }
}

