/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.bitmap;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.codec.PNGEncodeParam;
import org.apache.batik.ext.awt.image.codec.PNGImageEncoder;
import org.apache.commons.io.IOUtils;
import org.apache.fop.apps.FOPException;
import org.apache.fop.area.PageViewport;
import org.apache.fop.render.java2d.Java2DRenderer;

public class PNGRenderer
extends Java2DRenderer {
    public static final String MIME_TYPE = "image/png";
    private String filePrefix;
    private File outputDir;
    private PNGEncodeParam renderParams;
    private OutputStream firstOutputStream;

    public String getMimeType() {
        return MIME_TYPE;
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        log.info((Object)"rendering areas to PNG");
        this.setOutputDirectory();
        this.firstOutputStream = outputStream;
    }

    private void setOutputDirectory() {
        File f = this.getUserAgent().getOutputFile();
        if (f == null) {
            this.outputDir = null;
            this.filePrefix = null;
        } else {
            int i;
            this.outputDir = f.getParentFile();
            String s = f.getName();
            if (s.charAt((i = s.lastIndexOf(".")) - 1) == '1') {
                --i;
            }
            this.filePrefix = s.substring(0, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRenderer() throws IOException {
        super.stopRenderer();
        for (int i = 0; i < this.pageViewportList.size(); ++i) {
            OutputStream os = this.getCurrentOutputStream(i);
            if (os == null) {
                log.warn((Object)"No filename information available. Stopping early after the first page.");
                break;
            }
            try {
                BufferedImage image = this.getPageImage((PageViewport)this.pageViewportList.get(i));
                log.debug((Object)("Encoding page " + (i + 1)));
                this.renderParams = PNGEncodeParam.getDefaultEncodeParam((RenderedImage)image);
                float pixSzMM = this.userAgent.getTargetPixelUnitToMillimeter();
                int numPix = (int)((double)(1000.0f / pixSzMM) + 0.5);
                this.renderParams.setPhysicalDimension(numPix, numPix, 1);
                PNGImageEncoder encoder = new PNGImageEncoder(os, this.renderParams);
                encoder.encode((RenderedImage)image);
                continue;
            }
            finally {
                if (os != this.firstOutputStream) {
                    IOUtils.closeQuietly((OutputStream)os);
                }
            }
        }
    }

    private OutputStream getCurrentOutputStream(int pageNumber) {
        if (pageNumber == 0) {
            return this.firstOutputStream;
        }
        if (this.filePrefix == null) {
            return null;
        }
        File f = new File(this.outputDir, this.filePrefix + (pageNumber + 1) + ".png");
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
            return os;
        }
        catch (FileNotFoundException e) {
            new FOPException("Can't build the OutputStream\n" + e);
            return null;
        }
    }
}

