/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.impl.SimpleLog;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.servlet.ServletContextURIResolver;

public class FopPrintServlet
extends HttpServlet {
    protected static final String FO_REQUEST_PARAM = "fo";
    protected static final String XML_REQUEST_PARAM = "xml";
    protected static final String XSLT_REQUEST_PARAM = "xslt";
    protected SimpleLog log = null;
    protected TransformerFactory transFactory = null;
    protected URIResolver uriResolver;

    public void init() throws ServletException {
        this.log = new SimpleLog("FOP/Print Servlet");
        this.log.setLevel(4);
        this.uriResolver = new ServletContextURIResolver(this.getServletContext());
        this.transFactory = TransformerFactory.newInstance();
        this.transFactory.setURIResolver(this.uriResolver);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (this.log == null) {
            this.log = new SimpleLog("FOP/Print Servlet");
            this.log.setLevel(4);
        }
        try {
            String foParam = request.getParameter(FO_REQUEST_PARAM);
            String xmlParam = request.getParameter(XML_REQUEST_PARAM);
            String xsltParam = request.getParameter(XSLT_REQUEST_PARAM);
            if (foParam != null) {
                FileInputStream file = new FileInputStream(foParam);
                this.renderFO(file, response);
            } else if (xmlParam != null && xsltParam != null) {
                this.renderXML(new File(xmlParam), new File(xsltParam), response);
            } else {
                response.setContentType("text/html");
                PrintWriter out = response.getWriter();
                out.println("<html><title>Error</title>\n<body><h1>FopServlet Error</h1>\n<h3>No 'fo' or 'xml/xsl' request param given.</h3></body>\n</html>");
            }
        }
        catch (ServletException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    public void renderFO(InputStream foFile, HttpServletResponse response) throws ServletException {
        try {
            Fop fop = new Fop("application/X-fop-print", this.getFOUserAgent());
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setURIResolver(this.uriResolver);
            StreamSource src = new StreamSource(foFile);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
            this.reportOK(response);
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    public void renderXML(File xmlfile, File xsltfile, HttpServletResponse response) throws ServletException {
        try {
            Fop fop = new Fop("application/X-fop-print", this.getFOUserAgent());
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(new StreamSource(xsltfile));
            transformer.setURIResolver(this.uriResolver);
            StreamSource src = new StreamSource(xmlfile);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
            this.reportOK(response);
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    private void reportOK(HttpServletResponse response) throws ServletException {
        String sMsg = "<html><title>Success</title>\n<body><h1>FopPrintServlet: </h1><h3>The requested data was printed</h3></body></html>";
        response.setContentType("text/html");
        response.setContentLength(sMsg.length());
        try {
            PrintWriter out = response.getWriter();
            out.println(sMsg);
            out.flush();
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    protected FOUserAgent getFOUserAgent() {
        FOUserAgent userAgent = new FOUserAgent();
        userAgent.setURIResolver(this.uriResolver);
        return userAgent;
    }
}

