/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.config.view;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jgpstrackedit.config.Configuration;
import jgpstrackedit.config.view.ConfigurationPanel;
import jgpstrackedit.international.International;

public class GeneralPanel
extends JPanel
implements ConfigurationPanel {
    private JCheckBox chckbxShowHelpDialog;
    private JComboBox comboBoxLanguage;
    private JComboBox comboBoxCountry;
    private JComboBox comboBoxLF;

    public GeneralPanel() {
        this.setLayout(null);
        this.chckbxShowHelpDialog = new JCheckBox(International.getText("dlgconfig.Show_Help_Dialog_on_startup"));
        this.chckbxShowHelpDialog.setBounds(6, 7, 331, 23);
        this.add(this.chckbxShowHelpDialog);
        JLabel lblLanguage = new JLabel(String.valueOf(International.getText("dlgconfig.Language")) + ":");
        lblLanguage.setBounds(6, 33, 117, 14);
        this.add(lblLanguage);
        this.comboBoxLanguage = new JComboBox();
        this.comboBoxLanguage.setModel(new DefaultComboBoxModel<String>(International.languages));
        this.comboBoxLanguage.setBounds(133, 30, 119, 20);
        this.add(this.comboBoxLanguage);
        JLabel lblCountry = new JLabel(String.valueOf(International.getText("dlgconfig.Country")) + ":");
        lblCountry.setBounds(6, 58, 117, 14);
        this.add(lblCountry);
        this.comboBoxCountry = new JComboBox();
        this.comboBoxCountry.setModel(new DefaultComboBoxModel<String>(International.getCountries()));
        this.comboBoxCountry.setBounds(133, 55, 119, 20);
        this.add(this.comboBoxCountry);
        JButton btnRestoreDefault = new JButton(International.getText("dlgconfig.Restore_default"));
        btnRestoreDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GeneralPanel.this.comboBoxLanguage.setSelectedItem(Locale.getDefault().getLanguage());
                GeneralPanel.this.comboBoxCountry.setSelectedItem(Locale.getDefault().getCountry());
                GeneralPanel.this.comboBoxLF.setSelectedItem("System");
            }
        });
        btnRestoreDefault.setBounds(6, 113, 246, 23);
        this.add(btnRestoreDefault);
        JLabel lblGuiLookfeel = new JLabel(String.valueOf(International.getText("dlgconfig.GUI_LookFeel")) + ":");
        lblGuiLookfeel.setBounds(6, 83, 117, 14);
        this.add(lblGuiLookfeel);
        this.comboBoxLF = new JComboBox();
        this.comboBoxLF.setModel(new DefaultComboBoxModel<String>(new String[]{"System", "Cross-Platform"}));
        this.comboBoxLF.setBounds(133, 80, 119, 20);
        this.add(this.comboBoxLF);
    }

    @Override
    public String getTabName() {
        return International.getText("dlgconfig.General");
    }

    @Override
    public void save() {
        Configuration.setProperty("SHOW_HELP_ON_STARTUP", this.chckbxShowHelpDialog.isSelected() ? "1" : "0");
        International.setCurrentLocale(new Locale(this.comboBoxLanguage.getSelectedItem().toString(), this.comboBoxCountry.getSelectedItem().toString()));
        Configuration.setProperty("LOCALE", International.getCurrentLocale().toString());
        Configuration.setProperty("GUILOOKFEEL", this.comboBoxLF.getSelectedItem().toString());
    }

    @Override
    public void cancel() {
    }

    @Override
    public void initialize() {
        this.chckbxShowHelpDialog.setSelected(Configuration.getBooleanProperty("SHOW_HELP_ON_STARTUP"));
        this.comboBoxLanguage.setSelectedItem(International.getCurrentLanguage());
        this.comboBoxCountry.setSelectedItem(International.getCurrentCountry());
        this.comboBoxLF.setSelectedItem(Configuration.getProperty("GUILOOKFEEL"));
    }
}

