/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.data;

import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.TreeSet;
import jgpstrackedit.data.Point;
import jgpstrackedit.data.TrackObserver;
import jgpstrackedit.data.util.Geometry;
import jgpstrackedit.data.util.TrackUtil;

public class Track {
    private ArrayList<Point> points = new ArrayList();
    private Point leftUpperBoundary = null;
    private Point rightLowerBoundary = null;
    private String name;
    private String copyright;
    private String link;
    private String linkText;
    private String trackFileType;
    private String trackFileName;
    private boolean valid = false;
    private boolean modified = false;
    private transient TreeSet<Integer> compressedTrackIndizes;
    private Color color;
    private ArrayList<TrackObserver> trackObservers = new ArrayList();
    private String time;
    private String gpxAttributes;

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
        this.notifyTrackObservers();
        this.modified = modified;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public String getTrackFileName() {
        return this.trackFileName;
    }

    public void setTrackFileName(String trackFileName) {
        this.trackFileName = trackFileName;
    }

    public String getTrackFileType() {
        return this.trackFileType;
    }

    public void setTrackFileType(String trackFileType) {
        this.trackFileType = trackFileType;
    }

    public Track() {
        this.color = Color.BLACK;
        Date now = new Date();
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat df2 = new SimpleDateFormat("HH:mm:ss");
        this.time = String.valueOf(df1.format(now)) + "T" + df2.format(now) + "Z";
    }

    public void addTrackObserver(TrackObserver observer) {
        this.trackObservers.add(observer);
    }

    public void removeTrackObserver(TrackObserver observer) {
        this.trackObservers.remove(observer);
    }

    protected void notifyTrackObservers() {
        for (TrackObserver observer : (ArrayList)this.trackObservers.clone()) {
            observer.trackModified(this);
        }
        this.modified = true;
    }

    public void hasBeenModified() {
        this.checkBoundaries();
        this.notifyTrackObservers();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public String getLinkText() {
        return this.linkText;
    }

    public void setLinkText(String linkText) {
        this.linkText = linkText;
    }

    public String getGpxAttributes() {
        return this.gpxAttributes;
    }

    public void setGpxAttributes(String gpxAttributes) {
        this.gpxAttributes = gpxAttributes;
    }

    public Point getLeftUpperBoundary() {
        return this.leftUpperBoundary;
    }

    public void setLeftUpperBoundary(Point leftUpperBoundary) {
        this.leftUpperBoundary = leftUpperBoundary;
    }

    public Point getRightLowerBoundary() {
        return this.rightLowerBoundary;
    }

    public void setRightLowerBoundary(Point rightLowerBoundary) {
        this.rightLowerBoundary = rightLowerBoundary;
    }

    public ArrayList<Point> getPoints() {
        return this.points;
    }

    public void setPoints(ArrayList<Point> points) {
        this.points = points;
        this.notifyTrackObservers();
    }

    public Point getPoint(int index) {
        return this.points.get(index);
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
        this.notifyTrackObservers();
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
        this.notifyTrackObservers();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.notifyTrackObservers();
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
        this.notifyTrackObservers();
    }

    public Point getFirstPoint() {
        return this.points.get(0);
    }

    public Point getLastPoint() {
        return this.points.get(this.points.size() - 1);
    }

    public int getNumberPoints() {
        return this.points.size();
    }

    public double getLength() {
        return this.getLength(false);
    }

    public double getLength(boolean storeLength) {
        double length = 0.0;
        Point first = this.getFirstPoint();
        if (storeLength) {
            first.setLength(0.0);
        }
        int i = 1;
        while (i < this.points.size()) {
            length += first.distance(this.points.get(i));
            if (storeLength) {
                this.points.get(i).setLength(length);
            }
            first = this.points.get(i);
            ++i;
        }
        return length;
    }

    public Point getPoint(double length) {
        double currentLength = 0.0;
        Point first = this.getFirstPoint();
        int i = 1;
        while (i < this.points.size()) {
            if ((currentLength += first.distance(this.points.get(i))) > length) {
                return first;
            }
            first = this.points.get(i);
            ++i;
        }
        return null;
    }

    public double getLength(Point point) {
        double tourLength = 0.0;
        Point firstPoint = this.getFirstPoint();
        int i = 1;
        while (this.points.get(i) != point) {
            tourLength += firstPoint.distance(this.points.get(i));
            firstPoint = this.points.get(i);
            ++i;
        }
        return tourLength;
    }

    public double getUpAltitudeDifference() {
        double attitude = 0.0;
        Point first = this.getFirstPoint();
        int i = 1;
        while (i < this.points.size()) {
            double delta = first.altitudeDifference(this.points.get(i));
            if (delta > 0.0) {
                attitude += delta;
            }
            first = this.points.get(i);
            ++i;
        }
        return attitude;
    }

    public double getDownAltitudeDifference() {
        double attitude = 0.0;
        Point first = this.getFirstPoint();
        int i = 1;
        while (i < this.points.size()) {
            double delta = first.altitudeDifference(this.points.get(i));
            if (delta < 0.0) {
                attitude += delta;
            }
            first = this.points.get(i);
            ++i;
        }
        return attitude;
    }

    public double getHighestElevation() {
        double max = this.getFirstPoint().getElevation();
        for (Point point : this.points) {
            if (!(point.getElevation() > max)) continue;
            max = point.getElevation();
        }
        return max;
    }

    public double getLowestElevation() {
        double min = this.getFirstPoint().getElevation();
        for (Point point : this.points) {
            if (!(point.getElevation() < min)) continue;
            min = point.getElevation();
        }
        return min;
    }

    public void reverse() {
        Collections.reverse(this.points);
        this.notifyTrackObservers();
    }

    public void add(Point point) {
        this.points.add(point);
        this.checkBoundaries(point);
        this.notifyTrackObservers();
    }

    public void remove(Point point) {
        this.points.remove(point);
        this.checkBoundaries();
        this.notifyTrackObservers();
    }

    public void remove(Point start, Point end) {
        ArrayList<Point> removePoints = new ArrayList<Point>();
        boolean isInterval = false;
        for (Point point : this.points) {
            if (point.equals(start) || point.equals(end)) {
                isInterval = !isInterval;
                continue;
            }
            if (!isInterval) continue;
            removePoints.add(point);
        }
        this.points.removeAll(removePoints);
        this.checkBoundaries();
        this.notifyTrackObservers();
    }

    public void add(ArrayList<Point> points) {
        this.points.addAll(points);
        this.checkBoundaries();
        this.notifyTrackObservers();
    }

    public void add(Track track, boolean direct) {
        if (!direct) {
            double[] distances = new double[]{this.getFirstPoint().distance(track.getFirstPoint()), this.getFirstPoint().distance(track.getLastPoint()), this.getLastPoint().distance(track.getFirstPoint()), this.getLastPoint().distance(track.getLastPoint())};
            int minIndex = 0;
            double minDistance = distances[0];
            int i = 1;
            while (i < 4) {
                if (distances[i] < minDistance) {
                    minIndex = i;
                    minDistance = distances[i];
                }
                ++i;
            }
            switch (minIndex) {
                case 0: {
                    this.reverse();
                    break;
                }
                case 1: {
                    this.reverse();
                    track.reverse();
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    track.reverse();
                }
            }
        }
        this.points.addAll(track.getPoints());
        this.checkBoundaries(track.getLeftUpperBoundary());
        this.checkBoundaries(track.getRightLowerBoundary());
        this.notifyTrackObservers();
    }

    public void correct() {
        int i = 0;
        while (i < this.points.size()) {
            if (this.points.get(i).isZero()) {
                this.points.remove(i);
                --i;
            }
            ++i;
        }
        this.checkBoundaries();
    }

    public void correctDoublePoints() {
        TrackUtil.removeDoublePoints(this.points);
        Point first = this.points.get(0);
        int i = 1;
        while (i < this.points.size()) {
            if (this.points.get(i).equals(first)) {
                this.points.remove(i);
                --i;
            } else {
                first = this.points.get(i);
            }
            ++i;
        }
    }

    public void correct(double epsilon) {
        Point reference = this.getFirstPoint();
        int i = 1;
        while (i < this.points.size()) {
            if (reference.distance(this.points.get(i)) > epsilon) {
                this.points.remove(i);
                --i;
            }
            ++i;
        }
        this.checkBoundaries();
    }

    protected void checkBoundaries(Point point) {
        if (this.leftUpperBoundary == null) {
            this.leftUpperBoundary = point.clone();
            this.rightLowerBoundary = point.clone();
        }
        if (point.getLatitude() > this.leftUpperBoundary.getLatitude()) {
            this.leftUpperBoundary.setLatitude(point.getLatitude());
        }
        if (point.getLongitude() < this.leftUpperBoundary.getLongitude()) {
            this.leftUpperBoundary.setLongitude(point.getLongitude());
        }
        if (point.getLatitude() < this.rightLowerBoundary.getLatitude()) {
            this.rightLowerBoundary.setLatitude(point.getLatitude());
        }
        if (point.getLongitude() > this.rightLowerBoundary.getLongitude()) {
            this.rightLowerBoundary.setLongitude(point.getLongitude());
        }
    }

    public void checkBoundaries() {
        this.leftUpperBoundary = null;
        this.rightLowerBoundary = null;
        for (Point p : this.points) {
            this.checkBoundaries(p);
        }
    }

    public Point nearestPoint(Point point) {
        if (this.points.size() == 0) {
            return null;
        }
        double distance = point.distance(this.points.get(0));
        Point nearestPoint = this.points.get(0);
        for (Point p : this.points) {
            if (!(p.distance(point) < distance)) continue;
            distance = p.distance(point);
            nearestPoint = p;
        }
        return nearestPoint;
    }

    public boolean isInBoundary(Point point) {
        return this.leftUpperBoundary.getLongitude() < point.getLongitude() && this.leftUpperBoundary.getLatitude() > point.getLatitude() && this.rightLowerBoundary.getLongitude() > point.getLongitude() && this.rightLowerBoundary.getLatitude() < point.getLatitude();
    }

    public Track split(Point splitPoint, String name) {
        int splitIndex = this.points.indexOf(splitPoint);
        assert (splitIndex != -1);
        Track secondTrack = new Track();
        secondTrack.setName(String.valueOf(name) + "_2");
        secondTrack.setLink(this.getLink());
        secondTrack.setLinkText(this.getLinkText());
        secondTrack.setTime(this.getTime());
        secondTrack.setGpxAttributes(this.getGpxAttributes());
        secondTrack.setCopyright(this.getCopyright());
        secondTrack.add(splitPoint);
        int i = splitIndex + 1;
        while (i < this.points.size()) {
            secondTrack.add(this.points.get(i));
            ++i;
        }
        i = this.points.size() - 1;
        while (i > splitIndex) {
            this.points.remove(i);
            --i;
        }
        this.setName(String.valueOf(name) + "_1");
        this.checkBoundaries();
        secondTrack.checkBoundaries();
        this.notifyTrackObservers();
        return secondTrack;
    }

    public Track split(Point splitPoint) {
        return this.split(splitPoint, this.getName());
    }

    public void insertAdjacentPoints(Point selectedPoint) {
        int selectedIndex = this.points.indexOf(selectedPoint);
        if (selectedIndex < this.points.size() - 1) {
            this.insertAdjacentPoint(selectedIndex + 1, selectedPoint, this.points.get(selectedIndex + 1));
        }
        if (selectedIndex > 0) {
            this.insertAdjacentPoint(selectedIndex, selectedPoint, this.points.get(selectedIndex - 1));
        }
        this.notifyTrackObservers();
    }

    protected void insertAdjacentPoint(int insertionIndex, Point selectedPoint, Point adjacentPoint) {
        double longitude = (selectedPoint.getLongitude() + adjacentPoint.getLongitude()) / 2.0;
        double latitude = (selectedPoint.getLatitude() + adjacentPoint.getLatitude()) / 2.0;
        double elevation = (selectedPoint.getElevation() + adjacentPoint.getElevation()) / 2.0;
        Point point = new Point(longitude, latitude, elevation);
        this.points.add(insertionIndex, point);
    }

    public void setPointPosition(Point point, double mapLongitude, double mapLatitude) {
        if (point != null) {
            point.setLongitude(mapLongitude);
            point.setLatitude(mapLatitude);
            this.notifyTrackObservers();
        }
    }

    public int indexOf(Point point) {
        return this.points.indexOf(point);
    }

    public void add(double mapLongitude, double mapLatitude) {
        Point point = new Point(mapLongitude, mapLatitude);
        this.add(point);
    }

    public void compress(double maxDeviation) {
        if (this.getNumberPoints() > 3) {
            Point first = this.points.get(0);
            Point second = this.points.get(2);
            int i = 1;
            while (i + 2 < this.points.size()) {
                if (Geometry.distanceLineToPoint(first, second, this.points.get(i)) <= maxDeviation) {
                    this.points.remove(i);
                    second = this.points.get(i + 1);
                    --i;
                } else {
                    first = this.points.get(i);
                    second = this.points.get(i + 2);
                }
                ++i;
            }
            this.notifyTrackObservers();
        }
    }

    protected void compressDP(int firstPointIndex, int lastPointIndex, double maxDeviation) {
        Point first = this.points.get(firstPointIndex);
        Point last = this.points.get(lastPointIndex);
        double maxDistance = 0.0;
        double actualDistance = 0.0;
        int distanceIndex = firstPointIndex;
        int i = firstPointIndex + 1;
        while (i < lastPointIndex) {
            actualDistance = Geometry.distanceLineToPoint(first, last, this.points.get(i));
            if (actualDistance > maxDistance) {
                maxDistance = actualDistance;
                distanceIndex = i;
            }
            ++i;
        }
        if (maxDistance > maxDeviation) {
            this.compressDP(firstPointIndex, distanceIndex, maxDeviation);
            this.compressDP(distanceIndex, lastPointIndex, maxDeviation);
        } else {
            this.compressedTrackIndizes.add(firstPointIndex);
            this.compressedTrackIndizes.add(lastPointIndex);
        }
    }

    public void compressDouglasPeucker(double maxDeviation) {
        this.compressedTrackIndizes = new TreeSet();
        this.compressDP(0, this.points.size() - 1, maxDeviation);
        ArrayList<Point> pointsCompressed = new ArrayList<Point>();
        for (int i : this.compressedTrackIndizes) {
            pointsCompressed.add(this.points.get(i));
        }
        this.points = pointsCompressed;
        this.compressedTrackIndizes = null;
        this.notifyTrackObservers();
    }

    public void compress(int removeInterval) {
        if (removeInterval > 1) {
            int i = removeInterval - 1;
            while (i < this.points.size() - 1) {
                this.points.remove(i);
                i = i + removeInterval - 1;
            }
            this.notifyTrackObservers();
        }
    }

    public Track clone() {
        Track cloneTrack = new Track();
        for (Point p : this.points) {
            cloneTrack.add(p.clone());
        }
        cloneTrack.setColor(this.getColor());
        cloneTrack.setCopyright(this.getCopyright());
        cloneTrack.setGpxAttributes(this.getGpxAttributes());
        cloneTrack.setLink(this.getLink());
        cloneTrack.setLinkText(this.getLinkText());
        cloneTrack.setName(this.getName());
        cloneTrack.setTime(this.getTime());
        cloneTrack.setTrackFileType(this.getTrackFileType());
        return cloneTrack;
    }

    public void compress(double interdistance, int dummy) {
        int i = 0;
        while (i + 2 < this.points.size() - 1) {
            if (this.points.get(i).distance(this.points.get(i + 1)) <= interdistance / 1000.0) {
                this.points.remove(i + 1);
                --i;
            }
            ++i;
        }
        this.notifyTrackObservers();
    }

    public Point previousPoint(Point point) {
        int pointIndex = this.points.indexOf(point);
        if (pointIndex > 0) {
            return this.points.get(pointIndex - 1);
        }
        return point;
    }

    public Point nextPoint(Point point) {
        int pointIndex = this.points.indexOf(point);
        if (pointIndex < this.points.size() - 1) {
            return this.points.get(pointIndex + 1);
        }
        return point;
    }
}

