/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.map.tiledownload;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import jgpstrackedit.config.SystemConfig;

public class DlgStopTiledownloadMode
extends JDialog {
    private final JPanel contentPanel = new JPanel();
    private JLabel lblDirectoryToStore;
    private JTextField textField;
    private JButton btnChooseDirectory;
    private JCheckBox chckbxAddExtensiontile;
    private JLabel lblPressOkButton;
    private boolean result = false;
    private JCheckBox chckbxDownloadTilesOf;
    private JList list;
    private JCheckBox chckbxAppendMapName;
    private JTextField textFieldMapName;

    public boolean isResult() {
        return this.result;
    }

    public String getExtension() {
        if (this.chckbxAddExtensiontile.isSelected()) {
            return ".tile";
        }
        return "";
    }

    public String getTargetDir() {
        return String.valueOf(this.textField.getText()) + (this.chckbxAppendMapName.isSelected() ? String.valueOf(SystemConfig.dirSeparator()) + this.textFieldMapName.getText() : "");
    }

    public List getAdditionalZoomLevels() {
        if (this.chckbxDownloadTilesOf.isSelected()) {
            return this.list.getSelectedValuesList();
        }
        return new ArrayList();
    }

    public DlgStopTiledownloadMode(JFrame frame, int zoomLevel, String mapName) {
        super((Frame)frame, true);
        this.initComponents(zoomLevel);
        this.textFieldMapName.setText(mapName);
    }

    private void initComponents(int zoomLevel) {
        this.setTitle("Stop Tile Download Mode");
        this.setBounds(100, 100, 659, 364);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(null);
        this.lblDirectoryToStore = new JLabel("Directory to store download tiles");
        this.lblDirectoryToStore.setBounds(10, 11, 188, 14);
        this.contentPanel.add(this.lblDirectoryToStore);
        this.textField = new JTextField();
        this.textField.setBounds(20, 36, 465, 20);
        this.contentPanel.add(this.textField);
        this.textField.setColumns(10);
        this.btnChooseDirectory = new JButton("Choose Directory");
        this.btnChooseDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgStopTiledownloadMode.this.btnChooseDirectoryActionPerformed(e);
            }
        });
        this.btnChooseDirectory.setBounds(495, 35, 146, 23);
        this.contentPanel.add(this.btnChooseDirectory);
        this.chckbxAddExtensiontile = new JCheckBox("Add extension .tile to image files");
        this.chckbxAddExtensiontile.setBounds(6, 88, 416, 23);
        this.contentPanel.add(this.chckbxAddExtensiontile);
        this.lblPressOkButton = new JLabel("Press OK button to save all download tiles to the given directory. This action may take some time!");
        this.lblPressOkButton.setBounds(10, 272, 631, 14);
        this.contentPanel.add(this.lblPressOkButton);
        this.chckbxDownloadTilesOf = new JCheckBox("Additionally download tiles of lower zoom levels");
        this.chckbxDownloadTilesOf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DlgStopTiledownloadMode.this.chckbxDownloadTilesOfActionPerformed(arg0);
            }
        });
        this.chckbxDownloadTilesOf.setBounds(6, 114, 595, 23);
        this.contentPanel.add(this.chckbxDownloadTilesOf);
        this.list = new JList();
        this.list.setBorder(new EtchedBorder(1, null, null));
        this.list.setBounds(20, 119, 51, 110);
        DefaultListModel<Integer> listModel = new DefaultListModel<Integer>();
        int i = zoomLevel - 1;
        while (i > 1) {
            listModel.addElement(i);
            --i;
        }
        this.list.setModel(listModel);
        JScrollPane scrollPane = new JScrollPane(this.list);
        scrollPane.setBounds(20, 144, 51, 117);
        this.list.setEnabled(false);
        this.contentPanel.add(scrollPane);
        this.chckbxAppendMapName = new JCheckBox("Append map name to target directory");
        this.chckbxAppendMapName.setBounds(6, 63, 288, 23);
        this.contentPanel.add(this.chckbxAppendMapName);
        this.textFieldMapName = new JTextField();
        this.textFieldMapName.setBounds(310, 67, 175, 20);
        this.contentPanel.add(this.textFieldMapName);
        this.textFieldMapName.setColumns(10);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgStopTiledownloadMode.this.okButtonActionPerformed(e);
            }
        });
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgStopTiledownloadMode.this.cancelButtonActionPerformed(e);
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
    }

    protected void btnChooseDirectoryActionPerformed(ActionEvent e) {
        JFileChooser fileOpenChooser = new JFileChooser();
        fileOpenChooser.setFileSelectionMode(1);
        int returnVal = fileOpenChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fileOpenChooser.getSelectedFile();
            this.textField.setText(file.getPath());
        }
    }

    protected void okButtonActionPerformed(ActionEvent e) {
        if (this.textField.getText().length() > 0) {
            this.result = true;
            this.setVisible(false);
        } else {
            JOptionPane.showMessageDialog(this, "No target directory given!", "Missing values", 0);
        }
    }

    protected void cancelButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    protected void chckbxDownloadTilesOfActionPerformed(ActionEvent arg0) {
        if (this.chckbxDownloadTilesOf.isSelected()) {
            this.list.setEnabled(true);
        } else {
            this.list.setEnabled(false);
        }
    }
}

