/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.map.tilehandler;

import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import jgpstrackedit.map.tilehandler.AbstractTileCommand;
import jgpstrackedit.map.tilehandler.QueueObserver;
import jgpstrackedit.map.tilehandler.StopCommand;

public abstract class AbstractTileHandler
implements Runnable {
    private ArrayList<QueueObserver> queueObservers = new ArrayList();
    private BlockingQueue<AbstractTileCommand> commandQueue;
    private boolean stopped = false;

    public synchronized void addQueueObserver(QueueObserver queueObserver) {
        this.queueObservers.add(queueObserver);
    }

    public synchronized void removeQueueObserver(QueueObserver queueObserver) {
        this.queueObservers.remove(queueObserver);
    }

    protected synchronized void notifyQueueObservers() {
        for (QueueObserver observer : this.queueObservers) {
            observer.lengthChanged(this.commandQueue.size());
        }
    }

    protected BlockingQueue<AbstractTileCommand> getCommandQueue() {
        return this.commandQueue;
    }

    protected void setCommandQueue(BlockingQueue<AbstractTileCommand> commandQueue) {
        this.commandQueue = commandQueue;
    }

    public void start() {
        new Thread(this).start();
    }

    public void stop() {
        this.stopped = true;
        try {
            this.commandQueue.put(new StopCommand());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void addCommand(AbstractTileCommand command) {
        try {
            this.commandQueue.put(command);
            this.notifyQueueObservers();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (!this.stopped) {
            try {
                AbstractTileCommand command = this.commandQueue.take();
                this.notifyQueueObservers();
                command.doAction();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

