/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.map.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import jgpstrackedit.map.util.TileLRUObserver;
import jgpstrackedit.map.util.TileNumber;

public class TileLRUList
extends LinkedHashMap<TileNumber, Object> {
    private int numberElements;
    private ArrayList<TileLRUObserver> observers = new ArrayList();

    public void addTileLRUObserver(TileLRUObserver observer) {
        this.observers.add(observer);
    }

    public void removeTileLRUObserver(TileLRUObserver observer) {
        this.observers.remove(observer);
    }

    protected void notifyTileLRUObservers(TileNumber tileNumber) {
        for (TileLRUObserver observer : this.observers) {
            observer.freeTile(tileNumber);
        }
    }

    public int getNumberElements() {
        return this.numberElements;
    }

    public void setNumberElements(int numberElements) {
        this.numberElements = numberElements;
    }

    public TileLRUList(int numberElements) {
        super(numberElements * 2, 0.75f, true);
        this.setNumberElements(numberElements);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<TileNumber, Object> eldest) {
        if (this.size() > this.getNumberElements()) {
            this.notifyTileLRUObservers(eldest.getKey());
            return true;
        }
        return false;
    }

    public void touch(TileNumber tileNumber) {
        this.put(tileNumber, null);
    }
}

