/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.trackfile.kml;

import java.io.IOException;
import java.net.URL;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import jgpstrackedit.trackfile.kml.KmlHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class KmlParser
implements ContentHandler {
    private KmlHandler handler;
    private Stack context;
    private StringBuffer buffer;
    private EntityResolver resolver;

    public KmlParser(KmlHandler handler, EntityResolver resolver) {
        this.handler = handler;
        this.resolver = resolver;
        this.buffer = new StringBuffer(111);
        this.context = new Stack();
    }

    @Override
    public final void setDocumentLocator(Locator locator) {
    }

    @Override
    public final void startDocument() throws SAXException {
    }

    @Override
    public final void endDocument() throws SAXException {
    }

    @Override
    public final void startElement(String ns, String name, String qname, Attributes attrs) throws SAXException {
        this.dispatch(true);
        this.context.push(new Object[]{qname, new AttributesImpl(attrs)});
        if ("LineStyle".equals(qname)) {
            this.handler.start_LineStyle(attrs);
        } else if ("Pair".equals(qname)) {
            this.handler.start_Pair(attrs);
        } else if ("Style".equals(qname)) {
            this.handler.start_Style(attrs);
        } else if ("MultiGeometry".equals(qname)) {
            this.handler.start_MultiGeometry(attrs);
        } else if ("kml".equals(qname)) {
            this.handler.start_kml(attrs);
        } else if ("BalloonStyle".equals(qname)) {
            this.handler.start_BalloonStyle(attrs);
        } else if ("Point".equals(qname)) {
            this.handler.start_Point(attrs);
        } else if ("Document".equals(qname)) {
            this.handler.start_Document(attrs);
        } else if ("Snippet".equals(qname)) {
            this.handler.handle_Snippet(attrs);
        } else if ("LineString".equals(qname)) {
            this.handler.start_LineString(attrs);
        } else if ("StyleMap".equals(qname)) {
            this.handler.start_StyleMap(attrs);
        } else if ("LabelStyle".equals(qname)) {
            this.handler.start_LabelStyle(attrs);
        } else if ("IconStyle".equals(qname)) {
            this.handler.start_IconStyle(attrs);
        } else if ("Placemark".equals(qname)) {
            this.handler.start_Placemark(attrs);
        } else if ("Icon".equals(qname)) {
            this.handler.start_Icon(attrs);
        }
    }

    @Override
    public final void endElement(String ns, String name, String qname) throws SAXException {
        this.dispatch(false);
        this.context.pop();
        if ("LineStyle".equals(qname)) {
            this.handler.end_LineStyle();
        } else if ("Pair".equals(qname)) {
            this.handler.end_Pair();
        } else if ("Style".equals(qname)) {
            this.handler.end_Style();
        } else if ("MultiGeometry".equals(qname)) {
            this.handler.end_MultiGeometry();
        } else if ("kml".equals(qname)) {
            this.handler.end_kml();
        } else if ("BalloonStyle".equals(qname)) {
            this.handler.end_BalloonStyle();
        } else if ("Point".equals(qname)) {
            this.handler.end_Point();
        } else if ("Document".equals(qname)) {
            this.handler.end_Document();
        } else if ("LineString".equals(qname)) {
            this.handler.end_LineString();
        } else if ("StyleMap".equals(qname)) {
            this.handler.end_StyleMap();
        } else if ("LabelStyle".equals(qname)) {
            this.handler.end_LabelStyle();
        } else if ("IconStyle".equals(qname)) {
            this.handler.end_IconStyle();
        } else if ("Placemark".equals(qname)) {
            this.handler.end_Placemark();
        } else if ("Icon".equals(qname)) {
            this.handler.end_Icon();
        }
    }

    @Override
    public final void characters(char[] chars, int start, int len) throws SAXException {
        this.buffer.append(chars, start, len);
    }

    @Override
    public final void ignorableWhitespace(char[] chars, int start, int len) throws SAXException {
    }

    @Override
    public final void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public final void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public final void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public final void skippedEntity(String name) throws SAXException {
    }

    private void dispatch(boolean fireOnlyIfMixed) throws SAXException {
        if (fireOnlyIfMixed && this.buffer.length() == 0) {
            return;
        }
        Object[] ctx = (Object[])this.context.peek();
        String here = (String)ctx[0];
        Attributes attrs = (Attributes)ctx[1];
        if ("scale".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_scale(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("visibility".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_visibility(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("styleUrl".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_styleUrl(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("extrude".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_extrude(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("open".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_open(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("description".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_description(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("name".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_name(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("colorMode".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_colorMode(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("href".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_href(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("key".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_key(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("coordinates".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_coordinates(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("text".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_text(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("width".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_width(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("tessellate".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_tessellate(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        }
        this.buffer.delete(0, this.buffer.length());
    }

    public void parse(InputSource input) throws SAXException, ParserConfigurationException, IOException {
        KmlParser.parse(input, this);
    }

    public void parse(URL url) throws SAXException, ParserConfigurationException, IOException {
        KmlParser.parse(new InputSource(url.toExternalForm()), this);
    }

    public static void parse(InputSource input, KmlHandler handler) throws SAXException, ParserConfigurationException, IOException {
        KmlParser.parse(input, new KmlParser(handler, null));
    }

    public static void parse(URL url, KmlHandler handler) throws SAXException, ParserConfigurationException, IOException {
        KmlParser.parse(new InputSource(url.toExternalForm()), handler);
    }

    private static void parse(InputSource input, KmlParser recognizer) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        XMLReader parser = factory.newSAXParser().getXMLReader();
        parser.setContentHandler(recognizer);
        parser.setErrorHandler(recognizer.getDefaultErrorHandler());
        if (recognizer.resolver != null) {
            parser.setEntityResolver(recognizer.resolver);
        }
        parser.parse(input);
    }

    protected ErrorHandler getDefaultErrorHandler() {
        return new ErrorHandler(){

            @Override
            public void error(SAXParseException ex) throws SAXException {
                if (KmlParser.this.context.isEmpty()) {
                    System.err.println("Missing DOCTYPE.");
                }
                throw ex;
            }

            @Override
            public void fatalError(SAXParseException ex) throws SAXException {
                throw ex;
            }

            @Override
            public void warning(SAXParseException ex) throws SAXException {
            }
        };
    }
}

