/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import jgpstrackedit.international.International;
import jgpstrackedit.util.Parser;

public class DlgCompressOptions
extends JDialog {
    private CompressionOption option;
    private final JPanel contentPanel = new JPanel();
    private JTextField textFieldRemoveInterval;
    private JTextField textFieldMaxDistance;
    private JTextField textFieldTrackName;
    private ButtonGroup buttonGroup = new ButtonGroup();
    JCheckBox chckbxCopyCompressionResult;
    JRadioButton rdbtnRemoveEvery;
    JRadioButton rdbtnRemovePointsWithin;
    private JRadioButton rdbtnRemovePointsWhich;
    private JTextField textFieldInterdistance;
    private JLabel lblNewLabel;
    private JRadioButton rdbtnDouglasPeucker;
    private JTextField textFieldDPDistance;
    private JLabel label;

    public DlgCompressOptions(String trackName) {
        this.setTitle(String.valueOf(International.getText("dlgCompress.Compress_Options_For_Track")) + " " + trackName);
        this.setBounds(100, 100, 519, 236);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(null);
        this.rdbtnRemoveEvery = new JRadioButton(International.getText("dlgCompress.Remove_every"));
        this.rdbtnRemoveEvery.setSelected(true);
        this.rdbtnRemoveEvery.setBounds(6, 7, 109, 23);
        this.contentPanel.add(this.rdbtnRemoveEvery);
        this.buttonGroup.add(this.rdbtnRemoveEvery);
        this.textFieldRemoveInterval = new JTextField();
        this.textFieldRemoveInterval.setText("2");
        this.textFieldRemoveInterval.setBounds(121, 8, 21, 20);
        this.contentPanel.add(this.textFieldRemoveInterval);
        this.textFieldRemoveInterval.setColumns(10);
        JLabel lblThPoint = new JLabel(International.getText("dlgCompress.th_point"));
        lblThPoint.setBounds(146, 11, 335, 14);
        this.contentPanel.add(lblThPoint);
        this.rdbtnRemovePointsWithin = new JRadioButton(International.getText("dlgCompress.Remove_points_within"));
        this.rdbtnRemovePointsWithin.setBounds(6, 33, 150, 23);
        this.contentPanel.add(this.rdbtnRemovePointsWithin);
        this.buttonGroup.add(this.rdbtnRemovePointsWithin);
        this.textFieldMaxDistance = new JTextField();
        this.textFieldMaxDistance.setText("4.0");
        this.textFieldMaxDistance.setBounds(162, 34, 30, 20);
        this.contentPanel.add(this.textFieldMaxDistance);
        this.textFieldMaxDistance.setColumns(10);
        JLabel lblMetersOffTrack = new JLabel(International.getText("dlgCompress.meters_off_track_line"));
        lblMetersOffTrack.setBounds(202, 36, 279, 14);
        this.contentPanel.add(lblMetersOffTrack);
        this.chckbxCopyCompressionResult = new JCheckBox(International.getText("dlgCompress.Copy_compression_result"));
        this.chckbxCopyCompressionResult.setBounds(6, 117, 237, 23);
        this.contentPanel.add(this.chckbxCopyCompressionResult);
        this.textFieldTrackName = new JTextField();
        this.textFieldTrackName.setBounds(249, 118, 232, 20);
        this.contentPanel.add(this.textFieldTrackName);
        this.textFieldTrackName.setColumns(10);
        this.textFieldTrackName.setText(String.valueOf(International.getText("dlgCompress.Compressed")) + "_" + trackName);
        this.rdbtnRemovePointsWhich = new JRadioButton(International.getText("dlgCompress.Remove_points_which_are_nearer_than"));
        this.rdbtnRemovePointsWhich.setBounds(6, 59, 237, 23);
        this.contentPanel.add(this.rdbtnRemovePointsWhich);
        this.buttonGroup.add(this.rdbtnRemovePointsWhich);
        this.textFieldInterdistance = new JTextField();
        this.textFieldInterdistance.setText("4.0");
        this.textFieldInterdistance.setBounds(249, 60, 38, 20);
        this.contentPanel.add(this.textFieldInterdistance);
        this.textFieldInterdistance.setColumns(10);
        this.lblNewLabel = new JLabel("meters");
        this.lblNewLabel.setBounds(298, 61, 183, 14);
        this.contentPanel.add(this.lblNewLabel);
        this.rdbtnDouglasPeucker = new JRadioButton(International.getText("dlgCompress.douglaspeucker"));
        this.rdbtnDouglasPeucker.setBounds(6, 85, 237, 23);
        this.contentPanel.add(this.rdbtnDouglasPeucker);
        this.buttonGroup.add(this.rdbtnDouglasPeucker);
        this.textFieldDPDistance = new JTextField();
        this.textFieldDPDistance.setText("4.0");
        this.textFieldDPDistance.setColumns(10);
        this.textFieldDPDistance.setBounds(249, 91, 38, 20);
        this.contentPanel.add(this.textFieldDPDistance);
        this.label = new JLabel("meters");
        this.label.setBounds(298, 93, 183, 14);
        this.contentPanel.add(this.label);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton(International.getText("OK"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DlgCompressOptions.this.rdbtnRemoveEvery.isSelected()) {
                    DlgCompressOptions.this.option = CompressionOption.RemoveInterval;
                }
                if (DlgCompressOptions.this.rdbtnRemovePointsWithin.isSelected()) {
                    DlgCompressOptions.this.option = CompressionOption.MaxDistance;
                }
                if (DlgCompressOptions.this.rdbtnRemovePointsWhich.isSelected()) {
                    DlgCompressOptions.this.option = CompressionOption.Interdistance;
                }
                if (DlgCompressOptions.this.rdbtnDouglasPeucker.isSelected()) {
                    DlgCompressOptions.this.option = CompressionOption.DouglasPeucker;
                }
                DlgCompressOptions.this.setVisible(false);
            }
        });
        okButton.setActionCommand(International.getText("OK"));
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton(International.getText("Cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgCompressOptions.this.option = CompressionOption.Cancel;
                DlgCompressOptions.this.setVisible(false);
            }
        });
        cancelButton.setActionCommand(International.getText("Cancel"));
        buttonPane.add(cancelButton);
    }

    public String getTrackName() {
        return this.textFieldTrackName.getText();
    }

    public int getRemoveInterval() {
        return Parser.parseInt(this.textFieldRemoveInterval.getText());
    }

    public double getMaxDistance() {
        return Parser.parseDouble(this.textFieldMaxDistance.getText());
    }

    public double getDouglasPeuckerDistance() {
        return Parser.parseDouble(this.textFieldDPDistance.getText());
    }

    public double getInterdistance() {
        return Parser.parseDouble(this.textFieldInterdistance.getText());
    }

    public boolean copyToNewTrack() {
        return this.chckbxCopyCompressionResult.isSelected();
    }

    public CompressionOption getOption() {
        return this.option;
    }

    public static enum CompressionOption {
        Cancel,
        RemoveInterval,
        MaxDistance,
        Interdistance,
        DouglasPeucker;

    }
}

