/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.GregorianCalendar;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import jgpstrackedit.config.Configuration;
import jgpstrackedit.config.ConfigurationObserver;
import jgpstrackedit.config.view.ConfigurationDialog;
import jgpstrackedit.config.view.ViewingConfiguration;
import jgpstrackedit.control.UIController;
import jgpstrackedit.data.Database;
import jgpstrackedit.data.Point;
import jgpstrackedit.data.Track;
import jgpstrackedit.data.util.TourPlaner;
import jgpstrackedit.data.util.UnDoManager;
import jgpstrackedit.international.International;
import jgpstrackedit.map.TileManager;
import jgpstrackedit.map.tiledownload.DlgProcessingTileDownload;
import jgpstrackedit.map.tiledownload.DlgStartTiledownloadMode;
import jgpstrackedit.map.tiledownload.DlgStopTiledownloadMode;
import jgpstrackedit.map.tiledownload.TileDownload;
import jgpstrackedit.map.util.MapExtract;
import jgpstrackedit.map.util.MapExtractManager;
import jgpstrackedit.map.util.TileNumber;
import jgpstrackedit.util.Parser;
import jgpstrackedit.view.AltitudeProfilePanel;
import jgpstrackedit.view.DlgAbout;
import jgpstrackedit.view.DlgHelp;
import jgpstrackedit.view.DlgMerge;
import jgpstrackedit.view.DlgPointEdit;
import jgpstrackedit.view.DlgSplit;
import jgpstrackedit.view.PointView;
import jgpstrackedit.view.TrackDataPanel;
import jgpstrackedit.view.TrackPanel;
import jgpstrackedit.view.TrackView;
import jgpstrackedit.view.TracksPanel;
import jgpstrackedit.view.TracksView;
import jgpstrackedit.view.Transform;
import jgpstrackedit.view.util.ColorEditor;
import jgpstrackedit.view.util.ColorRenderer;

public class JGPSTrackEdit
extends JFrame
implements ListSelectionListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
ConfigurationObserver,
KeyListener {
    private static final long serialVersionUID = 1L;
    private TracksPanel tracksPanel;
    private TrackPanel trackPanel;
    private TrackDataPanel trackDataPanel;
    private AltitudeProfilePanel altitudeProfilePanel;
    private TracksView tracksView;
    private UIController uiController;
    private Database db;
    private int selectedRowTracksTable = -1;
    private boolean pointDeleteMode = false;
    private boolean moveSelectedPoint = false;
    private boolean moveSelectedPointMode = false;
    private boolean appendMode = false;
    private boolean appendRoutingMode = false;
    private boolean showCoordinatesMode = false;
    private boolean shortCut = false;
    private boolean distanceMeasurement = false;
    private Point distanceMeasurementFirstPoint = null;
    private Point distanceMeasurementSecondPoint = null;
    private Point shortCutStartPoint = null;
    private int currentScreenX = 0;
    private int currentScreenY = 0;
    private int lastScreenX = 0;
    private int lastScreenY = 0;
    private int lastDraggedX = -1;
    private int lastDraggedY = -1;
    private boolean draggingActive = false;
    private TileDownload tileDownload = null;
    public static final int MODE_INACTIVE = 0;
    public static final int MODE_WAIT_FIRST_POINT = 1;
    public static final int MODE_WAIT_SECOND_POINT = 2;
    private int tileSelectionMode = 0;
    private Point tileSelectFirstPoint = null;
    private ButtonGroup mapRadioButtons = new ButtonGroup();
    private JGPSTrackEdit own = this;
    private JPopupMenu popupTracksView;
    private UnDoManager appendUnDo = null;
    private JCheckBoxMenuItem chckbxmntmScale;
    private boolean showScale = true;
    private JMenuItem aboutMenuItem;
    private JMenuItem contentsMenuItem;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JButton jButtonSave;
    private JButton jButtonEast;
    private JButton jButtonNorth;
    private JButton jButtonOpenTrack;
    private JButton jButtonSouth;
    private JButton jButtonWest;
    private JMenuItem jMenuItemReverse;
    private JPanel jPanelstatusBar;
    private JPanel jPanelMap;
    private JScrollPane jScrollPaneTracksTable;
    private JScrollPane jScrollPanePointsTable;
    private JSplitPane jSplitPaneTrack;
    private JSplitPane jSplitPaneTrackDetail;
    private JSplitPane jSplitPaneMap;
    private JTable jTableTracks;
    private JTable jTablePoints;
    private JTextField jTextFieldStateMessage;
    private JMenuBar menuBar;
    private JMenuItem openMenuItem;
    private JMenuItem saveAsMenuItem;
    private JMenuItem saveMenuItem;
    private JMenu trackMenu;
    private JMenuItem mntmConfiguration;
    private JMenu mnPoints;
    private JMenuItem mntmDelete;
    private JMenuItem mntmDeleteP;
    private JCheckBoxMenuItem chckbxmntmDeleteMode;
    private JCheckBoxMenuItem chckbxmntmDeleteModeP;
    private JMenu mnView;
    private JMenuItem mntmZoomIn;
    private JMenuItem mntmZoomOut;
    private JMenuItem mntmSplit;
    private JMenuItem mntmMerge;
    private JMenuItem mntmDelete_1;
    private JMenu mnMaps;
    private JRadioButtonMenuItem rdbtnmntmNone;
    private JRadioButtonMenuItem rdbtnmntmOpenstreetmapmapnik;
    private JMenuItem mntmZoomSelectedTrack;
    private JMenuItem mntmRefreshMap;
    private JCheckBoxMenuItem chckbxmntmShowDayTour;
    private JMenuItem mntmMoveSelectedPoint;
    private JMenuItem mntmMoveSelectedPointP;
    private JCheckBoxMenuItem chckbxmntmAppendMode;
    private JCheckBoxMenuItem chckbxmntmAppendModeP;
    private JRadioButtonMenuItem rdbtnmntmOpencyclemap;
    private JCheckBoxMenuItem chckbxmntmShowCoordinates;
    private JMenuItem mntmInsertAdjacentPoints;
    private JMenuItem mntmInsertAdjacentPointsP;
    private JMenuItem mntmNew;
    private JButton btnConfiguration;
    private JCheckBoxMenuItem chckbxmntmNewCheckItem;
    private JMenuItem mnuItemReloadTile;
    private JMenuItem mntmOpenGpsiescomTrack;
    private JRadioButtonMenuItem rdbtnmntmHikebikemap;
    private JRadioButtonMenuItem rdbtnmntmMapquest;
    private JCheckBoxMenuItem chckbxmntmAppendRoutingMode;
    private JCheckBoxMenuItem chckbxmntmAppendRoutingModeP;
    private JCheckBoxMenuItem chckbxmntmAutoRefresh;
    private JMenuItem mntmUndoAppend;
    private JMenuItem mntmUndoAppendP;
    private JRadioButtonMenuItem rdbtnmntmMapquestsatellite;
    private JRadioButtonMenuItem rdbtnmntmMapquesthybride;
    private JMenuItem mntmShortCut;
    private JMenuItem mntmShortCutP;
    private JMenuItem mntmRemoveInvalidPoints;
    private JMenuItem mntmCompress;
    private JButton btnNewTrack;
    private JButton btnReverseTrack;
    private JButton btnSplitTrack;
    private JButton btnMergeTrack;
    private JButton btnCompressTrack;
    private JButton btnUpdateElevations;
    private JButton btnMoveSelectedPoint;
    private JButton btnAppendMode;
    private JButton btnAppendRoutingMode;
    private JButton btnUndoAppends;
    private JButton btnInsertAdjacentPoints;
    private JButton btnDeletePoint;
    private JButton btnDeleteMode;
    private JButton btnShortCut;
    private JButton btnNewButton_2;
    private JCheckBoxMenuItem chckbxmntmMoveselectedpointmode;
    private JCheckBoxMenuItem chckbxmntmMoveselectedpointmodeP;
    private JCheckBoxMenuItem chckbxmntmDistanceMeasurement;
    private JRadioButtonMenuItem rdbtnmntmumap;
    private JRadioButtonMenuItem rdbtnmntmGooglemapsatellite;
    private JRadioButtonMenuItem rdbtnmntmGooglemaphybrid;
    private JRadioButtonMenuItem rdbtnmntmGooglemapterrain;
    private JRadioButtonMenuItem rdbtnmntmGooglemap;
    private JMenu mnTiledownload;
    private JMenuItem mntmStartTileDownload;
    private JMenuItem mntmAddBorderTiles;
    private JMenuItem mntmStopAndSave;
    private JMenuItem mntmSaveCurrentWork;
    private JMenuItem mntmAddCurentMap;
    private JMenuItem mntmAddArea;
    private JCheckBoxMenuItem chckbxmntmShowTrackLength;
    private JCheckBoxMenuItem chckbxmntmPointInformation;
    private JMenuItem mntmEditPoint;
    private JMenuItem mntmEditPointP;
    private JMenuItem mntmSaveToGpsiescom;
    private JMenuItem mntmSaveMapView;
    private JMenuItem mntmSaveAltitudeProfile;

    private void setJGPSTrackEditVariant() {
        String mapType = Configuration.getProperty("MAPTYPE");
        if (mapType.equals("OpenStreetMap")) {
            this.uiController.tileManagerOSM_Mapnik();
            this.rdbtnmntmOpenstreetmapmapnik.setSelected(true);
        } else if (mapType.equals("OpenCycleMap")) {
            this.uiController.tileManagerOCM();
            this.rdbtnmntmOpencyclemap.setSelected(true);
        } else if (mapType.equals("MapQuest")) {
            this.uiController.tileManagerMapQuest();
            this.rdbtnmntmMapquest.setSelected(true);
        } else if (mapType.equals("MapQuestSat")) {
            this.uiController.tileManagerMapQuestSat();
            this.rdbtnmntmMapquestsatellite.setSelected(true);
        } else if (mapType.equals("MapQuestHybride")) {
            this.uiController.tileManagerMapQuestHybride();
            this.rdbtnmntmMapquesthybride.setSelected(true);
        } else if (mapType.equals("HikeBikeMap")) {
            this.uiController.tileManagerHikeBikeMap();
            this.rdbtnmntmHikebikemap.setSelected(true);
        } else if (mapType.equals("GoogleMap")) {
            this.uiController.tileManagerGoogleMap();
            this.rdbtnmntmGooglemap.setSelected(true);
        } else if (mapType.equals("GoogleMapTerrain")) {
            this.uiController.tileManagerGoogleMapTerrain();
            this.rdbtnmntmGooglemapterrain.setSelected(true);
        } else if (mapType.equals("GoogleMapSatellite")) {
            this.uiController.tileManagerGoogleMapSatellite();
            this.rdbtnmntmGooglemapsatellite.setSelected(true);
        } else if (mapType.equals("GoogleMapHybrid")) {
            this.uiController.tileManagerGoogleMapHybrid();
            this.rdbtnmntmGooglemaphybrid.setSelected(true);
        } else if (mapType.equals("4UMap")) {
            this.uiController.tileManager4UMap();
            this.rdbtnmntmumap.setSelected(true);
        } else {
            this.rdbtnmntmOpenstreetmapmapnik.setSelected(true);
            this.uiController.tileManagerOSM_Mapnik();
        }
    }

    public JGPSTrackEdit() {
        Configuration.addConfigurationObserver(this);
        MapExtractManager.load();
        International.initialize(Configuration.getProperty("LOCALE"));
        try {
            if (Configuration.getProperty("GUILOOKFEEL").equals("System")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        TourPlaner.initConfig();
        this.initComponents();
        this.initGPSViews();
        this.configurationChanged();
        this.tracksPanel.setFocusable(true);
        this.tracksPanel.addKeyListener(this);
    }

    public UnDoManager getAppendUnDo() {
        return this.appendUnDo;
    }

    public void initGPSViews() {
        this.db = new Database();
        this.tracksView = new TracksView(this.db);
        this.jTableTracks.setModel(this.db);
        this.jTableTracks.setDefaultRenderer(Color.class, new ColorRenderer(true));
        this.jTableTracks.setDefaultEditor(Color.class, new ColorEditor());
        this.jTableTracks.setDefaultEditor(String.class, new DefaultCellEditor(new JTextField()));
        this.jTableTracks.setSelectionMode(0);
        this.jTableTracks.getSelectionModel().addListSelectionListener(this);
        this.jTablePoints.setModel(this.db.getTrackTableModel());
        this.jTablePoints.setDefaultEditor(String.class, new DefaultCellEditor(new JTextField()));
        this.jTablePoints.getSelectionModel().addListSelectionListener(this);
        this.uiController = UIController.newUIController(this.db, this);
        this.tracksPanel = new TracksPanel(this.tracksView);
        this.tracksPanel.setPreferredSize(new Dimension(600, 450));
        this.tracksPanel.addMouseListener(this);
        this.tracksPanel.addMouseMotionListener(this);
        this.tracksPanel.addMouseWheelListener(this);
        this.jPanelMap.add((Component)this.tracksPanel, "Center");
        this.trackPanel = new TrackPanel();
        this.trackDataPanel = new TrackDataPanel();
        this.altitudeProfilePanel = new AltitudeProfilePanel();
        this.trackPanel.add((Component)this.trackDataPanel, "North");
        this.trackPanel.add((Component)this.altitudeProfilePanel, "Center");
        this.jSplitPaneTrackDetail.setLeftComponent(this.trackPanel);
        this.pack();
        Transform.setScreenDimension(this.getTracksPanel().getWidth(), this.getTracksPanel().getHeight());
        this.getTracksPanel().zoom(new MapExtract("XY", 9, "13.336978", "47.038977"));
        if (Configuration.getBooleanProperty("SHOW_MAP_ON_STARTUP")) {
            Transform.setScreenDimension(this.getTracksPanel().getWidth(), this.getTracksPanel().getHeight());
            if (Configuration.getBooleanProperty("COUNTRY_SPECIFIC_MAP")) {
                if (MapExtractManager.contains(Configuration.getProperty("LOCALE").substring(3))) {
                    this.getTracksPanel().zoom(MapExtractManager.get(Configuration.getProperty("LOCALE").substring(3)));
                }
            } else if (Configuration.getBooleanProperty("LAST_MAP_EXTRACT")) {
                this.getTracksPanel().zoom(MapExtractManager.get("LAST_MAP_EXTRACT"));
            } else if (MapExtractManager.contains(Configuration.getProperty("MAPEXTRACT"))) {
                this.getTracksPanel().zoom(MapExtractManager.get(Configuration.getProperty("MAPEXTRACT")));
            }
            this.setJGPSTrackEditVariant();
        }
        this.popupTracksView.add(this.mntmDeleteP);
        this.popupTracksView.add(this.chckbxmntmDeleteModeP);
        this.popupTracksView.add(this.mntmShortCutP);
        this.popupTracksView.addSeparator();
        this.popupTracksView.add(this.mntmMoveSelectedPointP);
        this.popupTracksView.add(this.chckbxmntmMoveselectedpointmodeP);
        this.popupTracksView.add(this.mntmEditPointP);
        this.popupTracksView.addSeparator();
        this.popupTracksView.add(this.chckbxmntmAppendModeP);
        this.popupTracksView.add(this.chckbxmntmAppendRoutingModeP);
        this.popupTracksView.add(this.mntmUndoAppendP);
        this.popupTracksView.addSeparator();
        this.popupTracksView.add(this.mntmInsertAdjacentPointsP);
        this.popupTracksView.addSeparator();
        this.mnuItemReloadTile = new JMenuItem(International.getText("menu.kontext.Reload_tile"));
        this.mnuItemReloadTile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TileManager.getCurrentTileManager().reloadTile(Transform.mapLongitude(JGPSTrackEdit.this.currentScreenX), Transform.mapLatitude(JGPSTrackEdit.this.currentScreenY));
                JGPSTrackEdit.this.repaint();
            }
        });
        this.popupTracksView.add(this.mnuItemReloadTile);
    }

    protected void handleAppendModeChange() {
        if (!this.appendMode && this.chckbxmntmAppendMode.isSelected()) {
            if (this.appendUnDo == null) {
                this.appendUnDo = new UnDoManager(this.db.getTrackTableModel().getSelectedTrack());
            }
            this.chckbxmntmAppendRoutingMode.setSelected(false);
            this.chckbxmntmAppendRoutingModeP.setSelected(false);
            this.handleAppendRoutingModeChange();
            this.tracksPanel.addBondPoint(this.getTracksView().getSelectedTrackView().getTrack().getLastPoint());
            this.tracksPanel.setShowBonds(true);
            this.tracksPanel.setCursorText(International.getText("append_point"), Color.BLUE);
        }
        if (this.appendMode && !this.chckbxmntmAppendMode.isSelected()) {
            this.tracksPanel.clearBondPoints();
            this.tracksPanel.setShowBonds(false);
            this.tracksPanel.setCursorText("", Color.BLUE);
            this.repaint();
        }
        this.appendMode = this.chckbxmntmAppendMode.isSelected();
        if (!this.appendMode && !this.appendRoutingMode && this.appendUnDo != null) {
            this.appendUnDo = null;
        }
    }

    protected void handleAppendRoutingModeChange() {
        if (!this.appendRoutingMode && this.chckbxmntmAppendRoutingMode.isSelected()) {
            this.chckbxmntmAppendMode.setSelected(false);
            this.chckbxmntmAppendModeP.setSelected(false);
            this.handleAppendModeChange();
            this.tracksPanel.setCursorText(International.getText("append_route"), Color.BLUE);
            this.tracksPanel.setCursor(Cursor.getPredefinedCursor(1));
            if (this.appendUnDo == null) {
                this.appendUnDo = new UnDoManager(this.db.getTrackTableModel().getSelectedTrack());
            }
        }
        if (this.appendRoutingMode && !this.chckbxmntmAppendRoutingMode.isSelected()) {
            this.tracksPanel.setCursorText("", Color.BLUE);
        }
        this.appendRoutingMode = this.chckbxmntmAppendRoutingMode.isSelected();
        if (!this.appendMode && !this.appendRoutingMode && this.appendUnDo != null) {
            this.appendUnDo = null;
        }
    }

    protected void handleNewTrack() {
        Track track = this.uiController.newTrack();
        if (track != null) {
            track.setLeftUpperBoundary(Transform.getUpperLeftBoundary());
            track.setRightLowerBoundary(Transform.getLowerRightBoundary());
            track.add(Transform.mapLongitude(this.lastScreenX), Transform.mapLatitude(this.lastScreenY));
            this.db.addTrack(track);
            this.db.getTrackTableModel().setSelectedTrack(track);
            this.getTracksTable().addRowSelectionInterval(this.db.getTrackNumber() - 1, this.db.getTrackNumber() - 1);
            this.setSelectedTrack(track);
            this.setStateMessage("New track " + track.getName() + " created.");
            this.chckbxmntmAppendMode.setSelected(true);
            this.handleAppendModeChange();
            this.repaint();
        }
    }

    protected void handleConfiguration() {
        ConfigurationDialog conf = new ConfigurationDialog(this.own);
        conf.initialize();
        conf.setVisible(true);
    }

    public void handleHelp() {
        DlgHelp dialog = new DlgHelp();
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
    }

    public void handleDistanceMeasurementChange() {
        this.distanceMeasurement = this.chckbxmntmDistanceMeasurement.isSelected();
        if (this.distanceMeasurement) {
            this.distanceMeasurementFirstPoint = new Point(Transform.mapLongitude(this.lastScreenX), Transform.mapLatitude(this.lastScreenY), 0.0);
            this.tracksPanel.addBondPoint(this.distanceMeasurementFirstPoint);
            this.tracksPanel.setShowBonds(true);
            this.tracksPanel.setCursorText("0.000km", Color.BLUE);
        } else {
            this.tracksPanel.clearBondPoints();
            this.tracksPanel.setShowBonds(false);
            this.tracksPanel.setCursorText("", Color.BLACK);
        }
    }

    private void initComponents() {
        this.jPanelstatusBar = new JPanel();
        this.jTextFieldStateMessage = new JTextField();
        this.jSplitPaneTrack = new JSplitPane();
        this.jSplitPaneTrackDetail = new JSplitPane();
        this.jSplitPaneMap = new JSplitPane(0);
        this.jScrollPaneTracksTable = new JScrollPane();
        this.jScrollPaneTracksTable.setPreferredSize(new Dimension(200, 140));
        this.jScrollPanePointsTable = new JScrollPane();
        this.jScrollPanePointsTable.setPreferredSize(new Dimension(150, 140));
        this.jTableTracks = new JTable();
        this.jTablePoints = new JTable();
        this.jPanelMap = new JPanel();
        this.jButtonNorth = new JButton();
        this.jButtonSouth = new JButton();
        this.jButtonWest = new JButton();
        this.jButtonEast = new JButton();
        this.popupTracksView = new JPopupMenu();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.uiController.save();
            }
        });
        this.saveAsMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.trackMenu = new JMenu();
        this.jMenuItemReverse = new JMenuItem();
        this.helpMenu = new JMenu();
        this.contentsMenuItem = new JMenuItem();
        this.contentsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.handleHelp();
            }
        });
        this.aboutMenuItem = new JMenuItem();
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.handleAbout();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent winEvt) {
                JGPSTrackEdit.this.exitMenuItemActionPerformed(null);
            }
        });
        this.setTitle("JGPSTrackEdit");
        JToolBar toolBar = new JToolBar();
        toolBar.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.getContentPane().add((Component)toolBar, "North");
        toolBar.setFloatable(false);
        this.jButtonOpenTrack = new JButton();
        this.jButtonOpenTrack.setBorder(null);
        toolBar.add(this.jButtonOpenTrack);
        this.jButtonOpenTrack.setPreferredSize(new Dimension(20, 20));
        this.jButtonOpenTrack.setMaximumSize(new Dimension(20, 20));
        this.jButtonOpenTrack.setMinimumSize(new Dimension(20, 20));
        this.jButtonOpenTrack.setContentAreaFilled(false);
        this.jButtonOpenTrack.setToolTipText(International.getText("Open_Track"));
        this.jButtonOpenTrack.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/folder.png")));
        JButton btnOpenGpsiesTrack = new JButton("");
        btnOpenGpsiesTrack.setBorder(null);
        btnOpenGpsiesTrack.setMaximumSize(new Dimension(20, 20));
        btnOpenGpsiesTrack.setMinimumSize(new Dimension(20, 20));
        btnOpenGpsiesTrack.setContentAreaFilled(false);
        btnOpenGpsiesTrack.setPreferredSize(new Dimension(20, 20));
        btnOpenGpsiesTrack.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/folder_find.png")));
        btnOpenGpsiesTrack.setToolTipText(International.getText("Open_GPSies_Track"));
        btnOpenGpsiesTrack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.uiController.openGPSies();
            }
        });
        toolBar.add(btnOpenGpsiesTrack);
        JButton btnNewButton = new JButton("");
        btnNewButton.setBorder(null);
        btnNewButton.setMinimumSize(new Dimension(20, 20));
        btnNewButton.setMaximumSize(new Dimension(20, 20));
        btnNewButton.setPreferredSize(new Dimension(20, 20));
        btnNewButton.setToolTipText(International.getText("Save_As"));
        btnNewButton.setContentAreaFilled(false);
        btnNewButton.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/page_save.png")));
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.saveAsMenuItemActionPerformed(e);
            }
        });
        JButton btnNewButton_1 = new JButton("");
        btnNewButton_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.uiController.openDirectory();
            }
        });
        btnNewButton_1.setBorder(null);
        btnNewButton_1.setContentAreaFilled(false);
        btnNewButton_1.setMaximumSize(new Dimension(20, 20));
        btnNewButton_1.setMinimumSize(new Dimension(20, 20));
        btnNewButton_1.setPreferredSize(new Dimension(20, 20));
        btnNewButton_1.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/folder_table.png")));
        btnNewButton_1.setToolTipText(International.getText("sel_dir"));
        toolBar.add(btnNewButton_1);
        toolBar.addSeparator();
        this.jButtonSave = new JButton();
        this.jButtonSave.setBorder(null);
        this.jButtonSave.setMaximumSize(new Dimension(20, 20));
        this.jButtonSave.setMinimumSize(new Dimension(20, 20));
        this.jButtonSave.setToolTipText(International.getText("Save_Track"));
        this.jButtonSave.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/disk.png")));
        this.jButtonSave.setPreferredSize(new Dimension(20, 20));
        this.jButtonSave.setContentAreaFilled(false);
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.uiController.save();
            }
        });
        toolBar.add(this.jButtonSave);
        toolBar.add(btnNewButton);
        this.btnConfiguration = new JButton("");
        this.btnConfiguration.setBorder(null);
        this.btnConfiguration.setMinimumSize(new Dimension(20, 20));
        this.btnConfiguration.setMaximumSize(new Dimension(20, 20));
        this.btnConfiguration.setContentAreaFilled(false);
        this.btnConfiguration.setPreferredSize(new Dimension(20, 20));
        this.btnConfiguration.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/wrench.png")));
        this.btnConfiguration.setToolTipText("Configuration");
        this.btnConfiguration.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.handleConfiguration();
            }
        });
        toolBar.addSeparator();
        JButton btnZoomIn = new JButton("");
        btnZoomIn.setBorder(null);
        btnZoomIn.setContentAreaFilled(false);
        btnZoomIn.setMaximumSize(new Dimension(20, 20));
        btnZoomIn.setMinimumSize(new Dimension(20, 20));
        btnZoomIn.setPreferredSize(new Dimension(20, 20));
        btnZoomIn.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/zoom_in.png")));
        btnZoomIn.setToolTipText(International.getText("Zoom_In"));
        btnZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JGPSTrackEdit.this.uiController.zoomIn();
            }
        });
        this.btnNewTrack = new JButton("");
        this.btnNewTrack.setBorder(null);
        this.btnNewTrack.setContentAreaFilled(false);
        this.btnNewTrack.setMaximumSize(new Dimension(20, 20));
        this.btnNewTrack.setMinimumSize(new Dimension(20, 20));
        this.btnNewTrack.setPreferredSize(new Dimension(20, 20));
        this.btnNewTrack.setToolTipText(International.getText("New_Track"));
        this.btnNewTrack.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/map_add.png")));
        this.btnNewTrack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.handleNewTrack();
            }
        });
        toolBar.add(this.btnNewTrack);
        this.btnReverseTrack = new JButton("");
        this.btnReverseTrack.setBorder(null);
        this.btnReverseTrack.setContentAreaFilled(false);
        this.btnReverseTrack.setMaximumSize(new Dimension(20, 20));
        this.btnReverseTrack.setMinimumSize(new Dimension(20, 20));
        this.btnReverseTrack.setPreferredSize(new Dimension(20, 20));
        this.btnReverseTrack.setToolTipText(International.getText("Reverse_Track"));
        this.btnReverseTrack.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/arrow_refresh.png")));
        this.btnReverseTrack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.uiController.reverseTrack();
            }
        });
        toolBar.add(this.btnReverseTrack);
        this.btnSplitTrack = new JButton("");
        this.btnSplitTrack.setMaximumSize(new Dimension(20, 20));
        this.btnSplitTrack.setMinimumSize(new Dimension(20, 20));
        this.btnSplitTrack.setPreferredSize(new Dimension(20, 20));
        this.btnSplitTrack.setToolTipText(International.getText("Split_Track"));
        this.btnSplitTrack.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/arrow_divide.png")));
        this.btnSplitTrack.setContentAreaFilled(false);
        this.btnSplitTrack.setBorder(null);
        this.btnSplitTrack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.handleSplit();
            }
        });
        toolBar.add(this.btnSplitTrack);
        this.btnMergeTrack = new JButton("");
        this.btnMergeTrack.setBorder(null);
        this.btnMergeTrack.setContentAreaFilled(false);
        this.btnMergeTrack.setMaximumSize(new Dimension(20, 20));
        this.btnMergeTrack.setMinimumSize(new Dimension(20, 20));
        this.btnMergeTrack.setPreferredSize(new Dimension(20, 20));
        this.btnMergeTrack.setToolTipText(International.getText("Merge_Track"));
        this.btnMergeTrack.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/arrow_join.png")));
        this.btnMergeTrack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.handleMerge();
            }
        });
        toolBar.add(this.btnMergeTrack);
        this.btnCompressTrack = new JButton("");
        this.btnCompressTrack.setMaximumSize(new Dimension(20, 20));
        this.btnCompressTrack.setMinimumSize(new Dimension(20, 20));
        this.btnCompressTrack.setPreferredSize(new Dimension(20, 20));
        this.btnCompressTrack.setToolTipText(International.getText("Compress_Track"));
        this.btnCompressTrack.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/arrow_in.png")));
        this.btnCompressTrack.setContentAreaFilled(false);
        this.btnCompressTrack.setBorder(null);
        this.btnCompressTrack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.uiController.compress();
            }
        });
        toolBar.add(this.btnCompressTrack);
        this.btnUpdateElevations = new JButton("");
        this.btnUpdateElevations.setMaximumSize(new Dimension(20, 20));
        this.btnUpdateElevations.setMinimumSize(new Dimension(20, 20));
        this.btnUpdateElevations.setPreferredSize(new Dimension(20, 20));
        this.btnUpdateElevations.setToolTipText(International.getText("Update_Elevations"));
        this.btnUpdateElevations.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/transmit_edit.png")));
        this.btnUpdateElevations.setContentAreaFilled(false);
        this.btnUpdateElevations.setBorder(null);
        this.btnUpdateElevations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.uiController.updateElevation();
            }
        });
        toolBar.add(this.btnUpdateElevations);
        toolBar.addSeparator();
        this.btnMoveSelectedPoint = new JButton("");
        this.btnMoveSelectedPoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.handleMoveSelectedPoint();
            }
        });
        this.btnMoveSelectedPoint.setBorder(null);
        this.btnMoveSelectedPoint.setContentAreaFilled(false);
        this.btnMoveSelectedPoint.setMaximumSize(new Dimension(20, 20));
        this.btnMoveSelectedPoint.setMinimumSize(new Dimension(20, 20));
        this.btnMoveSelectedPoint.setPreferredSize(new Dimension(20, 20));
        this.btnMoveSelectedPoint.setToolTipText(International.getText("Move_selected_point"));
        this.btnMoveSelectedPoint.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/anchor.png")));
        toolBar.add(this.btnMoveSelectedPoint);
        this.btnAppendMode = new JButton("");
        this.btnAppendMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.chckbxmntmAppendMode.setSelected(!JGPSTrackEdit.this.chckbxmntmAppendMode.isSelected());
                JGPSTrackEdit.this.chckbxmntmAppendModeP.setSelected(JGPSTrackEdit.this.chckbxmntmAppendMode.isSelected());
                JGPSTrackEdit.this.handleAppendModeChange();
            }
        });
        this.btnAppendMode.setBorder(null);
        this.btnAppendMode.setContentAreaFilled(false);
        this.btnAppendMode.setMaximumSize(new Dimension(20, 20));
        this.btnAppendMode.setMinimumSize(new Dimension(20, 20));
        this.btnAppendMode.setPreferredSize(new Dimension(20, 20));
        this.btnAppendMode.setToolTipText(International.getText("Append_mode"));
        this.btnAppendMode.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/map_edit.png")));
        toolBar.add(this.btnAppendMode);
        this.btnAppendRoutingMode = new JButton("");
        this.btnAppendRoutingMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.chckbxmntmAppendRoutingMode.setSelected(!JGPSTrackEdit.this.chckbxmntmAppendRoutingMode.isSelected());
                JGPSTrackEdit.this.chckbxmntmAppendRoutingModeP.setSelected(JGPSTrackEdit.this.chckbxmntmAppendRoutingMode.isSelected());
                JGPSTrackEdit.this.handleAppendRoutingModeChange();
            }
        });
        this.btnAppendRoutingMode.setBorder(null);
        this.btnAppendRoutingMode.setContentAreaFilled(false);
        this.btnAppendRoutingMode.setMaximumSize(new Dimension(20, 20));
        this.btnAppendRoutingMode.setMinimumSize(new Dimension(20, 20));
        this.btnAppendRoutingMode.setPreferredSize(new Dimension(20, 20));
        this.btnAppendRoutingMode.setToolTipText(International.getText("Append_routing_mode"));
        this.btnAppendRoutingMode.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/map_go.png")));
        toolBar.add(this.btnAppendRoutingMode);
        this.btnUndoAppends = new JButton("");
        this.btnUndoAppends.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.uiController.undoAppend();
            }
        });
        this.btnUndoAppends.setBorder(null);
        this.btnUndoAppends.setContentAreaFilled(false);
        this.btnUndoAppends.setMaximumSize(new Dimension(20, 20));
        this.btnUndoAppends.setMinimumSize(new Dimension(20, 20));
        this.btnUndoAppends.setPreferredSize(new Dimension(20, 20));
        this.btnUndoAppends.setToolTipText(International.getText("Undo_appends"));
        this.btnUndoAppends.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/arrow_undo.png")));
        toolBar.add(this.btnUndoAppends);
        this.btnInsertAdjacentPoints = new JButton("");
        this.btnInsertAdjacentPoints.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.uiController.insertAdjacentPoints();
            }
        });
        this.btnInsertAdjacentPoints.setMaximumSize(new Dimension(20, 20));
        this.btnInsertAdjacentPoints.setMinimumSize(new Dimension(20, 20));
        this.btnInsertAdjacentPoints.setPreferredSize(new Dimension(20, 20));
        this.btnInsertAdjacentPoints.setToolTipText(International.getText("Insert_adjacent_points"));
        this.btnInsertAdjacentPoints.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/vector_add.png")));
        this.btnInsertAdjacentPoints.setContentAreaFilled(false);
        this.btnInsertAdjacentPoints.setBorder(null);
        toolBar.add(this.btnInsertAdjacentPoints);
        this.btnDeletePoint = new JButton("");
        this.btnDeletePoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.uiController.deleteSelectedPoint();
            }
        });
        this.btnDeletePoint.setBorder(null);
        this.btnDeletePoint.setContentAreaFilled(false);
        this.btnDeletePoint.setMaximumSize(new Dimension(20, 20));
        this.btnDeletePoint.setMinimumSize(new Dimension(20, 20));
        this.btnDeletePoint.setPreferredSize(new Dimension(20, 20));
        this.btnDeletePoint.setToolTipText(International.getText("Delete_Point"));
        this.btnDeletePoint.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/delete.png")));
        toolBar.add(this.btnDeletePoint);
        this.btnDeleteMode = new JButton("");
        this.btnDeleteMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.chckbxmntmDeleteMode.setSelected(!JGPSTrackEdit.this.chckbxmntmDeleteMode.isSelected());
                JGPSTrackEdit.this.handleDeleteMode();
            }
        });
        this.btnDeleteMode.setMaximumSize(new Dimension(20, 20));
        this.btnDeleteMode.setMinimumSize(new Dimension(20, 20));
        this.btnDeleteMode.setPreferredSize(new Dimension(20, 20));
        this.btnDeleteMode.setToolTipText(International.getText("Delete_mode"));
        this.btnDeleteMode.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/vector_delete.png")));
        this.btnDeleteMode.setContentAreaFilled(false);
        this.btnDeleteMode.setBorder(null);
        toolBar.add(this.btnDeleteMode);
        this.btnShortCut = new JButton("");
        this.btnShortCut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.handleShortCut();
            }
        });
        this.btnShortCut.setMaximumSize(new Dimension(16, 16));
        this.btnShortCut.setMinimumSize(new Dimension(16, 16));
        this.btnShortCut.setPreferredSize(new Dimension(16, 16));
        this.btnShortCut.setToolTipText(International.getText("Short_cut"));
        this.btnShortCut.setContentAreaFilled(false);
        this.btnShortCut.setBorder(null);
        this.btnShortCut.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/cut_red.png")));
        toolBar.add(this.btnShortCut);
        toolBar.addSeparator();
        toolBar.add(btnZoomIn);
        JButton btnZoomOut = new JButton("");
        btnZoomOut.setBorder(null);
        btnZoomOut.setMaximumSize(new Dimension(20, 20));
        btnZoomOut.setMinimumSize(new Dimension(20, 20));
        btnZoomOut.setPreferredSize(new Dimension(20, 20));
        btnZoomOut.setToolTipText(International.getText("Zoom_Out"));
        btnZoomOut.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/zoom_out.png")));
        btnZoomOut.setContentAreaFilled(false);
        btnZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.uiController.zoomOut();
            }
        });
        toolBar.add(btnZoomOut);
        JButton btnPanNorth = new JButton("");
        btnPanNorth.setBorder(null);
        btnPanNorth.setContentAreaFilled(false);
        btnPanNorth.setPreferredSize(new Dimension(20, 20));
        btnPanNorth.setMinimumSize(new Dimension(20, 20));
        btnPanNorth.setMaximumSize(new Dimension(20, 20));
        btnPanNorth.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/arrow_up.png")));
        btnPanNorth.setToolTipText(International.getText("Pan_North"));
        btnPanNorth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JGPSTrackEdit.this.jButtonNorthActionPerformed(evt);
            }
        });
        JButton btnZoomTrack = new JButton("");
        btnZoomTrack.setContentAreaFilled(false);
        btnZoomTrack.setBorder(null);
        btnZoomTrack.setPreferredSize(new Dimension(20, 20));
        btnZoomTrack.setMaximumSize(new Dimension(20, 20));
        btnZoomTrack.setMinimumSize(new Dimension(20, 20));
        btnZoomTrack.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/map_magnify.png")));
        btnZoomTrack.setToolTipText(International.getText("Zoom_Track"));
        btnZoomTrack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.uiController.zoomSelectedTrack();
            }
        });
        toolBar.add(btnZoomTrack);
        this.btnNewButton_2 = new JButton("");
        this.btnNewButton_2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.uiController.zoomSelectedPoint();
            }
        });
        this.btnNewButton_2.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/bullet_red.png")));
        this.btnNewButton_2.setMaximumSize(new Dimension(20, 20));
        this.btnNewButton_2.setMinimumSize(new Dimension(20, 20));
        this.btnNewButton_2.setPreferredSize(new Dimension(20, 20));
        this.btnNewButton_2.setSelectedIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/bullet_red.png")));
        this.btnNewButton_2.setToolTipText(International.getText("zoom_selected_point"));
        this.btnNewButton_2.setContentAreaFilled(false);
        this.btnNewButton_2.setBorder(null);
        toolBar.add(this.btnNewButton_2);
        JButton btnNewButton_3 = new JButton("");
        btnNewButton_3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.uiController.zoomMapExtract();
            }
        });
        btnNewButton_3.setBorder(null);
        btnNewButton_3.setContentAreaFilled(false);
        btnNewButton_3.setPreferredSize(new Dimension(20, 20));
        btnNewButton_3.setMaximumSize(new Dimension(20, 20));
        btnNewButton_3.setMinimumSize(new Dimension(20, 20));
        btnNewButton_3.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/photo.png")));
        btnNewButton_3.setToolTipText(International.getText("Zoom_map_extract"));
        toolBar.add(btnNewButton_3);
        JButton btnNewButton_4 = new JButton("");
        btnNewButton_4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.uiController.saveMapExtract();
            }
        });
        btnNewButton_4.setToolTipText(International.getText("Save_current_map_extract"));
        btnNewButton_4.setPreferredSize(new Dimension(20, 20));
        btnNewButton_4.setMinimumSize(new Dimension(20, 20));
        btnNewButton_4.setMaximumSize(new Dimension(20, 20));
        btnNewButton_4.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/photo_add.png")));
        btnNewButton_4.setContentAreaFilled(false);
        btnNewButton_4.setBorder(null);
        toolBar.add(btnNewButton_4);
        toolBar.add(btnPanNorth);
        JButton btnPanEast = new JButton("");
        btnPanEast.setContentAreaFilled(false);
        btnPanEast.setBorder(null);
        btnPanEast.setMaximumSize(new Dimension(20, 20));
        btnPanEast.setMinimumSize(new Dimension(20, 20));
        btnPanEast.setPreferredSize(new Dimension(20, 20));
        btnPanEast.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/arrow_right.png")));
        btnPanEast.setToolTipText(International.getText("Pan_East"));
        btnPanEast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.jButtonEastActionPerformed(e);
            }
        });
        toolBar.add(btnPanEast);
        JButton btnPanSouth = new JButton("");
        btnPanSouth.setContentAreaFilled(false);
        btnPanSouth.setBorder(null);
        btnPanSouth.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/arrow_down.png")));
        btnPanSouth.setMaximumSize(new Dimension(20, 20));
        btnPanSouth.setMinimumSize(new Dimension(20, 20));
        btnPanSouth.setPreferredSize(new Dimension(20, 20));
        btnPanSouth.setToolTipText(International.getText("Pan_South"));
        btnPanSouth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.jButtonSouthActionPerformed(e);
            }
        });
        toolBar.add(btnPanSouth);
        JButton btnPanWest = new JButton("");
        btnPanWest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.jButtonWestActionPerformed(e);
            }
        });
        btnPanWest.setBorder(null);
        btnPanWest.setMaximumSize(new Dimension(20, 20));
        btnPanWest.setMinimumSize(new Dimension(20, 20));
        btnPanWest.setPreferredSize(new Dimension(20, 20));
        btnPanWest.setToolTipText(International.getText("Pan_West"));
        btnPanWest.setContentAreaFilled(false);
        btnPanWest.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/arrow_left.png")));
        toolBar.add(btnPanWest);
        toolBar.addSeparator();
        toolBar.add(this.btnConfiguration);
        JButton btnHelp = new JButton("");
        btnHelp.setBorder(null);
        btnHelp.setMinimumSize(new Dimension(20, 20));
        btnHelp.setMaximumSize(new Dimension(20, 20));
        btnHelp.setContentAreaFilled(false);
        btnHelp.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/help.png")));
        btnHelp.setPreferredSize(new Dimension(20, 20));
        btnHelp.setToolTipText(International.getText("Help"));
        btnHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.handleHelp();
            }
        });
        toolBar.addSeparator();
        toolBar.add(btnHelp);
        JButton btnOnlineUserManual = new JButton("");
        btnOnlineUserManual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.uiController.userManual();
            }
        });
        btnOnlineUserManual.setMaximumSize(new Dimension(20, 20));
        btnOnlineUserManual.setMinimumSize(new Dimension(20, 20));
        btnOnlineUserManual.setPreferredSize(new Dimension(20, 20));
        btnOnlineUserManual.setToolTipText(International.getText("Online_User_Manual"));
        btnOnlineUserManual.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/house.png")));
        btnOnlineUserManual.setContentAreaFilled(false);
        btnOnlineUserManual.setBorder(null);
        toolBar.add(btnOnlineUserManual);
        JButton btnUpdateJgpstrackeditDownload = new JButton("");
        btnUpdateJgpstrackeditDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.uiController.updatePage();
            }
        });
        btnUpdateJgpstrackeditDownload.setMaximumSize(new Dimension(20, 20));
        btnUpdateJgpstrackeditDownload.setMinimumSize(new Dimension(20, 20));
        btnUpdateJgpstrackeditDownload.setPreferredSize(new Dimension(20, 20));
        btnUpdateJgpstrackeditDownload.setToolTipText(International.getText("Update_JGPSTrackEdit_Download_Page"));
        btnUpdateJgpstrackeditDownload.setContentAreaFilled(false);
        btnUpdateJgpstrackeditDownload.setBorder(null);
        btnUpdateJgpstrackeditDownload.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/house_link.png")));
        toolBar.add(btnUpdateJgpstrackeditDownload);
        JButton btnAbout = new JButton("");
        btnAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.handleAbout();
            }
        });
        btnAbout.setBorder(null);
        btnAbout.setContentAreaFilled(false);
        btnAbout.setMaximumSize(new Dimension(20, 20));
        btnAbout.setMinimumSize(new Dimension(20, 20));
        btnAbout.setPreferredSize(new Dimension(20, 20));
        btnAbout.setToolTipText(International.getText("About"));
        btnAbout.setIcon(new ImageIcon(JGPSTrackEdit.class.getResource("/jgpstrackedit/view/icon/information.png")));
        toolBar.add(btnAbout);
        this.jButtonOpenTrack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JGPSTrackEdit.this.jButtonOpenTrackActionPerformed(evt);
            }
        });
        this.jPanelstatusBar.setLayout(new FlowLayout(0, 0, 5));
        this.jTextFieldStateMessage.setColumns(60);
        this.jTextFieldStateMessage.setEditable(false);
        this.jPanelstatusBar.add(this.jTextFieldStateMessage);
        this.getContentPane().add((Component)this.jPanelstatusBar, "South");
        this.jTableTracks.setModel(new DefaultTableModel(new Object[][]{new Object[4], new Object[4], new Object[4], new Object[4]}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTablePoints.setModel(new DefaultTableModel(new Object[][]{new Object[4], new Object[4], new Object[4], new Object[4]}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPaneTracksTable.setViewportView(this.jTableTracks);
        this.jScrollPanePointsTable.setViewportView(this.jTablePoints);
        this.jSplitPaneTrack.setLeftComponent(this.jScrollPaneTracksTable);
        this.jPanelMap.setLayout(new BorderLayout());
        this.jButtonNorth.setText(International.getText("North"));
        this.jButtonNorth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JGPSTrackEdit.this.jButtonNorthActionPerformed(evt);
            }
        });
        this.jPanelMap.add((Component)this.jButtonNorth, "North");
        this.jButtonSouth.setText(International.getText("South"));
        this.jButtonSouth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JGPSTrackEdit.this.jButtonSouthActionPerformed(evt);
            }
        });
        this.jPanelMap.add((Component)this.jButtonSouth, "South");
        this.jButtonWest.setText(International.getText("West"));
        this.jButtonWest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JGPSTrackEdit.this.jButtonWestActionPerformed(evt);
            }
        });
        this.jPanelMap.add((Component)this.jButtonWest, "West");
        this.jButtonEast.setText(International.getText("East"));
        this.jButtonEast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JGPSTrackEdit.this.jButtonEastActionPerformed(evt);
            }
        });
        this.jPanelMap.add((Component)this.jButtonEast, "East");
        this.jSplitPaneTrack.setRightComponent(this.jSplitPaneTrackDetail);
        this.jSplitPaneTrackDetail.setRightComponent(this.jScrollPanePointsTable);
        this.jSplitPaneMap.setTopComponent(this.jSplitPaneTrack);
        this.jSplitPaneMap.setBottomComponent(this.jPanelMap);
        this.getContentPane().add((Component)this.jSplitPaneMap, "Center");
        this.fileMenu.setText(International.getText("menu.File"));
        this.fileMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JGPSTrackEdit.this.fileMenuActionPerformed(evt);
            }
        });
        this.openMenuItem.setText(String.valueOf(International.getText("Open_Track")) + "...");
        this.openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JGPSTrackEdit.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.mntmOpenGpsiescomTrack = new JMenuItem(String.valueOf(International.getText("menu.File.Open_GPSies.com")) + "...");
        this.mntmOpenGpsiescomTrack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.uiController.openGPSies();
            }
        });
        this.fileMenu.add(this.mntmOpenGpsiescomTrack);
        JMenuItem mntmOpenDirectory = new JMenuItem(String.valueOf(International.getText("menu.File.Open_Directory")) + "...");
        mntmOpenDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.uiController.openDirectory();
            }
        });
        this.fileMenu.add(mntmOpenDirectory);
        this.fileMenu.addSeparator();
        this.saveMenuItem.setText(International.getText("menu.File.Save"));
        this.fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem.setText(String.valueOf(International.getText("menu.File.Save_As")) + "...");
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JGPSTrackEdit.this.saveAsMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveAsMenuItem);
        this.exitMenuItem.setText(International.getText("menu.File.Exit"));
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JGPSTrackEdit.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.mntmConfiguration = new JMenuItem(String.valueOf(International.getText("menu.File.Configuration")) + "...");
        this.mntmConfiguration.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.handleConfiguration();
            }
        });
        this.mntmDelete_1 = new JMenuItem(International.getText("menu.File.Close"));
        this.mntmDelete_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.uiController.delete();
            }
        });
        this.mntmSaveToGpsiescom = new JMenuItem(String.valueOf(International.getText("menu.File.Save_GPSies.com")) + "...");
        this.mntmSaveToGpsiescom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.uiController.saveGPSies();
            }
        });
        this.fileMenu.add(this.mntmSaveToGpsiescom);
        this.fileMenu.add(this.mntmDelete_1);
        this.fileMenu.addSeparator();
        this.mntmSaveMapView = new JMenuItem(String.valueOf(International.getText("menu.File.Save_Map_View_as_Image")) + "...");
        this.mntmSaveMapView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.mntmSaveMapViewActionPerformed(arg0);
            }
        });
        this.fileMenu.add(this.mntmSaveMapView);
        this.mntmSaveAltitudeProfile = new JMenuItem(String.valueOf(International.getText("menu.File.Save_Altitude_Profile_as_Image")) + "...");
        this.mntmSaveAltitudeProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.mntmSaveAltitudeProfileActionPerformed(arg0);
            }
        });
        this.fileMenu.add(this.mntmSaveAltitudeProfile);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.mntmConfiguration);
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.trackMenu.setText(International.getText("menu.Track"));
        this.jMenuItemReverse.setText(International.getText("menu.Track.Reverse"));
        this.jMenuItemReverse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JGPSTrackEdit.this.jMenuItemReverseActionPerformed(evt);
            }
        });
        this.mntmNew = new JMenuItem(International.getText("menu.Track.New"));
        this.mntmNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.handleNewTrack();
            }
        });
        this.trackMenu.add(this.mntmNew);
        this.trackMenu.addSeparator();
        this.trackMenu.add(this.jMenuItemReverse);
        this.menuBar.add(this.trackMenu);
        this.mntmSplit = new JMenuItem(String.valueOf(International.getText("menu.Track.Split")) + "...");
        this.mntmSplit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.handleSplit();
            }
        });
        this.trackMenu.add(this.mntmSplit);
        this.mntmMerge = new JMenuItem(String.valueOf(International.getText("menu.Track.Merge")) + "...");
        this.mntmMerge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.handleMerge();
            }
        });
        this.trackMenu.add(this.mntmMerge);
        this.trackMenu.addSeparator();
        JMenuItem mntmUpdateElevation = new JMenuItem(International.getText("menu.Track.Update_Elevation"));
        mntmUpdateElevation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.uiController.updateElevation();
            }
        });
        this.mntmCompress = new JMenuItem(String.valueOf(International.getText("menu.Track.Compress")) + "...");
        this.mntmCompress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.uiController.compress();
            }
        });
        this.trackMenu.add(this.mntmCompress);
        this.trackMenu.add(mntmUpdateElevation);
        JMenuItem mntmCorrectPoints = new JMenuItem(International.getText("menu.Track.Correct_points"));
        mntmCorrectPoints.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.uiController.correctSelectedTrack();
            }
        });
        this.trackMenu.add(mntmCorrectPoints);
        this.mntmRemoveInvalidPoints = new JMenuItem(International.getText("menu.Track.Remove_invalid_points"));
        this.mntmRemoveInvalidPoints.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.uiController.correctZeroPoints();
            }
        });
        this.trackMenu.add(this.mntmRemoveInvalidPoints);
        this.mnPoints = new JMenu(International.getText("menu.Point"));
        this.menuBar.add(this.mnPoints);
        this.mntmDelete = new JMenuItem(International.getText("menu.Point.Delete"));
        this.mntmDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.uiController.deleteSelectedPoint();
            }
        });
        this.mntmDeleteP = new JMenuItem(International.getText("menu.Point.Delete"));
        this.mntmDeleteP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.uiController.deleteSelectedPoint();
            }
        });
        this.mntmInsertAdjacentPoints = new JMenuItem(International.getText("menu.Point.Insert_adjacent_points"));
        this.mntmInsertAdjacentPoints.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.uiController.insertAdjacentPoints();
            }
        });
        this.mntmInsertAdjacentPointsP = new JMenuItem(International.getText("menu.Point.Insert_adjacent_points"));
        this.mntmInsertAdjacentPointsP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.uiController.insertAdjacentPoints();
            }
        });
        this.mntmMoveSelectedPoint = new JMenuItem(International.getText("menu.Point.Move_selected_point"));
        this.mntmMoveSelectedPoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.handleMoveSelectedPoint();
            }
        });
        this.mntmMoveSelectedPointP = new JMenuItem(International.getText("menu.Point.Move_selected_point"));
        this.mntmMoveSelectedPointP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.handleMoveSelectedPoint();
            }
        });
        this.mnPoints.add(this.mntmMoveSelectedPoint);
        this.chckbxmntmMoveselectedpointmode = new JCheckBoxMenuItem(International.getText("menu.Point.Move_selected_point_mode"));
        this.chckbxmntmMoveselectedpointmode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.handleMoveSelectedPointMode(JGPSTrackEdit.this.chckbxmntmMoveselectedpointmode.isSelected());
            }
        });
        this.mnPoints.add(this.chckbxmntmMoveselectedpointmode);
        this.mnPoints.addSeparator();
        this.chckbxmntmMoveselectedpointmodeP = new JCheckBoxMenuItem(International.getText("menu.Point.Move_selected_point_mode"));
        this.chckbxmntmMoveselectedpointmodeP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.handleMoveSelectedPointMode(JGPSTrackEdit.this.chckbxmntmMoveselectedpointmodeP.isSelected());
            }
        });
        this.chckbxmntmAppendMode = new JCheckBoxMenuItem(International.getText("menu.Point.Append_mode"));
        this.chckbxmntmAppendMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.chckbxmntmAppendModeP.setSelected(JGPSTrackEdit.this.chckbxmntmAppendMode.isSelected());
                JGPSTrackEdit.this.handleAppendModeChange();
            }
        });
        this.chckbxmntmAppendModeP = new JCheckBoxMenuItem(International.getText("menu.Point.Append_mode"));
        this.chckbxmntmAppendModeP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.chckbxmntmAppendMode.setSelected(JGPSTrackEdit.this.chckbxmntmAppendModeP.isSelected());
                JGPSTrackEdit.this.handleAppendModeChange();
            }
        });
        this.mnPoints.add(this.chckbxmntmAppendMode);
        this.chckbxmntmAppendRoutingMode = new JCheckBoxMenuItem(International.getText("menu.Point.Append_routing_mode"));
        this.chckbxmntmAppendRoutingMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.chckbxmntmAppendRoutingModeP.setSelected(JGPSTrackEdit.this.chckbxmntmAppendRoutingMode.isSelected());
                JGPSTrackEdit.this.handleAppendRoutingModeChange();
            }
        });
        this.chckbxmntmAppendRoutingModeP = new JCheckBoxMenuItem(International.getText("menu.Point.Append_routing_mode"));
        this.chckbxmntmAppendRoutingModeP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.chckbxmntmAppendRoutingMode.setSelected(JGPSTrackEdit.this.chckbxmntmAppendRoutingModeP.isSelected());
                JGPSTrackEdit.this.handleAppendRoutingModeChange();
            }
        });
        this.mnPoints.add(this.chckbxmntmAppendRoutingMode);
        this.mntmUndoAppend = new JMenuItem(International.getText("menu.Point.Undo_append"));
        this.mntmUndoAppend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.uiController.undoAppend();
                JGPSTrackEdit.this.repaint();
            }
        });
        this.mntmUndoAppendP = new JMenuItem(International.getText("menu.Point.Undo_append"));
        this.mntmUndoAppendP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.uiController.undoAppend();
                JGPSTrackEdit.this.repaint();
            }
        });
        this.mnPoints.add(this.mntmUndoAppend);
        this.mnPoints.add(this.mntmInsertAdjacentPoints);
        this.mnPoints.addSeparator();
        this.mnPoints.add(this.mntmDelete);
        this.chckbxmntmDeleteMode = new JCheckBoxMenuItem(International.getText("menu.Point.Delete_mode"));
        this.chckbxmntmDeleteMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.handleDeleteMode();
            }
        });
        this.chckbxmntmDeleteModeP = new JCheckBoxMenuItem(International.getText("menu.Point.Delete_mode"));
        this.chckbxmntmDeleteModeP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.pointDeleteMode = JGPSTrackEdit.this.chckbxmntmDeleteModeP.getState();
                JGPSTrackEdit.this.tracksPanel.setPointDeleteMode(JGPSTrackEdit.this.chckbxmntmDeleteModeP.getState());
                JGPSTrackEdit.this.repaint();
            }
        });
        this.mnPoints.add(this.chckbxmntmDeleteMode);
        this.mntmShortCut = new JMenuItem(International.getText("menu.Point.Short_Cut"));
        this.mntmShortCut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.handleShortCut();
            }
        });
        this.mnPoints.add(this.mntmShortCut);
        this.mntmEditPointP = new JMenuItem("Edit Point");
        this.mntmEditPointP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.mntmEditPointActionPerformed(e);
            }
        });
        this.mntmEditPoint = new JMenuItem("Edit Point");
        this.mntmEditPoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.mntmEditPointActionPerformed(e);
            }
        });
        this.mnPoints.addSeparator();
        this.mnPoints.add(this.mntmEditPoint);
        this.mntmShortCutP = new JMenuItem(International.getText("menu.Point.Short_Cut"));
        this.mntmShortCutP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.handleShortCut();
            }
        });
        this.mnView = new JMenu(International.getText("menu.View"));
        this.menuBar.add(this.mnView);
        this.mntmZoomIn = new JMenuItem(International.getText("menu.View.Zoom_In"));
        this.mntmZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.uiController.zoomIn();
            }
        });
        this.mnView.add(this.mntmZoomIn);
        this.mntmZoomOut = new JMenuItem(International.getText("menu.View.Zoom_out"));
        this.mntmZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.uiController.zoomOut();
            }
        });
        this.mnView.add(this.mntmZoomOut);
        this.mntmZoomSelectedTrack = new JMenuItem(International.getText("menu.View.Zoom_selected_track"));
        this.mntmZoomSelectedTrack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.uiController.zoomSelectedTrack();
            }
        });
        this.mnView.add(this.mntmZoomSelectedTrack);
        JMenuItem mntmZoomSelectedPoint = new JMenuItem(International.getText("menu.View.Zoom_selected_point"));
        mntmZoomSelectedPoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.uiController.zoomSelectedPoint();
            }
        });
        this.mnView.add(mntmZoomSelectedPoint);
        JMenuItem mntmZoomMapExtract = new JMenuItem(String.valueOf(International.getText("menu.View.Zoom_map_extract")) + "...");
        mntmZoomMapExtract.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.uiController.zoomMapExtract();
            }
        });
        this.mnView.add(mntmZoomMapExtract);
        JMenuItem mntmSaveCurrentMap = new JMenuItem(String.valueOf(International.getText("menu.View.Save_current_map_extract")) + "...");
        mntmSaveCurrentMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.uiController.saveMapExtract();
            }
        });
        this.mnView.add(mntmSaveCurrentMap);
        this.mnView.addSeparator();
        this.mnMaps = new JMenu(International.getText("menu.View.Maps"));
        this.mnView.add(this.mnMaps);
        this.rdbtnmntmNone = new JRadioButtonMenuItem(International.getText("menu.View.Maps.None"));
        this.rdbtnmntmNone.setSelected(true);
        this.mapRadioButtons.add(this.rdbtnmntmNone);
        this.rdbtnmntmNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.uiController.tileManagerNone();
                JGPSTrackEdit.this.repaint();
            }
        });
        this.mnMaps.add(this.rdbtnmntmNone);
        this.rdbtnmntmOpenstreetmapmapnik = new JRadioButtonMenuItem("OpenStreetMap (Mapnik)");
        this.mapRadioButtons.add(this.rdbtnmntmOpenstreetmapmapnik);
        this.rdbtnmntmOpenstreetmapmapnik.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.uiController.tileManagerOSM_Mapnik();
            }
        });
        this.mnMaps.add(this.rdbtnmntmOpenstreetmapmapnik);
        this.rdbtnmntmOpencyclemap = new JRadioButtonMenuItem("OpenCycleMap");
        this.mapRadioButtons.add(this.rdbtnmntmOpencyclemap);
        this.rdbtnmntmOpencyclemap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.uiController.tileManagerOCM();
            }
        });
        this.mnMaps.add(this.rdbtnmntmOpencyclemap);
        JRadioButtonMenuItem rdbtnmntmGooglemap = new JRadioButtonMenuItem("GoogleMap");
        this.mapRadioButtons.add(rdbtnmntmGooglemap);
        rdbtnmntmGooglemap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.uiController.tileManagerGoogleMap();
            }
        });
        this.rdbtnmntmHikebikemap = new JRadioButtonMenuItem("HikeBikeMap");
        this.mapRadioButtons.add(this.rdbtnmntmHikebikemap);
        this.rdbtnmntmHikebikemap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.uiController.tileManagerHikeBikeMap();
            }
        });
        this.mnMaps.add(this.rdbtnmntmHikebikemap);
        this.rdbtnmntmumap = new JRadioButtonMenuItem("4UMap");
        this.mapRadioButtons.add(this.rdbtnmntmumap);
        this.rdbtnmntmumap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.uiController.tileManager4UMap();
            }
        });
        this.mnMaps.add(this.rdbtnmntmumap);
        this.mnMaps.add(new JSeparator());
        this.rdbtnmntmMapquest = new JRadioButtonMenuItem("MapQuest");
        this.rdbtnmntmMapquest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.uiController.tileManagerMapQuest();
            }
        });
        this.mnMaps.add(this.rdbtnmntmMapquest);
        this.mapRadioButtons.add(this.rdbtnmntmMapquest);
        this.rdbtnmntmMapquestsatellite = new JRadioButtonMenuItem("MapQuest (Satellite)");
        this.rdbtnmntmMapquestsatellite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.uiController.tileManagerMapQuestSat();
            }
        });
        this.mnMaps.add(this.rdbtnmntmMapquestsatellite);
        this.mapRadioButtons.add(this.rdbtnmntmMapquestsatellite);
        this.rdbtnmntmMapquesthybride = new JRadioButtonMenuItem("MapQuest (Hybride)");
        this.rdbtnmntmMapquesthybride.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.uiController.tileManagerMapQuestHybride();
            }
        });
        this.mnMaps.add(this.rdbtnmntmMapquesthybride);
        this.mapRadioButtons.add(this.rdbtnmntmMapquesthybride);
        this.mnMaps.addSeparator();
        this.mnMaps.add(rdbtnmntmGooglemap);
        this.rdbtnmntmGooglemapsatellite = new JRadioButtonMenuItem("GoogleMap (Satellite)");
        this.mapRadioButtons.add(this.rdbtnmntmGooglemapsatellite);
        this.rdbtnmntmGooglemapsatellite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.uiController.tileManagerGoogleMapSatellite();
            }
        });
        this.mnMaps.add(this.rdbtnmntmGooglemapsatellite);
        this.rdbtnmntmGooglemaphybrid = new JRadioButtonMenuItem("GoogleMap (Hybrid)");
        this.mapRadioButtons.add(this.rdbtnmntmGooglemaphybrid);
        this.rdbtnmntmGooglemaphybrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.uiController.tileManagerGoogleMapHybrid();
            }
        });
        this.mnMaps.add(this.rdbtnmntmGooglemaphybrid);
        this.rdbtnmntmGooglemapterrain = new JRadioButtonMenuItem("GoogleMap (Terrain)");
        this.mapRadioButtons.add(this.rdbtnmntmGooglemapterrain);
        this.rdbtnmntmGooglemapterrain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.uiController.tileManagerGoogleMapTerrain();
            }
        });
        this.mnMaps.add(this.rdbtnmntmGooglemapterrain);
        this.mnView.addSeparator();
        this.chckbxmntmShowDayTour = new JCheckBoxMenuItem(International.getText("menu.View.Show_day_tour_markers"));
        this.chckbxmntmShowDayTour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.tracksPanel.setShowDayTourMarkers(JGPSTrackEdit.this.chckbxmntmShowDayTour.isSelected());
                JGPSTrackEdit.this.altitudeProfilePanel.setShowDayTourMarkers(JGPSTrackEdit.this.chckbxmntmShowDayTour.isSelected());
                JGPSTrackEdit.this.repaint();
            }
        });
        this.mnView.add(this.chckbxmntmShowDayTour);
        this.mntmRefreshMap = new JMenuItem(International.getText("menu.View.Refresh_Map"));
        this.mntmRefreshMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.repaint();
            }
        });
        this.chckbxmntmShowCoordinates = new JCheckBoxMenuItem(International.getText("menu.View.Show_coordinates"));
        this.chckbxmntmShowCoordinates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.tracksPanel.setShowCoordinates(JGPSTrackEdit.this.chckbxmntmShowCoordinates.isSelected());
                JGPSTrackEdit.this.showCoordinatesMode = JGPSTrackEdit.this.chckbxmntmShowCoordinates.isSelected();
                JGPSTrackEdit.this.repaint();
            }
        });
        this.mnView.add(this.chckbxmntmShowCoordinates);
        this.chckbxmntmDistanceMeasurement = new JCheckBoxMenuItem(International.getText("menu.View.Distance_Measurement"));
        this.chckbxmntmDistanceMeasurement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.handleDistanceMeasurementChange();
            }
        });
        this.chckbxmntmPointInformation = new JCheckBoxMenuItem(International.getText("menu.View.Point_Information"));
        this.chckbxmntmPointInformation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.chckbxmntmPointInformationActionPerformed(arg0);
            }
        });
        this.mnView.add(this.chckbxmntmPointInformation);
        this.mnView.add(this.chckbxmntmDistanceMeasurement);
        this.chckbxmntmShowTrackLength = new JCheckBoxMenuItem(International.getText("menu.View.Show_Track_Lengths"));
        this.chckbxmntmShowTrackLength.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.chckbxmntmShowTrackLengthActionPerformed(arg0);
            }
        });
        this.mnView.add(this.chckbxmntmShowTrackLength);
        this.chckbxmntmScale = new JCheckBoxMenuItem(International.getText("menu.View.Show_Scale"));
        this.chckbxmntmScale.setSelected(true);
        this.chckbxmntmScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.chckbxmntmScaleActionPerformed(arg0);
            }
        });
        this.mnView.add(this.chckbxmntmScale);
        this.mnView.addSeparator();
        this.mnView.add(this.mntmRefreshMap);
        this.chckbxmntmNewCheckItem = new JCheckBoxMenuItem(International.getText("menu.View.Show_Tiles"));
        this.chckbxmntmNewCheckItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TileManager.getCurrentTileManager().setShowTiles(JGPSTrackEdit.this.chckbxmntmNewCheckItem.isSelected());
                JGPSTrackEdit.this.repaint();
            }
        });
        this.chckbxmntmAutoRefresh = new JCheckBoxMenuItem(International.getText("menu.View.Auto_refresh"));
        this.chckbxmntmAutoRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.tracksPanel.setAutoRefresh(JGPSTrackEdit.this.chckbxmntmAutoRefresh.isSelected());
            }
        });
        this.chckbxmntmAutoRefresh.setSelected(true);
        this.mnView.add(this.chckbxmntmAutoRefresh);
        this.mnView.add(this.chckbxmntmNewCheckItem);
        this.helpMenu.setText(International.getText("menu.Help"));
        this.contentsMenuItem.setText(International.getText("menu.Help.Short_Help"));
        this.helpMenu.add(this.contentsMenuItem);
        JMenuItem mntmUserManual = new JMenuItem(International.getText("menu.Help.User_Manual"));
        mntmUserManual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.uiController.userManual();
            }
        });
        this.helpMenu.add(mntmUserManual);
        JMenuItem mntmUpdatePage = new JMenuItem(International.getText("menu.Help.Update_Page"));
        mntmUpdatePage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.uiController.updatePage();
            }
        });
        this.mnTiledownload = new JMenu(International.getText("menu.TileDown.Tile_Download"));
        this.menuBar.add(this.mnTiledownload);
        this.mntmStartTileDownload = new JMenuItem(International.getText("menu.TileDown.Start_Tile_Download_Mode"));
        this.mntmStartTileDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.mntmStartTileDownloadActionPerformed(arg0);
            }
        });
        this.mnTiledownload.add(this.mntmStartTileDownload);
        this.mnTiledownload.addSeparator();
        this.mntmAddBorderTiles = new JMenuItem(International.getText("menu.TileDown.Add_Border_Tiles"));
        this.mntmAddBorderTiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.mntmAddBorderTilesActionPerformed(e);
            }
        });
        this.mnTiledownload.add(this.mntmAddBorderTiles);
        this.mntmSaveCurrentWork = new JMenuItem(International.getText("menu.TileDown.Save_Current_Work"));
        this.mntmSaveCurrentWork.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGPSTrackEdit.this.mntmSaveCurrentWorkActionPerformed(e);
            }
        });
        this.mntmAddCurentMap = new JMenuItem(International.getText("menu.TileDown.Add_Current_Map_Extract"));
        this.mntmAddCurentMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.mntmAddCurentMapActionPerformed(arg0);
            }
        });
        this.mntmAddArea = new JMenuItem(International.getText("menu.TileDown.Add_Area"));
        this.mntmAddArea.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.mntmAddAreaActionPerformed(arg0);
            }
        });
        this.mnTiledownload.add(this.mntmAddArea);
        this.mnTiledownload.add(this.mntmAddCurentMap);
        this.mnTiledownload.addSeparator();
        this.mnTiledownload.add(this.mntmSaveCurrentWork);
        this.mntmStopAndSave = new JMenuItem(International.getText("menu.TileDown.Save_Download_Exit_Mode"));
        this.mntmStopAndSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JGPSTrackEdit.this.mntmStopAndSaveActionPerformed(arg0);
            }
        });
        this.mnTiledownload.add(this.mntmStopAndSave);
        this.helpMenu.add(mntmUpdatePage);
        this.aboutMenuItem.setText(International.getText("menu.Help.About"));
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    protected void chckbxmntmScaleActionPerformed(ActionEvent arg0) {
        this.showScale = this.chckbxmntmScale.isSelected();
        this.tracksPanel.setShowScale(this.showScale);
        this.repaint();
    }

    protected void handleMoveSelectedPointMode(boolean selected) {
        this.chckbxmntmMoveselectedpointmode.setSelected(selected);
        this.chckbxmntmMoveselectedpointmodeP.setSelected(selected);
        this.moveSelectedPointMode = selected;
        if (selected) {
            this.handleMoveSelectedPoint();
        }
    }

    public JTable getPointsTable() {
        return this.jTablePoints;
    }

    protected void handleAbout() {
        DlgAbout dialog = new DlgAbout();
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
    }

    protected void handleDeleteMode() {
        this.pointDeleteMode = this.chckbxmntmDeleteMode.getState();
        this.tracksPanel.setPointDeleteMode(this.chckbxmntmDeleteMode.getState());
        this.repaint();
    }

    protected void handleMerge() {
        try {
            DlgMerge dialog = new DlgMerge(this.db.getTrack(this.jTableTracks.getSelectedRow()).getName(), this.db.getTracks());
            dialog.setDefaultCloseOperation(2);
            dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            dialog.setVisible(true);
            this.uiController.merge(dialog.getMergeOption(), this.db.getTrack(this.jTableTracks.getSelectedRow()), dialog.getMergeTrack(), dialog.getTrackName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void handleSplit() {
        try {
            DlgSplit dialog = new DlgSplit(this.db.getTrack(this.jTableTracks.getSelectedRow()).getName());
            dialog.setDefaultCloseOperation(2);
            dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            dialog.setVisible(true);
            this.uiController.split(dialog.getSplitOption(), this.db.getTrack(this.jTableTracks.getSelectedRow()), dialog.getTrackName(), dialog.getNumberTracks(), dialog.getNumberPoints(), dialog.getSplitLength());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void handleShortCut() {
        this.shortCut = true;
        this.shortCutStartPoint = this.getTracksView().getSelectedTrackView().getSelectedPoint();
        this.tracksPanel.addBondPoint(this.shortCutStartPoint);
        this.tracksPanel.setShowBonds(true);
        this.tracksPanel.setCursorText(International.getText("ct.short_cut"), Color.RED);
    }

    protected void handleMoveSelectedPoint() {
        this.moveSelectedPoint = true;
        this.tracksPanel.setShowBonds(true);
        TrackView selectedTrackView = this.getTracksView().getSelectedTrackView();
        int selectedIndex = selectedTrackView.getSelectedPointIndex();
        if (selectedIndex > 1) {
            this.tracksPanel.addBondPoint(selectedTrackView.getTrack().getPoint(selectedIndex - 1));
        }
        if (selectedIndex < selectedTrackView.getTrack().getNumberPoints() - 1) {
            this.tracksPanel.addBondPoint(selectedTrackView.getTrack().getPoint(selectedIndex + 1));
        }
        this.tracksPanel.setCursorText(International.getText("ct_move"), Color.GREEN);
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        if (this.db.isModified() && JOptionPane.showConfirmDialog(this, International.getText("exit_anyway"), International.getText("Unsaved_Tracks"), 0) == 1) {
            return;
        }
        MapExtractManager.add("LAST_MAP_EXTRACT", Transform.getZoomLevel(), Transform.getUpperLeftBoundary());
        MapExtractManager.save();
        Configuration.setProperty("MAPTYPE", TileManager.getCurrentTileManager().getMapName());
        Configuration.saveProperties();
        System.exit(0);
    }

    private void fileMenuActionPerformed(ActionEvent evt) {
    }

    private void jButtonOpenTrackActionPerformed(ActionEvent evt) {
        this.uiController.openTrack();
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        this.uiController.openTrack();
    }

    private void jMenuItemReverseActionPerformed(ActionEvent evt) {
        this.uiController.reverseTrack();
    }

    private void saveAsMenuItemActionPerformed(ActionEvent evt) {
        this.uiController.saveAs();
    }

    private void jButtonNorthActionPerformed(ActionEvent evt) {
        this.uiController.moveNorth();
    }

    private void jButtonSouthActionPerformed(ActionEvent evt) {
        this.uiController.moveSouth();
    }

    private void jButtonWestActionPerformed(ActionEvent evt) {
        this.uiController.moveWest();
    }

    private void jButtonEastActionPerformed(ActionEvent evt) {
        this.uiController.moveEast();
    }

    public void setStateMessage(String msg) {
        this.jTextFieldStateMessage.setText(msg);
    }

    public JTable getTracksTable() {
        return this.jTableTracks;
    }

    public TracksView getTracksView() {
        return this.tracksView;
    }

    public TracksPanel getTracksPanel() {
        return this.tracksPanel;
    }

    public Point getSelectedPoint() {
        return this.tracksView.getSelectedTrackView().getSelectedPoint();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JGPSTrackEdit w = new JGPSTrackEdit();
                w.setVisible(true);
                if (Configuration.getBooleanProperty("SHOW_HELP_ON_STARTUP")) {
                    w.handleHelp();
                }
                w.handleUpdateRequest();
            }
        });
    }

    protected void handleUpdateRequest() {
        GregorianCalendar updateDay = new GregorianCalendar(2016, 6, 27);
        GregorianCalendar today = new GregorianCalendar();
        if (!Configuration.getBooleanProperty("NOUPDATEREQUEST") && updateDay.get(1) <= today.get(1) && updateDay.get(2) <= today.get(2) && updateDay.get(5) <= today.get(5)) {
            if (JOptionPane.showConfirmDialog(this, International.getText("Update_Request_Text"), International.getText("Update_request"), 0) == 0) {
                this.uiController.updatePage();
            } else {
                Configuration.setProperty("NOUPDATEREQUEST", "1");
                Configuration.saveProperties();
            }
        }
    }

    public void setSelectedTrack(Track selectedTrack) {
        this.tracksView.setSelectedTrack(selectedTrack);
        this.trackDataPanel.setTrack(selectedTrack);
        this.altitudeProfilePanel.setTrack(selectedTrack);
    }

    public AltitudeProfilePanel getAltitudeProfilePanel() {
        return this.altitudeProfilePanel;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int selectedRow;
        if (e.getSource() == this.jTableTracks.getSelectionModel()) {
            selectedRow = this.jTableTracks.getSelectedRow();
            if (selectedRow != -1) {
                this.db.getTrackTableModel().setSelectedTrack(this.db.getTrack(selectedRow));
                Track selectedTrack = this.db.getTrack(selectedRow);
                this.setSelectedTrack(selectedTrack);
                this.selectedRowTracksTable = selectedRow;
                this.tracksPanel.repaint();
            } else if (this.selectedRowTracksTable != -1) {
                this.jTableTracks.addRowSelectionInterval(this.selectedRowTracksTable, this.selectedRowTracksTable);
            }
        }
        if (e.getSource() == this.jTablePoints.getSelectionModel() && (selectedRow = this.jTablePoints.getSelectedRow()) != -1) {
            this.tracksView.setSelectedPoint(this.db.getTrackTableModel().getSelectedTrack().getPoint(selectedRow));
            this.altitudeProfilePanel.setSelectedPoint(this.db.getTrackTableModel().getSelectedTrack().getPoint(selectedRow));
            this.tracksPanel.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Track selTrack;
        boolean moveSelectedPointModeStarted = false;
        this.tracksPanel.requestFocusInWindow();
        int screenX = e.getX();
        int screenY = e.getY();
        this.currentScreenX = screenX;
        this.currentScreenY = screenY;
        this.tracksPanel.setMousePosition(screenX, screenY);
        int selectedPointIndex = -1;
        if (e.getClickCount() == 1) {
            if (this.tracksView.getSelectedTrackView() != null) {
                PointView selectedPoint = this.tracksView.getSelectedTrackView().getPointAt(screenX, screenY);
                if (selectedPoint != null) {
                    selectedPointIndex = this.tracksView.getSelectedTrackView().getTrack().indexOf(selectedPoint.getPoint());
                    this.altitudeProfilePanel.setSelectedPoint(selectedPoint.getPoint());
                } else {
                    this.altitudeProfilePanel.setSelectedPoint(null);
                }
            }
            if (selectedPointIndex != -1) {
                this.jTablePoints.setRowSelectionInterval(selectedPointIndex, selectedPointIndex);
                if (this.moveSelectedPointMode) {
                    this.handleMoveSelectedPoint();
                    moveSelectedPointModeStarted = true;
                }
            }
            if (this.pointDeleteMode) {
                this.uiController.deleteSelectedPoint();
            }
            if (this.moveSelectedPoint && !moveSelectedPointModeStarted) {
                this.moveSelectedPoint = false;
                this.tracksPanel.setShowBonds(false);
                this.tracksPanel.clearBondPoints();
                this.tracksPanel.setCursorText("", Color.BLACK);
                this.uiController.setSelectedPointPosition(screenX, screenY);
                this.repaint();
            }
            if (this.appendMode) {
                this.uiController.appendPoint(screenX, screenY);
                this.tracksPanel.clearBondPoints();
                this.tracksPanel.addBondPoint(this.getTracksView().getSelectedTrackView().getTrack().getLastPoint());
                this.repaint();
            }
            if (this.appendRoutingMode) {
                this.uiController.appendRoutingPoint(screenX, screenY);
            }
            if (this.shortCut) {
                this.tracksPanel.setShowBonds(false);
                this.tracksPanel.clearBondPoints();
                this.tracksPanel.setCursorText("", Color.RED);
                this.uiController.shortCut(this.shortCutStartPoint, this.tracksView.getSelectedTrackView().getSelectedPoint());
                this.tracksPanel.setCursor(Cursor.getDefaultCursor());
                this.shortCut = false;
            }
            if (this.tileDownload != null) {
                double longitude = Transform.mapLongitude(screenX);
                double latitude = Transform.mapLatitude(screenY);
                if (this.tileSelectionMode == 1) {
                    this.tileSelectionMode = 2;
                    this.tracksPanel.setCursorText("Define lower right", Color.RED);
                    System.out.println("tileSelectionMode = MODE_WAIT_SECOND_POINT");
                    this.tileSelectFirstPoint = new Point(longitude, latitude);
                    this.tracksPanel.setRectanglePoint(this.tileSelectFirstPoint);
                } else if (this.tileSelectionMode == 2) {
                    this.tileSelectionMode = 0;
                    this.tracksPanel.setCursorText("", Color.RED);
                    this.tracksPanel.setRectanglePoint(null);
                    this.tileDownload.addTiles(this.tileSelectFirstPoint, new Point(longitude, latitude));
                } else {
                    TileNumber clickedTileNumber = TileNumber.getTileNumber(this.tileDownload.getZoomLevel(), longitude, latitude);
                    this.tileDownload.toggleTile(clickedTileNumber);
                }
                this.repaint();
            }
            if (this.distanceMeasurement) {
                this.tracksPanel.clearBondPoints();
                this.distanceMeasurementFirstPoint = new Point(Transform.mapLongitude(screenX), Transform.mapLatitude(screenY), 0.0);
                this.tracksPanel.addBondPoint(this.distanceMeasurementFirstPoint);
                this.tracksPanel.setCursorText("0.000km", Color.BLUE);
                this.repaint();
            }
        } else if (e.getClickCount() == 2 && (selTrack = this.db.getTrack(Transform.mapPoint(screenX, screenY))) != null) {
            this.setSelectedTrack(selTrack);
            int index = this.db.getTrack(selTrack);
            this.jTableTracks.setRowSelectionInterval(index, index);
        }
        this.lastScreenX = screenX;
        this.lastScreenY = screenY;
        this.lastDraggedX = -1;
        this.lastDraggedY = -1;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.tracksPanel.requestFocusInWindow();
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void maybeShowPopup(MouseEvent e) {
        int screenX = e.getX();
        int screenY = e.getY();
        this.currentScreenX = screenX;
        this.currentScreenY = screenY;
        if (e.isPopupTrigger()) {
            this.popupTracksView.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int screenX = e.getX();
        int screenY = e.getY();
        this.currentScreenX = screenX;
        this.currentScreenY = screenY;
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int screenX = e.getX();
        int screenY = e.getY();
        this.currentScreenX = screenX;
        this.currentScreenY = screenY;
        this.lastDraggedX = -1;
        this.lastDraggedY = -1;
        if (this.draggingActive) {
            this.tracksPanel.setCursor(Cursor.getDefaultCursor());
            this.draggingActive = false;
        }
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int screenX = e.getX();
        int screenY = e.getY();
        if (this.lastDraggedX != -1) {
            this.uiController.move((double)(screenX - this.lastDraggedX) / (double)this.tracksPanel.getWidth(), (double)(this.lastDraggedY - screenY) / (double)this.tracksPanel.getHeight());
        }
        this.lastDraggedX = screenX;
        this.lastDraggedY = screenY;
        this.tracksPanel.setCursor(Cursor.getPredefinedCursor(13));
        this.draggingActive = true;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int screenX = e.getX();
        int screenY = e.getY();
        this.tracksPanel.setMousePosition(screenX, screenY);
        if (this.distanceMeasurement) {
            this.distanceMeasurementSecondPoint = new Point(Transform.mapLongitude(screenX), Transform.mapLatitude(screenY), 0.0);
            double distance = this.distanceMeasurementFirstPoint.distance(this.distanceMeasurementSecondPoint);
            this.tracksPanel.setCursorText(String.valueOf(Parser.formatLength(distance)) + "km", Color.BLUE);
        }
        if (this.moveSelectedPoint || this.appendMode || this.appendRoutingMode || this.showCoordinatesMode || this.pointDeleteMode || this.shortCut || this.distanceMeasurement || this.tileSelectionMode > 0) {
            this.repaint();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() < 0) {
            this.uiController.zoomIn();
        } else {
            this.uiController.zoomOut();
        }
    }

    @Override
    public void configurationChanged() {
        if (this.jButtonNorth != null) {
            this.jButtonNorth.setVisible(Configuration.getBooleanProperty("SHOW_DIRECTION_BUTTONS"));
            this.jButtonSouth.setVisible(Configuration.getBooleanProperty("SHOW_DIRECTION_BUTTONS"));
            this.jButtonEast.setVisible(Configuration.getBooleanProperty("SHOW_DIRECTION_BUTTONS"));
            this.jButtonWest.setVisible(Configuration.getBooleanProperty("SHOW_DIRECTION_BUTTONS"));
        }
        this.repaint();
    }

    @Override
    public void keyPressed(KeyEvent key) {
        if (key.getKeyCode() == 27) {
            if (this.pointDeleteMode) {
                this.chckbxmntmDeleteModeP.setState(false);
                this.chckbxmntmDeleteMode.setState(false);
                this.pointDeleteMode = false;
                this.tileSelectionMode = 0;
                this.tracksPanel.setPointDeleteMode(false);
                this.tracksPanel.setCursor(Cursor.getDefaultCursor());
                this.repaint();
            }
            if (this.moveSelectedPoint) {
                this.moveSelectedPoint = false;
                this.tracksPanel.setShowBonds(false);
                this.tracksPanel.clearBondPoints();
                this.tracksPanel.setCursorText("", Color.BLACK);
                this.repaint();
            }
            this.handleMoveSelectedPointMode(false);
            if (this.shortCut) {
                this.tracksPanel.setShowBonds(false);
                this.tracksPanel.clearBondPoints();
                this.tracksPanel.setCursorText("", Color.RED);
                this.shortCut = false;
                this.tracksPanel.setCursor(Cursor.getDefaultCursor());
                this.repaint();
            }
            if (this.appendMode) {
                this.chckbxmntmAppendMode.setSelected(false);
                this.chckbxmntmAppendModeP.setSelected(false);
                this.handleAppendModeChange();
                this.repaint();
            }
            if (this.appendRoutingMode) {
                this.chckbxmntmAppendRoutingMode.setSelected(false);
                this.chckbxmntmAppendRoutingModeP.setSelected(false);
                this.handleAppendRoutingModeChange();
                this.tracksPanel.setCursor(Cursor.getDefaultCursor());
                this.repaint();
            }
            if (this.distanceMeasurement) {
                this.chckbxmntmDistanceMeasurement.setSelected(false);
                this.handleDistanceMeasurementChange();
                this.repaint();
            }
        }
        if (key.getKeyCode() == 37) {
            this.uiController.selectPreviousPoint(true);
        }
        if (key.getKeyCode() == 39) {
            this.uiController.selectNextPoint(true);
        }
        if (key.getKeyCode() == 38) {
            this.uiController.selectPreviousPoint(false);
        }
        if (key.getKeyCode() == 40) {
            this.uiController.selectNextPoint(false);
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    protected void mntmStartTileDownloadActionPerformed(ActionEvent arg0) {
        DlgStartTiledownloadMode dialog = new DlgStartTiledownloadMode(this, Transform.getZoomLevel(), TileManager.getCurrentTileManager().getMaxZoom());
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
        this.tileDownload = new TileDownload();
        TileManager.getCurrentTileManager().setTileDownload(this.tileDownload);
        this.tileDownload.setZoomLevel(dialog.getDownloadZoom());
        this.tracksPanel.setCursor(Cursor.getPredefinedCursor(3));
        switch (dialog.getResult()) {
            case 1: {
                this.tileDownload.addTiles(this.db.getTracks());
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.tracksPanel.setCursor(Cursor.getPredefinedCursor(1));
                break;
            }
            case 2: {
                try {
                    this.tileDownload.loadFromFile(dialog.getFilePath());
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.tracksPanel.setCursor(Cursor.getPredefinedCursor(1));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Error opening file " + dialog.getFilePath(), "File Open Error", 0);
                    this.tileDownload = null;
                    TileManager.getCurrentTileManager().setTileDownload(this.tileDownload);
                    this.tracksPanel.setCursor(Cursor.getPredefinedCursor(0));
                }
                break;
            }
            case 3: {
                this.tracksPanel.setCursor(Cursor.getPredefinedCursor(1));
                break;
            }
            case 0: {
                this.tileDownload = null;
                TileManager.getCurrentTileManager().setTileDownload(this.tileDownload);
                this.tracksPanel.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        this.repaint();
    }

    protected void mntmAddBorderTilesActionPerformed(ActionEvent e) {
        if (this.tileDownload != null) {
            this.tileDownload.appendBorderTiles();
            this.repaint();
        }
    }

    protected void mntmSaveCurrentWorkActionPerformed(ActionEvent e) {
        JFileChooser fileSaveChooser;
        int returnVal;
        if (this.tileDownload != null && (returnVal = (fileSaveChooser = new JFileChooser()).showSaveDialog(this)) == 0) {
            try {
                this.tileDownload.saveToFile(fileSaveChooser.getSelectedFile().getPath());
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error writing to file " + fileSaveChooser.getSelectedFile().getPath(), "File Writing Error", 0);
            }
        }
    }

    protected void mntmStopAndSaveActionPerformed(ActionEvent arg0) {
        JFileChooser fileSaveChooser;
        int returnVal;
        if (this.tileDownload != null && (returnVal = (fileSaveChooser = new JFileChooser()).showSaveDialog(this)) == 0) {
            try {
                this.tileDownload.saveToFile(fileSaveChooser.getSelectedFile().getPath());
                final DlgStopTiledownloadMode dlg = new DlgStopTiledownloadMode(this, this.tileDownload.getZoomLevel(), TileManager.getCurrentTileManager().getMapName());
                dlg.setVisible(true);
                if (dlg.isResult()) {
                    final DlgProcessingTileDownload proc = new DlgProcessingTileDownload();
                    proc.setVisible(true);
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            JGPSTrackEdit.this.tileDownload.addExtensionTiles(dlg.getAdditionalZoomLevels());
                            proc.startDownload(JGPSTrackEdit.this.tileDownload.getAllDownloadTiles(), dlg.getTargetDir(), dlg.getExtension());
                            JGPSTrackEdit.this.tileDownload = null;
                            TileManager.getCurrentTileManager().setTileDownload(JGPSTrackEdit.this.tileDownload);
                            JGPSTrackEdit.this.tracksPanel.setCursor(Cursor.getPredefinedCursor(0));
                        }
                    });
                    t.start();
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error writing to file " + fileSaveChooser.getSelectedFile().getPath(), "File Writing Error", 0);
            }
        }
    }

    protected void mntmAddCurentMapActionPerformed(ActionEvent arg0) {
        this.tileDownload.addTiles(Transform.getUpperLeftBoundary(), Transform.getLowerRightBoundary());
    }

    protected void mntmAddAreaActionPerformed(ActionEvent arg0) {
        this.tileSelectionMode = 1;
        System.out.println("tileSelectionMode = MODE_WAIT_FIRST_POINT");
        this.tracksPanel.setCursorText("Define upper left corner", Color.RED);
        this.repaint();
    }

    protected void chckbxmntmShowTrackLengthActionPerformed(ActionEvent arg0) {
        ViewingConfiguration.setShowLength(this.chckbxmntmShowTrackLength.isSelected());
        if (this.getTracksTable().getSelectedRowCount() == 1) {
            Track currentTrack = this.db.getTracks().get(this.getTracksTable().getSelectedRow());
            currentTrack.getLength(true);
        }
        this.repaint();
    }

    protected void chckbxmntmPointInformationActionPerformed(ActionEvent arg0) {
        ViewingConfiguration.setShowInformation(this.chckbxmntmPointInformation.isSelected());
        this.repaint();
    }

    protected void mntmEditPointActionPerformed(ActionEvent e) {
        Point selectedPoint = this.getTracksView().getSelectedTrackView().getSelectedPoint();
        if (selectedPoint != null) {
            int selectedPointIndex = this.getTracksView().getSelectedTrackView().getSelectedPointIndex();
            DlgPointEdit dialog = new DlgPointEdit(selectedPointIndex, selectedPoint);
            dialog.setModal(true);
            dialog.setVisible(true);
            this.repaint();
        }
    }

    protected void mntmSaveMapViewActionPerformed(ActionEvent arg0) {
        this.uiController.saveMapViewAsImage();
    }

    protected void mntmSaveAltitudeProfileActionPerformed(ActionEvent arg0) {
        this.uiController.saveAltitudeProfileasImage();
    }
}

