/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.view;

import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import jgpstrackedit.data.Point;
import jgpstrackedit.data.Track;
import jgpstrackedit.data.TrackObserver;
import jgpstrackedit.view.PointView;
import jgpstrackedit.view.Transform;

public class TrackView
implements TrackObserver {
    private LinkedList<PointView> points = new LinkedList();
    private Track track;
    private boolean selected = false;
    private Point selectedPoint;

    public TrackView(Track track) {
        this.track = track;
        this.track.addTrackObserver(this);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(Track selectedTrack) {
        this.selected = selectedTrack == this.track;
    }

    public List<PointView> getPoints() {
        return this.points;
    }

    public void setPoints(LinkedList<PointView> points) {
        this.points = points;
    }

    public void setView(Point leftUpperBoundary, Point rightLowerBoundary) {
        this.points.clear();
        Point previous = null;
        boolean view = false;
        for (Point point : this.track.getPoints()) {
            PointView outViewPoint;
            if (point.isWithin(leftUpperBoundary, rightLowerBoundary)) {
                if (!view && previous != null) {
                    outViewPoint = new PointView(previous, this.track);
                    outViewPoint.setOutView(true);
                    this.points.add(outViewPoint);
                    view = true;
                }
                PointView pointView = new PointView(point, this.track);
                this.points.add(pointView);
            } else if (view) {
                outViewPoint = new PointView(point, this.track);
                outViewPoint.setOutView(true);
                this.points.add(outViewPoint);
                view = false;
            }
            previous = point;
        }
    }

    public String getName() {
        return this.track.getName();
    }

    public Color getColor() {
        return this.track.getColor();
    }

    public Point getSelectedPoint() {
        return this.selectedPoint;
    }

    public int getSelectedPointIndex() {
        return this.getTrack().indexOf(this.getSelectedPoint());
    }

    public void setSelectedPoint(Point selectedPoint) {
        this.selectedPoint = selectedPoint;
    }

    public void deleteSelectedPoint() {
        this.track.remove(this.selectedPoint);
    }

    public PointView getPointAt(int x, int y) {
        for (PointView pointView : this.points) {
            if (!pointView.contains(x, y)) continue;
            return pointView;
        }
        return null;
    }

    public int getPointIndexAt(int x, int y) {
        int i = 0;
        while (i < this.points.size()) {
            if (this.points.get(i).contains(x, y)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void trackModified(Track track) {
        this.setView(Transform.getUpperLeftBoundary(), Transform.getLowerRightBoundary());
    }

    public Track getTrack() {
        return this.track;
    }

    public PointView getFirstPoint() {
        if (this.points.size() > 0 && this.points.getFirst().getPoint() == this.track.getFirstPoint()) {
            return this.points.getFirst();
        }
        return null;
    }

    public PointView getLastPoint() {
        if (this.points.size() > 0 && this.points.getLast().getPoint() == this.track.getLastPoint()) {
            return this.points.getLast();
        }
        return null;
    }

    public void insertAdjacentPoints() {
        this.track.insertAdjacentPoints(this.selectedPoint);
    }

    public void setSelectedPointPosition(double mapLongitude, double mapLatitude) {
        this.track.setPointPosition(this.selectedPoint, mapLongitude, mapLatitude);
    }
}

