/*
 * Decompiled with CFR 0.152.
 */
package jpass.crypt.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import jpass.crypt.Cbc;
import jpass.crypt.DecryptException;

public class CryptInputStream
extends InputStream {
    private static final int FETCH_BUFFER_SIZE = 32;
    private InputStream _parent;
    private Cbc _cipher;
    private ByteArrayOutputStream _decrypted;
    private byte[] _buffer = null;
    private int _bufferUsed = 0;
    private byte[] _fetchBuffer = new byte[32];
    private boolean _lastBufferRead = false;

    public CryptInputStream(InputStream parent, byte[] key, byte[] iv) {
        this._parent = parent;
        this._decrypted = new ByteArrayOutputStream();
        this._cipher = new Cbc(iv, key, this._decrypted);
    }

    public CryptInputStream(InputStream parent, byte[] key) throws IOException {
        int cur;
        this._parent = parent;
        byte[] iv = new byte[16];
        for (int readed = 0; readed < 16; readed += cur) {
            cur = parent.read(iv, readed, 16 - readed);
            if (cur >= 0) continue;
            throw new IOException("No initial values in stream.");
        }
        this._decrypted = new ByteArrayOutputStream();
        this._cipher = new Cbc(iv, key, this._decrypted);
    }

    private void readFromStream() {
        if (this._decrypted.size() > 0) {
            this._buffer = this._decrypted.toByteArray();
            this._decrypted.reset();
        }
    }

    @Override
    public int read() throws IOException {
        while (this._buffer == null || this._bufferUsed >= this._buffer.length) {
            if (this._lastBufferRead) {
                return -1;
            }
            this._bufferUsed = 0;
            this._buffer = null;
            int readed = this._parent.read(this._fetchBuffer, 0, 32);
            if (readed < 0) {
                this._lastBufferRead = true;
                try {
                    this._cipher.finishDecryption();
                    this.readFromStream();
                    continue;
                }
                catch (DecryptException ex) {
                    throw new IOException("can't decrypt");
                }
            }
            this._cipher.decrypt(this._fetchBuffer, readed);
            this.readFromStream();
        }
        return this._buffer[this._bufferUsed++] & 0xFF;
    }

    @Override
    public void close() throws IOException {
        this._parent.close();
    }
}

