/*
 * Decompiled with CFR 0.152.
 */
package jpass.crypt.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import jpass.crypt.Cbc;
import jpass.util.CryptUtils;

public class CryptOutputStream
extends OutputStream {
    private Cbc _cipher;
    private byte[] _buffer = new byte[1];

    public CryptOutputStream(OutputStream parent, byte[] key, byte[] iv) {
        this._cipher = new Cbc(iv, key, parent);
    }

    public CryptOutputStream(OutputStream parent, byte[] key) throws IOException {
        byte[] iv = new byte[16];
        Random rnd = CryptUtils.newRandomNumberGenerator();
        rnd.nextBytes(iv);
        parent.write(iv);
        this._cipher = new Cbc(iv, key, parent);
    }

    @Override
    public void write(int b) throws IOException {
        this._buffer[0] = (byte)b;
        this._cipher.encrypt(this._buffer);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this._cipher.encrypt(b);
    }

    @Override
    public void close() throws IOException {
        this._cipher.finishEncryption();
    }
}

