/*
 * Decompiled with CFR 0.152.
 */
package jpass.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import jpass.data.DataModel;
import jpass.ui.MessageDialog;
import jpass.ui.SearchPanel;
import jpass.ui.StatusPanel;
import jpass.ui.action.Callback;
import jpass.ui.action.CloseListener;
import jpass.ui.action.ListListener;
import jpass.ui.action.MenuActionType;
import jpass.ui.helper.EntryHelper;
import jpass.ui.helper.FileHelper;
import jpass.util.Configuration;

public final class JPassFrame
extends JFrame {
    private static final long serialVersionUID = -4114209356464342368L;
    private static volatile JPassFrame INSTANCE;
    public static final String PROGRAM_NAME = "JPass Password Manager";
    public static final String PROGRAM_VERSION = "0.1.14a";
    private final JPopupMenu popup;
    private final JPanel topContainerPanel;
    private final JMenuBar menuBar;
    private final SearchPanel searchPanel;
    private final JMenu fileMenu;
    private final JMenu editMenu;
    private final JMenu toolsMenu;
    private final JMenu helpMenu;
    private final JToolBar toolBar;
    private final JScrollPane scrollPane;
    private final JList entryTitleList;
    private final DefaultListModel entryTitleListModel;
    private final DataModel model = DataModel.getInstance();
    private final StatusPanel statusPanel;
    private volatile boolean processing = false;

    private JPassFrame(String fileName) {
        try {
            this.setIconImage(MessageDialog.getIcon("lock").getImage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.toolBar.add(MenuActionType.NEW_FILE.getAction());
        this.toolBar.add(MenuActionType.OPEN_FILE.getAction());
        this.toolBar.add(MenuActionType.SAVE_FILE.getAction());
        this.toolBar.addSeparator();
        this.toolBar.add(MenuActionType.ADD_ENTRY.getAction());
        this.toolBar.add(MenuActionType.EDIT_ENTRY.getAction());
        this.toolBar.add(MenuActionType.DUPLICATE_ENTRY.getAction());
        this.toolBar.add(MenuActionType.DELETE_ENTRY.getAction());
        this.toolBar.addSeparator();
        this.toolBar.add(MenuActionType.COPY_URL.getAction());
        this.toolBar.add(MenuActionType.COPY_USER.getAction());
        this.toolBar.add(MenuActionType.COPY_PASSWORD.getAction());
        this.toolBar.add(MenuActionType.CLEAR_CLIPBOARD.getAction());
        this.toolBar.addSeparator();
        this.toolBar.add(MenuActionType.ABOUT.getAction());
        this.toolBar.add(MenuActionType.EXIT.getAction());
        this.searchPanel = new SearchPanel(new Callback(){

            @Override
            public void call(boolean enabled) {
                if (enabled) {
                    JPassFrame.this.refreshEntryTitleList(null);
                }
            }
        });
        this.topContainerPanel = new JPanel(new BorderLayout());
        this.topContainerPanel.add((Component)this.toolBar, "North");
        this.topContainerPanel.add((Component)this.searchPanel, "South");
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic(70);
        this.fileMenu.add(MenuActionType.NEW_FILE.getAction());
        this.fileMenu.add(MenuActionType.OPEN_FILE.getAction());
        this.fileMenu.add(MenuActionType.SAVE_FILE.getAction());
        this.fileMenu.add(MenuActionType.SAVE_AS_FILE.getAction());
        this.fileMenu.addSeparator();
        this.fileMenu.add(MenuActionType.EXPORT_XML.getAction());
        this.fileMenu.add(MenuActionType.IMPORT_XML.getAction());
        this.fileMenu.addSeparator();
        this.fileMenu.add(MenuActionType.CHANGE_PASSWORD.getAction());
        this.fileMenu.addSeparator();
        this.fileMenu.add(MenuActionType.EXIT.getAction());
        this.menuBar.add(this.fileMenu);
        this.editMenu = new JMenu("Edit");
        this.editMenu.setMnemonic(69);
        this.editMenu.add(MenuActionType.ADD_ENTRY.getAction());
        this.editMenu.add(MenuActionType.EDIT_ENTRY.getAction());
        this.editMenu.add(MenuActionType.DUPLICATE_ENTRY.getAction());
        this.editMenu.add(MenuActionType.DELETE_ENTRY.getAction());
        this.editMenu.addSeparator();
        this.editMenu.add(MenuActionType.COPY_URL.getAction());
        this.editMenu.add(MenuActionType.COPY_USER.getAction());
        this.editMenu.add(MenuActionType.COPY_PASSWORD.getAction());
        this.editMenu.addSeparator();
        this.editMenu.add(MenuActionType.FIND_ENTRY.getAction());
        this.menuBar.add(this.editMenu);
        this.toolsMenu = new JMenu("Tools");
        this.toolsMenu.setMnemonic(84);
        this.toolsMenu.add(MenuActionType.GENERATE_PASSWORD.getAction());
        this.toolsMenu.add(MenuActionType.CLEAR_CLIPBOARD.getAction());
        this.menuBar.add(this.toolsMenu);
        this.helpMenu = new JMenu("Help");
        this.helpMenu.setMnemonic(72);
        this.helpMenu.add(MenuActionType.LICENSE.getAction());
        this.helpMenu.addSeparator();
        this.helpMenu.add(MenuActionType.ABOUT.getAction());
        this.menuBar.add(this.helpMenu);
        this.popup = new JPopupMenu();
        this.popup.add(MenuActionType.ADD_ENTRY.getAction());
        this.popup.add(MenuActionType.EDIT_ENTRY.getAction());
        this.popup.add(MenuActionType.DUPLICATE_ENTRY.getAction());
        this.popup.add(MenuActionType.DELETE_ENTRY.getAction());
        this.popup.addSeparator();
        this.popup.add(MenuActionType.COPY_URL.getAction());
        this.popup.add(MenuActionType.COPY_USER.getAction());
        this.popup.add(MenuActionType.COPY_PASSWORD.getAction());
        this.popup.addSeparator();
        this.popup.add(MenuActionType.FIND_ENTRY.getAction());
        this.entryTitleListModel = new DefaultListModel();
        this.entryTitleList = new JList(this.entryTitleListModel);
        this.entryTitleList.setSelectionMode(0);
        this.entryTitleList.addMouseListener(new ListListener());
        this.scrollPane = new JScrollPane(this.entryTitleList);
        MenuActionType.bindAllActions(this.entryTitleList);
        this.statusPanel = new StatusPanel();
        this.refreshAll();
        this.getContentPane().add((Component)this.topContainerPanel, "North");
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.getContentPane().add((Component)this.statusPanel, "South");
        this.setJMenuBar(this.menuBar);
        this.setDefaultCloseOperation(0);
        this.setSize(420, 400);
        this.setMinimumSize(new Dimension(420, 200));
        this.addWindowListener(new CloseListener());
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        FileHelper.doOpenFile(fileName, this);
        this.entryTitleList.requestFocusInWindow();
    }

    public static JPassFrame getInstance() {
        return JPassFrame.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JPassFrame getInstance(String fileName) {
        if (INSTANCE != null) return INSTANCE;
        Class<JPassFrame> clazz = JPassFrame.class;
        synchronized (JPassFrame.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new JPassFrame(fileName);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public JList getEntryTitleList() {
        return this.entryTitleList;
    }

    public DataModel getModel() {
        return this.model;
    }

    public void refreshFrameTitle() {
        this.setTitle((this.getModel().isModified() ? "*" : "") + (this.getModel().getFileName() == null ? "Untitled" : this.getModel().getFileName()) + " - " + PROGRAM_NAME);
    }

    public void refreshEntryTitleList(String selectTitle) {
        this.entryTitleListModel.clear();
        List<String> titleList = this.model.getListOfTitles();
        Collections.sort(titleList, String.CASE_INSENSITIVE_ORDER);
        String searchCriteria = this.searchPanel.getSearchCriteria();
        for (String title : titleList) {
            if (!searchCriteria.isEmpty() && !title.toLowerCase().contains(searchCriteria.toLowerCase())) continue;
            this.entryTitleListModel.addElement(title);
        }
        if (selectTitle != null) {
            this.entryTitleList.setSelectedValue(selectTitle, true);
        }
        if (searchCriteria.isEmpty()) {
            this.statusPanel.setText("Entries count: " + titleList.size());
        } else {
            this.statusPanel.setText("Entries found: " + this.entryTitleListModel.size() + " / " + titleList.size());
        }
    }

    public void refreshAll() {
        this.refreshFrameTitle();
        this.refreshEntryTitleList(null);
    }

    public void exitFrame() {
        if (Configuration.getInstance().is("clear.clipboard.on.exit.enabled", false).booleanValue()) {
            EntryHelper.copyEntryField(this, null);
        }
        if (this.processing) {
            return;
        }
        if (this.model.isModified()) {
            int option = MessageDialog.showQuestionMessage(this, "The current file has been modified.\nDo you want to save the changes before closing?", 1);
            if (option == 0) {
                FileHelper.saveFile(this, false, new Callback(){

                    @Override
                    public void call(boolean result) {
                        if (result) {
                            System.exit(0);
                        }
                    }
                });
                return;
            }
            if (option != 1) {
                return;
            }
        }
        System.exit(0);
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }

    public void setProcessing(boolean processing) {
        this.processing = processing;
        for (MenuActionType actionType : MenuActionType.values()) {
            actionType.getAction().setEnabled(!processing);
        }
        this.searchPanel.setEnabled(!processing);
        this.entryTitleList.setEnabled(!processing);
        this.statusPanel.setProcessing(processing);
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public SearchPanel getSearchPanel() {
        return this.searchPanel;
    }
}

