/*
 * Decompiled with CFR 0.152.
 */
package jpass.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import jpass.ui.TextComponentFactory;
import jpass.util.CryptUtils;
import jpass.util.SpringUtilities;
import jpass.util.StringUtils;

public final class MessageDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -1860703845867414123L;
    public static final int DEFAULT_OPTION = -1;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int YES_OPTION = 0;
    public static final int OK_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    public static final int CLOSED_OPTION = -1;
    private int selectedOption;

    private MessageDialog(Dialog parent, Object message, String title, ImageIcon icon, int optionType) {
        super(parent);
        this.initializeDialog(parent, message, title, icon, optionType);
    }

    private MessageDialog(Frame parent, Object message, String title, ImageIcon icon, int optionType) {
        super(parent);
        this.initializeDialog(parent, message, title, icon, optionType);
    }

    private void initializeDialog(Component parent, Object message, String title, ImageIcon icon, int optionType) {
        float widthMultiplier;
        JButton defaultButton;
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.setTitle(title);
        this.selectedOption = -1;
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 5, 5));
        switch (optionType) {
            case 0: {
                defaultButton = this.createButton("Yes", 0, MessageDialog.getIcon("accept"));
                buttonPanel.add(defaultButton);
                buttonPanel.add(this.createButton("No", 1, MessageDialog.getIcon("close")));
                break;
            }
            case 1: {
                defaultButton = this.createButton("Yes", 0, MessageDialog.getIcon("accept"));
                buttonPanel.add(defaultButton);
                buttonPanel.add(this.createButton("No", 1, MessageDialog.getIcon("close")));
                buttonPanel.add(this.createButton("Cancel", 2, MessageDialog.getIcon("cancel")));
                break;
            }
            case 2: {
                defaultButton = this.createButton("OK", 0, MessageDialog.getIcon("accept"));
                buttonPanel.add(defaultButton);
                buttonPanel.add(this.createButton("Cancel", 2, MessageDialog.getIcon("cancel")));
                break;
            }
            default: {
                defaultButton = this.createButton("OK", 0, MessageDialog.getIcon("accept"));
                buttonPanel.add(defaultButton);
            }
        }
        this.getRootPane().setDefaultButton(defaultButton);
        JPanel mainPanel = new JPanel(new BorderLayout(5, 0));
        JPanel messagePanel = new JPanel(new BorderLayout());
        if (message instanceof JScrollPane) {
            widthMultiplier = 1.0f;
            messagePanel.add((Component)message, "Center");
        } else if (message instanceof Component) {
            widthMultiplier = 1.5f;
            messagePanel.add((Component)message, "North");
        } else {
            widthMultiplier = 1.0f;
            messagePanel.setBorder(new EmptyBorder(10, 0, 10, 10));
            messagePanel.add((Component)new JLabel("<html>" + String.valueOf(message).replaceAll("\\n", "<br />") + "</html>"), "Center");
        }
        mainPanel.add((Component)messagePanel, "Center");
        if (icon != null) {
            JLabel image = new JLabel(icon);
            image.setVerticalAlignment(1);
            image.setBorder(new EmptyBorder(10, 10, 0, 10));
            mainPanel.add((Component)image, "West");
        }
        mainPanel.add((Component)buttonPanel, "South");
        this.getContentPane().add(mainPanel);
        this.setResizable(false);
        this.pack();
        this.setSize((int)((float)this.getWidth() * widthMultiplier), this.getHeight());
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private JButton createButton(String name, int option, ImageIcon icon) {
        JButton button = new JButton(name, icon);
        button.setMnemonic(name.charAt(0));
        button.setActionCommand(String.valueOf(option));
        button.addActionListener(this);
        return button;
    }

    private int getSelectedOption() {
        return this.selectedOption;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.selectedOption = Integer.parseInt(event.getActionCommand());
        this.dispose();
    }

    private static void showMessageDialog(Component parent, Object message, String title, ImageIcon icon) {
        MessageDialog.showMessageDialog(parent, message, title, icon, -1);
    }

    private static int showMessageDialog(Component parent, Object message, String title, ImageIcon icon, int optionType) {
        int ret = -1;
        MessageDialog dialog = null;
        if (parent instanceof Frame) {
            dialog = new MessageDialog((Frame)parent, message, title, icon, optionType);
        } else if (parent instanceof Dialog) {
            dialog = new MessageDialog((Dialog)parent, message, title, icon, optionType);
        }
        if (dialog != null) {
            ret = super.getSelectedOption();
        }
        return ret;
    }

    public static void showWarningMessage(Component parent, String message) {
        MessageDialog.showMessageDialog(parent, message, "Warning", MessageDialog.getIcon("dialog_warning"));
    }

    public static void showErrorMessage(Component parent, String message) {
        MessageDialog.showMessageDialog(parent, message, "Error", MessageDialog.getIcon("dialog_error"));
    }

    public static void showInformationMessage(Component parent, String message) {
        MessageDialog.showMessageDialog(parent, message, "Information", MessageDialog.getIcon("dialog_info"));
    }

    public static int showQuestionMessage(Component parent, String message, int optionType) {
        return MessageDialog.showMessageDialog(parent, message, "Confirmation", MessageDialog.getIcon("dialog_question"), optionType);
    }

    public static byte[] showPasswordDialog(Component parent, boolean confirm) {
        JPanel panel = new JPanel();
        panel.add(new JLabel("Password:"));
        JPasswordField password = TextComponentFactory.newPasswordField();
        panel.add(password);
        JPasswordField repeat = null;
        if (confirm) {
            repeat = TextComponentFactory.newPasswordField();
            panel.add(new JLabel("Repeat:"));
            panel.add(repeat);
        }
        panel.setLayout(new SpringLayout());
        SpringUtilities.makeCompactGrid(panel, confirm ? 2 : 1, 2, 5, 5, 5, 5);
        boolean notCorrect = true;
        while (notCorrect) {
            int option = MessageDialog.showMessageDialog(parent, panel, "Enter Password", MessageDialog.getIcon("dialog_lock"), 2);
            if (option == 0) {
                if (password.getPassword().length == 0) {
                    MessageDialog.showWarningMessage(parent, "Please enter a password.");
                    continue;
                }
                if (confirm && !Arrays.equals(password.getPassword(), repeat.getPassword())) {
                    MessageDialog.showWarningMessage(parent, "Password and repeated password are not identical.");
                    continue;
                }
                notCorrect = false;
                continue;
            }
            return null;
        }
        byte[] passwordHash = null;
        try {
            passwordHash = CryptUtils.getPKCS5Sha256Hash(password.getPassword());
        }
        catch (Exception e) {
            MessageDialog.showErrorMessage(parent, "Cannot generate password hash:\n" + StringUtils.stripString(e.getMessage()) + "\n\nOpening and saving files are not possible!");
        }
        return passwordHash;
    }

    public static ImageIcon getIcon(String name) {
        try {
            return new ImageIcon(MessageDialog.class.getClassLoader().getResource("resources/images/" + name + ".png"));
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResourceAsString(String name) {
        StringBuilder builder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            String line;
            InputStream is = MessageDialog.class.getClassLoader().getResourceAsStream("resources/" + name);
            bufferedReader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            while ((line = bufferedReader.readLine()) != null) {
                builder.append(line).append('\n');
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return builder.toString();
    }

    public static void showTextFile(Component parent, String title, String textFile) {
        JTextArea area = TextComponentFactory.newTextArea(MessageDialog.getResourceAsString(textFile));
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        area.setEditable(false);
        area.setFont(new Font("Monospaced", 0, 12));
        JScrollPane scrollPane = new JScrollPane(area);
        scrollPane.setPreferredSize(new Dimension(600, 400));
        MessageDialog.showMessageDialog(parent, scrollPane, title, null, -1);
    }
}

