/*
 * Decompiled with CFR 0.152.
 */
package jpass.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jpass.ui.MessageDialog;
import jpass.ui.TextComponentFactory;
import jpass.ui.action.Callback;

public class SearchPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 5455248210301851210L;
    private static final String CLOSE_BUTTON_ACTION_COMMAND = "close_search_panel_button";
    private static final String SEARCH_PANEL_CLOSE_ACTION = "jpass.search_panel.close";
    private final JLabel label;
    private final JTextField criteriaField;
    private final JButton closeButton;
    private final Callback callback;

    public SearchPanel(Callback searchCallback) {
        super(new BorderLayout());
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.callback = searchCallback;
        this.label = new JLabel("Find: ", MessageDialog.getIcon("find"), 10);
        this.criteriaField = TextComponentFactory.newTextField();
        if (this.callback != null) {
            this.criteriaField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    SearchPanel.this.callback.call(SearchPanel.this.isEnabled());
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    SearchPanel.this.callback.call(SearchPanel.this.isEnabled());
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    SearchPanel.this.callback.call(SearchPanel.this.isEnabled());
                }
            });
        }
        this.closeButton = new JButton(MessageDialog.getIcon("close"));
        this.closeButton.setBorder(new EmptyBorder(0, 2, 0, 2));
        this.closeButton.setActionCommand(CLOSE_BUTTON_ACTION_COMMAND);
        this.closeButton.setFocusable(false);
        this.closeButton.addActionListener(this);
        AbstractAction closeAction = new AbstractAction(){
            private static final long serialVersionUID = 2L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.setVisible(false);
            }
        };
        this.closeButton.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), SEARCH_PANEL_CLOSE_ACTION);
        this.closeButton.getActionMap().put(SEARCH_PANEL_CLOSE_ACTION, closeAction);
        this.add((Component)this.label, "West");
        this.add((Component)this.criteriaField, "Center");
        this.add((Component)this.closeButton, "East");
        this.setVisible(false);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.criteriaField.requestFocusInWindow();
        } else {
            this.criteriaField.setText("");
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.label.setEnabled(enabled);
        this.criteriaField.setEnabled(enabled);
        this.closeButton.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (CLOSE_BUTTON_ACTION_COMMAND.equals(command)) {
            this.setVisible(false);
        }
    }

    public String getSearchCriteria() {
        String criteria = "";
        if (this.isVisible() && this.isEnabled()) {
            criteria = this.criteriaField.getText();
            criteria = criteria == null ? "" : criteria.trim();
        }
        return criteria;
    }
}

