/*
 * Decompiled with CFR 0.152.
 */
package jpass.ui.action;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;
import jpass.ui.action.TextComponentActionType;

public class TextComponentPopupListener
extends MouseAdapter {
    private final JPopupMenu popup;
    private final JMenuItem cutItem = new JMenuItem(TextComponentActionType.CUT.getAction());
    private final JMenuItem copyItem = new JMenuItem(TextComponentActionType.COPY.getAction());
    private final JMenuItem pasteItem = new JMenuItem(TextComponentActionType.PASTE.getAction());
    private final JMenuItem deleteItem = new JMenuItem(TextComponentActionType.DELETE.getAction());
    private final JMenuItem clearAllItem = new JMenuItem(TextComponentActionType.CLEAR_ALL.getAction());
    private final JMenuItem selectAllItem = new JMenuItem(TextComponentActionType.SELECT_ALL.getAction());

    public TextComponentPopupListener() {
        this.popup = new JPopupMenu();
        this.popup.add(this.cutItem);
        this.popup.add(this.copyItem);
        this.popup.add(this.pasteItem);
        this.popup.add(this.deleteItem);
        this.popup.addSeparator();
        this.popup.add(this.clearAllItem);
        this.popup.add(this.selectAllItem);
    }

    private void showPopupMenu(MouseEvent e) {
        JTextComponent textComponent;
        if (e.isPopupTrigger() && e.getSource() instanceof JTextComponent && (textComponent = (JTextComponent)e.getSource()).isEnabled() && (textComponent.hasFocus() || textComponent.requestFocusInWindow())) {
            this.cutItem.setEnabled(TextComponentActionType.CUT.getAction().isEnabled(textComponent));
            this.copyItem.setEnabled(TextComponentActionType.COPY.getAction().isEnabled(textComponent));
            this.pasteItem.setEnabled(TextComponentActionType.PASTE.getAction().isEnabled(textComponent));
            this.deleteItem.setEnabled(TextComponentActionType.DELETE.getAction().isEnabled(textComponent));
            this.clearAllItem.setEnabled(TextComponentActionType.CLEAR_ALL.getAction().isEnabled(textComponent));
            this.selectAllItem.setEnabled(TextComponentActionType.SELECT_ALL.getAction().isEnabled(textComponent));
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.showPopupMenu(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.showPopupMenu(e);
    }
}

