/*
 * Decompiled with CFR 0.152.
 */
package jpass.ui.helper;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import jpass.data.DocumentHelper;
import jpass.ui.JPassFrame;
import jpass.ui.MessageDialog;
import jpass.ui.action.Callback;
import jpass.ui.action.Worker;
import jpass.util.StringUtils;

public final class FileHelper {
    private FileHelper() {
    }

    public static void createNew(final JPassFrame parent) {
        if (parent.getModel().isModified()) {
            int option = MessageDialog.showQuestionMessage(parent, "The current file has been modified.\nDo you want to save the changes before closing?", 1);
            if (option == 0) {
                FileHelper.saveFile(parent, false, new Callback(){

                    @Override
                    public void call(boolean result) {
                        if (result) {
                            parent.getModel().clear();
                            parent.getSearchPanel().setVisible(false);
                            parent.refreshAll();
                        }
                    }
                });
                return;
            }
            if (option != 1) {
                return;
            }
        }
        parent.getModel().clear();
        parent.getSearchPanel().setVisible(false);
        parent.refreshAll();
    }

    public static void exportFile(final JPassFrame parent) {
        MessageDialog.showWarningMessage(parent, "Please note that all data will be stored unencrypted.\nMake sure you keep the exported file in a secure location.");
        File file = FileHelper.showFileChooser(parent, "Export", "xml", "XML Files (*.xml)");
        if (file == null) {
            return;
        }
        final String fileName = FileHelper.checkExtension(file.getPath(), "xml");
        if (!FileHelper.checkFileOverwrite(fileName, parent)) {
            return;
        }
        Worker worker = new Worker(parent){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    DocumentHelper.newInstance(fileName).writeDocument(parent.getModel().getEntries());
                }
                catch (Throwable e) {
                    throw new Exception("An error occured during the export operation:\n" + e.getMessage());
                }
                return null;
            }
        };
        worker.execute();
    }

    public static void importFile(final JPassFrame parent) {
        File file = FileHelper.showFileChooser(parent, "Import", "xml", "XML Files (*.xml)");
        if (file == null) {
            return;
        }
        final String fileName = file.getPath();
        if (parent.getModel().isModified()) {
            int option = MessageDialog.showQuestionMessage(parent, "The current file has been modified.\nDo you want to save the changes before closing?", 1);
            if (option == 0) {
                FileHelper.saveFile(parent, false, new Callback(){

                    @Override
                    public void call(boolean result) {
                        if (result) {
                            FileHelper.doImportFile(fileName, parent);
                        }
                    }
                });
                return;
            }
            if (option != 1) {
                return;
            }
        }
        FileHelper.doImportFile(fileName, parent);
    }

    static void doImportFile(final String fileName, final JPassFrame parent) {
        Worker worker = new Worker(parent){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    parent.getModel().setEntries(DocumentHelper.newInstance(fileName).readDocument());
                    parent.getModel().setModified(true);
                    parent.getModel().setFileName(null);
                    parent.getModel().setPassword(null);
                    parent.getSearchPanel().setVisible(false);
                }
                catch (Throwable e) {
                    throw new Exception("An error occured during the import operation:\n" + e.getMessage());
                }
                return null;
            }
        };
        worker.execute();
    }

    public static void saveFile(JPassFrame parent, boolean saveAs) {
        FileHelper.saveFile(parent, saveAs, new Callback(){

            @Override
            public void call(boolean result) {
            }
        });
    }

    public static void saveFile(final JPassFrame parent, boolean saveAs, final Callback callback) {
        byte[] password;
        String fileName;
        if (saveAs || parent.getModel().getFileName() == null) {
            File file = FileHelper.showFileChooser(parent, "Save", "jpass", "JPass Data Files (*.jpass)");
            if (file == null) {
                callback.call(false);
                return;
            }
            fileName = FileHelper.checkExtension(file.getPath(), "jpass");
            if (!FileHelper.checkFileOverwrite(fileName, parent)) {
                callback.call(false);
                return;
            }
        } else {
            fileName = parent.getModel().getFileName();
        }
        if (parent.getModel().getPassword() == null) {
            password = MessageDialog.showPasswordDialog(parent, true);
            if (password == null) {
                callback.call(false);
                return;
            }
        } else {
            password = parent.getModel().getPassword();
        }
        Worker worker = new Worker(parent){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    DocumentHelper.newInstance(fileName, password).writeDocument(parent.getModel().getEntries());
                    parent.getModel().setFileName(fileName);
                    parent.getModel().setPassword(password);
                    parent.getModel().setModified(false);
                }
                catch (Throwable e) {
                    throw new Exception("An error occured during the save operation:\n" + e.getMessage());
                }
                return null;
            }

            @Override
            protected void done() {
                this.stopProcessing();
                boolean result = true;
                try {
                    this.get();
                }
                catch (Exception e) {
                    result = false;
                    this.showErrorMessage(e);
                }
                callback.call(result);
            }
        };
        worker.execute();
    }

    public static void openFile(final JPassFrame parent) {
        final File file = FileHelper.showFileChooser(parent, "Open", "jpass", "JPass Data Files (*.jpass)");
        if (file == null) {
            return;
        }
        if (parent.getModel().isModified()) {
            int option = MessageDialog.showQuestionMessage(parent, "The current file has been modified.\nDo you want to save the changes before closing?", 1);
            if (option == 0) {
                FileHelper.saveFile(parent, false, new Callback(){

                    @Override
                    public void call(boolean result) {
                        if (result) {
                            FileHelper.doOpenFile(file.getPath(), parent);
                        }
                    }
                });
                return;
            }
            if (option != 1) {
                return;
            }
        }
        FileHelper.doOpenFile(file.getPath(), parent);
    }

    public static void doOpenFile(final String fileName, final JPassFrame parent) {
        parent.getModel().clear();
        if (fileName == null) {
            return;
        }
        final byte[] password = MessageDialog.showPasswordDialog(parent, false);
        if (password == null) {
            return;
        }
        Worker worker = new Worker(parent){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    parent.getModel().setEntries(DocumentHelper.newInstance(fileName, password).readDocument());
                    parent.getModel().setFileName(fileName);
                    parent.getModel().setPassword(password);
                    parent.getSearchPanel().setVisible(false);
                }
                catch (FileNotFoundException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw new Exception("An error occured during the open operation.\nPlease check your password.");
                }
                catch (Throwable e) {
                    throw new Exception("An error occured during the open operation:\n" + e.getMessage());
                }
                return null;
            }

            @Override
            protected void done() {
                this.stopProcessing();
                try {
                    this.get();
                }
                catch (Exception e) {
                    if (e.getCause() != null && e.getCause() instanceof FileNotFoundException) {
                        FileHelper.handleFileNotFound(parent, fileName, password);
                    }
                    this.showErrorMessage(e);
                }
            }
        };
        worker.execute();
    }

    static void handleFileNotFound(final JPassFrame parent, final String fileName, final byte[] password) {
        int option = MessageDialog.showQuestionMessage(parent, "File not found:\n" + StringUtils.stripString(fileName) + "\n\nDo you want to create the file?", 0);
        if (option == 0) {
            Worker fileNotFoundWorker = new Worker(parent){

                @Override
                protected Void doInBackground() throws Exception {
                    try {
                        DocumentHelper.newInstance(fileName, password).writeDocument(parent.getModel().getEntries());
                        parent.getModel().setFileName(fileName);
                        parent.getModel().setPassword(password);
                    }
                    catch (Exception ex) {
                        throw new Exception("An error occured during the open operation:\n" + ex.getMessage());
                    }
                    return null;
                }
            };
            fileNotFoundWorker.execute();
        }
    }

    private static File showFileChooser(JPassFrame parent, String taskName, final String extension, final String description) {
        File ret = null;
        JFileChooser fc = new JFileChooser("./");
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith("." + extension);
            }

            @Override
            public String getDescription() {
                return description;
            }
        });
        int returnVal = fc.showDialog(parent, taskName);
        if (returnVal == 0) {
            ret = fc.getSelectedFile();
        }
        return ret;
    }

    private static boolean checkFileOverwrite(String fileName, JPassFrame parent) {
        int option;
        boolean overwriteAccepted = true;
        File file = new File(fileName);
        if (file.exists() && (option = MessageDialog.showQuestionMessage(parent, "File is already exists:\n" + StringUtils.stripString(fileName) + "\n\nDo you want to overwrite?", 0)) != 0) {
            overwriteAccepted = false;
        }
        return overwriteAccepted;
    }

    private static String checkExtension(String fileName, String extension) {
        String separator;
        String string = separator = fileName.endsWith(".") ? "" : ".";
        if (!fileName.toLowerCase().endsWith(separator + extension)) {
            return fileName + separator + extension;
        }
        return fileName;
    }
}

