/*
 * Decompiled with CFR 0.152.
 */
package shared.swing;

import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

public class JPicButton
extends JComponent {
    public static final int MOUSEBUTTON1 = 1;
    public static final int MOUSEBUTTON2 = 2;
    public static final int MOUSEBUTTON3 = 4;
    private ArrayList<ActionListener> m_actionListenersArray = new ArrayList();
    protected BufferedImage m_uImg;
    protected BufferedImage m_dImg;
    protected BufferedImage m_xuImg;
    protected BufferedImage m_xdImg;
    private boolean m_bEnabled;
    private boolean m_bDown;
    private boolean m_bLastDown;
    private boolean m_bToggleMode;
    private int m_buttonMask;
    private String m_actionCommand;
    private boolean m_bMouseDown = false;
    private boolean m_bShowHandMouseOver = true;
    private String m_upPicFile;
    private String m_downPicFile;
    private String m_xupPicFile;
    private String m_xdownPicFile;
    private Object m_data = null;
    private Object m_interpolation = RenderingHints.VALUE_INTERPOLATION_BICUBIC;

    public JPicButton() {
        this.doInit(false);
    }

    public JPicButton(boolean bToggleMode) {
        this.doInit(bToggleMode);
    }

    private void doInit(boolean bToggleMode) {
        this.m_bEnabled = true;
        this.m_bDown = false;
        this.m_bLastDown = false;
        this.m_bToggleMode = bToggleMode;
        this.m_buttonMask = 1;
        this.m_bMouseDown = false;
        JPicButton button = this;
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                if (JPicButton.this.m_bShowHandMouseOver && JPicButton.this.isEnabled()) {
                    JPicButton.this.setCursor(Cursor.getPredefinedCursor(12));
                }
            }

            public void mouseExited(MouseEvent e) {
                if (JPicButton.this.m_bShowHandMouseOver) {
                    JPicButton.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }

            public void mousePressed(MouseEvent ev) {
                if (JPicButton.this.m_bEnabled && (1 << ev.getButton() - 1 & JPicButton.this.m_buttonMask) != 0) {
                    JPicButton.this.m_bLastDown = JPicButton.this.m_bDown;
                    JPicButton.this.m_bDown = true;
                    JPicButton.this.m_bMouseDown = true;
                    JPicButton.this.repaint();
                }
            }

            public void mouseReleased(MouseEvent ev) {
                if (JPicButton.this.m_bEnabled && JPicButton.this.m_bMouseDown) {
                    boolean bInCtrl = false;
                    Point pt = ev.getPoint();
                    if (pt.x >= 0 && pt.x <= JPicButton.this.getWidth() && pt.y >= 0 && pt.y <= JPicButton.this.getHeight()) {
                        bInCtrl = true;
                    }
                    if ((1 << ev.getButton() - 1 & JPicButton.this.m_buttonMask) != 0) {
                        JPicButton.this.m_bDown = bInCtrl ? (JPicButton.this.m_bToggleMode ? !JPicButton.this.m_bLastDown : false) : JPicButton.this.m_bLastDown;
                        JPicButton.this.m_bMouseDown = false;
                        JPicButton.this.repaint();
                        if (bInCtrl) {
                            JPicButton.this.fireActionPerformed();
                        }
                    }
                }
            }
        });
    }

    public void setActionCommand(String actionCommand) {
        this.m_actionCommand = actionCommand;
    }

    public String getActionCommand() {
        return this.m_actionCommand;
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.m_actionListenersArray == null) {
            this.m_actionListenersArray = new ArrayList();
        }
        this.m_actionListenersArray.add(actionListener);
    }

    public void removeActionListener(ActionListener al) {
        if (this.m_actionListenersArray != null) {
            int index = 0;
            for (ActionListener item : this.m_actionListenersArray) {
                if (item.equals(al)) {
                    this.m_actionListenersArray.remove(index);
                    return;
                }
                ++index;
            }
        }
    }

    protected void fireActionPerformed() {
        if (this.m_actionListenersArray != null && !this.m_actionListenersArray.isEmpty()) {
            AWTEvent event = EventQueue.getCurrentEvent();
            int modifier = 0;
            if (event instanceof InputEvent) {
                modifier = ((InputEvent)event).getModifiers();
            } else if (event instanceof ActionEvent) {
                modifier = ((ActionEvent)event).getModifiers();
            } else assert (false);
            ActionEvent actionEvent = new ActionEvent(this, 1001, this.m_actionCommand, EventQueue.getMostRecentEventTime(), modifier);
            for (ActionListener listener : this.m_actionListenersArray) {
                listener.actionPerformed(actionEvent);
            }
        }
    }

    public BufferedImage getUPic(boolean bEnabled) {
        return bEnabled ? this.m_uImg : this.m_xuImg;
    }

    public BufferedImage getDPic(boolean bEnabled) {
        return bEnabled ? this.m_dImg : this.m_xdImg;
    }

    public void setUPic(BufferedImage img, boolean bEnabled) {
        if (bEnabled) {
            this.m_uImg = img;
        } else {
            this.m_xuImg = img;
        }
    }

    public void setDPic(BufferedImage img, boolean bEnabled) {
        if (bEnabled) {
            this.m_dImg = img;
        } else {
            this.m_xdImg = img;
        }
    }

    public void setUPic(BufferedImage img) {
        this.setUPic(img, true);
    }

    public void setDPic(BufferedImage img) {
        this.m_dImg = img;
    }

    public void setXPic(BufferedImage img) {
        this.m_xuImg = this.m_xdImg = img;
    }

    public void setEnabledUpPicture(String pic) {
        try {
            this.m_upPicFile = pic;
            this.setUPic(ImageIO.read(new File(this.m_upPicFile)), true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public BufferedImage getEnabledUpPicture() {
        return this.m_uImg;
    }

    public void setEnabledDownPicture(String pic) {
        try {
            this.m_downPicFile = pic;
            this.setDPic(ImageIO.read(new File(this.m_downPicFile)), true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public BufferedImage getEnabledDownPicture() {
        return this.m_dImg;
    }

    public void setDisabledUpPicture(String pic) {
        try {
            this.m_xupPicFile = pic;
            this.setUPic(ImageIO.read(new File(this.m_xupPicFile)), false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public BufferedImage getDisabledUpPicture() {
        return this.m_xuImg;
    }

    public void setDisabledDownPicture(String pic) {
        try {
            this.m_xdownPicFile = pic;
            this.setDPic(ImageIO.read(new File(this.m_xdownPicFile)), false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public BufferedImage getDisabledDownPicture() {
        return this.m_xdImg;
    }

    public boolean isDown() {
        return this.m_bDown;
    }

    public boolean isEnabled() {
        return this.m_bEnabled;
    }

    public void setEnabled(boolean bEnabled) {
        this.m_bEnabled = bEnabled;
        this.m_bMouseDown = false;
        this.repaint();
    }

    public void setDown(boolean bDown) {
        this.m_bDown = bDown;
        this.m_bMouseDown = false;
        this.repaint();
    }

    public void setToggleMode(boolean bToggleMode) {
        this.m_bToggleMode = bToggleMode;
    }

    public boolean getToggleMode() {
        return this.m_bToggleMode;
    }

    public void setButtonMask(int buttonMask) {
        this.m_buttonMask = buttonMask;
    }

    public int getButtonMask() {
        return this.m_buttonMask;
    }

    public void paintComponent(Graphics g) {
        BufferedImage img = null;
        img = this.m_bEnabled ? (this.m_bDown ? this.m_dImg : this.m_uImg) : (this.m_bDown ? this.m_xdImg : this.m_xuImg);
        Rectangle rect = this.getBounds();
        Insets ins = this.getInsets();
        rect = new Rectangle(ins.left, ins.top, rect.width - ins.left - ins.right, rect.height - ins.bottom - ins.top);
        if (img != null) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.m_interpolation);
            if (rect != null) {
                int w = img.getWidth(this);
                int h = img.getHeight(this);
                if (w >= 0 && h >= 0) {
                    g2d.drawImage(img, 0, 0, rect.width, rect.height, 0, 0, w, h, this);
                }
            }
        }
    }

    public boolean getMouseDown() {
        return this.m_bMouseDown;
    }

    public void setMouseDown(boolean bMouseDown) {
        this.m_bMouseDown = bMouseDown;
    }

    public void setData(Object data) {
        this.m_data = data;
    }

    public Object getData() {
        return this.m_data;
    }

    public void setShowHandMouseOver(boolean bShowHandMouseOver) {
        this.m_bShowHandMouseOver = bShowHandMouseOver;
    }

    public boolean getShowHandMouseOver() {
        return this.m_bShowHandMouseOver;
    }
}

