/*
 * Decompiled with CFR 0.152.
 */
package net.java.balloontip.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Timer;
import net.java.balloontip.BalloonTip;

public class ToolTipUtils {
    private ToolTipUtils() {
    }

    public static void balloonToToolTip(BalloonTip bT, int initialDelay, int showDelay) {
        bT.setVisible(false);
        bT.getAttachedComponent().addMouseListener(new ToolTipController(bT, initialDelay, showDelay));
    }

    private static class ToolTipController
    extends MouseAdapter {
        private BalloonTip balloonTip;
        private Timer initialTimer;
        private Timer showTimer;

        public ToolTipController(final BalloonTip balloonTip, int initialDelay, int showDelay) {
            this.balloonTip = balloonTip;
            this.initialTimer = new Timer(initialDelay, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    balloonTip.setVisible(true);
                    ToolTipController.this.showTimer.start();
                }
            });
            this.initialTimer.setRepeats(false);
            this.showTimer = new Timer(showDelay, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    balloonTip.setVisible(false);
                }
            });
            this.showTimer.setRepeats(false);
        }

        public void mouseEntered(MouseEvent e) {
            if (!this.balloonTip.isVisible()) {
                this.initialTimer.start();
            }
        }

        public void mouseExited(MouseEvent e) {
            this.initialTimer.stop();
        }
    }
}

