/*
 * Decompiled with CFR 0.152.
 */
package com.ehsunbehravesh.mypasswords.entity;

import com.ehsunbehravesh.mypasswords.Domain;
import com.ehsunbehravesh.mypasswords.Logger;
import com.ehsunbehravesh.mypasswords.Utils;
import com.ehsunbehravesh.mypasswords.entity.PasswordTag;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class PasswordEntry {
    private int id;
    private String title;
    private String username;
    private String url;
    private String description;
    String password;

    public PasswordEntry(int id, String title, String url, String password) {
        this.id = id;
        this.title = title;
        this.url = url;
        this.password = password;
    }

    public PasswordEntry(int id, String title, String url, String description, String username, String password) {
        this.id = id;
        this.title = title;
        this.url = url;
        this.description = description;
        this.username = username;
        this.password = password;
    }

    public PasswordEntry(String title) {
        this.title = title;
    }

    public PasswordEntry() {
    }

    public PasswordEntry(Integer id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPassword(char[] password) {
        this.password = new String(password);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PasswordTag[] readTags() {
        ArrayList<PasswordTag> tags = new ArrayList<PasswordTag>();
        Domain domain = Domain.getInstance();
        Connection con = domain.getDBConnection();
        ResultSet rs = null;
        if (con != null) {
            try {
                Statement st = con.createStatement();
                String sql = String.format("SELECT * FROM PASSWORD_TAG pt INNER JOIN PASSWORD_ENTRY_PASSWORD_TAG pept ON (pt.ID = pept.PASSWORD_TAG_ID) WHERE pept.PASSWORD_ENTRY_ID = %d", this.id);
                rs = st.executeQuery(sql);
                while (rs.next()) {
                    PasswordTag pTag = new PasswordTag(rs.getInt("id"), rs.getString("title"));
                    tags.add(pTag);
                }
            }
            catch (SQLException ex) {
                Logger.log(ex.getMessage());
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    con.close();
                }
                catch (SQLException ex) {
                    Logger.log(ex.getMessage());
                }
            }
        }
        PasswordTag[] arrTags = new PasswordTag[tags.size()];
        arrTags = tags.toArray(arrTags);
        return arrTags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTag(String tagTitle) {
        Domain domain = Domain.getInstance();
        Connection con = domain.getDBConnection();
        if (con != null) {
            try {
                PasswordTag tag = new PasswordTag(tagTitle);
                if (tag.loadByTitle()) {
                    if (!(tag.getId() > 0 || tag.save() && tag.getId() > 0)) {
                        boolean bl = false;
                        return bl;
                    }
                    String sql = String.format("INSERT INTO PASSWORD_ENTRY_PASSWORD_TAG (PASSWORD_ENTRY_ID, PASSWORD_TAG_ID) VALUES (%d, %d)", this.id, tag.getId());
                    Statement st = con.createStatement();
                    boolean bl = st.executeUpdate(sql) == 1;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (SQLException ex) {
                Logger.log(ex.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    con.close();
                }
                catch (SQLException ex) {
                    Logger.log(ex.getMessage());
                    return false;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        Domain domain = Domain.getInstance();
        Connection con = domain.getDBConnection();
        if (con != null) {
            try {
                ResultSet rs;
                PreparedStatement st = null;
                String sql = "";
                String encryptedPassword = "";
                encryptedPassword = Utils.encrypt(Utils.createEncryptionKey(domain.getPassword()), this.password);
                sql = this.id <= 0 ? String.format("INSERT INTO PASSWORD_ENTRY (TITLE, URL, DESCRIPTION, \"PASSWORD\", USERNAME) VALUES ('%s', '%s', '%s', '%s', '%s')", this.title, this.url, this.description, encryptedPassword, this.username) : String.format("UPDATE PASSWORD_ENTRY SET TITLE = '%s', URL = '%s', DESCRIPTION = '%s', \"PASSWORD\" = '%s', USERNAME = '%s' WHERE ID = %d", this.title, this.url, this.description, encryptedPassword, this.username, this.id);
                st = con.prepareStatement(sql, 1);
                int result = st.executeUpdate();
                if (this.id <= 0 && (rs = st.getGeneratedKeys()).next()) {
                    this.id = rs.getInt(1);
                }
                boolean bl = result == 1;
                return bl;
            }
            catch (Exception ex) {
                Logger.log(ex.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    con.close();
                }
                catch (SQLException ex) {
                    Logger.log(ex.getMessage());
                    return false;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load() {
        Domain domain = Domain.getInstance();
        Connection con = domain.getDBConnection();
        if (con != null) {
            try {
                Statement st = con.createStatement();
                String sql = String.format("SELECT * FROM PASSWORD_ENTRY WHERE ID = %d", this.id);
                ResultSet rs = st.executeQuery(sql);
                if (rs.next()) {
                    this.id = rs.getInt("ID");
                    this.title = rs.getString("TITLE");
                    this.url = rs.getString("URL");
                    String decryptedPassword = "";
                    try {
                        decryptedPassword = Utils.decrypt(Utils.createEncryptionKey(domain.getPassword()), rs.getString("PASSWORD"));
                    }
                    catch (Exception ex) {
                        Logger.log(ex.getMessage());
                    }
                    this.password = decryptedPassword;
                    this.username = rs.getString("USERNAME");
                    this.description = rs.getString("DESCRIPTION");
                }
                boolean bl = true;
                return bl;
            }
            catch (SQLException ex) {
                Logger.log(ex.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    con.close();
                }
                catch (SQLException ex) {
                    Logger.log(ex.getMessage());
                    return false;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadByTitle(boolean caseSensetive) {
        Domain domain = Domain.getInstance();
        Connection con = domain.getDBConnection();
        if (con != null) {
            try {
                Statement st = con.createStatement();
                String sql = "";
                sql = caseSensetive ? String.format("SELECT * FROM PASSWORD_ENTRY WHERE TITLE = '%s'", this.title) : String.format("SELECT * FROM PASSWORD_ENTRY WHERE UPPER(TITLE) LIKE UPPER('%s')", this.title);
                ResultSet rs = st.executeQuery(sql);
                if (rs.next()) {
                    this.id = rs.getInt("ID");
                    this.title = rs.getString("TITLE");
                    this.url = rs.getString("URL");
                    this.description = rs.getString("DESCRIPTION");
                    this.username = rs.getString("USERNAME");
                    String decryptedPassword = "";
                    try {
                        decryptedPassword = Utils.decrypt(Utils.createEncryptionKey(domain.getPassword()), rs.getString("PASSWORD"));
                    }
                    catch (Exception ex) {
                        Logger.log(ex.getMessage());
                    }
                    this.password = decryptedPassword;
                }
                boolean bl = true;
                return bl;
            }
            catch (SQLException ex) {
                Logger.log(ex.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    con.close();
                }
                catch (SQLException ex) {
                    Logger.log(ex.getMessage());
                    return false;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearTags() {
        Domain domain = Domain.getInstance();
        Connection con = domain.getDBConnection();
        if (con != null) {
            try {
                String sql = String.format("DELETE FROM PASSWORD_ENTRY_PASSWORD_TAG WHERE PASSWORD_ENTRY_ID = %d", this.id);
                Statement st = con.createStatement();
                st.executeUpdate(sql);
                boolean bl = true;
                return bl;
            }
            catch (SQLException ex) {
                Logger.log(ex.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    con.close();
                }
                catch (SQLException ex) {
                    Logger.log(ex.getMessage());
                    return false;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete() {
        Domain domain = Domain.getInstance();
        Connection con = domain.getDBConnection();
        if (con != null) {
            try {
                Statement st = con.createStatement();
                String sql = String.format("DELETE FROM PASSWORD_ENTRY WHERE ID = %d", this.id);
                st.executeUpdate(sql);
                boolean bl = true;
                return bl;
            }
            catch (SQLException ex) {
                Logger.log(ex.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    con.close();
                }
                catch (SQLException ex) {
                    Logger.log(ex.getMessage());
                    return false;
                }
            }
        }
        return false;
    }

    public String toString() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PasswordEntry[] getAllPasswordEntries() {
        ArrayList<PasswordEntry> passwordEntries = new ArrayList<PasswordEntry>();
        Domain domain = Domain.getInstance();
        Connection con = domain.getDBConnection();
        if (con != null) {
            try {
                Statement st = con.createStatement();
                String sql = "SELECT * FROM PASSWORD_ENTRY ORDER BY Title";
                ResultSet rs = st.executeQuery(sql);
                String key = Utils.createEncryptionKey(domain.getPassword());
                while (rs.next()) {
                    String encryotedPassword = rs.getString("password");
                    String decryptedPassword = Utils.decrypt(key, encryotedPassword);
                    PasswordEntry passwordEntry = new PasswordEntry(rs.getInt("id"), rs.getString("title"), rs.getString("url"), rs.getString("description"), rs.getString("username"), decryptedPassword);
                    passwordEntries.add(passwordEntry);
                }
            }
            catch (SQLException ex) {
                Logger.log(ex.getMessage());
            }
            catch (Exception ex) {
                Logger.log(ex.getMessage());
            }
            finally {
                try {
                    con.close();
                }
                catch (SQLException ex) {
                    Logger.log(ex.getMessage());
                }
            }
        }
        PasswordEntry[] arrPasswordEntry = new PasswordEntry[passwordEntries.size()];
        arrPasswordEntry = passwordEntries.toArray(arrPasswordEntry);
        return arrPasswordEntry;
    }

    public static PasswordEntry[] getPasswordEntriesWithoutTag() {
        PasswordEntry[] allPasswords = PasswordEntry.getAllPasswordEntries();
        ArrayList<PasswordEntry> passwordEntries = new ArrayList<PasswordEntry>();
        for (int i = 0; i < allPasswords.length; ++i) {
            PasswordEntry passwordEntry = allPasswords[i];
            if (passwordEntry.readTags().length > 0) continue;
            passwordEntries.add(passwordEntry);
        }
        PasswordEntry[] arrPasswordEntry = new PasswordEntry[passwordEntries.size()];
        arrPasswordEntry = passwordEntries.toArray(arrPasswordEntry);
        return arrPasswordEntry;
    }
}

