/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.gui;

import de.saring.sportstracker.core.STException;
import de.saring.sportstracker.core.STExceptionID;
import de.saring.sportstracker.core.STOptions;
import de.saring.sportstracker.data.Exercise;
import de.saring.sportstracker.data.ExerciseFilter;
import de.saring.sportstracker.data.ExerciseList;
import de.saring.sportstracker.data.NoteList;
import de.saring.sportstracker.data.SportTypeList;
import de.saring.sportstracker.data.WeightList;
import de.saring.sportstracker.gui.STContext;
import de.saring.sportstracker.gui.STDocument;
import de.saring.sportstracker.storage.IStorage;
import de.saring.util.data.IdDateObjectList;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class STDocumentImpl
implements STDocument {
    private static final Logger LOGGER = Logger.getLogger(STDocumentImpl.class.getName());
    private static final String FILENAME_SPORT_TYPE_LIST = "sport-types.xml";
    private static final String FILENAME_EXERCISE_LIST = "exercises.xml";
    private static final String FILENAME_NOTE_LIST = "notes.xml";
    private static final String FILENAME_WEIGHT_LIST = "weights.xml";
    private static final String FILENAME_OPTIONS = "st-options.xml";
    private STContext context;
    private SportTypeList sportTypeList;
    private ExerciseList exerciseList;
    private NoteList noteList;
    private WeightList weightList;
    private IStorage storage;
    private String dataDirectory;
    private boolean dirtyData;
    private STOptions options;
    private boolean filterEnabled;
    private ExerciseFilter currentFilter;

    @Inject
    public STDocumentImpl(STContext context, IStorage storage) {
        this.context = context;
        this.storage = storage;
        Exercise.IntensityType.setResReader(context.getResReader());
        this.dataDirectory = String.valueOf(System.getProperty("user.home")) + "/.sportstracker";
        this.sportTypeList = new SportTypeList();
        this.exerciseList = new ExerciseList();
        this.noteList = new NoteList();
        this.weightList = new WeightList();
        this.dirtyData = false;
        this.filterEnabled = false;
        this.currentFilter = ExerciseFilter.createDefaultExerciseFilter();
    }

    @Override
    public SportTypeList getSportTypeList() {
        return this.sportTypeList;
    }

    @Override
    public ExerciseList getExerciseList() {
        return this.exerciseList;
    }

    @Override
    public NoteList getNoteList() {
        return this.noteList;
    }

    @Override
    public WeightList getWeightList() {
        return this.weightList;
    }

    @Override
    public STOptions getOptions() {
        return this.options;
    }

    @Override
    public boolean isDirtyData() {
        return this.dirtyData;
    }

    @Override
    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    @Override
    public void setFilterEnabled(boolean filterEnabled) {
        this.filterEnabled = filterEnabled;
    }

    @Override
    public ExerciseFilter getCurrentFilter() {
        return this.currentFilter;
    }

    @Override
    public void setCurrentFilter(ExerciseFilter currentFilter) {
        this.currentFilter = currentFilter;
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    @Override
    public void evaluateCommandLineParameters(String[] parameters) {
        if (parameters != null) {
            String[] stringArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                String dataDir;
                String parameter = stringArray[n2];
                if (parameter.startsWith("--datadir=") && (dataDir = parameter.substring("--datadir=".length()).trim()) != null && dataDir.length() > 0) {
                    this.dataDirectory = dataDir;
                }
                ++n2;
            }
        }
    }

    @Override
    public void loadOptions() {
        try {
            this.options = (STOptions)this.context.getSAFContext().getLocalStorage().load(FILENAME_OPTIONS);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to load application options from 'st-options.xml', using default values ...", e);
        }
        if (this.options == null) {
            this.options = STOptions.createDefaultInstance();
        }
    }

    @Override
    public void storeOptions() {
        try {
            this.context.getSAFContext().getLocalStorage().save(this.options, FILENAME_OPTIONS);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "Failed to write application options to 'st-options.xml' ...", ioe);
        }
    }

    @Override
    public void createApplicationDirectory() throws STException {
        File fDataDirectory = new File(this.dataDirectory);
        if (!(fDataDirectory.exists() && fDataDirectory.isDirectory() || fDataDirectory.mkdir())) {
            throw new STException(STExceptionID.DOCUMENT_CREATE_APP_DIRECTORY, "Failed to create application data directory '" + this.dataDirectory + "' ...");
        }
    }

    @Override
    public IdDateObjectList<Exercise> getFilterableExerciseList() {
        if (this.filterEnabled && this.currentFilter != null) {
            return this.exerciseList.getExercisesForFilter(this.currentFilter);
        }
        return this.exerciseList;
    }

    @Override
    public void readApplicationData() throws STException {
        try {
            this.sportTypeList = this.storage.readSportTypeList(String.valueOf(this.dataDirectory) + "/" + FILENAME_SPORT_TYPE_LIST);
            this.exerciseList = this.storage.readExerciseList(String.valueOf(this.dataDirectory) + "/" + FILENAME_EXERCISE_LIST, this.sportTypeList);
            this.noteList = this.storage.readNoteList(String.valueOf(this.dataDirectory) + "/" + FILENAME_NOTE_LIST);
            this.weightList = this.storage.readWeightList(String.valueOf(this.dataDirectory) + "/" + FILENAME_WEIGHT_LIST);
        }
        finally {
            this.registerListChangeListener();
            this.dirtyData = false;
        }
    }

    @Override
    public void storeApplicationData() throws STException {
        this.storage.storeSportTypeList(this.sportTypeList, String.valueOf(this.dataDirectory) + "/" + FILENAME_SPORT_TYPE_LIST);
        this.storage.storeExerciseList(this.exerciseList, String.valueOf(this.dataDirectory) + "/" + FILENAME_EXERCISE_LIST);
        this.storage.storeNoteList(this.noteList, String.valueOf(this.dataDirectory) + "/" + FILENAME_NOTE_LIST);
        this.storage.storeWeightList(this.weightList, String.valueOf(this.dataDirectory) + "/" + FILENAME_WEIGHT_LIST);
        this.dirtyData = false;
    }

    @Override
    public void listChanged() {
        this.dirtyData = true;
    }

    private void registerListChangeListener() {
        this.sportTypeList.addListChangeListener(this);
        this.exerciseList.addListChangeListener(this);
        this.noteList.addListChangeListener(this);
        this.weightList.addListChangeListener(this);
    }
}

