/*
 * Decompiled with CFR 0.152.
 */
package de.saring.exerciseviewer.gui.panels;

import de.saring.exerciseviewer.data.EVExercise;
import de.saring.exerciseviewer.data.HeartRateLimit;
import de.saring.exerciseviewer.gui.EVContext;
import de.saring.exerciseviewer.gui.panels.BasePanel;
import de.saring.exerciseviewer.gui.panels.DiagramPanel;
import de.saring.util.unitcalc.FormatUtils;
import java.awt.GridLayout;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;

public class MainPanel
extends BasePanel {
    private static final String ACTION_UPDATE_RANGE_TIMES = "pv.main.update_range_times";
    private DiagramPanel diagramPanel;
    private JComboBox cbRange;
    private JLabel laAltitude;
    private JLabel laAltitudeValue;
    private JLabel laAverage;
    private JLabel laAverageValue;
    private JLabel laCadence;
    private JLabel laCadenceValue;
    private JLabel laDate;
    private JLabel laDateValue;
    private JLabel laDuration;
    private JLabel laDurationValue;
    private JLabel laEnergy;
    private JLabel laEnergyValue;
    private JLabel laGeneralData;
    private JLabel laHeartRateData;
    private JLabel laHeartRateLimits;
    private JLabel laMaximum;
    private JLabel laMaximumValue;
    private JLabel laOdometer;
    private JLabel laOdometerValue;
    private JLabel laPower;
    private JLabel laPowerValue;
    private JLabel laRange;
    private JLabel laRecordingMode;
    private JLabel laSpeed;
    private JLabel laSpeedValue;
    private JLabel laStatistics;
    private JLabel laTimeAbove;
    private JLabel laTimeAboveValue;
    private JLabel laTimeBelow;
    private JLabel laTimeBelowValue;
    private JLabel laTimeWithin;
    private JLabel laTimeWithinValue;
    private JLabel laTotalEnergy;
    private JLabel laTotalEnergyValue;
    private JLabel laTotalExerciseTime;
    private JLabel laTotalExerciseTimeValue;
    private JLabel laTotalRidingTime;
    private JLabel laTotalRidingTimeValue;
    private JLabel laType;
    private JLabel laTypeValue;
    private JLabel laUser;
    private JLabel laUserValue;
    private JPanel pLeft;
    private JPanel pRight;

    @Inject
    public MainPanel(EVContext context) {
        super(context);
        this.initComponents();
        ApplicationActionMap actionMap = this.getContext().getSAFContext().getActionMap(this.getClass(), (Object)this);
        this.cbRange.setAction(actionMap.get(ACTION_UPDATE_RANGE_TIMES));
    }

    @Override
    public void displayExercise() {
        EVExercise exercise = this.getDocument().getExercise();
        FormatUtils formatUtils = this.getContext().getFormatUtils();
        this.laTypeValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laUserValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laDateValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laDurationValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laEnergyValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laAverageValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laMaximumValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laTimeBelowValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laTimeWithinValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laTimeAboveValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laAltitudeValue.setText(this.getContext().getResReader().getString("common.disabled", new Object[0]));
        this.laSpeedValue.setText(this.getContext().getResReader().getString("common.disabled", new Object[0]));
        this.laCadenceValue.setText(this.getContext().getResReader().getString("common.disabled", new Object[0]));
        this.laPowerValue.setText(this.getContext().getResReader().getString("common.disabled", new Object[0]));
        this.laTotalExerciseTimeValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laTotalRidingTimeValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laTotalEnergyValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laOdometerValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laTypeValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laUserValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laEnergyValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laTotalExerciseTimeValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laTotalRidingTimeValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laTotalEnergyValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        if (exercise.getFileType() != EVExercise.ExerciseFileType.HRM) {
            if (exercise.getType() > 0) {
                this.laTypeValue.setText(exercise.getType() + " (" + exercise.getTypeLabel() + ")");
            }
            if (exercise.getUserID() > 0) {
                this.laUserValue.setText("" + exercise.getUserID());
            }
            if (exercise.getEnergy() > 0) {
                this.laEnergyValue.setText(formatUtils.caloriesToString(exercise.getEnergy()));
            }
            if (exercise.getSumExerciseTime() > 0) {
                this.laTotalExerciseTimeValue.setText(formatUtils.minutes2TimeString(exercise.getSumExerciseTime()));
            }
            if (exercise.getEnergyTotal() > 0) {
                this.laTotalEnergyValue.setText(formatUtils.caloriesToString(exercise.getEnergyTotal()));
            }
            if (exercise.getFileType() == EVExercise.ExerciseFileType.S710RAW) {
                this.laTotalRidingTimeValue.setText(formatUtils.minutes2TimeString(exercise.getSumRideTime()));
            }
        }
        if (exercise.getDate() != null) {
            DateFormat sdFormat = SimpleDateFormat.getDateTimeInstance(2, 2);
            this.laDateValue.setText(sdFormat.format(exercise.getDate()));
        }
        if (exercise.getDuration() > 0) {
            this.laDurationValue.setText(formatUtils.tenthSeconds2TimeString(exercise.getDuration()));
        }
        if (exercise.getHeartRateAVG() > 0) {
            this.laAverageValue.setText(formatUtils.heartRateToString((int)exercise.getHeartRateAVG()));
        }
        if (exercise.getHeartRateMax() > 0) {
            this.laMaximumValue.setText(formatUtils.heartRateToString((int)exercise.getHeartRateMax()));
        }
        this.laAltitudeValue.setText(this.boolean2EnabledString(exercise.getRecordingMode().isAltitude()));
        this.laSpeedValue.setText(this.boolean2EnabledString(exercise.getRecordingMode().isSpeed()));
        this.laCadenceValue.setText(this.boolean2EnabledString(exercise.getRecordingMode().isCadence()));
        this.laPowerValue.setText(this.boolean2EnabledString(exercise.getRecordingMode().isPower()));
        if (exercise.getOdometer() != 0) {
            this.laOdometerValue.setText(formatUtils.distanceToString((double)exercise.getOdometer(), 2));
        }
        this.fillHeartRateRanges();
    }

    public void setDiagramPanel(DiagramPanel diagramPanel) {
        this.diagramPanel = diagramPanel;
    }

    private String boolean2EnabledString(boolean fEnabled) {
        if (fEnabled) {
            return this.getContext().getResReader().getString("common.enabled", new Object[0]);
        }
        return this.getContext().getResReader().getString("common.disabled", new Object[0]);
    }

    private void fillHeartRateRanges() {
        EVExercise exercise = this.getDocument().getExercise();
        if (exercise.getHeartRateLimits() != null && exercise.getHeartRateLimits().length > 0) {
            HeartRateLimit[] heartRateLimitArray = exercise.getHeartRateLimits();
            int n = heartRateLimitArray.length;
            int n2 = 0;
            while (n2 < n) {
                HeartRateLimit limit = heartRateLimitArray[n2];
                String unitName = limit.isAbsoluteRange() ? "bpm" : "%";
                this.cbRange.addItem(limit.getLowerHeartRate() + " - " + limit.getUpperHeartRate() + " " + unitName);
                ++n2;
            }
            this.cbRange.setSelectedIndex(0);
            this.updateHeartRateRangeTimes();
        } else {
            this.cbRange.setEnabled(false);
        }
    }

    @Action(name="pv.main.update_range_times")
    public void updateHeartRateRangeTimes() {
        int index = this.cbRange.getSelectedIndex();
        EVExercise exercise = this.getDocument().getExercise();
        FormatUtils formatUtils = this.getContext().getFormatUtils();
        HeartRateLimit limit = exercise.getHeartRateLimits()[index];
        int percentsBelow = 0;
        int percentsWithin = 0;
        int percentsAbove = 0;
        if (exercise.getDuration() > 0) {
            percentsBelow = (int)Math.round((double)limit.getTimeBelow() / (double)exercise.getDuration() * 10.0 * 100.0);
            percentsWithin = (int)Math.round((double)limit.getTimeWithin() / (double)exercise.getDuration() * 10.0 * 100.0);
            percentsAbove = (int)Math.round((double)limit.getTimeAbove() / (double)exercise.getDuration() * 10.0 * 100.0);
        }
        this.laTimeBelowValue.setText(String.valueOf(formatUtils.seconds2TimeString(limit.getTimeBelow())) + "   (" + percentsBelow + " %)");
        this.laTimeWithinValue.setText(String.valueOf(formatUtils.seconds2TimeString(limit.getTimeWithin())) + "   (" + percentsWithin + " %)");
        this.laTimeAboveValue.setText(String.valueOf(formatUtils.seconds2TimeString(limit.getTimeAbove())) + "   (" + percentsAbove + " %)");
        this.diagramPanel.displayDiagramForHeartrateRange(index);
    }

    private void initComponents() {
        this.pLeft = new JPanel();
        this.laHeartRateLimits = new JLabel();
        this.laHeartRateData = new JLabel();
        this.laDuration = new JLabel();
        this.laDate = new JLabel();
        this.laEnergy = new JLabel();
        this.laUser = new JLabel();
        this.laType = new JLabel();
        this.laMaximum = new JLabel();
        this.laAverage = new JLabel();
        this.laTimeBelow = new JLabel();
        this.laRange = new JLabel();
        this.laTimeWithin = new JLabel();
        this.laTimeAbove = new JLabel();
        this.laTypeValue = new JLabel();
        this.laUserValue = new JLabel();
        this.laDateValue = new JLabel();
        this.laDurationValue = new JLabel();
        this.laEnergyValue = new JLabel();
        this.laMaximumValue = new JLabel();
        this.laAverageValue = new JLabel();
        this.laTimeBelowValue = new JLabel();
        this.laTimeAboveValue = new JLabel();
        this.laTimeWithinValue = new JLabel();
        this.cbRange = new JComboBox();
        this.laGeneralData = new JLabel();
        this.pRight = new JPanel();
        this.laRecordingMode = new JLabel();
        this.laAltitude = new JLabel();
        this.laSpeed = new JLabel();
        this.laCadence = new JLabel();
        this.laPower = new JLabel();
        this.laStatistics = new JLabel();
        this.laTotalExerciseTime = new JLabel();
        this.laTotalRidingTime = new JLabel();
        this.laTotalEnergy = new JLabel();
        this.laOdometer = new JLabel();
        this.laAltitudeValue = new JLabel();
        this.laSpeedValue = new JLabel();
        this.laCadenceValue = new JLabel();
        this.laPowerValue = new JLabel();
        this.laTotalExerciseTimeValue = new JLabel();
        this.laTotalRidingTimeValue = new JLabel();
        this.laTotalEnergyValue = new JLabel();
        this.laOdometerValue = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new GridLayout(1, 2, 20, 20));
        this.laHeartRateLimits.setFont(this.laHeartRateLimits.getFont().deriveFont(this.laHeartRateLimits.getFont().getStyle() | 1));
        this.laHeartRateLimits.setText("_Heart Rate Limits");
        this.laHeartRateLimits.setName("pv.main.heartrate_limits");
        this.laHeartRateData.setFont(this.laHeartRateData.getFont().deriveFont(this.laHeartRateData.getFont().getStyle() | 1));
        this.laHeartRateData.setText("_Heart Rate Data");
        this.laHeartRateData.setName("pv.main.heartrate_data");
        this.laDuration.setText("_Duration:");
        this.laDuration.setName("pv.main.duration");
        this.laDate.setText("_Date:");
        this.laDate.setName("pv.main.date");
        this.laEnergy.setText("_Energy:");
        this.laEnergy.setName("pv.main.energy");
        this.laUser.setText("_User:");
        this.laUser.setName("pv.main.user");
        this.laType.setText("_Type:");
        this.laType.setName("pv.main.type");
        this.laMaximum.setText("_Maximum:");
        this.laMaximum.setName("pv.main.maximum");
        this.laAverage.setText("_Average:");
        this.laAverage.setName("pv.main.average");
        this.laTimeBelow.setText("_Time below:");
        this.laTimeBelow.setName("pv.main.time_below");
        this.laRange.setText("_Range:");
        this.laRange.setName("pv.main.range");
        this.laTimeWithin.setText("_Time within:");
        this.laTimeWithin.setName("pv.main.time_within");
        this.laTimeAbove.setText("_Time above:");
        this.laTimeAbove.setName("pv.main.time_above");
        this.laTypeValue.setText("_n.a.");
        this.laUserValue.setText("_n.a.");
        this.laDateValue.setText("_n.a.");
        this.laDurationValue.setText("_n.a.");
        this.laEnergyValue.setText("_n.a.");
        this.laMaximumValue.setText("_n.a.");
        this.laAverageValue.setText("_n.a.");
        this.laTimeBelowValue.setText("_n.a.");
        this.laTimeAboveValue.setText("_n.a.");
        this.laTimeWithinValue.setText("_n.a.");
        this.laGeneralData.setFont(this.laGeneralData.getFont().deriveFont(this.laGeneralData.getFont().getStyle() | 1));
        this.laGeneralData.setText("_General Data");
        this.laGeneralData.setName("pv.main.general_data");
        GroupLayout pLeftLayout = new GroupLayout(this.pLeft);
        this.pLeft.setLayout(pLeftLayout);
        pLeftLayout.setHorizontalGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pLeftLayout.createSequentialGroup().addGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pLeftLayout.createSequentialGroup().addContainerGap().addGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laRange).addComponent(this.laTimeBelow).addComponent(this.laTimeWithin).addComponent(this.laTimeAbove)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laAverageValue, -1, 141, Short.MAX_VALUE).addComponent(this.laMaximumValue, -1, 141, Short.MAX_VALUE).addComponent(this.laEnergyValue, -1, 141, Short.MAX_VALUE).addComponent(this.laDurationValue, -1, 141, Short.MAX_VALUE).addComponent(this.laDateValue, -1, 141, Short.MAX_VALUE).addComponent(this.laUserValue, -1, 141, Short.MAX_VALUE).addComponent(this.laTypeValue, -1, 141, Short.MAX_VALUE).addComponent(this.laTimeBelowValue, -1, 141, Short.MAX_VALUE).addComponent(this.laTimeWithinValue, -1, 141, Short.MAX_VALUE).addComponent(this.laTimeAboveValue, -1, 141, Short.MAX_VALUE).addComponent(this.cbRange, -2, -1, -2))).addComponent(this.laGeneralData).addComponent(this.laHeartRateData).addComponent(this.laHeartRateLimits).addGroup(pLeftLayout.createSequentialGroup().addContainerGap().addGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laMaximum).addComponent(this.laAverage)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 164, Short.MAX_VALUE)).addGroup(pLeftLayout.createSequentialGroup().addContainerGap().addGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laType).addComponent(this.laUser).addComponent(this.laDate).addComponent(this.laDuration).addComponent(this.laEnergy)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 172, Short.MAX_VALUE))).addContainerGap()));
        pLeftLayout.setVerticalGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pLeftLayout.createSequentialGroup().addComponent(this.laGeneralData).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pLeftLayout.createSequentialGroup().addComponent(this.laType).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.laUser).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.laDate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.laDuration).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.laEnergy)).addGroup(pLeftLayout.createSequentialGroup().addComponent(this.laTypeValue).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.laUserValue).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.laDateValue).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.laDurationValue).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.laEnergyValue))).addGap(25, 25, 25).addComponent(this.laHeartRateData).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pLeftLayout.createSequentialGroup().addComponent(this.laAverage).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.laMaximum)).addGroup(pLeftLayout.createSequentialGroup().addComponent(this.laAverageValue).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.laMaximumValue))).addGap(25, 25, 25).addComponent(this.laHeartRateLimits).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pLeftLayout.createSequentialGroup().addComponent(this.laTimeWithin).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.laTimeAbove)).addGroup(pLeftLayout.createSequentialGroup().addGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbRange, -2, -1, -2).addComponent(this.laRange, -2, 15, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laTimeBelowValue).addComponent(this.laTimeBelow)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.laTimeWithinValue).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.laTimeAboveValue))).addContainerGap(-1, Short.MAX_VALUE)));
        this.add(this.pLeft);
        this.laRecordingMode.setFont(this.laRecordingMode.getFont().deriveFont(this.laRecordingMode.getFont().getStyle() | 1));
        this.laRecordingMode.setText("_Recording Mode");
        this.laRecordingMode.setName("pv.main.recording_mode");
        this.laAltitude.setText("_Altitude:");
        this.laAltitude.setName("pv.main.altitude");
        this.laSpeed.setText("_Speed:");
        this.laSpeed.setName("pv.main.speed");
        this.laCadence.setText("_Cadence:");
        this.laCadence.setName("pv.main.cadence");
        this.laPower.setText("_Power:");
        this.laPower.setName("pv.main.power");
        this.laStatistics.setFont(this.laStatistics.getFont().deriveFont(this.laStatistics.getFont().getStyle() | 1));
        this.laStatistics.setText("_Statistics");
        this.laStatistics.setName("pv.main.statistics");
        this.laTotalExerciseTime.setText("_Total exercise time:");
        this.laTotalExerciseTime.setName("pv.main.total_exercise_time");
        this.laTotalRidingTime.setText("_Total riding time:");
        this.laTotalRidingTime.setName("pv.main.total_riding_time");
        this.laTotalEnergy.setText("_Total energy:");
        this.laTotalEnergy.setName("pv.main.total_energy");
        this.laOdometer.setText("_Odometer:");
        this.laOdometer.setName("pv.main.odometer");
        this.laAltitudeValue.setText("_disabled");
        this.laSpeedValue.setText("_disabled");
        this.laCadenceValue.setText("_disabled");
        this.laPowerValue.setText("_disabled");
        this.laTotalExerciseTimeValue.setText("_n.a.");
        this.laTotalRidingTimeValue.setText("_n.a.");
        this.laTotalEnergyValue.setText("_n.a.");
        this.laOdometerValue.setText("_n.a.");
        GroupLayout pRightLayout = new GroupLayout(this.pRight);
        this.pRight.setLayout(pRightLayout);
        pRightLayout.setHorizontalGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pRightLayout.createSequentialGroup().addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laStatistics).addComponent(this.laRecordingMode).addGroup(pRightLayout.createSequentialGroup().addContainerGap().addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laTotalExerciseTime).addComponent(this.laTotalRidingTime).addComponent(this.laTotalEnergy).addComponent(this.laOdometer).addComponent(this.laAltitude).addComponent(this.laSpeed).addComponent(this.laCadence).addComponent(this.laPower)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laAltitudeValue, -1, 88, Short.MAX_VALUE).addComponent(this.laSpeedValue, -1, 88, Short.MAX_VALUE).addComponent(this.laCadenceValue, -1, 88, Short.MAX_VALUE).addComponent(this.laPowerValue, -1, 88, Short.MAX_VALUE).addComponent(this.laTotalExerciseTimeValue, -1, 88, Short.MAX_VALUE).addComponent(this.laTotalRidingTimeValue, -1, 88, Short.MAX_VALUE).addComponent(this.laTotalEnergyValue, -1, 88, Short.MAX_VALUE).addComponent(this.laOdometerValue, -1, 88, Short.MAX_VALUE)))).addContainerGap()));
        pRightLayout.setVerticalGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pRightLayout.createSequentialGroup().addComponent(this.laRecordingMode).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laAltitude).addComponent(this.laAltitudeValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laSpeed).addComponent(this.laSpeedValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laCadence).addComponent(this.laCadenceValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laPower).addComponent(this.laPowerValue)).addGap(25, 25, 25).addComponent(this.laStatistics).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laTotalExerciseTime).addComponent(this.laTotalExerciseTimeValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laTotalRidingTime).addComponent(this.laTotalRidingTimeValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laTotalEnergy).addComponent(this.laTotalEnergyValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laOdometer).addComponent(this.laOdometerValue)).addContainerGap(133, Short.MAX_VALUE)));
        this.add(this.pRight);
    }
}

