/*
 * Decompiled with CFR 0.152.
 */
package de.saring.exerciseviewer.gui.panels;

import de.saring.exerciseviewer.data.EVExercise;
import de.saring.exerciseviewer.data.ExerciseSample;
import de.saring.exerciseviewer.gui.EVContext;
import de.saring.exerciseviewer.gui.panels.BasePanel;
import de.saring.util.gui.ListUtils;
import de.saring.util.gui.TableCellRendererOddEven;
import de.saring.util.unitcalc.FormatUtils;
import java.awt.Component;
import java.awt.Dimension;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class SamplePanel
extends BasePanel {
    private static final int COLUMN_COUNT = 7;
    private static final int COLUMN_TIME = 0;
    private static final int COLUMN_HEARTRATE = 1;
    private static final int COLUMN_ALTITUDE = 2;
    private static final int COLUMN_SPEED = 3;
    private static final int COLUMN_DISTANCE = 4;
    private static final int COLUMN_CADENCE = 5;
    private static final int COLUMN_TEMPERATURE = 6;
    private String[] columnNames;
    private JLabel laSamples;
    private JScrollPane spSamples;
    private JTable tbSamples;

    @Inject
    public SamplePanel(EVContext context) {
        super(context);
        this.initComponents();
        this.columnNames = new String[7];
        this.columnNames[0] = this.getContext().getResReader().getString("pv.samples.time", new Object[0]);
        this.columnNames[1] = this.getContext().getResReader().getString("pv.samples.heartrate", new Object[0]);
        this.columnNames[2] = this.getContext().getResReader().getString("pv.samples.altitude", new Object[0]);
        this.columnNames[3] = this.getContext().getResReader().getString("pv.samples.speed", new Object[0]);
        this.columnNames[4] = this.getContext().getResReader().getString("pv.samples.distance", new Object[0]);
        this.columnNames[5] = this.getContext().getResReader().getString("pv.samples.cadence", new Object[0]);
        this.columnNames[6] = this.getContext().getResReader().getString("pv.samples.temperature", new Object[0]);
        this.tbSamples.setSelectionMode(0);
        ListUtils.increaseTableRowHeight((JTable)this.tbSamples);
    }

    @Override
    public void displayExercise() {
        final EVExercise exercise = this.getDocument().getExercise();
        this.tbSamples.setModel(new AbstractTableModel(){

            @Override
            public String getColumnName(int col) {
                return SamplePanel.this.columnNames[col];
            }

            @Override
            public int getRowCount() {
                if (exercise.getSampleList() != null) {
                    return exercise.getSampleList().length;
                }
                return 0;
            }

            @Override
            public int getColumnCount() {
                return SamplePanel.this.columnNames.length;
            }

            @Override
            public Class<?> getColumnClass(int col) {
                switch (col) {
                    case 0: 
                    case 4: {
                        return Integer.class;
                    }
                    case 1: 
                    case 2: 
                    case 5: 
                    case 6: {
                        return Short.class;
                    }
                    case 3: {
                        return Float.class;
                    }
                }
                return Object.class;
            }

            @Override
            public Object getValueAt(int row, int col) {
                ExerciseSample sample = exercise.getSampleList()[row];
                switch (col) {
                    case 0: {
                        return (int)(sample.getTimestamp() / 1000L);
                    }
                    case 1: {
                        return sample.getHeartRate();
                    }
                    case 2: {
                        if (!exercise.getRecordingMode().isAltitude()) break;
                        return sample.getAltitude();
                    }
                    case 3: {
                        if (!exercise.getRecordingMode().isSpeed()) break;
                        return new Float(sample.getSpeed());
                    }
                    case 4: {
                        if (!exercise.getRecordingMode().isSpeed()) break;
                        return sample.getDistance();
                    }
                    case 5: {
                        if (!exercise.getRecordingMode().isCadence()) break;
                        return sample.getCadence();
                    }
                    case 6: {
                        if (!exercise.getRecordingMode().isTemperature()) break;
                        return sample.getTemperature();
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        });
        SampleCellRenderer cellRenderer = new SampleCellRenderer();
        int i = 0;
        while (i < 7) {
            this.tbSamples.getColumnModel().getColumn(i).setCellRenderer((TableCellRenderer)((Object)cellRenderer));
            ++i;
        }
    }

    private void initComponents() {
        this.laSamples = new JLabel();
        this.spSamples = new JScrollPane();
        this.tbSamples = new JTable();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.laSamples.setFont(this.laSamples.getFont().deriveFont(this.laSamples.getFont().getStyle() | 1));
        this.laSamples.setText("_All Recorded Samples");
        this.laSamples.setName("pv.samples.recorded_samples");
        this.tbSamples.setAutoCreateRowSorter(true);
        this.tbSamples.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.tbSamples.setIntercellSpacing(new Dimension(0, 0));
        this.tbSamples.setShowHorizontalLines(false);
        this.tbSamples.setShowVerticalLines(false);
        this.tbSamples.getTableHeader().setReorderingAllowed(false);
        this.spSamples.setViewportView(this.tbSamples);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.laSamples).addContainerGap(380, Short.MAX_VALUE)).addComponent(this.spSamples, -1, 549, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.laSamples).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spSamples, -1, 326, Short.MAX_VALUE)));
    }

    class SampleCellRenderer
    extends TableCellRendererOddEven {
        final FormatUtils formatUtils;

        public SampleCellRenderer() {
            super(SamplePanel.this.getContext().getResReader().getColor("common.table.background_odd"), SamplePanel.this.getContext().getResReader().getColor("common.table.background_even"));
            this.formatUtils = SamplePanel.this.getContext().getFormatUtils();
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, rowIndex, vColIndex);
            String text = null;
            switch (vColIndex) {
                case 0: {
                    text = this.formatUtils.seconds2TimeString(((Integer)value).intValue());
                    break;
                }
                case 1: {
                    text = this.formatUtils.heartRateToString((int)((Short)value).shortValue());
                    break;
                }
                case 2: {
                    if (value == null) break;
                    text = this.formatUtils.heightToString((int)((Short)value).shortValue());
                    break;
                }
                case 3: {
                    if (value == null) break;
                    text = this.formatUtils.speedToString(((Float)value).floatValue(), 2);
                    break;
                }
                case 4: {
                    if (value == null) break;
                    text = this.formatUtils.distanceToString((double)((float)((Integer)value).intValue() / 1000.0f), 3);
                    break;
                }
                case 5: {
                    if (value == null) break;
                    text = this.formatUtils.cadenceToString((int)((Short)value).shortValue());
                    break;
                }
                case 6: {
                    if (value == null) break;
                    text = this.formatUtils.temperatureToString(((Short)value).shortValue());
                }
            }
            this.setText(text);
            return component;
        }
    }
}

