/*
 * Decompiled with CFR 0.152.
 */
package de.saring.exerciseviewer.parser.impl;

import de.saring.exerciseviewer.core.EVException;
import de.saring.exerciseviewer.data.EVExercise;
import de.saring.exerciseviewer.data.ExerciseSample;
import de.saring.exerciseviewer.data.ExerciseSpeed;
import de.saring.exerciseviewer.data.HeartRateLimit;
import de.saring.exerciseviewer.data.Lap;
import de.saring.exerciseviewer.data.LapSpeed;
import de.saring.exerciseviewer.data.RecordingMode;
import de.saring.exerciseviewer.parser.AbstractExerciseParser;
import de.saring.exerciseviewer.parser.ExerciseParserInfo;
import de.saring.util.unitcalc.ConvertUtils;
import java.util.Calendar;

public class PolarHsrRawParser
extends AbstractExerciseParser {
    private final ExerciseParserInfo info = new ExerciseParserInfo("Polar HSR", new String[]{"hsr", "HSR"});
    private int[] fileContent;
    int[][] s;

    @Override
    public ExerciseParserInfo getInfo() {
        return this.info;
    }

    private int sdata(int section, int index) throws EVException {
        section += index / 60;
        index %= 60;
        if (section >= this.s.length) {
            throw new EVException(String.format("Error! Section %d does not exist", section));
        }
        if (index >= this.s[section].length) {
            throw new EVException(String.format("Error! Byte %d in section %d does not exist (%d)", index, section, this.s[section].length));
        }
        return this.s[section][index];
    }

    @Override
    public EVExercise parseExercise(String filename) throws EVException {
        int lapseccnt;
        short[] interval = new short[]{5, 15, 30, 60, 120, 240, 300, 480};
        this.fileContent = this.readFileToByteArray(filename);
        EVExercise exercise = new EVExercise();
        exercise.setFileType(EVExercise.ExerciseFileType.S510RAW);
        int bytesInFile = this.fileContent[1] * 256 + this.fileContent[0];
        if (bytesInFile != this.fileContent.length) {
            throw new EVException("The exercise file is not valid, the file length is not correct ...");
        }
        int bytesInData = bytesInFile - 2;
        int[] data = new int[bytesInData];
        System.arraycopy(this.fileContent, 2, data, 0, bytesInData);
        int ii = 0;
        int sectionIx = 0;
        int sectionsInData = 0;
        this.s = new int[1][1];
        while (ii < bytesInData) {
            if (sectionIx == 0) {
                if (data[0] == 85) {
                    sectionsInData = data[3];
                    this.s = new int[sectionsInData + 1][];
                    ++sectionIx;
                    ii += 8;
                    continue;
                }
                throw new EVException("The exercise file is not valid, the first section could not be found");
            }
            if (data[ii] == 85) {
                if (data[ii + 1] != sectionIx) {
                    throw new EVException("Wrong section index in file");
                }
                int sectionLength = data[ii + 2];
                this.s[sectionIx] = new int[sectionLength];
                System.arraycopy(data, ii + 3, this.s[sectionIx], 0, sectionLength);
                ++sectionIx;
                ii += sectionLength + 5;
                continue;
            }
            if (sectionIx - 1 != sectionsInData) {
                throw new EVException("Could not find all sections");
            }
            if (data[ii] == 7) break;
            throw new EVException("Could not find no-more-sections byte in file");
        }
        int numberOfSamples = this.sdata(1, 0);
        int intix = this.sdata(1, 1) - 95;
        if (intix >= interval.length) {
            throw new EVException("Recording interval is not valid ...");
        }
        exercise.setRecordingInterval(interval[intix]);
        boolean fHeartRateRangeAbsolute = true;
        exercise.setType((byte)this.sdata(1, 2));
        if (exercise.getType() > 0) {
            StringBuilder sbExerciseLabel = new StringBuilder();
            int i = 0;
            while (i < 7) {
                sbExerciseLabel.append(this.decodeChar(this.sdata(1, i + 3)));
                ++i;
            }
            exercise.setTypeLabel(sbExerciseLabel.toString());
        } else {
            exercise.setTypeLabel("BasicUse");
        }
        int dateSeconds = this.decodeBCD(this.sdata(1, 10));
        int dateMinutes = this.decodeBCD(this.sdata(1, 11));
        int dateHours = this.decodeBCD(this.sdata(1, 12) & 0x7F);
        int dateDay = this.decodeBCD(this.sdata(1, 13) & 0x7F);
        int dateYear = 2000 + this.sdata(1, 14);
        int dateMonth = this.sdata(1, 15) & 0xF;
        if (dateHours < 12 && (this.sdata(1, 12) & 0x80) == 128) {
            dateHours += 12;
        }
        Calendar calDate = Calendar.getInstance();
        calDate.set(dateYear, dateMonth - 1, dateDay, dateHours, dateMinutes, dateSeconds);
        exercise.setDate(calDate.getTime());
        int durationTenthSeconds = this.sdata(1, 15) >> 4;
        int durationSeconds = this.decodeBCD(this.sdata(1, 16));
        int durationMinutes = this.decodeBCD(this.sdata(1, 17));
        int durationHours = this.decodeBCD(this.sdata(1, 18));
        exercise.setDuration(durationHours * 60 * 60 * 10 + durationMinutes * 60 * 10 + durationSeconds * 10 + durationTenthSeconds);
        exercise.setHeartRateAVG((short)this.sdata(1, 19));
        exercise.setHeartRateMax((short)this.sdata(1, 20));
        int numberOfMeas = this.decodeBCD(this.sdata(1, 21));
        int numberOfLaps = this.decodeBCD(this.sdata(1, 22));
        exercise.setUserID((byte)this.decodeBCD(this.sdata(1, 24)));
        boolean fMetricUnits = (this.sdata(1, 25) & 2) == 0;
        RecordingMode recMode = new RecordingMode();
        exercise.setRecordingMode(recMode);
        boolean fBike2 = (this.sdata(1, 26) & 0x20) == 32;
        boolean fBike1 = (this.sdata(1, 26) & 0x10) == 16;
        recMode.setPower(false);
        recMode.setCadence(false);
        recMode.setAltitude(false);
        if (!fBike1 && !fBike2) {
            recMode.setSpeed(false);
            recMode.setBikeNumber((byte)0);
        } else {
            recMode.setSpeed(true);
            if (fBike1) {
                recMode.setBikeNumber((byte)1);
            } else {
                recMode.setBikeNumber((byte)2);
            }
        }
        recMode.setIntervalExercise(numberOfMeas != numberOfLaps);
        int indexHRLimitStart = 28;
        exercise.setHeartRateLimits(new HeartRateLimit[3]);
        exercise.getHeartRateLimits()[0] = this.decodeHeartRateLimit(indexHRLimitStart + 0, indexHRLimitStart + 9);
        exercise.getHeartRateLimits()[1] = this.decodeHeartRateLimit(indexHRLimitStart + 2, indexHRLimitStart + 18);
        exercise.getHeartRateLimits()[2] = this.decodeHeartRateLimit(indexHRLimitStart + 4, indexHRLimitStart + 27);
        HeartRateLimit[] heartRateLimitArray = exercise.getHeartRateLimits();
        int n = heartRateLimitArray.length;
        int n2 = 0;
        while (n2 < n) {
            HeartRateLimit hrLimit = heartRateLimitArray[n2];
            hrLimit.setAbsoluteRange(fHeartRateRangeAbsolute);
            ++n2;
        }
        int energyPart1 = this.decodeBCD(this.sdata(1, 69));
        int energyPart2 = this.decodeBCD(this.sdata(1, 70));
        int energyPart3 = this.decodeBCD(this.sdata(1, 71));
        exercise.setEnergy((energyPart1 + energyPart2 * 100 + energyPart3 * 10000) / 10);
        int energyTotalPart1 = this.decodeBCD(this.sdata(1, 72));
        int energyTotalPart2 = this.decodeBCD(this.sdata(1, 73));
        int energyTotalPart3 = this.decodeBCD(this.sdata(1, 74));
        exercise.setEnergyTotal(energyTotalPart1 + energyTotalPart2 * 100 + energyTotalPart3 * 10000);
        int cumWorkoutPart1 = this.decodeBCD(this.sdata(1, 75));
        int cumWorkoutPart2 = this.decodeBCD(this.sdata(1, 76));
        int cumWorkoutPart3 = this.decodeBCD(this.sdata(1, 77));
        exercise.setSumExerciseTime(cumWorkoutPart3 + cumWorkoutPart1 * 60 + cumWorkoutPart2 * 60 * 100);
        int cumRidePart1 = this.decodeBCD(this.sdata(1, 78));
        int cumRidePart2 = this.decodeBCD(this.sdata(1, 79));
        int cumRidePart3 = this.decodeBCD(this.sdata(1, 80));
        exercise.setSumRideTime(cumRidePart3 + cumRidePart1 * 60 + cumRidePart2 * 60 * 100);
        int odometerPart1 = this.decodeBCD(this.sdata(1, 81));
        int odometerPart2 = this.decodeBCD(this.sdata(1, 82));
        int odometerPart3 = this.decodeBCD(this.sdata(1, 83));
        int odometer = odometerPart1 + odometerPart2 * 100 + odometerPart3 * 10000;
        if (fMetricUnits) {
            exercise.setOdometer(odometer);
        } else {
            exercise.setOdometer(ConvertUtils.convertMiles2Kilometer((int)odometer));
        }
        if (recMode.isSpeed()) {
            ExerciseSpeed speed = new ExerciseSpeed();
            exercise.setSpeed(speed);
            int distance = (this.sdata(1, 84) + (this.sdata(1, 85) << 8)) * 100;
            if (fMetricUnits) {
                speed.setDistance(distance);
            } else {
                speed.setDistance(ConvertUtils.convertMiles2Kilometer((int)distance));
            }
            int avgSpeedPart1 = this.sdata(1, 86);
            int avgSpeedPart2 = this.sdata(1, 87) & 0xF;
            float avgSpeed = (float)(avgSpeedPart2 << 8 | avgSpeedPart1) / 16.0f;
            if (fMetricUnits) {
                speed.setSpeedAVG(avgSpeed);
            } else {
                speed.setSpeedAVG((float)ConvertUtils.convertMiles2Kilometer((double)avgSpeed));
            }
            int maxSpeedPart1 = this.sdata(1, 87) >> 4;
            int maxSpeedPart2 = this.sdata(1, 88);
            float maxSpeed = (float)(maxSpeedPart2 << 4 | maxSpeedPart1) / 16.0f;
            if (fMetricUnits) {
                speed.setSpeedMax(maxSpeed);
            } else {
                speed.setSpeedMax((float)ConvertUtils.convertMiles2Kilometer((double)maxSpeed));
            }
        }
        int lapSize = 11;
        if (recMode.isIntervalExercise()) {
            lapSize += 5;
        }
        if (recMode.isAltitude()) {
            lapSize += 5;
        }
        int lapsec = 4 + (numberOfSamples - 1) / 60;
        if (recMode.isSpeed()) {
            lapsec += 1 + (numberOfSamples - 1) / 60;
        }
        if (this.s[lapsec + (lapseccnt = (int)((double)(numberOfMeas * lapSize) / 60.0 + 0.9999)) - 1].length != numberOfMeas * lapSize % 60) {
            throw new EVException(String.format("Lap-data section (%d) has wrong size (%d instead of %d)", lapsec + lapseccnt - 1, this.s[lapsec + lapseccnt - 1].length, numberOfMeas * lapSize % 60));
        }
        if (recMode.isIntervalExercise()) {
            exercise.setLapList(new Lap[numberOfMeas]);
        } else {
            exercise.setLapList(new Lap[numberOfLaps]);
        }
        int l = 0;
        while (l < exercise.getLapList().length) {
            Lap lap;
            int os = l * lapSize;
            exercise.getLapList()[l] = lap = new Lap();
            int bLapEndHour = this.sdata(lapsec, os + 2);
            int bLapEndMinute = this.sdata(lapsec, os + 1) & 0x3F;
            int bLapEndSecond = this.sdata(lapsec, os + 0) & 0x3F;
            int bLapEndTenthSecond = 4 * (this.sdata(lapsec, os + 1) >> 6) + (this.sdata(lapsec, os + 0) >> 6);
            lap.setTimeSplit(bLapEndTenthSecond + bLapEndSecond * 10 + bLapEndMinute * 60 * 10 + bLapEndHour * 60 * 60 * 10);
            lap.setHeartRateSplit((short)this.sdata(lapsec, os + 3));
            lap.setHeartRateAVG((short)this.sdata(lapsec, os + 4));
            lap.setHeartRateMax((short)this.sdata(lapsec, os + 5));
            if (recMode.isSpeed()) {
                lap.setSpeed(new LapSpeed());
                int lapDistance = this.sdata(lapsec, os + 6);
                lapDistance += this.sdata(lapsec, os + 7) << 8;
                lapDistance *= 100;
                if (fMetricUnits) {
                    lap.getSpeed().setDistance(lapDistance);
                } else {
                    lap.getSpeed().setDistance(ConvertUtils.convertMiles2Kilometer((int)lapDistance));
                }
                float lapEndSpeed = this.sdata(lapsec, os + 9);
                lapEndSpeed += (float)(this.sdata(lapsec, os + 10) << 8);
                lapEndSpeed *= 0.0625f;
                if (fMetricUnits) {
                    lap.getSpeed().setSpeedEnd(lapEndSpeed);
                } else {
                    lap.getSpeed().setSpeedEnd((float)ConvertUtils.convertMiles2Kilometer((double)lapEndSpeed));
                }
            }
            ++l;
        }
        int hrsec = 3;
        int spdsec = 4 + (numberOfSamples - 1) / 60;
        exercise.setSampleList(new ExerciseSample[numberOfSamples]);
        int i = 0;
        while (i < numberOfSamples) {
            ExerciseSample exeSample = new ExerciseSample();
            exeSample.setTimestamp((long)(i * exercise.getRecordingInterval()) * 1000L);
            exercise.getSampleList()[i] = exeSample;
            exeSample.setHeartRate((short)this.sdata(hrsec, i));
            if (recMode.isSpeed()) {
                float sampleSpeed = (float)this.sdata(spdsec, i) / 2.0f;
                if (fMetricUnits) {
                    exeSample.setSpeed(sampleSpeed);
                } else {
                    exeSample.setSpeed((float)ConvertUtils.convertMiles2Kilometer((double)sampleSpeed));
                }
            }
            ++i;
        }
        if (recMode.isSpeed()) {
            double distanceAccum = 0.0;
            ExerciseSample[] exerciseSampleArray = exercise.getSampleList();
            int n3 = exerciseSampleArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ExerciseSample exeSample = exerciseSampleArray[n4];
                exeSample.setDistance((int)distanceAccum);
                distanceAccum += (double)(exeSample.getSpeed() * (float)exercise.getRecordingInterval() / 3.6f);
                ++n4;
            }
        }
        exercise.repairSamples();
        return exercise;
    }

    private char decodeChar(int value) {
        char cDecoded = '?';
        switch (value) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                cDecoded = (char)(48 + value);
                break;
            }
            case 10: {
                cDecoded = ' ';
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                cDecoded = (char)(65 + value - 11);
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                cDecoded = (char)(97 + value - 37);
                break;
            }
            case 63: {
                cDecoded = '-';
                break;
            }
            case 64: {
                cDecoded = '%';
                break;
            }
            case 65: {
                cDecoded = '/';
                break;
            }
            case 66: {
                cDecoded = '(';
                break;
            }
            case 67: {
                cDecoded = ')';
                break;
            }
            case 68: {
                cDecoded = '*';
                break;
            }
            case 69: {
                cDecoded = '+';
                break;
            }
            case 70: {
                cDecoded = '.';
                break;
            }
            case 71: {
                cDecoded = ':';
                break;
            }
            case 72: {
                cDecoded = '?';
                break;
            }
        }
        return cDecoded;
    }

    private int decodeBCD(int value) {
        return (value >> 4) * 10 + (value & 0xF);
    }

    private HeartRateLimit decodeHeartRateLimit(int offsetLimits, int offsetTimes) throws EVException {
        HeartRateLimit hrLimit = new HeartRateLimit();
        hrLimit.setLowerHeartRate((short)this.sdata(1, offsetLimits + 0));
        hrLimit.setUpperHeartRate((short)this.sdata(1, offsetLimits + 1));
        int hrLimitBelowSecs = this.decodeBCD(this.sdata(1, offsetTimes + 0));
        hrLimitBelowSecs += this.decodeBCD(this.sdata(1, offsetTimes + 1)) * 60;
        hrLimit.setTimeBelow(hrLimitBelowSecs += this.decodeBCD(this.sdata(1, offsetTimes + 2)) * 60 * 60);
        int hrLimitWithinSecs = this.decodeBCD(this.sdata(1, offsetTimes + 3));
        hrLimitWithinSecs += this.decodeBCD(this.sdata(1, offsetTimes + 4)) * 60;
        hrLimit.setTimeWithin(hrLimitWithinSecs += this.decodeBCD(this.sdata(1, offsetTimes + 5)) * 60 * 60);
        int hrLimitAboveSecs = this.decodeBCD(this.sdata(1, offsetTimes + 6));
        hrLimitAboveSecs += this.decodeBCD(this.sdata(1, offsetTimes + 7)) * 60;
        hrLimit.setTimeAbove(hrLimitAboveSecs += this.decodeBCD(this.sdata(1, offsetTimes + 8)) * 60 * 60);
        return hrLimit;
    }
}

