/*
 * Decompiled with CFR 0.152.
 */
package de.saring.util.gui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.DateFormat;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXDatePicker;

public final class GuiCreateUtils {
    private GuiCreateUtils() {
    }

    public static JLabel createLabel(String name, boolean boldFont) {
        JLabel label = new JLabel();
        label.setName(name);
        if (boldFont) {
            label.setFont(label.getFont().deriveFont(label.getFont().getStyle() | 1));
        }
        return label;
    }

    public static JXDatePicker createDatePicker() {
        JXDatePicker datePicker = new JXDatePicker();
        datePicker.setFormats(new DateFormat[]{DateFormat.getDateInstance(2)});
        datePicker.setLinkPanel(null);
        return datePicker;
    }

    public static JSpinner createSpinner(SpinnerModel model) {
        JSpinner spinner = new JSpinner(model);
        FocusAdapter focusListenerSelectAll = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                final JTextField tf = (JTextField)e.getSource();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        tf.selectAll();
                    }
                });
            }
        };
        ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().addFocusListener(focusListenerSelectAll);
        GuiCreateUtils.addMouseWheelSupportToSpinner(spinner);
        return spinner;
    }

    public static void addMouseWheelSupportToSpinner(final JSpinner spinner) {
        spinner.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                boolean fForward = e.getWheelRotation() >= 0;
                int count = Math.abs(e.getWheelRotation());
                int i = 0;
                while (i < count) {
                    Object newValue;
                    Object object = newValue = fForward ? spinner.getModel().getNextValue() : spinner.getModel().getPreviousValue();
                    if (newValue == null) break;
                    spinner.setValue(newValue);
                    ++i;
                }
            }
        });
    }

    public static JPanel createDialogButtonPanel(JButton ... buttons) {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("insets 0, gap 10, fillx", "[grow][]", "[][]"));
        panel.add((Component)new JSeparator(), "spanx, growx, wrap");
        panel.add(new JPanel());
        JButton[] jButtonArray = buttons;
        int n = buttons.length;
        int n2 = 0;
        while (n2 < n) {
            JButton button = jButtonArray[n2];
            panel.add((Component)button, "sg 1");
            ++n2;
        }
        return panel;
    }
}

