/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.CRC;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.MesgDefinitionListener;
import com.garmin.fit.MesgListener;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.List;

public class BufferEncoder
implements MesgListener,
MesgDefinitionListener {
    private ByteArrayOutputStream byteOutStream;
    private DataOutputStream dataOutStream;
    private MesgDefinition[] lastMesgDefinition = new MesgDefinition[16];
    private int dataSize;

    public BufferEncoder() {
        this.byteOutStream = new ByteArrayOutputStream();
        this.dataOutStream = new DataOutputStream(this.byteOutStream);
        this.open();
    }

    public void open() {
        this.byteOutStream.reset();
        this.dataSize = 0;
        this.writeFileHeader();
    }

    private void writeFileHeader() {
        this.byteOutStream.write(12);
        this.byteOutStream.write(16);
        this.byteOutStream.write(100);
        this.byteOutStream.write(0);
        this.byteOutStream.write(0);
        this.byteOutStream.write(0);
        this.byteOutStream.write(0);
        this.byteOutStream.write(0);
        this.byteOutStream.write(46);
        this.byteOutStream.write(70);
        this.byteOutStream.write(73);
        this.byteOutStream.write(84);
    }

    @Override
    public void onMesg(Mesg mesg) {
        this.write(mesg);
    }

    @Override
    public void onMesgDefinition(MesgDefinition mesgDefinition) {
        this.write(mesgDefinition);
    }

    public void write(MesgDefinition mesgDefinition) {
        if (!mesgDefinition.equals(this.lastMesgDefinition[mesgDefinition.localNum])) {
            this.lastMesgDefinition[mesgDefinition.localNum] = mesgDefinition;
            this.dataSize += mesgDefinition.write(this.dataOutStream);
        }
    }

    public void write(Mesg mesg) {
        this.write(new MesgDefinition(mesg));
        this.dataSize += mesg.write(this.dataOutStream);
    }

    public void write(List<Mesg> list) {
        for (Mesg mesg : list) {
            this.write(mesg);
        }
    }

    public byte[] close() {
        this.byteOutStream.write(0);
        this.byteOutStream.write(0);
        byte[] byArray = this.byteOutStream.toByteArray();
        byArray[4] = (byte)(this.dataSize & 0xFF);
        byArray[5] = (byte)(this.dataSize >> 8 & 0xFF);
        byArray[6] = (byte)(this.dataSize >> 16 & 0xFF);
        byArray[7] = (byte)(this.dataSize >> 24 & 0xFF);
        int n = 0;
        this.dataSize += 12;
        for (int i = 0; i < this.dataSize; ++i) {
            n = CRC.get16(n, byArray[i]);
        }
        byArray[this.dataSize++] = (byte)(n & 0xFF);
        byArray[this.dataSize++] = (byte)(n >> 8 & 0xFF);
        this.open();
        return byArray;
    }
}

