/*
 * Decompiled with CFR 0.152.
 */
package ca.beq.util.win32.registry;

import ca.beq.util.win32.registry.KeyIterator;
import ca.beq.util.win32.registry.RegistryException;
import ca.beq.util.win32.registry.RegistryValue;
import ca.beq.util.win32.registry.RootKey;
import ca.beq.util.win32.registry.ValueIterator;
import java.util.Iterator;

public class RegistryKey {
    static boolean c_initSucceeded = false;
    public static final String DEFAULT_LIB = "jRegistryKey";
    private static final String EMPTY = "";
    public static final String ENVIRONMENT_PATH = "JREGISTRYKEY_LIB";
    public static final String PROPERTY_PATH = "jRegistryKey.lib";
    private static final char SPLITTER = '\\';
    String m_path = "";
    RootKey m_root = RootKey.HKEY_CURRENT_USER;
    String m_Machine = null;
    boolean m_ignore_expand = false;

    public static void checkInitialized() {
    }

    private static void compareVersions() {
        String versionJNI;
        String versionAPI = RegistryKey.getAPIVersion();
        if (versionAPI == null) {
            return;
        }
        try {
            versionJNI = RegistryKey.getJNIVersion();
        }
        catch (UnsatisfiedLinkError e) {
            versionJNI = "pre 1.3.2";
        }
        if (versionAPI.equals(versionJNI)) {
            return;
        }
        throw new RegistryException("Native library loaded, however JNI version " + versionJNI + " does not match API version " + versionAPI);
    }

    public static String getAPIVersion() {
        return "1.4.5";
    }

    private static native String getJNIVersion();

    public static void initialize() {
        if (RegistryKey.isInitialized()) {
            return;
        }
        try {
            RegistryKey.testInitialized();
            return;
        }
        catch (UnsatisfiedLinkError ule) {
            String property = System.getProperty(PROPERTY_PATH);
            if (RegistryKey.loadNative(property)) {
                return;
            }
            try {
                String env = System.getenv(ENVIRONMENT_PATH);
                if (RegistryKey.loadNative(env)) {
                    return;
                }
            }
            catch (Error error) {
                // empty catch block
            }
            if (RegistryKey.loadNative(DEFAULT_LIB)) {
                return;
            }
            RegistryKey.testInitialized();
            return;
        }
    }

    public static synchronized void initialize(String libname) {
        if (RegistryKey.isInitialized()) {
            return;
        }
        try {
            RegistryKey.testInitialized();
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (RegistryKey.loadNative(libname)) {
                return;
            }
            RegistryKey.testInitialized();
            return;
        }
    }

    public static synchronized boolean isInitialized() {
        return c_initSucceeded;
    }

    private static boolean loadNative(String library) {
        if (library == null) {
            return false;
        }
        try {
            System.loadLibrary(library);
            c_initSucceeded = true;
        }
        catch (UnsatisfiedLinkError uleName) {
            try {
                System.load(library);
                c_initSucceeded = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
        if (c_initSucceeded) {
            RegistryKey.compareVersions();
        }
        return c_initSucceeded;
    }

    static native void testInitialized();

    public RegistryKey() {
        try {
            RegistryKey.initialize();
        }
        catch (RegistryException re) {
            re.printStackTrace();
        }
    }

    public RegistryKey(RootKey root) {
        this();
        this.m_root = root;
    }

    public RegistryKey(RootKey root, String path) {
        this.m_root = root;
        this.m_path = path;
    }

    public RegistryKey(String path) {
        this();
        this.m_path = path;
    }

    public RegistryKey(String iMachine, RootKey root) {
        this(root);
        this.m_Machine = iMachine;
    }

    public RegistryKey(String iMachine, RootKey root, String path) {
        this(root, path);
        this.m_Machine = iMachine;
    }

    public native void create();

    public RegistryKey createSubkey(String name) {
        RegistryKey r = new RegistryKey(this.m_root, this.makePath(name));
        r.create();
        return r;
    }

    public native void delete();

    public native void deleteValue(String var1);

    public native boolean exists();

    public String getName() {
        return this.m_path.substring(1 + this.m_path.lastIndexOf(92));
    }

    public String getPath() {
        return this.m_path;
    }

    public RootKey getRootKey() {
        return this.m_root;
    }

    protected native long getLastModifiedFileTime();

    public long getLastModifiedTime() {
        long MS_BETWEEN_IDIOCY_AND_EPOCH = 11644473600000L;
        return Math.round((double)this.getLastModifiedFileTime() * 1.0E-4) - 11644473600000L;
    }

    public native RegistryValue getValue(String var1);

    public boolean hasSubkey(String name) {
        RegistryKey r = new RegistryKey(this.m_root, this.makePath(name));
        return r.exists();
    }

    public native boolean hasSubkeys();

    public native boolean hasValue(String var1);

    public native boolean hasValues();

    public String makePath(String subPath) {
        StringBuffer path = new StringBuffer(this.m_path);
        if (!EMPTY.equals(this.m_path)) {
            path.append('\\');
        }
        path.append(subPath);
        return path.toString();
    }

    public native void setValue(RegistryValue var1);

    public Iterator subkeys() {
        return new KeyIterator(this);
    }

    public String toString() {
        StringBuffer toString = new StringBuffer(this.m_root.toString());
        if (!EMPTY.equals(this.m_path)) {
            toString.append('\\');
            toString.append(this.m_path);
        }
        return toString.toString();
    }

    public Iterator values() {
        return new ValueIterator(this);
    }

    public void bypassExpansion(boolean doBypass) {
        this.m_ignore_expand = doBypass;
    }
}

